﻿using Microsoft.Xna.Framework;
using JigLibX.Physics;
using JigLibX.Collision;
using JigLibX.Geometry;
using JigLibX.Math;


namespace SilverlightXna04
{
    public class BoxActor
    {
        private Vector3 scale;

        public Body Body { get; private set; }
        private CollisionSkin skin;

        public BoxActor(Vector3 position, Vector3 scale)
        {
            this.scale = scale;

            this.Body = new Body();
            this.skin = new CollisionSkin(this.Body);

            this.Body.CollisionSkin = this.skin;

            this.skin.AddPrimitive(
                new Box(Vector3.Zero, Matrix.Identity, scale),
                new MaterialProperties(
                    0.8f, // elasticity
                    0.8f, // static roughness
                    0.7f  // dynamic roughness
                ));

            SetMass(1.0f);
            this.Body.MoveTo(position, Matrix.Identity);
        }

        private void SetMass(float mass)
        {
            PrimitiveProperties primitiveProperties = new PrimitiveProperties(
                PrimitiveProperties.MassDistributionEnum.Solid,
                PrimitiveProperties.MassTypeEnum.Mass,
                mass
                );

            float junk;
            Vector3 centerOfMass;
            Matrix inertiaTensor, inertiaTensorCenterOfMass;

            this.skin.GetMassProperties(
                primitiveProperties,
                out junk,
                out centerOfMass,
                out inertiaTensor,
                out inertiaTensorCenterOfMass
                );

            this.Body.BodyInertia = inertiaTensorCenterOfMass;
            this.Body.Mass = mass;
            this.skin.ApplyLocalTransform(new Transform(-centerOfMass, Matrix.Identity));
        }

        public Matrix GetWorldTransform()
        {
            return Matrix.CreateScale(scale)
                * skin.GetPrimitiveLocal(0).Transform.Orientation
                * Body.Orientation
                * Matrix.CreateTranslation(Body.Position);
        }
    }
}
