﻿
    using Microsoft.Xna.Framework;
    using Microsoft.Xna.Framework.Graphics;

namespace SilverlightXna04
{
    class BoxRenderer : System.IDisposable
    {
        public GraphicsDevice GraphicsDevice { get; private set; }
        VertexBuffer vertexBuffer;
        BasicEffect basicEffect;

        public BoxRenderer(GraphicsDevice graphicsDevice)
        {
            GraphicsDevice = graphicsDevice;
            basicEffect = new BasicEffect(GraphicsDevice) { VertexColorEnabled = true };

            Vector3[] positions = new[]
            {
                new Vector3(1, 1, 1),
                new Vector3(1, -1, 1),
                new Vector3(-1, -1,1),
                new Vector3(-1, 1, 1),

                new Vector3(1, 1, -1),
                new Vector3(1, -1, -1),
                new Vector3(-1, -1,-1),
                new Vector3(-1, 1, -1),
            };
            Color[] colors = new[]
            {
                new Color(0, 0, 1f),
                new Color(1f, 0, 0),
                new Color(0, 1f, 0),
                new Color(0, 1f, 1f),
                new Color(1f, 0, 1f),
                new Color(1f, 1f, 0),
            };

            VertexPositionColor[] vertices = new[]
            {
            new VertexPositionColor(positions[0], colors[0]),
            new VertexPositionColor(positions[1], colors[0]),
            new VertexPositionColor(positions[2], colors[0]),

            new VertexPositionColor(positions[3], colors[0]),
            new VertexPositionColor(positions[0], colors[0]),
            new VertexPositionColor(positions[2], colors[0]),

            
            new VertexPositionColor(positions[3], colors[1]),
            new VertexPositionColor(positions[2], colors[1]),
            new VertexPositionColor(positions[7], colors[1]),

            new VertexPositionColor(positions[7], colors[1]),
            new VertexPositionColor(positions[2], colors[1]),
            new VertexPositionColor(positions[6], colors[1]),
            

            new VertexPositionColor(positions[0], colors[2]),
            new VertexPositionColor(positions[3], colors[2]),
            new VertexPositionColor(positions[7], colors[2]),

            new VertexPositionColor(positions[0], colors[2]),
            new VertexPositionColor(positions[7], colors[2]),
            new VertexPositionColor(positions[4], colors[2]),


            new VertexPositionColor(positions[4], colors[3]),
            new VertexPositionColor(positions[6], colors[3]),
            new VertexPositionColor(positions[5], colors[3]),

            new VertexPositionColor(positions[4], colors[3]),
            new VertexPositionColor(positions[7], colors[3]),
            new VertexPositionColor(positions[6], colors[3]),


            new VertexPositionColor(positions[5], colors[4]),
            new VertexPositionColor(positions[2], colors[4]),
            new VertexPositionColor(positions[1], colors[4]),

            new VertexPositionColor(positions[5], colors[4]),
            new VertexPositionColor(positions[6], colors[4]),
            new VertexPositionColor(positions[2], colors[4]),


            new VertexPositionColor(positions[0], colors[5]),
            new VertexPositionColor(positions[5], colors[5]),
            new VertexPositionColor(positions[1], colors[5]),

            new VertexPositionColor(positions[0], colors[5]),
            new VertexPositionColor(positions[4], colors[5]),
            new VertexPositionColor(positions[5], colors[5]),
        };

            vertexBuffer = new VertexBuffer(
                graphicsDevice,
                typeof(VertexPositionColor),
                vertices.Length,
                BufferUsage.WriteOnly
                );
            vertexBuffer.SetData<VertexPositionColor>(vertices);
        }

        public void SetCamera(Matrix view, Matrix projection)
        {
            basicEffect.View = view;
            basicEffect.Projection = projection;
        }

        public void Draw(Matrix world)
        {
            basicEffect.World = Matrix.CreateScale(1 / 2f) * world;
            basicEffect.CurrentTechnique.Passes[0].Apply();


            GraphicsDevice.SetVertexBuffer(vertexBuffer);
            GraphicsDevice.DrawPrimitives(
                PrimitiveType.TriangleList,
                0,
                vertexBuffer.VertexCount / 3
                );
        }

        public void Dispose()
        {
            basicEffect.Dispose();
            vertexBuffer.Dispose();
        }
    }

}
