﻿using System.Windows.Controls;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Xna = Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using System.Windows.Graphics;
using JigLibX.Physics;
using JigLibX.Collision;

namespace SilverlightXna04
{
    public partial class MainPage : UserControl
    {
        private bool loaded = false;

        private BoxRenderer boxRenderer;

        private PhysicsSystem world;
        private List<BoxActor> mobileBoxes = new List<BoxActor>();
        private BoxActor immobileBox;

        public MainPage()
        {
            InitializeComponent();
            textBlock.Text = GpuError.Message;
            InitializePhysics();
        }

        private void InitializePhysics()
        {
            world = new PhysicsSystem { };
            world.CollisionSystem = new CollisionSystemSAP();

            immobileBox = new BoxActor(new Vector3(0, -5, 0), new Vector3(25, 5, 25));
            immobileBox.Body.Immovable = true;

            world.AddBody(immobileBox.Body);
        }

        private void DrawingSurface_Draw(object sender, DrawEventArgs e)
        {
            if (!loaded)
            {
                LoadContent();
                loaded = true;
            }

            Update();
            Draw();
            e.InvalidateSurface();
        }

        private GraphicsDevice GraphicsDevice
        {
            get
            {
                return GraphicsDeviceManager.Current.GraphicsDevice;
            }
        }

        private void LoadContent()
        {
            boxRenderer = new BoxRenderer(GraphicsDevice);
            boxRenderer.SetCamera(
                Matrix.CreateLookAt(
                    new Vector3(15, 15, 30),
                    new Vector3(),
                    Vector3.Up
                    ),
                Matrix.CreatePerspectiveFieldOfView(
                    MathHelper.ToRadians(45),
                    GraphicsDevice.Viewport.AspectRatio,
                    0.1f,
                    1000
                    )
                 );
        }

        private void Draw()
        {
            GraphicsDevice.Clear(new Xna.Color(0.39f, 0.58f, 0.93f));
            GraphicsDevice.RasterizerState = RasterizerState.CullNone;

            foreach (var box in mobileBoxes)
            {
                boxRenderer.Draw(box.GetWorldTransform());
            }
            boxRenderer.Draw(immobileBox.GetWorldTransform());

        }

        private void Update()
        {
            if (addingBox)
            {
                addBox();
                addingBox = false;
            }
            world.Integrate(1 / 60f);
        }

        private void Button_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            //こんな仕掛けが必要なのは
            //Update, Drawがスレッドで動いているため
            addingBox = true;
        }

        private bool addingBox;

        private void addBox()
        {
            var actor = new BoxActor(new Vector3(0, 10, 0), new Vector3(1));
            world.AddBody(actor.Body);
            mobileBoxes.Add(actor);
        }
    }
}
