﻿using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Shapes;
using System.Collections.ObjectModel;

namespace Ecosystem.Silverlight
{
    public struct PopulationInfo
    {
        public int PlantCount { get; set; }
        public int AnimalCount { get; set; }
        public int Time { get; set; }
    }

    public partial class MainPage : UserControl
    {
        VirtualWorld world = new VirtualWorld();

        SolidColorBrush red = new SolidColorBrush(Colors.Red);
        SolidColorBrush green = new SolidColorBrush(Colors.Green);
        bool isRunning = true;
        ObservableCollection<PopulationInfo> individualCounts = new ObservableCollection<PopulationInfo>();
        int loopCounter = 0;

        Settings Settings
        {
            get
            {
                return (Settings)this.Resources["settings"];
            }
        }

        public MainPage()
        {
            InitializeComponent();
            world.Settings = Settings;
            initialize();

            CompositionTarget.Rendering += delegate
            {
                update();
                draw();
            };

            this.chart1.DataContext = individualCounts;
        }

        private void initialize()
        {
            VirtualCreature creature = new VirtualCreature(new CreatureGenome { IsPlant = true });
            creature.Body.Position = new Vector(10, 10);
            creature.Body.Velocity = new Vector(100, 400);
            world.Add(creature);
        }

        private void update()
        {
            if (!isRunning) { return; }

            world.Update();

            if (loopCounter % 60 == 0)
            {
                var population = new PopulationInfo
                {
                    Time = loopCounter / 60,
                    AnimalCount = world.VirtualCreatures.Count(c => !c.IsPlant),
                    PlantCount = world.VirtualCreatures.Count(c => c.IsPlant)
                };
                individualCounts.Add(population);

                if (individualCounts.Count > 360)
                {
                    var copy = individualCounts.Select(i => i).ToArray();
                    individualCounts.Clear();

                    for (int i = 0; i < copy.Length / 2; i++)
                    {
                        individualCounts.Add(copy[i + copy.Length / 2]);
                    }
                }
            }

            loopCounter++;
        }

        private void draw()
        {
            canvas.Children.Clear();

            foreach (var creature in world.VirtualCreatures)
            {
                var body = creature.Body;
                var ellipse = new Ellipse
                {
                    Fill = creature.IsPlant ? green : red,
                    Height = body.Radius * 2,
                    Width = body.Radius * 2
                };
                Canvas.SetTop(ellipse, body.Position.Y - body.Radius);
                Canvas.SetLeft(ellipse, body.Position.X - body.Radius);
                canvas.Children.Add(ellipse);
            }
        }

        private void canvas_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            isRunning = !isRunning;
        }

        private void resetButton_Click(object sender, RoutedEventArgs e)
        {
            world = new VirtualWorld
            {
                Settings = Settings
            };
            individualCounts.Clear();
            loopCounter = 0;
            world.Add(new VirtualCreature(new CreatureGenome { IsPlant = true }));
        }
    }
}
