﻿using System;
using System.Windows;
using System.Collections.Generic;
using System.Linq;

namespace Ecosystem
{
    public class Settings
    {
        public double ReproductionCost { get; set; }
        public double ReproductionThreashold { get; set; }
        public double PlantEnergySupplyPerFrame { get; set; }
        public double AnimalEnergyConsumptionPerFrame { get; set; }
        public double AnimalEnergyDrain { get; set; }

        public Settings()
        {
            ReproductionCost = 100;
            ReproductionThreashold = 1000;
            PlantEnergySupplyPerFrame = 5;
            AnimalEnergyConsumptionPerFrame = 10;
            AnimalEnergyDrain = 50;
        }

    }

    public class VirtualWorld
    {
        HashSet<VirtualCreature> virtualCreatures = new HashSet<VirtualCreature>();
        PhysicalSimulator simulator = new PhysicalSimulator
        {
            Bounds = new Rect(0, 0, 450, 450)
        };
        Random random = new Random(0);
        public Settings Settings;

        public IEnumerable<VirtualCreature> VirtualCreatures
        {
            get
            {
                return virtualCreatures;
            }
        }

        public void Add(VirtualCreature creature)
        {
            virtualCreatures.Add(creature);
            simulator.Add(creature.Body);
            creature.Settings = Settings;
        }

        public void Remove(VirtualCreature creature)
        {
            virtualCreatures.Remove(creature);
            simulator.Remove(creature.Body);
        }

        public void Update()
        {
            simulator.Update();

            foreach (var creature in virtualCreatures)
            {
                if (creature.IsPlant)
                {
                    creature.Energy += Settings.PlantEnergySupplyPerFrame;
                }
                else
                {
                    creature.Energy -= Settings.AnimalEnergyConsumptionPerFrame;
                }
            }

            foreach (var animal in virtualCreatures.Where(c => !c.IsPlant))
            {
                var others = animal.Body.Collisions.Select(c => c.Obstacle).Where(o => o != null).Select(o => (VirtualCreature)o.Tag);

                foreach (var other in others)
                {
                    if (other.IsPlant)
                    {
                        double energyDrain = Settings.AnimalEnergyDrain;
                        other.Energy -= energyDrain;
                        animal.Energy += energyDrain;
                    }
                }
            }

            foreach (var creature in virtualCreatures.ToArray())
            {
                if (creature.CanCreateChild)
                {
                    var child = creature.CreateChild(random, 0.02);
                    Add(child);
                }
            }


            foreach (var creature in virtualCreatures.ToArray())
            {
                if (creature.Energy < 0)
                {
                    Remove(creature);
                }
            }

        }
    }
}
