﻿using System;
using System.Threading;

namespace Ecosystem
{
    public class Parallel
    {
        //参考：
        //http://blog.efvincent.com/concurrency-optimization-silverlight/
        public static void For(int fromInclusive, int toExclusive, Action<int> body)
        {
            int threadCount = Environment.ProcessorCount;
            // Iterations per thread
            int chunk = (toExclusive - fromInclusive) / threadCount;

            AutoResetEvent[] latch = new AutoResetEvent[threadCount];
            for (int i = 0; i < threadCount; i++)
            {
                latch[i] = new AutoResetEvent(false);
            }

            // Schedule the events to run in parallel
            for (int i = 0; i < threadCount; i++)
            {
                ThreadPool.QueueUserWorkItem((ob) =>
                {
                    int pid = (int)ob;
                    int start = fromInclusive + pid * chunk;
                    int end = pid == threadCount - 1 ? toExclusive : start + chunk;
                    for (int j = start; j < end; j++)
                    {
                        body(j);
                    }
                    latch[pid].Set();
                }, i);
            }
            WaitHandle.WaitAll(latch);
        }
    }
}
