﻿using System.Windows;
using System;

namespace Ecosystem
{
    public class VirtualCreature
    {
        public Body Body = new Body(10) {};
        public Vector Direction = new Vector(1, 0);
        public double Energy;
        public bool IsPlant;
        public CreatureGenome Genome;
        public Settings Settings;

        public VirtualCreature(CreatureGenome genome)
        {
            this.Genome = genome;
            this.IsPlant = genome.IsPlant;
            this.Body.Tag = this;
        }

        public VirtualCreature CreateChild(Random random, double rate)
        {
            Energy -= Settings.ReproductionCost;
            Energy /= 2;
            var genome = Genome.Copy();
            genome.Mutate(random, rate);
            var result  = new VirtualCreature(genome)
            {
                Direction = Vector.Transform(Direction, Matrix.CreateRotation(random.NextDouble(-0.1, 0.1))),
                Energy = Energy
            };
            result.Body.Position = Body.Position + Direction * Body.Radius * 2;
            result.Body.Velocity = Body.Velocity;
            return result;
        }

        public bool CanCreateChild 
        {
            get 
            {
                return Energy > Settings.ReproductionThreashold;
            }
        }
    }


    public class CreatureGenome
    {
        public bool IsPlant;

        public void Mutate(Random random, double mutationRate)
        {
            if (random.NextBool(mutationRate))
            {
                IsPlant = !IsPlant;
            }
        }

        public CreatureGenome Copy()
        {
            return new CreatureGenome
            {
                IsPlant = IsPlant
            };
        }
    }
}
