﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Ecosystem
{
    public struct Vector
    {
        public double X;
        public double Y;

        public double Length
        {
            get
            {
                return Math.Sqrt(this * this);
            }
        }

        public Vector(double x, double y)
        {
            X = x;
            Y = y;
        }

        public static Vector operator *(Vector v, double scale)
        {
            return new Vector(v.X * scale, v.Y * scale);
        }
        public static double operator *(Vector v1, Vector v2)
        {
            return v1.X * v2.X + v1.Y * v2.Y;
        }
        public static Vector operator /(Vector v, double divider)
        {
            return new Vector(v.X / divider, v.Y / divider);
        }
        public static Vector operator +(Vector v1, Vector v2)
        {
            return new Vector(v1.X + v2.X, v1.Y + v2.Y);
        }
        public static Vector operator -(Vector v1, Vector v2)
        {
            return v1 + (-v2);
        }
        public static Vector operator -(Vector v)
        {
            return new Vector(-v.X, -v.Y);
        }

        public void Normalize()
        {
            this = this / Length;
        }

        public static Vector Normalize(Vector v)
        {
            v.Normalize();
            return v;
        }

        public override string ToString()
        {
            return "{" + X + ", " + Y + "}";
        }

        public static Vector Transform(Vector v, Matrix m)
        {
            return new Vector(
                v.X * m.M11 + v.Y * m.M21, 
                v.X * m.M12 + v.Y * m.M22
                );
        }
    }
}
