;------------------------------------------------------------------------
;                                                                       |
;   FILE        :sfr_r8m12a.inc                                         |
;   DATE        :Fri, Jun 03, 2011                                      |
;   DESCRIPTION :define the sfr register. (for Assembler language)      |
;   CPU GROUP   :M12A                                                   |
;                                                                       |
;   This file is generated by Renesas Project Generator (Ver.4.19).     |
;   NOTE:THIS IS A TYPICAL EXAMPLE.                                     |
;------------------------------------------------------------------------
;/***********************************************************************
;*
;* Device       : R8C/M12A
;*
;* File Name    : sfr_r8m12a.inc
;*
;* Abstract     : definition of R8C/M12A Group SFR
;*
;* History      : 2.00 ( 2010-12-03 ) [User's Manual: Hardware Rev.1.00]
;*              : 1.10 ( 2010-06-24 ) [User's Manual: Hardware Rev.0.10]
;*              : 1.00 ( 2010-02-26 ) [User's Manual: Hardware Rev.0.01]
;*
;* NOTE         : THIS IS A TYPICAL EXAMPLE.
;*
;* Copyright (C) 2010 Renesas Electronics Corporation.
;* and Renesas Solutions Corp.
;*
;************************************************************************/
;
;-------------------------------------------------------
;   Processor Mode Register 0
;-------------------------------------------------------
pm0					.equ		0010h
;
srst				.btequ		3,pm0		; Software reset bit
;
;-------------------------------------------------------
;   Module Standby Control Register
;-------------------------------------------------------
mstcr				.equ		0012h
;
msttrj				.btequ		0,mstcr		; Timer RJ2 standby bit
msttrb				.btequ		1,mstcr		; Timer RB2 standby bit
mstad				.btequ		4,mstcr		; A/D converter standby bit
msttrc				.btequ		5,mstcr		; Timer RC standby bit
mstuart				.btequ		6,mstcr		; UART0 standby bit
;
;-------------------------------------------------------
;   Protect Register
;-------------------------------------------------------
prcr				.equ		0013h
;
prc0				.btequ		0,prcr		; Protect bit 0
prc1				.btequ		1,prcr		; Protect bit 1
prc3				.btequ		3,prcr		; Protect bit 3
prc4				.btequ		4,prcr		; Protect bit 4
;
;-------------------------------------------------------
;   Hardware Reset Protect Register
;-------------------------------------------------------
hrpr				.equ		0016h
;
pamcre				.btequ		0,hrpr		; PAMCR register write enable bit
;
;-------------------------------------------------------
;   External Clock Control Register
;-------------------------------------------------------
exckcr				.equ		0020h
;
ckpt0				.btequ		0,exckcr	; P4_6 and P4_7 pin function select bit
ckpt1				.btequ		1,exckcr	; P4_6 and P4_7 pin function select bit
xrcut				.btequ		6,exckcr	; XIN-XOUT on-chip feedback resistor select bit
;
;-------------------------------------------------------
;  High-Speed/Low-Speed On-Chip Oscillator Control Register
;-------------------------------------------------------
ococr				.equ		0021h
;
hocoe				.btequ		0,ococr		; High-speed on-chip oscillator oscillation enable bit
locodis				.btequ		1,ococr		; Low-speed on-chip oscillator oscillation stop bit
;
;-------------------------------------------------------
;   System Clock f Control Register
;-------------------------------------------------------
sckcr				.equ		0022h
;
phissel0			.btequ		0,sckcr		; CPU clock division ratio select bit
phissel1			.btequ		1,sckcr		; CPU clock division ratio select bit
phissel2			.btequ		2,sckcr		; CPU clock division ratio select bit
waitm				.btequ		5,sckcr		; Wait control bit
hscksel				.btequ		6,sckcr		; High-speed on-chip oscillator/XIN clock select bit
;
;-------------------------------------------------------
;   System Clock f Select Register
;-------------------------------------------------------
phisel				.equ		0023h
;
phisel0				.btequ		0,phisel	; System clock division select bit select bit
phisel1				.btequ		1,phisel	; System clock division select bit select bit
phisel2				.btequ		2,phisel	; System clock division select bit select bit
phisel3				.btequ		3,phisel	; System clock division select bit select bit
phisel4				.btequ		4,phisel	; System clock division select bit select bit
phisel5				.btequ		5,phisel	; System clock division select bit select bit
phisel6				.btequ		6,phisel	; System clock division select bit select bit
phisel7				.btequ		7,phisel	; System clock division select bit select bit
;
;-------------------------------------------------------
;   Clock Stop Control Register
;-------------------------------------------------------
ckstpr				.equ		0024h
;
stpm				.btequ		0,ckstpr	; All clock stop control bit
wckstp				.btequ		1,ckstpr	; fBASE stop bit in wait mode
pscstp				.btequ		2,ckstpr	; Prescaler stop bit
scksel				.btequ		7,ckstpr	; System base clock select bit
;
;-------------------------------------------------------
;   Clock Control Register When Returning from Modes
;-------------------------------------------------------
ckrscr				.equ		0025h
;
ckst0				.btequ		0,ckrscr	; Clock oscillator circuit oscillation stabilization state select bit
ckst1				.btequ		1,ckrscr	; Clock oscillator circuit oscillation stabilization state select bit
ckst2				.btequ		2,ckrscr	; Clock oscillator circuit oscillation stabilization state select bit
ckst3				.btequ		3,ckrscr	; Clock oscillator circuit oscillation stabilization state select bit
phisrs				.btequ		5,ckrscr	; CPU clock division select bit when returning from wait mode or stop mode
waitrs				.btequ		6,ckrscr	; System base clock select bit when returning from wait mode
stoprs				.btequ		7,ckrscr	; System base clock select bit when returning from stop mode
;
;-------------------------------------------------------
;   Oscillation Stop Detection Register
;-------------------------------------------------------
bakcr				.equ		0026h
;
xinbake				.btequ		0,bakcr		; Oscillation stop detection enable bit
ckswie				.btequ		1,bakcr		; Oscillation stop detection interrupt enable bit
xinhalt				.btequ		2,bakcr		; Clock monitor bit
ckswif				.btequ		3,bakcr		; Oscillation stop detection interrupt request flag
;
;-------------------------------------------------------
;  Watchdog Timer Function Register
;-------------------------------------------------------
risr				.equ		0030h
;
ufif				.btequ		6,risr		; WDT underflow detection flag
ris					.btequ		7,risr		; WDT interrupt/reset switch bit
;
;-------------------------------------------------------
;   Watchdog Timer Reset Register
;-------------------------------------------------------
wdtr				.equ		0031h
;
;-------------------------------------------------------
;   Watchdog Timer Start Register
;-------------------------------------------------------
wdts				.equ		0032h
;
;-------------------------------------------------------
;   Watchdog Timer Control Register
;-------------------------------------------------------
wdtc				.equ		0033h
;
wdtc6				.btequ		6,wdtc		; Watchdog timer count source select bit
wdtc7				.btequ		7,wdtc		; Watchdog timer count source select bit
;
;-------------------------------------------------------
;   Count Source Protection Mode Register
;-------------------------------------------------------
cspr				.equ		0034h
;
cspro				.btequ		7,cspr		; Count source protection mode select bit
;
;-------------------------------------------------------
;   Periodic Timer Interrupt Control Register
;-------------------------------------------------------
wdtir				.equ		0035h
;
wdtif				.btequ		6,wdtir		; Periodic timer interrupt request flag
wdtie				.btequ		7,wdtir		; Periodic timer interrupt enable bit
;
;-------------------------------------------------------
;   External Input Enable Register
;-------------------------------------------------------
inten				.equ		0038h
;
int0en				.btequ		0,inten		; INT0 input enable bit
int1en				.btequ		1,inten		; INT1 input enable bit
int2en				.btequ		2,inten		; INT2 input enable bit
int3en				.btequ		3,inten		; INT3 input enable bit
;
;-------------------------------------------------------
;   INT Input Filter Select Register 0
;-------------------------------------------------------
intf0				.equ		003Ah
;
int0f0				.btequ		0,intf0		; INT0 input filter select bit
int0f1				.btequ		1,intf0		; INT0 input filter select bit
int1f0				.btequ		2,intf0		; INT1 input filter select bit
int1f1				.btequ		3,intf0		; INT1 input filter select bit
int2f0				.btequ		4,intf0		; INT2 input filter select bit
int2f1				.btequ		5,intf0		; INT2 input filter select bit
int3f0				.btequ		6,intf0		; INT3 input filter select bit
int3f1				.btequ		7,intf0		; INT3 input filter select bit
;
;-------------------------------------------------------
;   INT Input Edge Select Register 0
;-------------------------------------------------------
iscr0				.equ		003Ch
;
int0sa				.btequ		0,iscr0		; INT0 input edge select bit
int0sb				.btequ		1,iscr0		; INT0 input edge select bit
int1sa				.btequ		2,iscr0		; INT1 input edge select bit
int1sb				.btequ		3,iscr0		; INT1 input edge select bit
int2sa				.btequ		4,iscr0		; INT2 input edge select bit
int2sb				.btequ		5,iscr0		; INT2 input edge select bit
int3sa				.btequ		6,iscr0		; INT3 input edge select bit
int3sb				.btequ		7,iscr0		; INT3 input edge select bit
;
;-------------------------------------------------------
;   Key Input Enable Register
;-------------------------------------------------------
kien				.equ		003Eh
;
ki0en				.btequ		0,kien		; KI0 input enable bit
ki0pl				.btequ		1,kien		; KI0 input edge select bit
ki1en				.btequ		2,kien		; KI1 input enable bit
ki1pl				.btequ		3,kien		; KI1 input edge select bit
ki2en				.btequ		4,kien		; KI2 input enable bit
ki2pl				.btequ		5,kien		; KI2 input edge select bit
ki3en				.btequ		6,kien		; KI3 input enable bit
ki3pl				.btequ		7,kien		; KI3 input edge select bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 0
;-------------------------------------------------------
ilvl0				.equ		0040h
;
ilvl00				.btequ		0,ilvl0		; Interrupt priority level setting bit
ilvl01				.btequ		1,ilvl0		; Interrupt priority level setting bit
ilvl04				.btequ		4,ilvl0		; Interrupt priority level setting bit
ilvl05				.btequ		5,ilvl0		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 2
;-------------------------------------------------------
ilvl2				.equ		0042h
;
ilvl20				.btequ		0,ilvl2		; Interrupt priority level setting bit
ilvl21				.btequ		1,ilvl2		; Interrupt priority level setting bit
ilvl24				.btequ		4,ilvl2		; Interrupt priority level setting bit
ilvl25				.btequ		5,ilvl2		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 3
;-------------------------------------------------------
ilvl3				.equ		0043h
;
ilvl30				.btequ		0,ilvl3		; Interrupt priority level setting bit
ilvl31				.btequ		1,ilvl3		; Interrupt priority level setting bit
ilvl34				.btequ		4,ilvl3		; Interrupt priority level setting bit
ilvl35				.btequ		5,ilvl3		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 4
;-------------------------------------------------------
ilvl4				.equ		0044h
;
ilvl40				.btequ		0,ilvl4		; Interrupt priority level setting bit
ilvl41				.btequ		1,ilvl4		; Interrupt priority level setting bit
ilvl44				.btequ		4,ilvl4		; Interrupt priority level setting bit
ilvl45				.btequ		5,ilvl4		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 5
;-------------------------------------------------------
ilvl5				.equ		0045h
;
ilvl50				.btequ		0,ilvl5		; Interrupt priority level setting bit
ilvl51				.btequ		1,ilvl5		; Interrupt priority level setting bit
ilvl54				.btequ		4,ilvl5		; Interrupt priority level setting bit
ilvl55				.btequ		5,ilvl5		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 6
;-------------------------------------------------------
ilvl6				.equ		0046h
;
ilvl60				.btequ		0,ilvl6		; Interrupt priority level setting bit
ilvl61				.btequ		1,ilvl6		; Interrupt priority level setting bit
ilvl64				.btequ		4,ilvl6		; Interrupt priority level setting bit
ilvl65				.btequ		5,ilvl6		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 7
;-------------------------------------------------------
ilvl7				.equ		0047h
;
ilvl70				.btequ		0,ilvl7		; Interrupt priority level setting bit
ilvl71				.btequ		1,ilvl7		; Interrupt priority level setting bit
ilvl74				.btequ		4,ilvl7		; Interrupt priority level setting bit
ilvl75				.btequ		5,ilvl7		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 8
;-------------------------------------------------------
ilvl8				.equ		0048h
;
ilvl80				.btequ		0,ilvl8		; Interrupt priority level setting bit
ilvl81				.btequ		1,ilvl8		; Interrupt priority level setting bit
ilvl84				.btequ		4,ilvl8		; Interrupt priority level setting bit
ilvl85				.btequ		5,ilvl8		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register 9
;-------------------------------------------------------
ilvl9				.equ		0049h
;
ilvl90				.btequ		0,ilvl9		; Interrupt priority level setting bit
ilvl91				.btequ		1,ilvl9		; Interrupt priority level setting bit
ilvl94				.btequ		4,ilvl9		; Interrupt priority level setting bit
ilvl95				.btequ		5,ilvl9		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register A
;-------------------------------------------------------
ilvla				.equ		004Ah
;
ilvla0				.btequ		0,ilvla		; Interrupt priority level setting bit
ilvla1				.btequ		1,ilvla		; Interrupt priority level setting bit
ilvla4				.btequ		4,ilvla		; Interrupt priority level setting bit
ilvla5				.btequ		5,ilvla		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register B
;-------------------------------------------------------
ilvlb				.equ		004Bh
;
ilvlb0				.btequ		0,ilvlb		; Interrupt priority level setting bit
ilvlb1				.btequ		1,ilvlb		; Interrupt priority level setting bit
ilvlb4				.btequ		4,ilvlb		; Interrupt priority level setting bit
ilvlb5				.btequ		5,ilvlb		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register C
;-------------------------------------------------------
ilvlc				.equ		004Ch
;
ilvlc0				.btequ		0,ilvlc		; Interrupt priority level setting bit
ilvlc1				.btequ		1,ilvlc		; Interrupt priority level setting bit
ilvlc4				.btequ		4,ilvlc		; Interrupt priority level setting bit
ilvlc5				.btequ		5,ilvlc		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register D
;-------------------------------------------------------
ilvld				.equ		004Dh
;
ilvld0				.btequ		0,ilvld		; Interrupt priority level setting bit
ilvld1				.btequ		1,ilvld		; Interrupt priority level setting bit
ilvld4				.btequ		4,ilvld		; Interrupt priority level setting bit
ilvld5				.btequ		5,ilvld		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Priority Level Register E
;-------------------------------------------------------
ilvle				.equ		004Eh
;
ilvle0				.btequ		0,ilvle		; Interrupt priority level setting bit
ilvle1				.btequ		1,ilvle		; Interrupt priority level setting bit
ilvle4				.btequ		4,ilvle		; Interrupt priority level setting bit
ilvle5				.btequ		5,ilvle		; Interrupt priority level setting bit
;
;-------------------------------------------------------
;   Interrupt Monitor Flag Register 0
;-------------------------------------------------------
irr0				.equ		0050h
;
irtj				.btequ		0,irr0		; Timer RJ2 interrupt request monitor flag
irtb				.btequ		1,irr0		; Timer RB2 interrupt request monitor flag
irtc				.btequ		2,irr0		; Timer RC interrupt request monitor flag
irs0t				.btequ		4,irr0		; UART0 transmit interrupt request monitor flag
irs0r				.btequ		5,irr0		; UART0 receive interrupt request monitor flag
;
;-------------------------------------------------------
;   Interrupt Monitor Flag Register 1
;-------------------------------------------------------
irr1				.equ		0051h
;
irad				.btequ		2,irr1		; A/D conversion interrupt request monitor flag
irfm				.btequ		4,irr1		; Flash ready interrupt request monitor flag
irwd				.btequ		5,irr1		; Periodic timer interrupt request monitor flag
;
;-------------------------------------------------------
;   Interrupt Monitor Flag Register 2
;-------------------------------------------------------
irr2				.equ		0052h
;
ircmp1				.btequ		2,irr2		; Comparator B1 interrupt request monitor flag
ircmp3				.btequ		3,irr2		; Comparator B3 interrupt request monitor flag
;
;-------------------------------------------------------
;   External Interrupt Flag Register
;-------------------------------------------------------
irr3				.equ		0053h
;
iri0				.btequ		0,irr3		; INT0 interrupt request flag
iri1				.btequ		1,irr3		; INT1 interrupt request flag
iri2				.btequ		2,irr3		; INT2 interrupt request flag
iri3				.btequ		3,irr3		; INT3 interrupt request flag
irki				.btequ		5,irr3		; Key input interrupt request flag
;
;-------------------------------------------------------
;   Voltage Monitor Circuit Edge Select Register
;-------------------------------------------------------
vcac				.equ		0058h
;
vcac1				.btequ		1,vcac		; Voltage monitor 1 circuit edge select bit
;
;-------------------------------------------------------
;   Voltage Detect Register 2
;-------------------------------------------------------
vca2				.equ		005Ah
;
lpe					.btequ		0,vca2		; Internal low-power-consumption enable bit
vc0e				.btequ		5,vca2		; Voltage detection 0 enable bit
vc1e				.btequ		6,vca2		; Voltage detection 1 enable bit
;
;-------------------------------------------------------
;   Voltage Detection 1 Level Select Register
;-------------------------------------------------------
vd1ls				.equ		005Bh
;
vd1s1				.btequ		1,vd1ls		; Voltage detection 1 Level select bit
vd1s2				.btequ		2,vd1ls		; Voltage detection 1 Level select bit
vd1s3				.btequ		3,vd1ls		; Voltage detection 1 Level select bit
;
;-------------------------------------------------------
;   Voltage Monitor 0 Circuit Control Register
;-------------------------------------------------------
vw0c				.equ		005Ch
;
vw0c0				.btequ		0,vw0c		; Voltage monitor 0 reset enable bit
vw0c1				.btequ		1,vw0c		; Voltage monitor 0 digital filter mode select bit
vw0f0				.btequ		4,vw0c		; Sampling clock select bit
vw0f1				.btequ		5,vw0c		; Sampling clock select bit
;
;-------------------------------------------------------
;   Voltage Monitor 1 Circuit Control Register
;-------------------------------------------------------
vw1c				.equ		005Dh
;
vw1c0				.btequ		0,vw1c		; Voltage monitor 1 interrupt enable bit
vw1c1				.btequ		1,vw1c		; Voltage monitor 1 digital filter mode select bit
vw1c2				.btequ		2,vw1c		; Voltage change detection flag
vw1c3				.btequ		3,vw1c		; Voltage detection 1 signal monitor flag
vw1f0				.btequ		4,vw1c		; Sampling clock select bit
vw1f1				.btequ		5,vw1c		; Sampling clock select bit
vw1c7				.btequ		7,vw1c		; Voltage monitor 1 interrupt generation condition select bit
;
;-------------------------------------------------------
;   Reset Source Determination Register
;-------------------------------------------------------
rstfr				.equ		005Fh
;
cwr					.btequ		0,rstfr		; Cold start-up/warm start-up determine flag
hwr					.btequ		1,rstfr		; Hardware reset detect flag
swr					.btequ		2,rstfr		; Software reset detect flag
wdr					.btequ		3,rstfr		; Watchdog timer reset detect flag
;
;-------------------------------------------------------
;   High-Speed On-Chip Oscillator 18.432 MHz Control Register 0
;-------------------------------------------------------
fr18s0				.equ		0064h
;
;-------------------------------------------------------
;   High-Speed On-Chip Oscillator 18.432 MHz Control Register 1
;-------------------------------------------------------
fr18s1				.equ		0065h
;
;-------------------------------------------------------
;   High-Speed On-Chip Oscillator Control Register 1
;-------------------------------------------------------
frv1				.equ		0067h
;
;-------------------------------------------------------
;   High-Speed On-Chip Oscillator Control Register 2
;-------------------------------------------------------
frv2				.equ		0068h
;
;-------------------------------------------------------
;   UART0 Transmit/Receive Mode Register
;-------------------------------------------------------
u0mr				.equ		0080h
;
smd0_u0mr			.btequ		0,u0mr		; Serial I/O mode select bit
smd1_u0mr			.btequ		1,u0mr		; Serial I/O mode select bit
smd2_u0mr			.btequ		2,u0mr		; Serial I/O mode select bit
ckdir_u0mr			.btequ		3,u0mr		; Internal/external clock select bit
stps_u0mr			.btequ		4,u0mr		; Stop bit length select bit
pry_u0mr			.btequ		5,u0mr		; Odd/even parity select bit
prye_u0mr			.btequ		6,u0mr		; Parity enable bit
;
;-------------------------------------------------------
;   UART0 Bit Rate Register
;-------------------------------------------------------
u0brg				.equ		0081h
;
;-------------------------------------------------------
;   UART0 Transmit Buffer Register Low
;-------------------------------------------------------
u0tbl				.equ		0082h
;
;-------------------------------------------------------
;   UART0 Transmit Buffer Register High
;-------------------------------------------------------
u0tbh				.equ		0083h
;
;-------------------------------------------------------
;   UART0 Transmit/Receive Control Register 0
;-------------------------------------------------------
u0c0				.equ		0084h
;
clk0_u0c0			.btequ		0,u0c0		; U0BRG count source select bit
clk1_u0c0			.btequ		1,u0c0		; U0BRG count source select bit
txept_u0c0			.btequ		3,u0c0		; Transmit register empty flag
dfe_u0c0			.btequ		4,u0c0		; RXD0 digital filter enable bit
nch_u0c0			.btequ		5,u0c0		; Data output select bit
ckpol_u0c0			.btequ		6,u0c0		; CLK polarity select bit
uform_u0c0			.btequ		7,u0c0		; Transfer format select bit
;
;-------------------------------------------------------
;   UART0 Transmit/Receive Control Register 1
;-------------------------------------------------------
u0c1				.equ		0085h
;
te_u0c1				.btequ		0,u0c1		; Transmit enable bit
ti_u0c1				.btequ		1,u0c1		; Transmit buffer empty flag
re_u0c1				.btequ		2,u0c1		; Receive enable bit
ri_u0c1				.btequ		3,u0c1		; Receive complete flag
u0irs_u0c1			.btequ		4,u0c1		; UART0 transmit interrupt source select bit
u0rrm_u0c1			.btequ		5,u0c1		; UART0 continuous receive mode enable bit
;
;-------------------------------------------------------
;   UART0 Receive Buffer Register
;-------------------------------------------------------
u0rb				.equ		0086h
;
;-------------------------------------------------------
;   UART0 Interrupt Flag and Enable Register
;-------------------------------------------------------
u0ir				.equ		0088h
;
u0rie				.btequ		2,u0ir		; UART0 receive interrupt enable bit
u0tie				.btequ		3,u0ir		; UART0 transmit interrupt enable bit
u0rif				.btequ		6,u0ir		; UART0 receive interrupt flag
u0tif				.btequ		7,u0ir		; UART0 transmit interrupt flag
;
;-------------------------------------------------------
;   A/D Register 0
;-------------------------------------------------------
ad0					.equ		0098h
;
ad0l				.equ		ad0			;       Low
ad0h				.equ		ad0+1		;       High
;
;-------------------------------------------------------
;   A/D Register 1
;-------------------------------------------------------
ad1					.equ		009Ah
;
ad1l				.equ		ad1			;       Low
ad1h				.equ		ad1+1		;       High
;
;-------------------------------------------------------
;   A/D Mode Register
;-------------------------------------------------------
admod				.equ		009Ch
;
cks0				.btequ		0,admod		; A/D conversion clock select bit
cks1				.btequ		1,admod		; A/D conversion clock select bit
cks2				.btequ		2,admod		; A/D conversion clock select bit
md0					.btequ		3,admod		; A/D operating mode select bit
md1					.btequ		4,admod		; A/D operating mode select bit
adcap0				.btequ		6,admod		; A/D conversion trigger select bit
adcap1				.btequ		7,admod		; A/D conversion trigger select bit
;
;-------------------------------------------------------
;   A/D Input Select Register
;-------------------------------------------------------
adinsel				.equ		009Dh
;
ch0					.btequ		0,adinsel	; Channel select bit
adgsel0				.btequ		6,adinsel	; A/D input group select bit
adgsel1				.btequ		7,adinsel	; A/D input group select bit
;
;-------------------------------------------------------
;   A/D Control Register 0
;-------------------------------------------------------
adcon0				.equ		009Eh
;
adst				.btequ		0,adcon0	; A/D conversion start bit
;
;-------------------------------------------------------
;   A/D Interrupt Control Status Register
;-------------------------------------------------------
adicsr				.equ		009Fh
;
adie				.btequ		6,adicsr	; A/D conversion interrupt enable bit
adf					.btequ		7,adicsr	; A/D conversion Interrupt request bit
;
;-------------------------------------------------------
;   Port P1 Direction Register
;-------------------------------------------------------
pd1					.equ		00A9h
;
pd1_0				.btequ		0,pd1		; Port P1_0 direction bit
pd1_1				.btequ		1,pd1		; Port P1_1 direction bit
pd1_2				.btequ		2,pd1		; Port P1_2 direction bit
pd1_3				.btequ		3,pd1		; Port P1_3 direction bit
pd1_4				.btequ		4,pd1		; Port P1_4 direction bit
pd1_5				.btequ		5,pd1		; Port P1_5 direction bit
pd1_6				.btequ		6,pd1		; Port P1_6 direction bit
pd1_7				.btequ		7,pd1		; Port P1_7 direction bit
;
;-------------------------------------------------------
;   Port P3 Direction Register
;-------------------------------------------------------
pd3					.equ		00ABh
;
pd3_3				.btequ		3,pd3		; Port P3_3 direction bit
pd3_4				.btequ		4,pd3		; Port P3_4 direction bit
pd3_5				.btequ		5,pd3		; Port P3_5 direction bit
pd3_7				.btequ		7,pd3		; Port P3_7 direction bit
;
;-------------------------------------------------------
;   Port P4 Direction Register
;-------------------------------------------------------
pd4					.equ		00ACh
;
pd4_2				.btequ		2,pd4		; Port P4_2 direction bit
pd4_5				.btequ		5,pd4		; Port P4_5 direction bit
pd4_6				.btequ		6,pd4		; Port P4_6 direction bit
pd4_7				.btequ		7,pd4		; Port P4_7 direction bit
;
;-------------------------------------------------------
;   Port PA Direction Register
;-------------------------------------------------------
pda					.equ		00ADh
;
pda_0				.btequ		0,pda		; Port PA_0 direction bit
;
;-------------------------------------------------------
;   Port P1 Register
;-------------------------------------------------------
p1					.equ		00AFh
;
p1_0				.btequ		0,p1		; Port P1_0 bit
p1_1				.btequ		1,p1		; Port P1_1 bit
p1_2				.btequ		2,p1		; Port P1_2 bit
p1_3				.btequ		3,p1		; Port P1_3 bit
p1_4				.btequ		4,p1		; Port P1_4 bit
p1_5				.btequ		5,p1		; Port P1_5 bit
p1_6				.btequ		6,p1		; Port P1_6 bit
p1_7				.btequ		7,p1		; Port P1_7 bit
;
;-------------------------------------------------------
;   Port P3 Register
;-------------------------------------------------------
p3					.equ		00B1h
;
p3_3				.btequ		3,p3		; Port P3_3 bit
p3_4				.btequ		4,p3		; Port P3_4 bit
p3_5				.btequ		5,p3		; Port P3_5 bit
p3_7				.btequ		7,p3		; Port P3_7 bit
;
;-------------------------------------------------------
;   Port P4 Register
;-------------------------------------------------------
p4					.equ		00B2h
;
p4_2				.btequ		2,p4		; Port P4_2 bit
p4_5				.btequ		5,p4		; Port P4_5 bit
p4_6				.btequ		6,p4		; Port P4_6 bit
p4_7				.btequ		7,p4		; Port P4_7 bit
;
;-------------------------------------------------------
;   Port PA Register
;-------------------------------------------------------
pa					.equ		00B3h
;
pa_0				.btequ		0,pa		; Port PA_0 bit
;
;-------------------------------------------------------
;   Pull-Up Control Register 1
;-------------------------------------------------------
pur1				.equ		00B5h
;
pu1_0				.btequ		0,pur1		; Port P1_0 pull-up control bit
pu1_1				.btequ		1,pur1		; Port P1_1 pull-up control bit
pu1_2				.btequ		2,pur1		; Port P1_2 pull-up control bit
pu1_3				.btequ		3,pur1		; Port P1_3 pull-up control bit
pu1_4				.btequ		4,pur1		; Port P1_4 pull-up control bit
pu1_5				.btequ		5,pur1		; Port P1_5 pull-up control bit
pu1_6				.btequ		6,pur1		; Port P1_6 pull-up control bit
pu1_7				.btequ		7,pur1		; Port P1_7 pull-up control bit
;
;-------------------------------------------------------
;   Pull-Up Control Register 3
;-------------------------------------------------------
pur3				.equ		00B7h
;
pu3_3				.btequ		3,pur3		; Port P3_3 pull-up control bit
pu3_4				.btequ		4,pur3		; Port P3_4 pull-up control bit
pu3_5				.btequ		5,pur3		; Port P3_5 pull-up control bit
pu3_7				.btequ		7,pur3		; Port P3_7 pull-up control bit
;
;-------------------------------------------------------
;   Pull-Up Control Register 4
;-------------------------------------------------------
pur4				.equ		00B8h
;
pu4_2				.btequ		2,pur4		; Port P4_2 pull-up control bit
pu4_5				.btequ		5,pur4		; Port P4_5 pull-up control bit
pu4_6				.btequ		6,pur4		; Port P4_6 pull-up control bit
pu4_7				.btequ		7,pur4		; Port P4_7 pull-up control bit
;
;-------------------------------------------------------
;   Port I/O Function Control Register
;-------------------------------------------------------
pinsr				.equ		00B9h
;
trjiosel			.btequ		6,pinsr		; TRJIO input signal select bit
ioinsel				.btequ		7,pinsr		; Pin level force read-out bit
;
;-------------------------------------------------------
;   Drive Capacity Control Register 1
;-------------------------------------------------------
drr1				.equ		00BBh
;
drr1_2				.btequ		2,drr1		; Port P1_2 drive capacity control bit
drr1_3				.btequ		3,drr1		; Port P1_3 drive capacity control bit
drr1_4				.btequ		4,drr1		; Port P1_4 drive capacity control bit
drr1_5				.btequ		5,drr1		; Port P1_5 drive capacity control bit
;
;-------------------------------------------------------
;   Drive Capacity Control Register 3
;-------------------------------------------------------
drr3				.equ		00BDh
;
drr3_3				.btequ		3,drr3		; Port P3_3 drive capacity control bit
drr3_4				.btequ		4,drr3		; Port P3_4 drive capacity control bit
drr3_5				.btequ		5,drr3		; Port P3_5 drive capacity control bit
drr3_7				.btequ		7,drr3		; Port P3_7 drive capacity control bit
;
;-------------------------------------------------------
;   Open-Drain Control Register 1
;-------------------------------------------------------
pod1				.equ		00C1h
;
pod1_0				.btequ		0,pod1		; Port P1_0 open-drain control bit
pod1_1				.btequ		1,pod1		; Port P1_1 open-drain control bit
pod1_2				.btequ		2,pod1		; Port P1_2 open-drain control bit
pod1_3				.btequ		3,pod1		; Port P1_3 open-drain control bit
pod1_4				.btequ		4,pod1		; Port P1_4 open-drain control bit
pod1_5				.btequ		5,pod1		; Port P1_5 open-drain control bit
pod1_6				.btequ		6,pod1		; Port P1_6 open-drain control bit
pod1_7				.btequ		7,pod1		; Port P1_7 open-drain control bit
;
;-------------------------------------------------------
;   Open-Drain Control Register 3
;-------------------------------------------------------
pod3				.equ		00C3h
;
pod3_3				.btequ		3,pod3		; Port P3_3 open-drain control bit
pod3_4				.btequ		4,pod3		; Port P3_4 open-drain control bit
pod3_5				.btequ		5,pod3		; Port P3_5 open-drain control bit
pod3_7				.btequ		7,pod3		; Port P3_7 open-drain control bit
;
;-------------------------------------------------------
;   Open-Drain Control Register 4
;-------------------------------------------------------
pod4				.equ		00C4h
;
pod4_2				.btequ		2,pod4		; Port P4_2 open-drain control bi
pod4_5				.btequ		5,pod4		; Port P4_5 open-drain control bi
pod4_6				.btequ		6,pod4		; Port P4_6 open-drain control bi
pod4_7				.btequ		7,pod4		; Port P4_7 open-drain control bi
;
;-------------------------------------------------------
;   Port PA Mode Control Register
;-------------------------------------------------------
pamcr				.equ		00C5h
;
poda_0				.btequ		0,pamcr		; Port PA_0 open-drain control bit
hwrste				.btequ		4,pamcr		; Hardware reset enabled bit
;
;-------------------------------------------------------
;   Port 1 Function Mapping Register 0
;-------------------------------------------------------
pml1				.equ		00C8h
;
p10sel0				.btequ		0,pml1		; Port P1_0 function select bit
p10sel1				.btequ		1,pml1		; Port P1_0 function select bit
p11sel0				.btequ		2,pml1		; Port P1_1 function select bit
p11sel1				.btequ		3,pml1		; Port P1_1 function select bit
p12sel0				.btequ		4,pml1		; Port P1_2 function select bit
p12sel1				.btequ		5,pml1		; Port P1_2 function select bit
p13sel0				.btequ		6,pml1		; Port P1_3 function select bit
p13sel1				.btequ		7,pml1		; Port P1_3 function select bit
;
;-------------------------------------------------------
;   Port 1 Function Mapping Register 1
;-------------------------------------------------------
pmh1				.equ		00C9h
;
p14sel0				.btequ		0,pmh1		; Port P1_4 function select bit
p14sel1				.btequ		1,pmh1		; Port P1_4 function select bit
p15sel0				.btequ		2,pmh1		; Port P1_5 function select bit
p15sel1				.btequ		3,pmh1		; Port P1_5 function select bit
p16sel0				.btequ		4,pmh1		; Port P1_6 function select bit
p16sel1				.btequ		5,pmh1		; Port P1_6 function select bit
p17sel0				.btequ		6,pmh1		; Port P1_7 function select bit
p17sel1				.btequ		7,pmh1		; Port P1_7 function select bit
;
;-------------------------------------------------------
;   Port 3 Function Mapping Register 0
;-------------------------------------------------------
pml3				.equ		00CCh
;
p33sel0				.btequ		6,pml3		; Port P3_3 function select bit
p33sel1				.btequ		7,pml3		; Port P3_3 function select bit
;
;-------------------------------------------------------
;   Port 3 Function Mapping Register 1
;-------------------------------------------------------
pmh3				.equ		00CDh
;
p34sel0				.btequ		0,pmh3		; Port P3_4 function select bit
p34sel1				.btequ		1,pmh3		; Port P3_4 function select bit
p35sel0				.btequ		2,pmh3		; Port P3_5 function select bit
p35sel1				.btequ		3,pmh3		; Port P3_5 function select bit
p37sel0				.btequ		6,pmh3		; Port P3_7 function select bit
p37sel1				.btequ		7,pmh3		; Port P3_7 function select bit
;
;-------------------------------------------------------
;   Port 4 Function Mapping Register 0
;-------------------------------------------------------
pml4				.equ		00CEh
;
p42sel0				.btequ		4,pml4		; Port P4_2 function select bit
p42sel1				.btequ		5,pml4		; Port P4_2 function select bit
;
;-------------------------------------------------------
;   Port 4 Function Mapping Register 1
;-------------------------------------------------------
pmh4				.equ		00CFh
;
p45sel0				.btequ		2,pmh4		; Port P4_5 function select bit
p45sel1				.btequ		3,pmh4		; Port P4_5 function select bit
p46sel0				.btequ		4,pmh4		; Port P4_6 function select bit
p46sel1				.btequ		5,pmh4		; Port P4_6 function select bit
p47sel0				.btequ		6,pmh4		; Port P4_7 function select bit
p47sel1				.btequ		7,pmh4		; Port P4_7 function select bit
;
;-------------------------------------------------------
;   Port 1 Function Mapping Expansion Register
;-------------------------------------------------------
pmh1e				.equ		00D1h
;
p14sel2				.btequ		0,pmh1e		; The P1_4 pin function is selected in conjunction with bits P14SEL0 to P14SEL1 in the PMH1 register
p15sel2				.btequ		2,pmh1e		; The P1_5 pin function is selected in conjunction with bits P15SEL0 to P15SEL1 in the PMH1 register
;
;-------------------------------------------------------
;   Port 4 Function Mapping Expansion Register
;-------------------------------------------------------
pmh4e				.equ		00D5h
;
p46sel2				.btequ		4,pmh4e		; The P4_6 pin function is selected in conjunction with bits P46SEL0 to P46SEL1 in the PMH4 register
;
;-------------------------------------------------------
;   Timer RJ Counter Register, Timer RJ Reload Register
;-------------------------------------------------------
trj					.equ		00D8h
;
;-------------------------------------------------------
;   Timer RJ Control Register
;-------------------------------------------------------
trjcr				.equ		00DAh
;
tstart_trjcr			.btequ		0,trjcr		; Timer RJ count start bit
tcstf_trjcr				.btequ		1,trjcr		; Timer RJ count status flag
tstop_trjcr				.btequ		2,trjcr		; Timer RJ count forced stop bit
tedgf_trjcr				.btequ		4,trjcr		; Active edge judgment flag
tundf_trjcr				.btequ		5,trjcr		; Timer RJ underflow flag
;
;-------------------------------------------------------
;   Timer RJ I/O Control Register
;-------------------------------------------------------
trjioc				.equ		00DBh
;
tedgsel_trjioc		.btequ		0,trjioc	; I/O polarity switch bit
topcr_trjioc		.btequ		1,trjioc	; TRJIO output control bit
tipf0_trjioc		.btequ		4,trjioc	; TRJIO input filter select bit
tipf1_trjioc		.btequ		5,trjioc	; TRJIO input filter select bit
tiogt0_trjioc		.btequ		6,trjioc	; TRJIO count control bit
tiogt1_trjioc		.btequ		7,trjioc	; TRJIO count control bit
;
;-------------------------------------------------------
;   Timer RJ Mode Register
;-------------------------------------------------------
trjmr				.equ		00DCh
;
tmod0_trjmr			.btequ		0,trjmr		; Timer RJ operating mode select bit
tmod1_trjmr			.btequ		1,trjmr		; Timer RJ operating mode select bit
tmod2_trjmr			.btequ		2,trjmr		; Timer RJ operating mode select bit
tedgpl_trjmr		.btequ		3,trjmr		; TRJIO edge polarity select bit
tck0_trjmr			.btequ		4,trjmr		; Timer RJ count source select bit
tck1_trjmr			.btequ		5,trjmr		; Timer RJ count source select bit
tck2_trjmr			.btequ		6,trjmr		; Timer RJ count source select bit
tckcut_trjmr		.btequ		7,trjmr		; Timer RJ count source cutoff bit
;
;-------------------------------------------------------
;   Timer RJ Event Select Register
;-------------------------------------------------------
trjisr				.equ		00DDh
;
rccpsel0_trjisr		.btequ		0,trjisr	; Timer RC output signal select bit
rccpsel1_trjisr		.btequ		1,trjisr	; Timer RC output signal select bit
rccpsel2_trjisr		.btequ		2,trjisr	; Timer RC output signal inversion bit
;
;-------------------------------------------------------
;  Timer RJ Interrupt Control Register
;-------------------------------------------------------
trjir				.equ		00DEh
;
trjif_trjir			.btequ		6,trjir		; Timer RJ interrupt request flag
trjie_trjir			.btequ		7,trjir		; Timer RJ interrupt enable bit
;
;-------------------------------------------------------
;   Timer RB Control Register
;-------------------------------------------------------
trbcr				.equ		00E0h
;
tstart_trbcr		.btequ		0,trbcr		; Timer RB count start bit
tcstf_trbcr			.btequ		1,trbcr		; Timer RB count status flag
tstop_trbcr			.btequ		2,trbcr		; Timer RB count forced stop bit
;
;-------------------------------------------------------
;   Timer RB One-Shot Control Register
;-------------------------------------------------------
trbocr				.equ		00E1h
;
tosst_trbocr		.btequ		0,trbocr	; Timer RB one-shot start bit
tossp_trbocr		.btequ		1,trbocr	; Timer RB one-shot stop bit
tosstf_trbocr		.btequ		2,trbocr	; Timer RB one-shot status flag
;
;-------------------------------------------------------
;   Timer RB I/O Control Register
;-------------------------------------------------------
trbioc				.equ		00E2h
;
topl_trbioc			.btequ		0,trbioc	; Timer RB output level select bit
tocnt_trbioc		.btequ		1,trbioc	; Timer RB output switch bit
inostg_trbioc		.btequ		2,trbioc	; One-shot trigger control bit
inoseg_trbioc		.btequ		3,trbioc	; One-shot trigger polarity select bit
;
;-------------------------------------------------------
;   Timer RB Mode Register
;-------------------------------------------------------
trbmr				.equ		00E3h
;
tmod0_trbmr			.btequ		0,trbmr		; Timer RB operating mode select bit
tmod1_trbmr			.btequ		1,trbmr		; Timer RB operating mode select bit
tcnt16_trbmr		.btequ		2,trbmr		; Timer RB counter select bit
twrc_trbmr			.btequ		3,trbmr		; Timer RB write control bit
tck0_trbmr			.btequ		4,trbmr		; Timer RB count source select bit
tck1_trbmr			.btequ		5,trbmr		; Timer RB count source select bit
tck2_trbmr			.btequ		6,trbmr		; Timer RB count source select bit
tckcut_trbmr		.btequ		7,trbmr		; Timer RB count source cutoff bit
;
;-------------------------------------------------------
;   Timer RB Prescaler Register
;-------------------------------------------------------
trbpre				.equ		00E4h
;
;-------------------------------------------------------
;   Timer RB Primary Register
;-------------------------------------------------------
trbpr				.equ		00E5h
;
;-------------------------------------------------------
;   Timer RB Secondary Register
;-------------------------------------------------------
trbsc				.equ		00E6h
;
;-------------------------------------------------------
;   Timer RB Interrupt Control Register
;-------------------------------------------------------
trbir				.equ		00E7h
;
trbif_trbir			.btequ		6,trbir		; Timer RB interrupt request flag
trbie_trbir			.btequ		7,trbir		; Timer RB interrupt enable bit
;
;-------------------------------------------------------
;   Timer RC Counter
;-------------------------------------------------------
trccnt				.equ		00E8h
;
;-------------------------------------------------------
;   Timer RC General Register A
;-------------------------------------------------------
trcgra				.equ		00EAh
;
;-------------------------------------------------------
;   Timer RC General Register B
;-------------------------------------------------------
trcgrb				.equ		00ECh
;
;-------------------------------------------------------
;   Timer RC General Register C
;-------------------------------------------------------
trcgrc				.equ		00EEh
;
;-------------------------------------------------------
;   Timer RC General Register D
;-------------------------------------------------------
trcgrd				.equ		00F0h
;
;-------------------------------------------------------
;   Timer RC Mode Register
;-------------------------------------------------------
trcmr				.equ		00F2h
;
pwmb_trcmr			.btequ		0,trcmr		; TRCIOB PWM mode select bit
pwmc_trcmr			.btequ		1,trcmr		; TRCIOC PWM mode select bit
pwmd_trcmr			.btequ		2,trcmr		; TRCIOD PWM mode select bit
pwm2_trcmr			.btequ		3,trcmr		; PWM2 mode select bit
bufea_trcmr			.btequ		4,trcmr		; TRCGRC register function select bit
bufeb_trcmr			.btequ		5,trcmr		; TRCGRD register function select bit
cts_trcmr			.btequ		7,trcmr		; TRCCNT count start bit
;
;-------------------------------------------------------
;   Timer RC Control Register 1
;-------------------------------------------------------
trccr1				.equ		00F3h
;
toa_trccr1			.btequ		0,trccr1	; Timer output level select A bit
tob_trccr1			.btequ		1,trccr1	; Timer output level select B bit
toc_trccr1			.btequ		2,trccr1	; Timer output level select C bit
tod_trccr1			.btequ		3,trccr1	; Timer output level select D bit
cks0_trccr1			.btequ		4,trccr1	; Count source select bit
cks1_trccr1			.btequ		5,trccr1	; Count source select bit
cks2_trccr1			.btequ		6,trccr1	; Count source select bit
cclr_trccr1			.btequ		7,trccr1	; TRCCNT counter clear select bit
;
;-------------------------------------------------------
;   Timer RC Interrupt Enable Register
;-------------------------------------------------------
trcier				.equ		00F4h
;
imiea_trcier		.btequ		0,trcier	; Input capture/compare match A interrupt enable bit
imieb_trcier		.btequ		1,trcier	; Input capture/compare match B interrupt enable bit
imiec_trcier		.btequ		2,trcier	; Input capture/compare match C interrupt enable bit
imied_trcier		.btequ		3,trcier	; Input capture/compare match D interrupt enable bit
ovie_trcier			.btequ		7,trcier	; Timer overflow interrupt enable bit
;
;-------------------------------------------------------
;   Timer RC Status Register
;-------------------------------------------------------
trcsr				.equ		00F5h
;
imfa_trcsr			.btequ		0,trcsr		; Input capture/compare match A flag
imfb_trcsr			.btequ		1,trcsr		; Input capture/compare match B flag
imfc_trcsr			.btequ		2,trcsr		; Input capture/compare match C flag
imfd_trcsr			.btequ		3,trcsr		; Input capture/compare match D flag
ovf_trcsr			.btequ		7,trcsr		; Timer overflow flag
;
;-------------------------------------------------------
;   Timer RC I/O Control Register 0
;-------------------------------------------------------
trcior0				.equ		00F6h
;
ioa0_trcior0		.btequ		0,trcior0	; TRCGRA control A0 bit
ioa1_trcior0		.btequ		1,trcior0	; TRCGRA control A1 bit
ioa2_trcior0		.btequ		2,trcior0	; TRCGRA control A2 bit
iob0_trcior0		.btequ		4,trcior0	; TRCGRB control B0 bit
iob1_trcior0		.btequ		5,trcior0	; TRCGRB control B1 bit
iob2_trcior0		.btequ		6,trcior0	; TRCGRB control B2 bit
;
;-------------------------------------------------------
;   Timer RC I/O Control Register 1
;-------------------------------------------------------
trcior1				.equ		00F7h
;
ioc0_trcior1		.btequ		0,trcior1	; TRCGRC control C0 bit
ioc1_trcior1		.btequ		1,trcior1	; TRCGRC control C1 bit
ioc2_trcior1		.btequ		2,trcior1	; TRCGRC control C2 bit
ioc3_trcior1		.btequ		3,trcior1	; TRCGRC control C3 bit
iod0_trcior1		.btequ		4,trcior1	; TRCGRD control D0 bit
iod1_trcior1		.btequ		5,trcior1	; TRCGRD control D1 bit
iod2_trcior1		.btequ		6,trcior1	; TRCGRD control D2 bit
iod3_trcior1		.btequ		7,trcior1	; TRCGRD control D3 bit
;
;-------------------------------------------------------
;   Timer RC Control Register 2
;-------------------------------------------------------
trccr2				.equ		00F8h
;
polb_trccr2			.btequ		0,trccr2	; TRCIOB PWM mode output level control bit
polc_trccr2			.btequ		1,trccr2	; TRCIOC PWM mode output level control bit
pold_trccr2			.btequ		2,trccr2	; TRCIOD PWM mode output level control bit
cstp_trccr2			.btequ		5,trccr2	; Count stop bit
tceg0_trccr2		.btequ		6,trccr2	; TRCTRG input edge select bit
tceg1_trccr2		.btequ		7,trccr2	; TRCTRG input edge select bit
;
;-------------------------------------------------------
;   Timer RC Digital Filter Function Select Register
;-------------------------------------------------------
trcdf				.equ		00F9h
;
dfa_trcdf			.btequ		0,trcdf		; TRCIOA digital filter function bit
dfb_trcdf			.btequ		1,trcdf		; TRCIOB digital filter function bit
dfc_trcdf			.btequ		2,trcdf		; TRCIOC digital filter function bit
dfd_trcdf			.btequ		3,trcdf		; TRCIOD digital filter function bit
dftrg_trcdf			.btequ		4,trcdf		; TRCTRG digital filter function bit
dfck0_trcdf			.btequ		6,trcdf		; Digital filter clock select bit
dfck1_trcdf			.btequ		7,trcdf		; Digital filter clock select bit
;
;-------------------------------------------------------
;   Timer RC Output Enable Register
;-------------------------------------------------------
trcoer				.equ		00FAh
;
ea_trcoer			.btequ		0,trcoer	; TRCIOA output disable bit
eb_trcoer			.btequ		1,trcoer	; TRCIOB output disable bit
ec_trcoer			.btequ		2,trcoer	; TRCIOC output disable bit
ed_trcoer			.btequ		3,trcoer	; TRCIOD output disable bit
pto_trcoer			.btequ		7,trcoer	; Timer output disable bit
;
;-------------------------------------------------------
;   Timer RC A/D Conversion Trigger Control Register
;-------------------------------------------------------
trcadcr				.equ		00FBh
;
adtrgae_trcadcr		.btequ		0,trcadcr	; TRCGRA A/D conversion start trigger enable bit
adtrgbe_trcadcr		.btequ		1,trcadcr	; TRCGRB A/D conversion start trigger enable bit
adtrgce_trcadcr		.btequ		2,trcadcr	; TRCGRC A/D conversion start trigger enable bit
adtrgde_trcadcr		.btequ		3,trcadcr	; TRCGRD A/D conversion start trigger enable bit
;
;-------------------------------------------------------
;   Timer RC Waveform Output Manipulation Register
;-------------------------------------------------------
trcopr				.equ		00FCh
;
opsel0_trcopr		.btequ		0,trcopr	; Waveform output manipulation event select bit
opsel1_trcopr		.btequ		1,trcopr	; Waveform output manipulation event select bit
opol0_trcopr		.btequ		2,trcopr	; Waveform output manipulation period output level select bit
opol1_trcopr		.btequ		3,trcopr	; Waveform output manipulation period output level select bit
restats_trcopr		.btequ		4,trcopr	; Restart method select bit
ope_trcopr			.btequ		5,trcopr	; Waveform output manipulation enable bit
;
;-------------------------------------------------------
;   Comparator B Control Register
;-------------------------------------------------------
wcmpr				.equ		0180h
;
wcb1m0				.btequ		0,wcmpr		; Comparator B1 operation enable bit
wcb1out				.btequ		3,wcmpr		; Comparator B1 monitor flag
wcb3m0				.btequ		4,wcmpr		; Comparator B3 operation enable bit
wcb3out				.btequ		7,wcmpr		; Comparator B3 monitor flag
;
;-------------------------------------------------------
;   Comparator B1 Interrupt Control Register
;-------------------------------------------------------
wcb1intr			.equ		0181h
;
wcb1f0				.btequ		0,wcb1intr	; Comparator B1 filter select bit
wcb1f1				.btequ		1,wcb1intr	; Comparator B1 filter select bit
wcb1s0				.btequ		4,wcb1intr	; Comparator B1 interrupt edge select bit
wcb1s1				.btequ		5,wcb1intr	; Comparator B1 interrupt edge select bit
wcb1inten			.btequ		6,wcb1intr	; Comparator B1 interrupt enable signal bit
wcb1f				.btequ		7,wcb1intr	; Comparator B1 interrupt request flag
;
;-------------------------------------------------------
;   Comparator B3 Interrupt Control Register
;-------------------------------------------------------
wcb3intr			.equ		0182h
;
wcb3f0				.btequ		0,wcb3intr	; Comparator B3 filter select bit
wcb3f1				.btequ		1,wcb3intr	; Comparator B3 filter select bit
wcb3s0				.btequ		4,wcb3intr	; Comparator B3 interrupt edge select bit
wcb3s1				.btequ		5,wcb3intr	; Comparator B3 interrupt edge select bit
wcb3inten			.btequ		6,wcb3intr	; Comparator B3 interrupt enable signal bit
wcb3f				.btequ		7,wcb3intr	; Comparator B3 interrupt request flag
;
;-------------------------------------------------------
;   Flash Memory Status Register
;-------------------------------------------------------
fst					.equ		01A9h
;
rdysti				.btequ		0,fst		; Flash ready status interrupt request flag
bsyaei				.btequ		1,fst		; Flash access error interrupt request flag
fst2				.btequ		2,fst		; LBDATA monitor flag
fst3				.btequ		3,fst		; Program-suspend status flag
fst4				.btequ		4,fst		; Program error status flag
fst5				.btequ		5,fst		; Erase error/blank check error status flag
fst6				.btequ		6,fst		; Erase-suspend status flag
fst7				.btequ		7,fst		; Ready/busy status flag
;
;-------------------------------------------------------
;   Flash Memory Control Register 0
;-------------------------------------------------------
fmr0				.equ		01AAh
;
fmr01				.btequ		1,fmr0		; CPU rewrite mode select bit
fmr02				.btequ		2,fmr0		; EW1 mode select bit
fmstp				.btequ		3,fmr0		; Flash memory stop bit
cmdrst				.btequ		4,fmr0		; Erase/write sequence reset bit
cmderie				.btequ		5,fmr0		; Erase/write error, blank check error, command error interrupt enable bit
bsyaeie				.btequ		6,fmr0		; Flash access error interrupt enable bit
rdystie				.btequ		7,fmr0		; Flash ready status interrupt enable bit
;
;-------------------------------------------------------
;   Flash Memory Control Register 1
;-------------------------------------------------------
fmr1				.equ		01ABh
;
wtfmstp				.btequ		2,fmr1		; Flash memory stop bit in wait mode
fmr13				.btequ		3,fmr1		; Lock bit disable select bit
fmr16				.btequ		6,fmr1		; Data flash block A rewrite disable bit
fmr17				.btequ		7,fmr1		; Data flash block B rewrite disable bit
;
;-------------------------------------------------------
;   Flash Memory Control Register 2
;-------------------------------------------------------
fmr2				.equ		01ACh
;
fmr20				.btequ		0,fmr2		; Suspend enable bit
fmr21				.btequ		1,fmr2		; Suspend request bit
fmr22				.btequ		2,fmr2		; Interrupt request suspend request enable bit
fmr27				.btequ		7,fmr2		; Low-current-consumption read mode enable bit
;
;-------------------------------------------------------
;   Flash Memory Refresh Control Register
;-------------------------------------------------------
frefr				.equ		01ADh
;
ref0				.btequ		0,frefr		; Periodic refresh interval control bit
ref1				.btequ		1,frefr		; Periodic refresh interval control bit
ref2				.btequ		2,frefr		; Periodic refresh interval control bit
ref3				.btequ		3,frefr		; Periodic refresh interval control bit
ref4				.btequ		4,frefr		; Periodic refresh interval control bit
ref5				.btequ		5,frefr		; Periodic refresh interval control bit
;
;-------------------------------------------------------
;   Address Match Interrupt Register 0
;-------------------------------------------------------
aiadr0				.equ		01C0h
;
aiadr0l				.equ		aiadr0		;  Low
aiadr0m				.equ		aiadr0+1	;  Middle
aiadr0h				.equ		aiadr0+2	;  High
;
;-------------------------------------------------------
;   Address Match Interrupt Enable Register 0
;-------------------------------------------------------
aien0				.equ		01C3h
;
aien00				.btequ		0,aien0		; Address match interrupt enable 0 bit
;
;-------------------------------------------------------
;   Address Match Interrupt Register 1
;-------------------------------------------------------
aiadr1				.equ		01C4h
;
aiadr1l				.equ		aiadr1		;  Low
aiadr1m				.equ		aiadr1+1	;  Middle
aiadr1h				.equ		aiadr1+2	;  High
;
;-------------------------------------------------------
;   Address Match Interrupt Enable Register 1
;-------------------------------------------------------
aien1				.equ		01C7h
;
aien10				.btequ		0,aien1		; Address match interrupt enable 1 bit
;
