/***********************************************************************/
/*                                                                     */
/*  FILE        :resetprg.c                                            */
/*  DATE        :Mon, Jul 11, 2011                                     */
/*  DESCRIPTION :initialize for C language.                            */
/*  CPU GROUP   :M12A                                                  */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.19).    */
/*  NOTE:THIS IS A TYPICAL EXAMPLE.                                    */
/***********************************************************************/
/*********************************************************************
*
* Device     : R8C/M12A
*
* File Name  : resetprg.c
*
* Abstract   : Initialize for C language.
*
* History    : 0.10  (2010-12-20)  [Hardware Manual Revision : 1.00]
*
* NOTE       : THIS IS A TYPICAL EXAMPLE.
*
* Copyright (C) 2010 Renesas Electronics Corporation.
* and Renesas Solutions Corp.
*
*********************************************************************/
#include "sfr_r8m12a.h"
#include "typedefine.h"
#include "resetprg.h"
#include "initsct.h"

DEF_SBREGISTER;
extern _UINT	_stack_top,_istack_top;
#pragma entry start
void start(void);
//extern void initsct(void);
extern void _init(void);
//void exit(void);
void main(void);
//void _CALL_INIT(void);
//void _CALL_END(void);

#pragma section program interrupt 

void start(void)
{
	_isp_	= &_istack_top; 	// set interrupt stack pointer
	prcr	= 0x02U;		// change protect mode register
	pm0	= 0x00U;		// set processor mode register
	prcr	= 0x00U;		// change protect mode register
	_flg_	= __F_value__;	// set flag register
#if __STACKSIZE__!=0
	_sp_	= &_stack_top; 	// set user stack pointer
#endif
	_sb_	= 0x400U;	// 400H fixation (Do not change)
	_intbh_ = 0x00U; 	// set variable vector's address
	_asm("	ldc	#(topof vector)&0FFFFh,INTBL");

	//initsct();		// initlalize each sections
	{
		sclear("bss_SE","data","align");	
		sclear("bss_SO","data","noalign");
		sclear("bss_NE","data","align");
		sclear("bss_NO","data","noalign");
		// add new sections. refer to the above-mentioned.

		scopy("data_SE","data","align");
		scopy("data_SO","data","noalign");
		scopy("data_NE","data","align");
		scopy("data_NO","data","noalign");

	}
#if __HEAPSIZE__ != 0
	heap_init();		// initialize heap 
#endif
#if __STANDARD_IO__ != 0
	_init();			// initialize standard I/O
#endif
	_fb_ = 0U;		// initialize FB registe for debugger
	// _CALL_INIT();		// dynamic initialize non_local objects
	main();			// call main routine

	//exit();		// call exit
	for(;;);
}

//void exit(void)
//{
//	// _CALL_END();			// for static storage object destruct
//	while(1)
//	{
//		;		//infinite loop
//	}
//}


