/***********************************************************************/
/*                                                                     */
/*  FILE        :sfr_r8m12a.h                                          */
/*  DATE        :Mon, Jul 11, 2011                                     */
/*  DESCRIPTION :define the sfr register. (for C language)             */
/*  CPU GROUP   :M12A                                                  */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.19).    */
/*  NOTE:THIS IS A TYPICAL EXAMPLE.                                    */
/***********************************************************************/
/************************************************************************
*
* Device       : R8C/M12A
*
* File Name    : sfr_r8m12a.h
*
* Abstract     : definition of R8C/M12A Group SFR
*
* History      : 2.00 ( 2010-12-03 ) [User's Manual: Hardware Rev.1.00]
*              : 1.10 ( 2010-06-18 ) [User's Manual: Hardware Rev.0.10]
*              : 1.00 ( 2010-02-26 ) [User's Manual: Hardware Rev.0.01]
*
* NOTE         : THIS IS A TYPICAL EXAMPLE.
*
* Copyright (C) 2010 Renesas Electronics Corporation.
* and Renesas Solutions Corp.
*
*************************************************************************/

/********************************************************
*  declare SFR addresses                                *
********************************************************/

#pragma	ADDRESS		pm0_addr		0010H	/* Processor Mode Register 0 */

#pragma	ADDRESS		mstcr_addr		0012H	/* Module Standby Control Register */

#pragma	ADDRESS		prcr_addr		0013H	/* Protect Register */

#pragma	ADDRESS		hrpr_addr		0016H	/* Hardware Reset Protect Register */

#pragma	ADDRESS		exckcr_addr		0020H	/* External Clock Control Register */

#pragma	ADDRESS		ococr_addr		0021H	/* High-Speed/Low-Speed On-Chip Oscillator Control Register */

#pragma	ADDRESS		sckcr_addr		0022H	/* System Clock f Control Register */

#pragma	ADDRESS		phisel_addr		0023H	/* System Clock f Select Register */

#pragma	ADDRESS		ckstpr_addr		0024H	/* Clock Stop Control Register */

#pragma	ADDRESS		ckrscr_addr		0025H	/* Clock Control Register When Returning from Modes */

#pragma	ADDRESS		bakcr_addr		0026H	/* Oscillation Stop Detection Register */

#pragma	ADDRESS		risr_addr		0030H	/* Watchdog Timer Function Register */

#pragma	ADDRESS		wdtr_addr		0031H	/* Watchdog Timer Reset Register */

#pragma	ADDRESS		wdts_addr		0032H	/* Watchdog Timer Start Register */

#pragma	ADDRESS		wdtc_addr		0033H	/* Watchdog Timer Control Register */

#pragma	ADDRESS		cspr_addr		0034H	/* Count Source Protection Mode Register */

#pragma	ADDRESS		wdtir_addr		0035H	/* Periodic Timer Interrupt Control Register */

#pragma	ADDRESS		inten_addr		0038H	/* External Input Enable Register */

#pragma	ADDRESS		intf0_addr		003AH	/* INT Input Filter Select Register 0 */

#pragma	ADDRESS		iscr0_addr		003CH	/* INT Input Edge Select Register 0 */

#pragma	ADDRESS		kien_addr		003EH	/* Key Input Enable Register */

#pragma	ADDRESS		ilvl0_addr		0040H	/* Interrupt Priority Level Register 0 */

#pragma	ADDRESS		ilvl2_addr		0042H	/* Interrupt Priority Level Register 2 */

#pragma	ADDRESS		ilvl3_addr		0043H	/* Interrupt Priority Level Register 3 */

#pragma	ADDRESS		ilvl4_addr		0044H	/* Interrupt Priority Level Register 4 */

#pragma	ADDRESS		ilvl5_addr		0045H	/* Interrupt Priority Level Register 5 */

#pragma	ADDRESS		ilvl6_addr		0046H	/* Interrupt Priority Level Register 6 */

#pragma	ADDRESS		ilvl7_addr		0047H	/* Interrupt Priority Level Register 7 */

#pragma	ADDRESS		ilvl8_addr		0048H	/* Interrupt Priority Level Register 8 */

#pragma	ADDRESS		ilvl9_addr		0049H	/* Interrupt Priority Level Register 9 */

#pragma	ADDRESS		ilvla_addr		004AH	/* Interrupt Priority Level Register A */

#pragma	ADDRESS		ilvlb_addr		004BH	/* Interrupt Priority Level Register B */

#pragma	ADDRESS		ilvlc_addr		004CH	/* Interrupt Priority Level Register C */

#pragma	ADDRESS		ilvld_addr		004DH	/* Interrupt Priority Level Register D */

#pragma	ADDRESS		ilvle_addr		004EH	/* Interrupt Priority Level Register E */

#pragma	ADDRESS		irr0_addr		0050H	/* Interrupt Monitor Flag Register 0 */

#pragma	ADDRESS		irr1_addr		0051H	/* Interrupt Monitor Flag Register 1 */

#pragma	ADDRESS		irr2_addr		0052H	/* Interrupt Monitor Flag Register 2 */

#pragma	ADDRESS		irr3_addr		0053H	/* External Interrupt Flag Register */

#pragma	ADDRESS		vcac_addr		0058H	/* Voltage Monitor Circuit Edge Select Register */

#pragma	ADDRESS		vca2_addr		005AH	/* Voltage Detect Register 2 */

#pragma	ADDRESS		vd1ls_addr		005BH	/* Voltage Detection 1 Level Select Register */

#pragma	ADDRESS		vw0c_addr		005CH	/* Voltage Monitor 0 Circuit Control Register */

#pragma	ADDRESS		vw1c_addr		005DH	/* Voltage Monitor 1 Circuit Control Register */

#pragma	ADDRESS		rstfr_addr		005FH	/* Reset Source Determination Register */

#pragma	ADDRESS		fr18s0_addr		0064H	/* High-Speed On-Chip Oscillator 18.432 MHz Control Register 0 */

#pragma	ADDRESS		fr18s1_addr		0065H	/* High-Speed On-Chip Oscillator 18.432 MHz Control Register 1 */

#pragma	ADDRESS		frv1_addr		0067H	/* High-Speed On-Chip Oscillator Control Register 1 */

#pragma	ADDRESS		frv2_addr		0068H	/* High-Speed On-Chip Oscillator Control Register 2 */

#pragma	ADDRESS		u0mr_addr		0080H	/* UART0 Transmit/Receive Mode Register */

#pragma	ADDRESS		u0brg_addr		0081H	/* UART0 Bit Rate Register */

#pragma	ADDRESS		u0tbl_addr		0082H	/* UART0 Transmit Buffer Register Low */

#pragma	ADDRESS		u0tbh_addr		0083H	/* UART0 Transmit Buffer Register Hogh */

#pragma	ADDRESS		u0c0_addr		0084H	/* UART0 Transmit/Receive Control Register 0 */

#pragma	ADDRESS		u0c1_addr		0085H	/* UART0 Transmit/Receive Control Register 1 */

#pragma	ADDRESS		u0rb_addr		0086H	/* UART0 Receive Buffer Register */

#pragma	ADDRESS		u0ir_addr		0088H	/* UART0 Interrupt Flag and Enable Register */

#pragma	ADDRESS		ad0_addr		0098H	/* A/D Register 0 */

#pragma	ADDRESS		ad1_addr		009AH	/* A/D Register 1 */

#pragma	ADDRESS		admod_addr		009CH	/* A/D Mode Register */

#pragma	ADDRESS		adinsel_addr	009DH	/* A/D Input Select Register */

#pragma	ADDRESS		adcon0_addr		009EH	/* A/D Control Register 0 */

#pragma	ADDRESS		adicsr_addr		009FH	/* A/D Interrupt Control Status Register */

#pragma	ADDRESS		pd1_addr		00A9H	/* Port P1 Direction Register */

#pragma	ADDRESS		pd3_addr		00ABH	/* Port P3 Direction Register */

#pragma	ADDRESS		pd4_addr		00ACH	/* Port P4 Direction Register */

#pragma	ADDRESS		pda_addr		00ADH	/* Port PA Direction Register */

#pragma	ADDRESS		p1_addr			00AFH	/* Port P1 Register */

#pragma	ADDRESS		p3_addr			00B1H	/* Port P3 Register */

#pragma	ADDRESS		p4_addr			00B2H	/* Port P4 Register */

#pragma	ADDRESS		pa_addr			00B3H	/* Port PA Register */

#pragma	ADDRESS		pur1_addr		00B5H	/* Pull-Up Control Register 1 */

#pragma	ADDRESS		pur3_addr		00B7H	/* Pull-Up Control Register 3 */

#pragma	ADDRESS		pur4_addr		00B8H	/* Pull-Up Control Register 4 */

#pragma	ADDRESS		pinsr_addr		00B9H	/* Port I/O Function Control Register */

#pragma	ADDRESS		drr1_addr		00BBH	/* Drive Capacity Control Register 1 */

#pragma	ADDRESS		drr3_addr		00BDH	/* Drive Capacity Control Register 3 */

#pragma	ADDRESS		pod1_addr		00C1H	/* Open-Drain Control Register 1 */

#pragma	ADDRESS		pod3_addr		00C3H	/* Open-Drain Control Register 3 */

#pragma	ADDRESS		pod4_addr		00C4H	/* Open-Drain Control Register 4 */

#pragma	ADDRESS		pamcr_addr		00C5H	/* Port PA Mode Control Register */

#pragma	ADDRESS		pml1_addr		00C8H	/* Port 1 Function Mapping Register 0 */

#pragma	ADDRESS		pmh1_addr		00C9H	/* Port 1 Function Mapping Register 1 */

#pragma	ADDRESS		pml3_addr		00CCH	/* Port 3 Function Mapping Register 0 */

#pragma	ADDRESS		pmh3_addr		00CDH	/* Port 3 Function Mapping Register 1 */

#pragma	ADDRESS		pml4_addr		00CEH	/* Port 4 Function Mapping Register 0 */

#pragma	ADDRESS		pmh4_addr		00CFH	/* Port 4 Function Mapping Register 1 */

#pragma	ADDRESS		pmh1e_addr		00D1H	/* Port 1 Function Mapping Expansion Register */

#pragma	ADDRESS		pmh4e_addr		00D5H	/* Port 4 Function Mapping Expansion Register */

#pragma	ADDRESS		trj_addr		00D8H	/* Timer RJ Counter Register, Timer RJ Reload Register */

#pragma	ADDRESS		trjcr_addr		00DAH	/* Timer RJ Control Register */

#pragma	ADDRESS		trjioc_addr		00DBH	/* Timer RJ I/O Control Register */

#pragma	ADDRESS		trjmr_addr		00DCH	/* Timer RJ Mode Register */

#pragma	ADDRESS		trjisr_addr		00DDH	/* Timer RJ Event Select Register */

#pragma	ADDRESS		trjir_addr		00DEH	/* Timer RJ Interrupt Control Register */

#pragma	ADDRESS		trbcr_addr		00E0H	/* Timer RB Control Register */

#pragma	ADDRESS		trbocr_addr		00E1H	/* Timer RB One-Shot Control Register */

#pragma	ADDRESS		trbioc_addr		00E2H	/* Timer RB I/O Control Register */

#pragma	ADDRESS		trbmr_addr		00E3H	/* Timer RB Mode Register */

#pragma	ADDRESS		trbpre_addr		00E4H	/* Timer RB Prescaler Register */

#pragma	ADDRESS		trbpr_addr		00E5H	/* Timer RB Primary Register */

#pragma	ADDRESS		trbsc_addr		00E6H	/* Timer RB Secondary Register */

#pragma	ADDRESS		trbir_addr		00E7H	/* Timer RB Interrupt Control Register */

#pragma	ADDRESS		trccnt_addr		00E8H	/* Timer RC Counter */

#pragma	ADDRESS		trcgra_addr		00EAH	/* Timer RC General Register A */

#pragma	ADDRESS		trcgrb_addr		00ECH	/* Timer RC General Register B */

#pragma	ADDRESS		trcgrc_addr		00EEH	/* Timer RC General Register C */

#pragma	ADDRESS		trcgrd_addr		00F0H	/* Timer RC General Register D */

#pragma	ADDRESS		trcmr_addr		00F2H	/* Timer RC Mode Register */

#pragma	ADDRESS		trccr1_addr		00F3H	/* Timer RC Control Register 1 */

#pragma	ADDRESS		trcier_addr		00F4H	/* Timer RC Interrupt Enable Register */

#pragma	ADDRESS		trcsr_addr		00F5H	/* Timer RC Status Register */

#pragma	ADDRESS		trcior0_addr	00F6H	/* Timer RC I/O Control Register 0 */

#pragma	ADDRESS		trcior1_addr	00F7H	/* Timer RC I/O Control Register 1 */

#pragma	ADDRESS		trccr2_addr		00F8H	/* Timer RC Control Register 2 */

#pragma	ADDRESS		trcdf_addr		00F9H	/* Timer RC Digital Filter Function Select Register */

#pragma	ADDRESS		trcoer_addr		00FAH	/* Timer RC Output Enable Register */

#pragma	ADDRESS		trcadcr_addr	00FBH	/* Timer RC A/D Conversion Trigger Control Register */

#pragma	ADDRESS		trcopr_addr		00FCH	/* Timer RC Waveform Output Manipulation Register */

#pragma	ADDRESS		wcmpr_addr		0180H	/* Comparator B Control Register */

#pragma	ADDRESS		wcb1intr_addr	0181H	/* Comparator B1 Interrupt Control Register */

#pragma	ADDRESS		wcb3intr_addr	0182H	/* Comparator B3 Interrupt Control Register */

#pragma	ADDRESS		fst_addr		01A9H	/* Flash Memory Status Register */

#pragma	ADDRESS		fmr0_addr		01AAH	/* Flash Memory Control Register 0 */

#pragma	ADDRESS		fmr1_addr		01ABH	/* Flash Memory Control Register 1 */

#pragma	ADDRESS		fmr2_addr		01ACH	/* Flash Memory Control Register 2 */

#pragma	ADDRESS		frefr_addr		01ADH	/* Flash Memory Refresh Control Register */

#pragma	ADDRESS		aiadr0_addr		01C0H	/* Address Match Interrupt Register 0 */

#pragma	ADDRESS		aien0_addr		01C3H	/* Address Match Interrupt Enable Register 0 */

#pragma	ADDRESS		aiadr1_addr		01C4H	/* Address Match Interrupt Register 1 */

#pragma	ADDRESS		aien1_addr		01C7H	/* Address Match Interrupt Enable Register 1 */

/********************************************************
*  declare SFR union                                    *
********************************************************/
struct	bit_def_b {
	unsigned char	b0:1;
	unsigned char	b1:1;
	unsigned char	b2:1;
	unsigned char	b3:1;
	unsigned char	b4:1;
	unsigned char	b5:1;
	unsigned char	b6:1;
	unsigned char	b7:1;
};

struct	bit_def_w {
	unsigned char	b0:1;
	unsigned char	b1:1;
	unsigned char	b2:1;
	unsigned char	b3:1;
	unsigned char	b4:1;
	unsigned char	b5:1;
	unsigned char	b6:1;
	unsigned char	b7:1;

	unsigned char	b8:1;
	unsigned char	b9:1;
	unsigned char	b10:1;
	unsigned char	b11:1;
	unsigned char	b12:1;
	unsigned char	b13:1;
	unsigned char	b14:1;
	unsigned char	b15:1;
};

struct	bit_def_dw {
	unsigned char	b0:1;
	unsigned char	b1:1;
	unsigned char	b2:1;
	unsigned char	b3:1;
	unsigned char	b4:1;
	unsigned char	b5:1;
	unsigned char	b6:1;
	unsigned char	b7:1;

	unsigned char	b8:1;
	unsigned char	b9:1;
	unsigned char	b10:1;
	unsigned char	b11:1;
	unsigned char	b12:1;
	unsigned char	b13:1;
	unsigned char	b14:1;
	unsigned char	b15:1;

	unsigned char	b16:1;
	unsigned char	b17:1;
	unsigned char	b18:1;
	unsigned char	b19:1;
	unsigned char	b20:1;
	unsigned char	b21:1;
	unsigned char	b22:1;
	unsigned char	b23:1;

	unsigned char	b24:1;
	unsigned char	b25:1;
	unsigned char	b26:1;
	unsigned char	b27:1;
	unsigned char	b28:1;
	unsigned char	b29:1;
	unsigned char	b30:1;
	unsigned char	b31:1;
};

union	byte_def{
	struct	bit_def_b bit;
	unsigned char	byte;
};

union	word_def{
	struct	bit_def_w bit;
	struct{
		unsigned char	low;					/* low  8 bit */
		unsigned char	high;					/* high 8 bit */
	} byte;
	unsigned short	word;
};

union	dword_def{
	struct	bit_def_dw bit;
	struct{
		unsigned char	low;					/* low  8 bit */
		unsigned char	mid;					/* mid  8 bit */
		unsigned char	high;					/* high 8 bit */
		unsigned char	nc;						/* non use */
	} byte;
	unsigned long	dword;
};
/********************************************************
*  declare SFR bit                                      *
********************************************************/

/*------------------------------------------------------
  Processor Mode Register 0
------------------------------------------------------*/
union	byte_def	pm0_addr;
#define		pm0			pm0_addr.byte

#define		srst		pm0_addr.bit.b3			/* Software reset bit */

/*------------------------------------------------------
  Module Standby Control Register
------------------------------------------------------*/
union	byte_def	mstcr_addr;
#define		mstcr		mstcr_addr.byte

#define		msttrj		mstcr_addr.bit.b0		/* Timer RJ2 standby bit */
#define		msttrb		mstcr_addr.bit.b1		/* Timer RB2 standby bit */
#define		mstad		mstcr_addr.bit.b4		/* A/D converter standby bit */
#define		msttrc		mstcr_addr.bit.b5		/* Timer RC standby bit */
#define		mstuart		mstcr_addr.bit.b6		/* UART0 standby bit */

/*------------------------------------------------------
  Protect Register
------------------------------------------------------*/
union	byte_def	prcr_addr;
#define		prcr		prcr_addr.byte

#define		prc0		prcr_addr.bit.b0		/* Protect bit 0 */
#define		prc1		prcr_addr.bit.b1		/* Protect bit 1 */
#define		prc3		prcr_addr.bit.b3		/* Protect bit 3 */
#define		prc4		prcr_addr.bit.b4		/* Protect bit 4 */

/*------------------------------------------------------
  Hardware Reset Protect Register
------------------------------------------------------*/
union	byte_def	hrpr_addr;
#define		hrpr		hrpr_addr.byte

#define		pamcre		hrpr_addr.bit.b0		/* PAMCR register write enable bit */

/*------------------------------------------------------
  External Clock Control Register
------------------------------------------------------*/
union	byte_def	exckcr_addr;
#define		exckcr		exckcr_addr.byte

#define		ckpt0		exckcr_addr.bit.b0		/* P4_6 and P4_7 pin function select bit */
#define		ckpt1		exckcr_addr.bit.b1		/* P4_6 and P4_7 pin function select bit */
#define		xrcut		exckcr_addr.bit.b6		/* XIN-XOUT on-chip feedback resistor select bit */

/*------------------------------------------------------
  High-Speed/Low-Speed On-Chip Oscillator Control Register
------------------------------------------------------*/
union	byte_def	ococr_addr;
#define		ococr		ococr_addr.byte

#define		hocoe		ococr_addr.bit.b0		/* High-speed on-chip oscillator oscillation enable bit */
#define		locodis		ococr_addr.bit.b1		/* Low-speed on-chip oscillator oscillation stop bit */

/*------------------------------------------------------
  System Clock f Control Register
------------------------------------------------------*/
union	byte_def	sckcr_addr;
#define		sckcr		sckcr_addr.byte

#define		phissel0	sckcr_addr.bit.b0		/* CPU clock division ratio select bit */
#define		phissel1	sckcr_addr.bit.b1		/* CPU clock division ratio select bit */
#define		phissel2	sckcr_addr.bit.b2		/* CPU clock division ratio select bit */
#define		waitm		sckcr_addr.bit.b5		/* Wait control bit */
#define		hscksel		sckcr_addr.bit.b6		/* High-speed on-chip oscillator/XIN clock select bit */

/*------------------------------------------------------
  System Clock f Select Register
------------------------------------------------------*/
union	byte_def	phisel_addr;
#define		phisel		phisel_addr.byte

#define		phisel0		phisel_addr.bit.b0		/* System clock division select bit */
#define		phisel1		phisel_addr.bit.b1		/* System clock division select bit */
#define		phisel2		phisel_addr.bit.b2		/* System clock division select bit */
#define		phisel3		phisel_addr.bit.b3		/* System clock division select bit */
#define		phisel4		phisel_addr.bit.b4		/* System clock division select bit */
#define		phisel5		phisel_addr.bit.b5		/* System clock division select bit */
#define		phisel6		phisel_addr.bit.b6		/* System clock division select bit */
#define		phisel7		phisel_addr.bit.b7		/* System clock division select bit */

/*------------------------------------------------------
  Clock Stop Control Register
------------------------------------------------------*/
union	byte_def	ckstpr_addr;
#define		ckstpr		ckstpr_addr.byte

#define		stpm		ckstpr_addr.bit.b0		/* All clock stop control bit */
#define		wckstp		ckstpr_addr.bit.b1		/* fBASE stop bit in wait mode */
#define		pscstp		ckstpr_addr.bit.b2		/* Prescaler stop bit */
#define		scksel		ckstpr_addr.bit.b7		/* System base clock select bit */

/*------------------------------------------------------
  Clock Control Register When Returning from Modes
------------------------------------------------------*/
union	byte_def	ckrscr_addr;
#define		ckrscr		ckrscr_addr.byte

#define		ckst0		ckrscr_addr.bit.b0		/* Clock oscillator circuit oscillation stabilization state select bit */
#define		ckst1		ckrscr_addr.bit.b1		/* Clock oscillator circuit oscillation stabilization state select bit */
#define		ckst2		ckrscr_addr.bit.b2		/* Clock oscillator circuit oscillation stabilization state select bit */
#define		ckst3		ckrscr_addr.bit.b3		/* Clock oscillator circuit oscillation stabilization state select bit */
#define		phisrs		ckrscr_addr.bit.b5		/* CPU clock division select bit when returning from wait mode or stop mode */
#define		waitrs		ckrscr_addr.bit.b6		/* System base clock select bit when returning from wait mode */
#define		stoprs		ckrscr_addr.bit.b7		/* System base clock select bit when returning from stop mode */

/*------------------------------------------------------
  Oscillation Stop Detection Register
------------------------------------------------------*/
union	byte_def	bakcr_addr;
#define		bakcr		bakcr_addr.byte

#define		xinbake		bakcr_addr.bit.b0		/* Oscillation stop detection enable bit */
#define		ckswie		bakcr_addr.bit.b1		/* Oscillation stop detection interrupt enable bit */
#define		xinhalt		bakcr_addr.bit.b2		/* Clock monitor bit */
#define		ckswif		bakcr_addr.bit.b3		/* Oscillation stop detection interrupt request flag */

/*------------------------------------------------------
  Watchdog Timer Function Register
------------------------------------------------------*/
union	byte_def	risr_addr;
#define		risr		risr_addr.byte

#define		ufif		risr_addr.bit.b6		/* WDT underflow detection flag */
#define		ris			risr_addr.bit.b7		/* WDT interrupt/reset switch bit */

/*------------------------------------------------------
  Watchdog Timer Reset Register
------------------------------------------------------*/
union	byte_def	wdtr_addr;
#define		wdtr		wdtr_addr.byte

/*------------------------------------------------------
  Watchdog Timer Start Register
------------------------------------------------------*/
union	byte_def	wdts_addr;
#define		wdts		wdts_addr.byte

/*------------------------------------------------------
  Watchdog Timer Control Register
------------------------------------------------------*/
union	byte_def	wdtc_addr;
#define		wdtc		wdtc_addr.byte

#define		wdtc6		wdtc_addr.bit.b6		/* Watchdog timer count source select bit */
#define		wdtc7		wdtc_addr.bit.b7		/* Watchdog timer count source select bit */

/*------------------------------------------------------
  Count Source Protection Mode Register
------------------------------------------------------*/
union	byte_def	cspr_addr;
#define		cspr		cspr_addr.byte

#define		cspro		cspr_addr.bit.b7		/* Count source protection mode select bit */

/*------------------------------------------------------
  Periodic Timer Interrupt Control Register
------------------------------------------------------*/
union	byte_def	wdtir_addr;
#define		wdtir		wdtir_addr.byte

#define		wdtif		wdtir_addr.bit.b6		/* Periodic timer interrupt request flag */
#define		wdtie		wdtir_addr.bit.b7		/* Periodic timer interrupt enable bit */

/*------------------------------------------------------
  External Input Enable Register
------------------------------------------------------*/
union	byte_def	inten_addr;
#define		inten		inten_addr.byte

#define		int0en		inten_addr.bit.b0		/* INT0 input enable bit */
#define		int1en		inten_addr.bit.b1		/* INT1 input enable bit */
#define		int2en		inten_addr.bit.b2		/* INT2 input enable bit */
#define		int3en		inten_addr.bit.b3		/* INT3 input enable bit */

/*------------------------------------------------------
  INT Input Filter Select Register 0
------------------------------------------------------*/
union	byte_def	intf0_addr;
#define		intf0		intf0_addr.byte

#define		int0f0		intf0_addr.bit.b0		/* INT0 input filter select bit */
#define		int0f1		intf0_addr.bit.b1		/* INT0 input filter select bit */
#define		int1f0		intf0_addr.bit.b2		/* INT1 input filter select bit */
#define		int1f1		intf0_addr.bit.b3		/* INT1 input filter select bit */
#define		int2f0		intf0_addr.bit.b4		/* INT2 input filter select bit */
#define		int2f1		intf0_addr.bit.b5		/* INT2 input filter select bit */
#define		int3f0		intf0_addr.bit.b6		/* INT3 input filter select bit */
#define		int3f1		intf0_addr.bit.b7		/* INT3 input filter select bit */

/*------------------------------------------------------
  INT Input Edge Select Register 0
------------------------------------------------------*/
union	byte_def	iscr0_addr;
#define		iscr0		iscr0_addr.byte

#define		int0sa		iscr0_addr.bit.b0		/* INT0 input edge select bit */
#define		int0sb		iscr0_addr.bit.b1		/* INT0 input edge select bit */
#define		int1sa		iscr0_addr.bit.b2		/* INT1 input edge select bit */
#define		int1sb		iscr0_addr.bit.b3		/* INT1 input edge select bit */
#define		int2sa		iscr0_addr.bit.b4		/* INT2 input edge select bit */
#define		int2sb		iscr0_addr.bit.b5		/* INT2 input edge select bit */
#define		int3sa		iscr0_addr.bit.b6		/* INT3 input edge select bit */
#define		int3sb		iscr0_addr.bit.b7		/* INT3 input edge select bit */

/*------------------------------------------------------
  Key Input Enable Register
------------------------------------------------------*/
union	byte_def	kien_addr;
#define		kien		kien_addr.byte

#define		ki0en		kien_addr.bit.b0		/* KI0 input enable bit */
#define		ki0pl		kien_addr.bit.b1		/* KI0 input edge select bit */
#define		ki1en		kien_addr.bit.b2		/* KI1 input enable bit */
#define		ki1pl		kien_addr.bit.b3		/* KI1 input edge select bit */
#define		ki2en		kien_addr.bit.b4		/* KI2 input enable bit */
#define		ki2pl		kien_addr.bit.b5		/* KI2 input edge select bit */
#define		ki3en		kien_addr.bit.b6		/* KI3 input enable bit */
#define		ki3pl		kien_addr.bit.b7		/* KI3 input edge select bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 0
------------------------------------------------------*/
union	byte_def	ilvl0_addr;
#define		ilvl0		ilvl0_addr.byte

#define		ilvl00		ilvl0_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl01		ilvl0_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl04		ilvl0_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl05		ilvl0_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 2
------------------------------------------------------*/
union	byte_def	ilvl2_addr;
#define		ilvl2		ilvl2_addr.byte

#define		ilvl20		ilvl2_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl21		ilvl2_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl24		ilvl2_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl25		ilvl2_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 3
------------------------------------------------------*/
union	byte_def	ilvl3_addr;
#define		ilvl3		ilvl3_addr.byte

#define		ilvl30		ilvl3_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl31		ilvl3_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl34		ilvl3_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl35		ilvl3_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 4
------------------------------------------------------*/
union	byte_def	ilvl4_addr;
#define		ilvl4		ilvl4_addr.byte

#define		ilvl40		ilvl4_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl41		ilvl4_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl44		ilvl4_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl45		ilvl4_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 5
------------------------------------------------------*/
union	byte_def	ilvl5_addr;
#define		ilvl5		ilvl5_addr.byte

#define		ilvl50		ilvl5_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl51		ilvl5_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl54		ilvl5_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl55		ilvl5_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 6
------------------------------------------------------*/
union	byte_def	ilvl6_addr;
#define		ilvl6		ilvl6_addr.byte

#define		ilvl60		ilvl6_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl61		ilvl6_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl64		ilvl6_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl65		ilvl6_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 7
------------------------------------------------------*/
union	byte_def	ilvl7_addr;
#define		ilvl7		ilvl7_addr.byte

#define		ilvl70		ilvl7_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl71		ilvl7_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl74		ilvl7_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl75		ilvl7_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 8
------------------------------------------------------*/
union	byte_def	ilvl8_addr;
#define		ilvl8		ilvl8_addr.byte

#define		ilvl80		ilvl8_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl81		ilvl8_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl84		ilvl8_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl85		ilvl8_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register 9
------------------------------------------------------*/
union	byte_def	ilvl9_addr;
#define		ilvl9		ilvl9_addr.byte

#define		ilvl90		ilvl9_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvl91		ilvl9_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvl94		ilvl9_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvl95		ilvl9_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register A
------------------------------------------------------*/
union	byte_def	ilvla_addr;
#define		ilvla		ilvla_addr.byte

#define		ilvla0		ilvla_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvla1		ilvla_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvla4		ilvla_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvla5		ilvla_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register B
------------------------------------------------------*/
union	byte_def	ilvlb_addr;
#define		ilvlb		ilvlb_addr.byte

#define		ilvlb0		ilvlb_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvlb1		ilvlb_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvlb4		ilvlb_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvlb5		ilvlb_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register C
------------------------------------------------------*/
union	byte_def	ilvlc_addr;
#define		ilvlc		ilvlc_addr.byte

#define		ilvlc0		ilvlc_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvlc1		ilvlc_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvlc4		ilvlc_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvlc5		ilvlc_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register D
------------------------------------------------------*/
union	byte_def	ilvld_addr;
#define		ilvld		ilvld_addr.byte

#define		ilvld0		ilvld_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvld1		ilvld_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvld4		ilvld_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvld5		ilvld_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Priority Level Register E
------------------------------------------------------*/
union	byte_def	ilvle_addr;
#define		ilvle		ilvle_addr.byte

#define		ilvle0		ilvle_addr.bit.b0		/* Interrupt priority level setting bit */
#define		ilvle1		ilvle_addr.bit.b1		/* Interrupt priority level setting bit */
#define		ilvle4		ilvle_addr.bit.b4		/* Interrupt priority level setting bit */
#define		ilvle5		ilvle_addr.bit.b5		/* Interrupt priority level setting bit */

/*------------------------------------------------------
  Interrupt Monitor Flag Register 0
------------------------------------------------------*/
union	byte_def	irr0_addr;
#define		irr0		irr0_addr.byte

#define		irtj		irr0_addr.bit.b0		/* Timer RJ2 interrupt request monitor flag */
#define		irtb		irr0_addr.bit.b1		/* Timer RB2 interrupt request monitor flag */
#define		irtc		irr0_addr.bit.b2		/* Timer RC interrupt request monitor flag */
#define		irs0t		irr0_addr.bit.b4		/* UART0 transmit interrupt request monitor flag */
#define		irs0r		irr0_addr.bit.b5		/* UART0 receive interrupt request monitor flag */

/*------------------------------------------------------
  Interrupt Monitor Flag Register 1
------------------------------------------------------*/
union	byte_def	irr1_addr;
#define		irr1		irr1_addr.byte

#define		irad		irr1_addr.bit.b2		/* A/D conversion interrupt request monitor flag */
#define		irfm		irr1_addr.bit.b4		/* Flash ready interrupt request monitor flag */
#define		irwd		irr1_addr.bit.b5		/* Periodic timer interrupt request monitor flag */

/*------------------------------------------------------
  Interrupt Monitor Flag Register 2
------------------------------------------------------*/
union	byte_def	irr2_addr;
#define		irr2		irr2_addr.byte

#define		ircmp1		irr2_addr.bit.b2		/* Comparator B1 interrupt request monitor flag */
#define		ircmp3		irr2_addr.bit.b3		/* Comparator B3 interrupt request monitor flag */

/*------------------------------------------------------
  External Interrupt Flag Register
------------------------------------------------------*/
union	byte_def	irr3_addr;
#define		irr3		irr3_addr.byte

#define		iri0		irr3_addr.bit.b0		/* INT0 interrupt request flag */
#define		iri1		irr3_addr.bit.b1		/* INT1 interrupt request flag */
#define		iri2		irr3_addr.bit.b2		/* INT2 interrupt request flag */
#define		iri3		irr3_addr.bit.b3		/* INT3 interrupt request flag */
#define		irki		irr3_addr.bit.b5		/* Key input interrupt request flag */

/*------------------------------------------------------
  Voltage Monitor Circuit Edge Select Register
------------------------------------------------------*/
union	byte_def	vcac_addr;
#define		vcac		vcac_addr.byte

#define		vcac1		vcac_addr.bit.b1		/* Voltage monitor 1 circuit edge select bit */

/*------------------------------------------------------
  Voltage Detect Register 2
------------------------------------------------------*/
union	byte_def	vca2_addr;
#define		vca2		vca2_addr.byte

#define		lpe			vca2_addr.bit.b0		/* Internal low-power-consumption enable bit */
#define		vc0e		vca2_addr.bit.b5		/* Voltage detection 0 enable bit */
#define		vc1e		vca2_addr.bit.b6		/* Voltage detection 1 enable bit */

/*------------------------------------------------------
  Voltage Detection 1 Level Select Register
------------------------------------------------------*/
union	byte_def	vd1ls_addr;
#define		vd1ls		vd1ls_addr.byte

#define		vd1s1		vd1ls_addr.bit.b1		/* Voltage detection 1 Level select bit */
#define		vd1s2		vd1ls_addr.bit.b2		/* Voltage detection 1 Level select bit */
#define		vd1s3		vd1ls_addr.bit.b3		/* Voltage detection 1 Level select bit */

/*------------------------------------------------------
  Voltage Monitor 0 Circuit Control Register
------------------------------------------------------*/
union	byte_def	vw0c_addr;
#define		vw0c		vw0c_addr.byte

#define		vw0c0		vw0c_addr.bit.b0		/* Voltage monitor 0 reset enable bit */
#define		vw0c1		vw0c_addr.bit.b1		/* Voltage monitor 0 digital filter mode select bit */
#define		vw0f0		vw0c_addr.bit.b4		/* Sampling clock select bit */
#define		vw0f1		vw0c_addr.bit.b5		/* Sampling clock select bit */

/*------------------------------------------------------
  Voltage Monitor 1 Circuit Control Register
------------------------------------------------------*/
union	byte_def	vw1c_addr;
#define		vw1c		vw1c_addr.byte

#define		vw1c0		vw1c_addr.bit.b0		/* Voltage monitor 1 interrupt enable bit */
#define		vw1c1		vw1c_addr.bit.b1		/* Voltage monitor 1 digital filter mode select bit */
#define		vw1c2		vw1c_addr.bit.b2		/* Voltage change detection flag */
#define		vw1c3		vw1c_addr.bit.b3		/* Voltage detection 1 signal monitor flag */
#define		vw1f0		vw1c_addr.bit.b4		/* Sampling clock select bit */
#define		vw1f1		vw1c_addr.bit.b5		/* Sampling clock select bit */
#define		vw1c7		vw1c_addr.bit.b7		/* Voltage monitor 1 interrupt generation condition select bit */

/*------------------------------------------------------
  Reset Source Determination Register
------------------------------------------------------*/
union	byte_def	rstfr_addr;
#define		rstfr		rstfr_addr.byte

#define		cwr			rstfr_addr.bit.b0		/* Cold start-up/warm start-up determine flag */
#define		hwr			rstfr_addr.bit.b1		/* Hardware reset detect flag */
#define		swr			rstfr_addr.bit.b2		/* Software reset detect flag */
#define		wdr			rstfr_addr.bit.b3		/* Watchdog timer reset detect flag */

/*------------------------------------------------------
  High-Speed On-Chip Oscillator 18.432 MHz Control Register 0
------------------------------------------------------*/
union	byte_def	fr18s0_addr;
#define		fr18s0		fr18s0_addr.byte

/*------------------------------------------------------
  High-Speed On-Chip Oscillator 18.432 MHz Control Register 1
------------------------------------------------------*/
union	byte_def	fr18s1_addr;
#define		fr18s1		fr18s1_addr.byte

/*------------------------------------------------------
  High-Speed On-Chip Oscillator Control Register 1
------------------------------------------------------*/
union	byte_def	frv1_addr;
#define		frv1		frv1_addr.byte

/*------------------------------------------------------
  High-Speed On-Chip Oscillator Control Register 2
------------------------------------------------------*/
union	byte_def	frv2_addr;
#define		frv2		frv2_addr.byte

/*------------------------------------------------------
  UART0 Transmit/Receive Mode Register
------------------------------------------------------*/
union	byte_def	u0mr_addr;
#define		u0mr		u0mr_addr.byte

#define		smd0_u0mr		u0mr_addr.bit.b0	/* Serial I/O mode select bit */
#define		smd1_u0mr		u0mr_addr.bit.b1	/* Serial I/O mode select bit */
#define		smd2_u0mr		u0mr_addr.bit.b2	/* Serial I/O mode select bit */
#define		ckdir_u0mr		u0mr_addr.bit.b3	/* Internal/external clock select bit */
#define		stps_u0mr		u0mr_addr.bit.b4	/* Stop bit length select bit */
#define		pry_u0mr		u0mr_addr.bit.b5	/* Odd/even parity select bit */
#define		prye_u0mr		u0mr_addr.bit.b6	/* Parity enable bit */

/*------------------------------------------------------
  UART0 Bit Rate Register
------------------------------------------------------*/
union	byte_def	u0brg_addr;
#define		u0brg		u0brg_addr.byte

/*------------------------------------------------------
  UART0 Transmit Buffer Register Low
------------------------------------------------------*/
union	byte_def	u0tbl_addr;
#define		u0tbl		u0tbl_addr.byte

/*------------------------------------------------------
  UART0 Transmit Buffer Register High
------------------------------------------------------*/
union	byte_def	u0tbh_addr;
#define		u0tbh		u0tbh_addr.byte

/*------------------------------------------------------
  UART0 Transmit/Receive Control Register 0
------------------------------------------------------*/
union	byte_def	u0c0_addr;
#define		u0c0		u0c0_addr.byte

#define		clk0_u0c0		u0c0_addr.bit.b0	/* U0BRG count source select bit */
#define		clk1_u0c0		u0c0_addr.bit.b1	/* U0BRG count source select bit */
#define		txept_u0c0		u0c0_addr.bit.b3	/* Transmit register empty flag */
#define		dfe_u0c0		u0c0_addr.bit.b4	/* RXD0 digital filter enable bit */
#define		nch_u0c0		u0c0_addr.bit.b5	/* Data output select bit */
#define		ckpol_u0c0		u0c0_addr.bit.b6	/* CLK polarity select bit */
#define		uform_u0c0		u0c0_addr.bit.b7	/* Transfer format select bit */

/*------------------------------------------------------
  UART0 Transmit/Receive Control Register 1
------------------------------------------------------*/
union	byte_def	u0c1_addr;
#define		u0c1		u0c1_addr.byte

#define		te_u0c1			u0c1_addr.bit.b0	/* Transmit enable bit */
#define		ti_u0c1			u0c1_addr.bit.b1	/* Transmit buffer empty flag */
#define		re_u0c1			u0c1_addr.bit.b2	/* Receive enable bit */
#define		ri_u0c1			u0c1_addr.bit.b3	/* Receive complete flag */
#define		u0irs_u0c1		u0c1_addr.bit.b4	/* UART0 transmit interrupt source select bit */
#define		u0rrm_u0c1		u0c1_addr.bit.b5	/* UART0 continuous receive mode enable bit */

/*------------------------------------------------------
  UART0 Receive Buffer Register
------------------------------------------------------*/
union	word_def	u0rb_addr;
#define		u0rb		u0rb_addr.word

/*------------------------------------------------------
  UART0 Interrupt Flag and Enable Register
------------------------------------------------------*/
union	byte_def	u0ir_addr;
#define		u0ir		u0ir_addr.byte

#define		u0rie		u0ir_addr.bit.b2		/* UART0 receive interrupt enable bit */
#define		u0tie		u0ir_addr.bit.b3		/* UART0 transmit interrupt enable bit */
#define		u0rif		u0ir_addr.bit.b6		/* UART0 receive interrupt flag */
#define		u0tif		u0ir_addr.bit.b7		/* UART0 transmit interrupt flag */

/*------------------------------------------------------
  A/D Register 0
------------------------------------------------------*/
union	word_def	ad0_addr;
#define		ad0			ad0_addr.word			/* A/D Register 0 */

#define		ad0l		ad0_addr.byte.low		/* A/D Register 0 Low */
#define		ad0h		ad0_addr.byte.high		/* A/D Register 0 High */

/*------------------------------------------------------
  A/D Register 1
------------------------------------------------------*/
union	word_def	ad1_addr;
#define		ad1			ad1_addr.word			/* A/D Register 1 */

#define		ad1l		ad1_addr.byte.low		/* A/D Register 1 Low */
#define		ad1h		ad1_addr.byte.high		/* A/D Register 1 High */

/*------------------------------------------------------
  A/D Mode Register
------------------------------------------------------*/
union	byte_def	admod_addr;
#define		admod		admod_addr.byte

#define		cks0		admod_addr.bit.b0		/* A/D conversion clock select bit */
#define		cks1		admod_addr.bit.b1		/* A/D conversion clock select bit */
#define		cks2		admod_addr.bit.b2		/* A/D conversion clock select bit */
#define		md0			admod_addr.bit.b3		/* A/D operating mode select bit */
#define		md1			admod_addr.bit.b4		/* A/D operating mode select bit */
#define		adcap0		admod_addr.bit.b6		/* A/D conversion trigger select bit */
#define		adcap1		admod_addr.bit.b7		/* A/D conversion trigger select bit */

/*------------------------------------------------------
  A/D Input Select Register
------------------------------------------------------*/
union	byte_def	adinsel_addr;
#define		adinsel		adinsel_addr.byte

#define		ch0			adinsel_addr.bit.b0		/* Channel select bit */
#define		adgsel0		adinsel_addr.bit.b6		/* A/D input group select bit */
#define		adgsel1		adinsel_addr.bit.b7		/* A/D input group select bit */

/*------------------------------------------------------
  A/D Control Register 0
------------------------------------------------------*/
union	byte_def	adcon0_addr;
#define		adcon0		adcon0_addr.byte

#define		adst		adcon0_addr.bit.b0		/* A/D conversion start bit */

/*------------------------------------------------------
  A/D Interrupt Control Status Register
------------------------------------------------------*/
union	byte_def	adicsr_addr;
#define		adicsr		adicsr_addr.byte

#define		adie		adicsr_addr.bit.b6		/* A/D conversion interrupt enable bit */
#define		adf			adicsr_addr.bit.b7		/* A/D conversion Interrupt request bit */

/*------------------------------------------------------
  Port P1 Direction Register
------------------------------------------------------*/
union	byte_def	pd1_addr;
#define		pd1			pd1_addr.byte

#define		pd1_0		pd1_addr.bit.b0			/* Port P1_0 direction bit */
#define		pd1_1		pd1_addr.bit.b1			/* Port P1_1 direction bit */
#define		pd1_2		pd1_addr.bit.b2			/* Port P1_2 direction bit */
#define		pd1_3		pd1_addr.bit.b3			/* Port P1_3 direction bit */
#define		pd1_4		pd1_addr.bit.b4			/* Port P1_4 direction bit */
#define		pd1_5		pd1_addr.bit.b5			/* Port P1_5 direction bit */
#define		pd1_6		pd1_addr.bit.b6			/* Port P1_6 direction bit */
#define		pd1_7		pd1_addr.bit.b7			/* Port P1_7 direction bit */

/*------------------------------------------------------
  Port P3 Direction Register
------------------------------------------------------*/
union	byte_def	pd3_addr;
#define		pd3			pd3_addr.byte

#define		pd3_3		pd3_addr.bit.b3			/* Port P3_3 direction bit */
#define		pd3_4		pd3_addr.bit.b4			/* Port P3_4 direction bit */
#define		pd3_5		pd3_addr.bit.b5			/* Port P3_5 direction bit */
#define		pd3_7		pd3_addr.bit.b7			/* Port P3_7 direction bit */

/*------------------------------------------------------
  Port P4 Direction Register
------------------------------------------------------*/
union	byte_def	pd4_addr;
#define		pd4			pd4_addr.byte

#define		pd4_2		pd4_addr.bit.b2			/* Port P4_2 direction bit */
#define		pd4_5		pd4_addr.bit.b5			/* Port P4_5 direction bit */
#define		pd4_6		pd4_addr.bit.b6			/* Port P4_6 direction bit */
#define		pd4_7		pd4_addr.bit.b7			/* Port P4_7 direction bit */

/*------------------------------------------------------
  Port PA Direction Register
------------------------------------------------------*/
union	byte_def	pda_addr;
#define		pda			pda_addr.byte

#define		pda_0		pda_addr.bit.b0			/* Port PA_0 direction bit */

/*------------------------------------------------------
  Port P1 Register
------------------------------------------------------*/
union	byte_def	p1_addr;
#define		p1			p1_addr.byte

#define		p1_0		p1_addr.bit.b0			/* Port P1_0 bit */
#define		p1_1		p1_addr.bit.b1			/* Port P1_1 bit */
#define		p1_2		p1_addr.bit.b2			/* Port P1_2 bit */
#define		p1_3		p1_addr.bit.b3			/* Port P1_3 bit */
#define		p1_4		p1_addr.bit.b4			/* Port P1_4 bit */
#define		p1_5		p1_addr.bit.b5			/* Port P1_5 bit */
#define		p1_6		p1_addr.bit.b6			/* Port P1_6 bit */
#define		p1_7		p1_addr.bit.b7			/* Port P1_7 bit */

/*------------------------------------------------------
  Port P3 Register
------------------------------------------------------*/
union	byte_def	p3_addr;
#define		p3			p3_addr.byte

#define		p3_3		p3_addr.bit.b3			/* Port P3_3 bit */
#define		p3_4		p3_addr.bit.b4			/* Port P3_4 bit */
#define		p3_5		p3_addr.bit.b5			/* Port P3_5 bit */
#define		p3_7		p3_addr.bit.b7			/* Port P3_7 bit */

/*------------------------------------------------------
  Port P4 Register
------------------------------------------------------*/
union	byte_def	p4_addr;
#define		p4			p4_addr.byte

#define		p4_2		p4_addr.bit.b2			/* Port P4_2 bit */
#define		p4_5		p4_addr.bit.b5			/* Port P4_5 bit */
#define		p4_6		p4_addr.bit.b6			/* Port P4_6 bit */
#define		p4_7		p4_addr.bit.b7			/* Port P4_7 bit */

/*------------------------------------------------------
  Port PA Register
------------------------------------------------------*/
union	byte_def	pa_addr;
#define		pa			pa_addr.byte

#define		pa_0		pa_addr.bit.b0			/* Port PA_0 bit */

/*------------------------------------------------------
  Pull-Up Control Register 1
------------------------------------------------------*/
union	byte_def	pur1_addr;
#define		pur1		pur1_addr.byte

#define		pu1_0		pur1_addr.bit.b0		/* Port P1_0 pull-up control bit */
#define		pu1_1		pur1_addr.bit.b1		/* Port P1_1 pull-up control bit */
#define		pu1_2		pur1_addr.bit.b2		/* Port P1_2 pull-up control bit */
#define		pu1_3		pur1_addr.bit.b3		/* Port P1_3 pull-up control bit */
#define		pu1_4		pur1_addr.bit.b4		/* Port P1_4 pull-up control bit */
#define		pu1_5		pur1_addr.bit.b5		/* Port P1_5 pull-up control bit */
#define		pu1_6		pur1_addr.bit.b6		/* Port P1_6 pull-up control bit */
#define		pu1_7		pur1_addr.bit.b7		/* Port P1_7 pull-up control bit */

/*------------------------------------------------------
  Pull-Up Control Register 3
------------------------------------------------------*/
union	byte_def	pur3_addr;
#define		pur3		pur3_addr.byte

#define		pu3_3		pur3_addr.bit.b3		/* Port P3_3 pull-up control bit */
#define		pu3_4		pur3_addr.bit.b4		/* Port P3_4 pull-up control bit */
#define		pu3_5		pur3_addr.bit.b5		/* Port P3_5 pull-up control bit */
#define		pu3_7		pur3_addr.bit.b7		/* Port P3_7 pull-up control bit */

/*------------------------------------------------------
  Pull-Up Control Register 4
------------------------------------------------------*/
union	byte_def	pur4_addr;
#define		pur4		pur4_addr.byte

#define		pu4_2		pur4_addr.bit.b2		/* Port P4_2 pull-up control bit */
#define		pu4_5		pur4_addr.bit.b5		/* Port P4_5 pull-up control bit */
#define		pu4_6		pur4_addr.bit.b6		/* Port P4_6 pull-up control bit */
#define		pu4_7		pur4_addr.bit.b7		/* Port P4_7 pull-up control bit */

/*------------------------------------------------------
  Port I/O Function Control Register
------------------------------------------------------*/
union	byte_def	pinsr_addr;
#define		pinsr		pinsr_addr.byte

#define		trjiosel	pinsr_addr.bit.b6		/* TRJIO input signal select bit */
#define		ioinsel		pinsr_addr.bit.b7		/* Pin level forced read-out bit */

/*------------------------------------------------------
  Drive Capacity Control Register 1
------------------------------------------------------*/
union	byte_def	drr1_addr;
#define		drr1		drr1_addr.byte

#define		drr1_2		drr1_addr.bit.b2		/* Port P1_2 drive capacity control bit */
#define		drr1_3		drr1_addr.bit.b3		/* Port P1_3 drive capacity control bit */
#define		drr1_4		drr1_addr.bit.b4		/* Port P1_4 drive capacity control bit */
#define		drr1_5		drr1_addr.bit.b5		/* Port P1_5 drive capacity control bit */

/*------------------------------------------------------
  Drive Capacity Control Register 3
------------------------------------------------------*/
union	byte_def	drr3_addr;
#define		drr3		drr3_addr.byte

#define		drr3_3		drr3_addr.bit.b3		/* Port P3_3 drive capacity control bit */
#define		drr3_4		drr3_addr.bit.b4		/* Port P3_4 drive capacity control bit */
#define		drr3_5		drr3_addr.bit.b5		/* Port P3_5 drive capacity control bit */
#define		drr3_7		drr3_addr.bit.b7		/* Port P3_7 drive capacity control bit */

/*------------------------------------------------------
  Open-Drain Control Register 1
------------------------------------------------------*/
union	byte_def	pod1_addr;
#define		pod1		pod1_addr.byte

#define		pod1_0		pod1_addr.bit.b0		/* Port P1_0 open-drain control bit */
#define		pod1_1		pod1_addr.bit.b1		/* Port P1_1 open-drain control bit */
#define		pod1_2		pod1_addr.bit.b2		/* Port P1_2 open-drain control bit */
#define		pod1_3		pod1_addr.bit.b3		/* Port P1_3 open-drain control bit */
#define		pod1_4		pod1_addr.bit.b4		/* Port P1_4 open-drain control bit */
#define		pod1_5		pod1_addr.bit.b5		/* Port P1_5 open-drain control bit */
#define		pod1_6		pod1_addr.bit.b6		/* Port P1_6 open-drain control bit */
#define		pod1_7		pod1_addr.bit.b7		/* Port P1_7 open-drain control bit */

/*------------------------------------------------------
  Open-Drain Control Register 3
------------------------------------------------------*/
union	byte_def	pod3_addr;
#define		pod3		pod3_addr.byte

#define		pod3_3		pod3_addr.bit.b3		/* Port P3_3 open-drain control bit */
#define		pod3_4		pod3_addr.bit.b4		/* Port P3_4 open-drain control bit */
#define		pod3_5		pod3_addr.bit.b5		/* Port P3_5 open-drain control bit */
#define		pod3_7		pod3_addr.bit.b7		/* Port P3_7 open-drain control bit */

/*------------------------------------------------------
  Open-Drain Control Register 4
------------------------------------------------------*/
union	byte_def	pod4_addr;
#define		pod4		pod4_addr.byte

#define		pod4_2		pod4_addr.bit.b2		/* Port P4_2 open-drain control bit */
#define		pod4_5		pod4_addr.bit.b5		/* Port P4_5 open-drain control bit */
#define		pod4_6		pod4_addr.bit.b6		/* Port P4_6 open-drain control bit */
#define		pod4_7		pod4_addr.bit.b7		/* Port P4_7 open-drain control bit */

/*------------------------------------------------------
  Port PA Mode Control Register
------------------------------------------------------*/
union	byte_def	pamcr_addr;
#define		pamcr		pamcr_addr.byte

#define		poda_0		pamcr_addr.bit.b0		/* Port PA_0 open-drain control bit */
#define		hwrste		pamcr_addr.bit.b4		/* Hardware reset enabled bit */

/*------------------------------------------------------
  Port 1 Function Mapping Register 0
------------------------------------------------------*/
union	byte_def	pml1_addr;
#define		pml1		pml1_addr.byte

#define		p10sel0		pml1_addr.bit.b0		/* Port P1_0 function select bit */
#define		p10sel1		pml1_addr.bit.b1		/* Port P1_0 function select bit */
#define		p11sel0		pml1_addr.bit.b2		/* Port P1_1 function select bit */
#define		p11sel1		pml1_addr.bit.b3		/* Port P1_1 function select bit */
#define		p12sel0		pml1_addr.bit.b4		/* Port P1_2 function select bit */
#define		p12sel1		pml1_addr.bit.b5		/* Port P1_2 function select bit */
#define		p13sel0		pml1_addr.bit.b6		/* Port P1_3 function select bit */
#define		p13sel1		pml1_addr.bit.b7		/* Port P1_3 function select bit */

/*------------------------------------------------------
  Port 1 Function Mapping Register 1
------------------------------------------------------*/
union	byte_def	pmh1_addr;
#define		pmh1		pmh1_addr.byte

#define		p14sel0		pmh1_addr.bit.b0		/* Port P1_4 function select bit */
#define		p14sel1		pmh1_addr.bit.b1		/* Port P1_4 function select bit */
#define		p15sel0		pmh1_addr.bit.b2		/* Port P1_5 function select bit */
#define		p15sel1		pmh1_addr.bit.b3		/* Port P1_5 function select bit */
#define		p16sel0		pmh1_addr.bit.b4		/* Port P1_6 function select bit */
#define		p16sel1		pmh1_addr.bit.b5		/* Port P1_6 function select bit */
#define		p17sel0		pmh1_addr.bit.b6		/* Port P1_7 function select bit */
#define		p17sel1		pmh1_addr.bit.b7		/* Port P1_7 function select bit */

/*------------------------------------------------------
  Port 3 Function Mapping Register 0
------------------------------------------------------*/
union	byte_def	pml3_addr;
#define		pml3		pml3_addr.byte

#define		p33sel0		pml3_addr.bit.b6		/* Port P3_3 function select bit */
#define		p33sel1		pml3_addr.bit.b7		/* Port P3_3 function select bit */

/*------------------------------------------------------
  Port 3 Function Mapping Register 1
------------------------------------------------------*/
union	byte_def	pmh3_addr;
#define		pmh3		pmh3_addr.byte

#define		p34sel0		pmh3_addr.bit.b0		/* Port P3_4 function select bit */
#define		p34sel1		pmh3_addr.bit.b1		/* Port P3_4 function select bit */
#define		p35sel0		pmh3_addr.bit.b2		/* Port P3_5 function select bit */
#define		p35sel1		pmh3_addr.bit.b3		/* Port P3_5 function select bit */
#define		p37sel0		pmh3_addr.bit.b6		/* Port P3_7 function select bit */
#define		p37sel1		pmh3_addr.bit.b7		/* Port P3_7 function select bit */

/*------------------------------------------------------
  Port 4 Function Mapping Register 0
------------------------------------------------------*/
union	byte_def	pml4_addr;
#define		pml4		pml4_addr.byte

#define		p42sel0		pml4_addr.bit.b4		/* Port P4_2 function select bit */
#define		p42sel1		pml4_addr.bit.b5		/* Port P4_2 function select bit */

/*------------------------------------------------------
  Port 4 Function Mapping Register 1
------------------------------------------------------*/
union	byte_def	pmh4_addr;
#define		pmh4		pmh4_addr.byte

#define		p45sel0		pmh4_addr.bit.b2		/* Port P4_5 function select bit */
#define		p45sel1		pmh4_addr.bit.b3		/* Port P4_5 function select bit */
#define		p46sel0		pmh4_addr.bit.b4		/* Port P4_6 function select bit */
#define		p46sel1		pmh4_addr.bit.b5		/* Port P4_6 function select bit */
#define		p47sel0		pmh4_addr.bit.b6		/* Port P4_7 function select bit */
#define		p47sel1		pmh4_addr.bit.b7		/* Port P4_7 function select bit */

/*------------------------------------------------------
  Port 1 Function Mapping Expansion Register
------------------------------------------------------*/
union	byte_def	pmh1e_addr;
#define		pmh1e		pmh1e_addr.byte

#define		p14sel2		pmh1e_addr.bit.b0		/* The P1_4 pin function is selected in conjunction with bits P14SEL0 to P14SEL1 in the PMH1 register */
#define		p15sel2		pmh1e_addr.bit.b2		/* The P1_5 pin function is selected in conjunction with bits P15SEL0 to P15SEL1 in the PMH1 register */

/*------------------------------------------------------
  Port 4 Function Mapping Expansion Register
------------------------------------------------------*/
union	byte_def	pmh4e_addr;
#define		pmh4e		pmh4e_addr.byte

#define		p46sel2		pmh4e_addr.bit.b4		/* The P4_6 pin function is selected in conjunction with bits P46SEL0 to P46SEL1 in the PMH4 register */

/*------------------------------------------------------
  Timer RJ Counter Register / Timer RJ Reload Register
------------------------------------------------------*/
union	word_def	trj_addr;
#define		trj			trj_addr.word			/* Timer RJ Counter Register, Timer RJ Reload Register */

/*------------------------------------------------------
  Timer RJ Control Register
------------------------------------------------------*/
union	byte_def	trjcr_addr;
#define		trjcr		trjcr_addr.byte

#define		tstart_trjcr	trjcr_addr.bit.b0	/* Timer RJ count start bit */
#define		tcstf_trjcr		trjcr_addr.bit.b1	/* Timer RJ count status flag */
#define		tstop_trjcr		trjcr_addr.bit.b2	/* Timer RJ count forced stop bit */
#define		tedgf_trjcr		trjcr_addr.bit.b4	/* Active edge judgment flag */
#define		tundf_trjcr		trjcr_addr.bit.b5	/* Timer RJ underflow flag */

/*------------------------------------------------------
  Timer RJ I/O Control Register
------------------------------------------------------*/
union	byte_def	trjioc_addr;
#define		trjioc		trjioc_addr.byte

#define		tedgsel_trjioc	trjioc_addr.bit.b0	/* I/O polarity switch bit */
#define		topcr_trjioc	trjioc_addr.bit.b1	/* TRJIO output control bit */
#define		tipf0_trjioc	trjioc_addr.bit.b4	/* TRJIO input filter select bit */
#define		tipf1_trjioc	trjioc_addr.bit.b5	/* TRJIO input filter select bit */
#define		tiogt0_trjioc	trjioc_addr.bit.b6	/* TRJIO count control bit */
#define		tiogt1_trjioc	trjioc_addr.bit.b7	/* TRJIO count control bit */

/*------------------------------------------------------
  Timer RJ Mode Register
------------------------------------------------------*/
union	byte_def	trjmr_addr;
#define		trjmr		trjmr_addr.byte

#define		tmod0_trjmr		trjmr_addr.bit.b0	/* Timer RJ operating mode select bit */
#define		tmod1_trjmr		trjmr_addr.bit.b1	/* Timer RJ operating mode select bit */
#define		tmod2_trjmr		trjmr_addr.bit.b2	/* Timer RJ operating mode select bit */
#define		tedgpl_trjmr	trjmr_addr.bit.b3	/* TRJIO edge polarity select bit */
#define		tck0_trjmr		trjmr_addr.bit.b4	/* Timer RJ count source select bit */
#define		tck1_trjmr		trjmr_addr.bit.b5	/* Timer RJ count source select bit */
#define		tck2_trjmr		trjmr_addr.bit.b6	/* Timer RJ count source select bit */
#define		tckcut_trjmr	trjmr_addr.bit.b7	/* Timer RJ count source cutoff bit */

/*------------------------------------------------------
  Timer RJ Event Select Register
------------------------------------------------------*/
union	byte_def	trjisr_addr;
#define		trjisr		trjisr_addr.byte

#define		rccpsel0_trjisr		trjisr_addr.bit.b0	/* Timer RC output signal select bit */
#define		rccpsel1_trjisr		trjisr_addr.bit.b1	/* Timer RC output signal select bit */
#define		rccpsel2_trjisr		trjisr_addr.bit.b2	/* Timer RC output signal inversion bit */

/*------------------------------------------------------
  Timer RJ Interrupt Control Register
------------------------------------------------------*/
union	byte_def	trjir_addr;
#define		trjir		trjir_addr.byte

#define		trjif_trjir		trjir_addr.bit.b6	/* Timer RJ interrupt request flag */
#define		trjie_trjir		trjir_addr.bit.b7	/* Timer RJ interrupt enable bit */

/*------------------------------------------------------
  Timer RB Control Register
------------------------------------------------------*/
union	byte_def	trbcr_addr;
#define		trbcr		trbcr_addr.byte

#define		tstart_trbcr	trbcr_addr.bit.b0	/* Timer RB count start bit */
#define		tcstf_trbcr		trbcr_addr.bit.b1	/* Timer RB count status flag */
#define		tstop_trbcr		trbcr_addr.bit.b2	/* Timer RB count forced stop bit */

/*------------------------------------------------------
  Timer RB One-Shot Control Register
------------------------------------------------------*/
union	byte_def	trbocr_addr;
#define		trbocr		trbocr_addr.byte

#define		tosst_trbocr	trbocr_addr.bit.b0	/* Timer RB one-shot start bit */
#define		tossp_trbocr	trbocr_addr.bit.b1	/* Timer RB one-shot stop bit */
#define		tosstf_trbocr	trbocr_addr.bit.b2	/* Timer RB one-shot status flag */

/*------------------------------------------------------
  Timer RB I/O Control Register
------------------------------------------------------*/
union	byte_def	trbioc_addr;
#define		trbioc		trbioc_addr.byte

#define		topl_trbioc		trbioc_addr.bit.b0	/* Timer RB output level select bit */
#define		tocnt_trbioc	trbioc_addr.bit.b1	/* Timer RB output switch bit */
#define		inostg_trbioc	trbioc_addr.bit.b2	/* One-shot trigger control bit */
#define		inoseg_trbioc	trbioc_addr.bit.b3	/* One-shot trigger polarity select bit */

/*------------------------------------------------------
  Timer RB Mode Register
------------------------------------------------------*/
union	byte_def	trbmr_addr;
#define		trbmr		trbmr_addr.byte

#define		tmod0_trbmr		trbmr_addr.bit.b0	/* Timer RB operating mode select bit */
#define		tmod1_trbmr		trbmr_addr.bit.b1	/* Timer RB operating mode select bit */
#define		tcnt16_trbmr	trbmr_addr.bit.b2	/* Timer RB counter select bit */
#define		twrc_trbmr		trbmr_addr.bit.b3	/* Timer RB write control bit */
#define		tck0_trbmr		trbmr_addr.bit.b4	/* Timer RB count source select bit */
#define		tck1_trbmr		trbmr_addr.bit.b5	/* Timer RB count source select bit */
#define		tck2_trbmr		trbmr_addr.bit.b6	/* Timer RB count source select bit */
#define		tckcut_trbmr	trbmr_addr.bit.b7	/* Timer RB count source cutoff bit */

/*------------------------------------------------------
  Timer RB Prescaler Register
------------------------------------------------------*/
union	byte_def	trbpre_addr;
#define		trbpre		trbpre_addr.byte

/*------------------------------------------------------
  Timer RB Primary Register
------------------------------------------------------*/
union	byte_def	trbpr_addr;
#define		trbpr		trbpr_addr.byte

/*------------------------------------------------------
  Timer RB Secondary Register
------------------------------------------------------*/
union	byte_def	trbsc_addr;
#define		trbsc		trbsc_addr.byte

/*------------------------------------------------------
  Timer RB Interrupt Control Register
------------------------------------------------------*/
union	byte_def	trbir_addr;
#define		trbir		trbir_addr.byte

#define		trbif_trbir		trbir_addr.bit.b6	/* Timer RB interrupt request flag */
#define		trbie_trbir		trbir_addr.bit.b7	/* Timer RB interrupt enable bit */

/*------------------------------------------------------
  Timer RC Counter, General Register A,B,C,D
------------------------------------------------------*/
union	word_def	 trccnt_addr;
#define		trccnt			trccnt_addr.word	/* Timer RC Counter */

union	word_def	 trcgra_addr;
#define		trcgra			trcgra_addr.word	/* Timer RC General Register A */

union	word_def	 trcgrb_addr;
#define		trcgrb			trcgrb_addr.word	/* Timer RC General Register B */

union	word_def	 trcgrc_addr;
#define		trcgrc			trcgrc_addr.word	/* Timer RC General Register C */

union	word_def	 trcgrd_addr;
#define		trcgrd			trcgrd_addr.word	/* Timer RC General Register D */

/*------------------------------------------------------
  Timer RC Mode Register
------------------------------------------------------*/
union	byte_def	trcmr_addr;
#define		trcmr		trcmr_addr.byte

#define		pwmb_trcmr		trcmr_addr.bit.b0	/* TRCIOB PWM mode select bit */
#define		pwmc_trcmr		trcmr_addr.bit.b1	/* TRCIOC PWM mode select bit */
#define		pwmd_trcmr		trcmr_addr.bit.b2	/* TRCIOD PWM mode select bit */
#define		pwm2_trcmr		trcmr_addr.bit.b3	/* PWM2 mode select bit */
#define		bufea_trcmr		trcmr_addr.bit.b4	/* TRCGRC register function select bit */
#define		bufeb_trcmr		trcmr_addr.bit.b5	/* TRCGRD register function select bit */
#define		cts_trcmr		trcmr_addr.bit.b7	/* TRCCNT count start bit */

/*------------------------------------------------------
  Timer RC Control Register 1
------------------------------------------------------*/
union	byte_def	trccr1_addr;
#define		trccr1		trccr1_addr.byte

#define		toa_trccr1		trccr1_addr.bit.b0	/* Timer output level select A bit */
#define		tob_trccr1		trccr1_addr.bit.b1	/* Timer output level select B bit */
#define		toc_trccr1		trccr1_addr.bit.b2	/* Timer output level select C bit */
#define		tod_trccr1		trccr1_addr.bit.b3	/* Timer output level select D bit */
#define		cks0_trccr1		trccr1_addr.bit.b4	/* Count source select bit */
#define		cks1_trccr1		trccr1_addr.bit.b5	/* Count source select bit */
#define		cks2_trccr1		trccr1_addr.bit.b6	/* Count source select bit */
#define		cclr_trccr1		trccr1_addr.bit.b7	/* TRCCNT counter clear select bit */

/*------------------------------------------------------
  Timer RC Interrupt Enable Register
------------------------------------------------------*/
union	byte_def	trcier_addr;
#define		trcier		trcier_addr.byte

#define		imiea_trcier	trcier_addr.bit.b0	/* Input capture/compare match A interrupt enable bit */
#define		imieb_trcier	trcier_addr.bit.b1	/* Input capture/compare match B interrupt enable bit */
#define		imiec_trcier	trcier_addr.bit.b2	/* Input capture/compare match C interrupt enable bit */
#define		imied_trcier	trcier_addr.bit.b3	/* Input capture/compare match D interrupt enable bit */
#define		ovie_trcier		trcier_addr.bit.b7	/* Timer overflow interrupt enable bit */

/*------------------------------------------------------
  Timer RC Status Register
------------------------------------------------------*/
union	byte_def	trcsr_addr;
#define		trcsr		trcsr_addr.byte

#define		imfa_trcsr		trcsr_addr.bit.b0	/* Input capture/compare match A flag */
#define		imfb_trcsr		trcsr_addr.bit.b1	/* Input capture/compare match B flag */
#define		imfc_trcsr		trcsr_addr.bit.b2	/* Input capture/compare match C flag */
#define		imfd_trcsr		trcsr_addr.bit.b3	/* Input capture/compare match D flag */
#define		ovf_trcsr		trcsr_addr.bit.b7	/* Timer overflow flag */

/*------------------------------------------------------
  Timer RC I/O Control Register 0
------------------------------------------------------*/
union	byte_def	trcior0_addr;
#define		trcior0		trcior0_addr.byte

#define		ioa0_trcior0	trcior0_addr.bit.b0	/* TRCGRA control A0 bit */
#define		ioa1_trcior0	trcior0_addr.bit.b1	/* TRCGRA control A1 bit */
#define		ioa2_trcior0	trcior0_addr.bit.b2	/* TRCGRA control A2 bit */
#define		iob0_trcior0	trcior0_addr.bit.b4	/* TRCGRB control B0 bit */
#define		iob1_trcior0	trcior0_addr.bit.b5	/* TRCGRB control B1 bit */
#define		iob2_trcior0	trcior0_addr.bit.b6	/* TRCGRB control B2 bit */

/*------------------------------------------------------
  Timer RC I/O Control Register 1
------------------------------------------------------*/
union	byte_def	trcior1_addr;
#define		trcior1		trcior1_addr.byte

#define		ioc0_trcior1	trcior1_addr.bit.b0	/* TRCGRC control C0 bit */
#define		ioc1_trcior1	trcior1_addr.bit.b1	/* TRCGRC control C1 bit */
#define		ioc2_trcior1	trcior1_addr.bit.b2	/* TRCGRC control C2 bit */
#define		ioc3_trcior1	trcior1_addr.bit.b3	/* TRCGRC control C3 bit */
#define		iod0_trcior1	trcior1_addr.bit.b4	/* TRCGRD control D0 bit */
#define		iod1_trcior1	trcior1_addr.bit.b5	/* TRCGRD control D1 bit */
#define		iod2_trcior1	trcior1_addr.bit.b6	/* TRCGRD control D2 bit */
#define		iod3_trcior1	trcior1_addr.bit.b7	/* TRCGRD control D3 bit */

/*------------------------------------------------------
  Timer RC Control Register 2
------------------------------------------------------*/
union	byte_def	trccr2_addr;
#define		trccr2		trccr2_addr.byte

#define		polb_trccr2		trccr2_addr.bit.b0	/* TRCIOB PWM mode output level control bit */
#define		polc_trccr2		trccr2_addr.bit.b1	/* TRCIOC PWM mode output level control bit */
#define		pold_trccr2		trccr2_addr.bit.b2	/* TRCIOD PWM mode output level control bit */
#define		cstp_trccr2		trccr2_addr.bit.b5	/* Count stop bit */
#define		tceg0_trccr2	trccr2_addr.bit.b6	/* TRCTRG input edge select bit */
#define		tceg1_trccr2	trccr2_addr.bit.b7	/* TRCTRG input edge select bit */

/*------------------------------------------------------
  Timer RC Digital Filter Function Select Register
------------------------------------------------------*/
union	byte_def	trcdf_addr;
#define		trcdf		trcdf_addr.byte

#define		dfa_trcdf		trcdf_addr.bit.b0	/* TRCIOA digital filter function bit */
#define		dfb_trcdf		trcdf_addr.bit.b1	/* TRCIOB digital filter function bit */
#define		dfc_trcdf		trcdf_addr.bit.b2	/* TRCIOC digital filter function bit */
#define		dfd_trcdf		trcdf_addr.bit.b3	/* TRCIOD digital filter function bit */
#define		dftrg_trcdf		trcdf_addr.bit.b4	/* TRCTRG digital filter function bit */
#define		dfck0_trcdf		trcdf_addr.bit.b6	/* Digital filter clock select bit */
#define		dfck1_trcdf		trcdf_addr.bit.b7	/* Digital filter clock select bit */

/*------------------------------------------------------
  Timer RC Output Enable Register
------------------------------------------------------*/
union	byte_def	trcoer_addr;
#define		trcoer		trcoer_addr.byte

#define		ea_trcoer		trcoer_addr.bit.b0	/* TRCIOA output disable bit */
#define		eb_trcoer		trcoer_addr.bit.b1	/* TRCIOB output disable bit */
#define		ec_trcoer		trcoer_addr.bit.b2	/* TRCIOC output disable bit */
#define		ed_trcoer		trcoer_addr.bit.b3	/* TRCIOD output disable bit */
#define		pto_trcoer		trcoer_addr.bit.b7	/* Timer output disable bit */

/*------------------------------------------------------
  Timer RC A/D Conversion Trigger Control Register
------------------------------------------------------*/
union	byte_def	trcadcr_addr;
#define		trcadcr		trcadcr_addr.byte

#define		adtrgae_trcadcr		trcadcr_addr.bit.b0	/* TRCGRA A/D conversion start trigger enable bit */
#define		adtrgbe_trcadcr		trcadcr_addr.bit.b1	/* TRCGRB A/D conversion start trigger enable bit */
#define		adtrgce_trcadcr		trcadcr_addr.bit.b2	/* TRCGRC A/D conversion start trigger enable bit */
#define		adtrgde_trcadcr		trcadcr_addr.bit.b3	/* TRCGRD A/D conversion start trigger enable bit */

/*------------------------------------------------------
  Timer RC Waveform Output Manipulation Register
------------------------------------------------------*/
union	byte_def	trcopr_addr;
#define		trcopr		trcopr_addr.byte

#define		opsel0_trcopr		trcopr_addr.bit.b0	/* Waveform output manipulation event select bit */
#define		opsel1_trcopr		trcopr_addr.bit.b1	/* Waveform output manipulation event select bit */
#define		opol0_trcopr		trcopr_addr.bit.b2	/* Waveform output manipulation period output level select bit */
#define		opol1_trcopr		trcopr_addr.bit.b3	/* Waveform output manipulation period output level select bit */
#define		restats_trcopr		trcopr_addr.bit.b4	/* Restart method select bit */
#define		ope_trcopr			trcopr_addr.bit.b5	/* Waveform output manipulation enable bit */

/*------------------------------------------------------
  Comparator B Control Register 0
------------------------------------------------------*/
union	byte_def	wcmpr_addr;
#define		wcmpr		wcmpr_addr.byte

#define		wcb1m0		wcmpr_addr.bit.b0		/* Comparator B1 operation enable bit */
#define		wcb1out		wcmpr_addr.bit.b3		/* Comparator B1 monitor flag */
#define		wcb3m0		wcmpr_addr.bit.b4		/* Comparator B3 operation enable bit */
#define		wcb3out		wcmpr_addr.bit.b7		/* Comparator B3 monitor flag */

/*------------------------------------------------------
  Comparator B1 Interrupt Control Register
------------------------------------------------------*/
union	byte_def	wcb1intr_addr;
#define		wcb1intr	wcb1intr_addr.byte

#define		wcb1f0		wcb1intr_addr.bit.b0	/* Comparator B1 filter select bit */
#define		wcb1f1		wcb1intr_addr.bit.b1	/* Comparator B1 filter select bit */
#define		wcb1s0		wcb1intr_addr.bit.b4	/* Comparator B1 interrupt edge select bit */
#define		wcb1s1		wcb1intr_addr.bit.b5	/* Comparator B1 interrupt edge select bit */
#define		wcb1inten	wcb1intr_addr.bit.b6	/* Comparator B1 interrupt enable signal bit */
#define		wcb1f		wcb1intr_addr.bit.b7	/* Comparator B1 interrupt request flag */

/*------------------------------------------------------
  Comparator B3 Interrupt Control Register
------------------------------------------------------*/
union	byte_def	wcb3intr_addr;
#define		wcb3intr	wcb3intr_addr.byte

#define		wcb3f0		wcb3intr_addr.bit.b0	/* Comparator B3 filter select bit */
#define		wcb3f1		wcb3intr_addr.bit.b1	/* Comparator B3 filter select bit */
#define		wcb3s0		wcb3intr_addr.bit.b4	/* Comparator B3 interrupt edge select bit */
#define		wcb3s1		wcb3intr_addr.bit.b5	/* Comparator B3 interrupt edge select bit */
#define		wcb3inten	wcb3intr_addr.bit.b6	/* Comparator B3 interrupt enable signal bit */
#define		wcb3f		wcb3intr_addr.bit.b7	/* Comparator B3 interrupt request flag */

/*------------------------------------------------------
  Flash Memory Status Register
------------------------------------------------------*/
union	byte_def	fst_addr;
#define		fst			fst_addr.byte

#define		rdysti		fst_addr.bit.b0			/* Flash ready status interrupt request flag */
#define		bsyaei		fst_addr.bit.b1			/* Flash access error interrupt request flag */
#define		fst2		fst_addr.bit.b2			/* LBDATA monitor flag */
#define		fst3		fst_addr.bit.b3			/* Program-suspend status flag */
#define		fst4		fst_addr.bit.b4			/* Program error status flag */
#define		fst5		fst_addr.bit.b5			/* Erase error/blank check error status flag */
#define		fst6		fst_addr.bit.b6			/* Erase-suspend status flag */
#define		fst7		fst_addr.bit.b7			/* Ready/busy status flag */

/*------------------------------------------------------
  Flash Memory Control Register 0
------------------------------------------------------*/
union	byte_def	fmr0_addr;
#define		fmr0		fmr0_addr.byte

#define		fmr01		fmr0_addr.bit.b1		/* CPU rewrite mode select bit */
#define		fmr02		fmr0_addr.bit.b2		/* EW1 mode select bit */
#define		fmstp		fmr0_addr.bit.b3		/* Flash memory stop bit */
#define		cmdrst		fmr0_addr.bit.b4		/* Erase/write sequence reset bit */
#define		cmderie		fmr0_addr.bit.b5		/* Erase/write error, blank check error, command error interrupt enable bit */
#define		bsyaeie		fmr0_addr.bit.b6		/* Flash access error interrupt enable bit */
#define		rdystie		fmr0_addr.bit.b7		/* Flash ready status interrupt enable bit */

/*------------------------------------------------------
  Flash Memory Control Register 1
------------------------------------------------------*/
union	byte_def	fmr1_addr;
#define		fmr1		fmr1_addr.byte

#define		wtfmstp		fmr1_addr.bit.b2		/* Flash memory stop bit in wait mode */
#define		fmr13		fmr1_addr.bit.b3		/* Lock bit disable select bit */
#define		fmr16		fmr1_addr.bit.b6		/* Data flash block A rewrite disable bit */
#define		fmr17		fmr1_addr.bit.b7		/* Data flash block B rewrite disable bit */

/*------------------------------------------------------
  Flash Memory Control Register 2
------------------------------------------------------*/
union	byte_def	fmr2_addr;
#define		fmr2		fmr2_addr.byte

#define		fmr20		fmr2_addr.bit.b0		/* Suspend enable bit */
#define		fmr21		fmr2_addr.bit.b1		/* Suspend request bit */
#define		fmr22		fmr2_addr.bit.b2		/* Interrupt request suspend request enable bit */
#define		fmr27		fmr2_addr.bit.b7		/* Low-current-consumption read mode enable bit */

/*------------------------------------------------------
  Flash Memory Refresh Control Register
------------------------------------------------------*/
union	byte_def	frefr_addr;
#define		frefr		frefr_addr.byte

#define		ref0		frefr_addr.bit.b0		/* Periodic refresh interval control bit */
#define		ref1		frefr_addr.bit.b1		/* Periodic refresh interval control bit */
#define		ref2		frefr_addr.bit.b2		/* Periodic refresh interval control bit */
#define		ref3		frefr_addr.bit.b3		/* Periodic refresh interval control bit */
#define		ref4		frefr_addr.bit.b4		/* Periodic refresh interval control bit */
#define		ref5		frefr_addr.bit.b5		/* Periodic refresh interval control bit */

/*------------------------------------------------------
  Address Match Interrupt Register 0
------------------------------------------------------*/
union	dword_def	aiadr0_addr;
#define		aiadr0		aiadr0_addr.dword		/* Address Match Interrupt Register 0 */

#define		aiadr0l		aiadr0_addr.byte.low	/* Address Match Interrupt Register 0 Low */
#define		aiadr0m		aiadr0_addr.byte.mid	/* Address Match Interrupt Register 0 Middle */
#define		aiadr0h		aiadr0_addr.byte.high	/* Address Match Interrupt Register 0 High */

/*------------------------------------------------------
  Address Match Interrupt Enable Register 0
------------------------------------------------------*/
union	byte_def	aien0_addr;
#define		aien0		aien0_addr.byte

#define		aien00		aien0_addr.bit.b0		/* Address match interrupt enable 0 bit */

/*------------------------------------------------------
  Address Match Interrupt Register 1
------------------------------------------------------*/
union	dword_def	aiadr1_addr;
#define		aiadr1		aiadr1_addr.dword		/* Address Match Interrupt Register 1 */

#define		aiadr1l		aiadr1_addr.byte.low	/* Address Match Interrupt Register 1 Low */
#define		aiadr1m		aiadr1_addr.byte.mid	/* Address Match Interrupt Register 1 Middle */
#define		aiadr1h		aiadr1_addr.byte.high	/* Address Match Interrupt Register 1 High */

/*------------------------------------------------------
  Address Match Interrupt Enable Register 1
------------------------------------------------------*/
union	byte_def	aien1_addr;
#define		aien1		aien1_addr.byte

#define		aien10		aien1_addr.bit.b0		/* Address match interrupt enable 1 bit */


