/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "lcd.h"
#include "disp.h"
#include "jpeg.h"
#include "fcpy.h"

//=================================================================

static U8 IsEqFn(const char* str1, const char* str2);

static DIR s_Dir;
static U32 s_nPeriod = 0;

//=================================================================

// \
extern U8 Display(int pattern)
{
	FILINFO Info;
	const char* pFile = NULL;

	// Ԋu`FbN
	if (pattern == DSP_PERIOD)
	{
		if (++s_nPeriod < OPT_DPERIOD)
			return FALSE;
	}
	s_nPeriod = 0;

	// t@CI
	if (f_chdrive(DRV_PRIMARY) == FR_OK)
	{
		if (pattern != DSP_NEWFILE)
		{
			int i = 0;
			for(;;)
			{
				if (f_readdir(&s_Dir, &Info) != FR_OK)
					break;
				
				// GhXĐ
				if (Info.fname[0] == '\0')
				{
					// t@C͗΂œhԂ
					if (i > 0)
					{
						FillLCD(NULL, COL_GREEN);
						return FALSE;
					}
					if (f_readdir(&s_Dir, NULL) != FR_OK)
						break;
					i++;
					continue;
				}

				// `FbN
				if ((Info.fattrib & (AM_HID | AM_SYS | AM_DIR)) != 0)
					continue;
				if (!IsValidFile(&Info))
					continue;

				pFile = Info.fname;
				break;
			}
		}
		else {
			pFile = GetCopied();
		}
	}
	// t@CVXeُ펞͉FœhԂ
	if (pFile == NULL)
	{
		FillLCD(NULL, COL_YELLOW);
		return FALSE;
	}
	// fR[hG[͎FœhԂ
	if (DispJPG(pFile) != RET_OK)
	{
		FillLCD(NULL, COL_MAGENTA);

		// ֐؂ւ悤ɂ
		if (pattern == DSP_PERIOD)
			s_nPeriod = OPT_DPERIOD;

		return FALSE;
	}
	// Xgۑ
	if (pattern == DSP_PERIOD)
	{
		CopyFn(g_Settings.LastFile, pFile);
		SaveSettings();
	}

	return TRUE;
}

// Jnʒuݒ
extern void SetPos(const char* fname)
{
	FILINFO Info;

	// ʒu擪փZbg
	if (f_chdrive(DRV_PRIMARY) == FR_OK)
	{
		if (f_opendir(&s_Dir, "\\") == FR_OK)
		{
			int i;
			if (fname == NULL)
			{
				// Xg΂̂܂ܐ擪
				if (g_Settings.LastFile[0] == '\0') {
					return;
				}
				fname = g_Settings.LastFile;
			}
			else
			{
				// Xgۑ
				CopyFn(g_Settings.LastFile, fname);
				SaveSettings();
			}

			// ʒuݒ
			for(i = 0; ;i++)
			{
				if (f_readdir(&s_Dir, &Info) != FR_OK)
					return;
				if (Info.fname[0] == '\0')
				{
					// t@C͐擪
					f_readdir(&s_Dir, NULL);
					return;
				}
				if (IsEqFn(Info.fname, fname))
				{
					// Öʒu֊߂
					if (f_readdir(&s_Dir, NULL) != FR_OK)
						return;
					for(; i > 0; i--)
					{
						if (f_readdir(&s_Dir, &Info) != FR_OK)
							return;
					}
					break;
				}
			}
		}
	}
}

// Lȃt@C`FbN
extern U8 IsValidFile(const FILINFO* pInfo)
{
	const char* p;

	// Lȃt@C`FbN
	if (pInfo->fsize < 1)
		return FALSE;
	if (pInfo->fdate == 0)
		return FALSE;

	// gq".JPG"̂
	for (p = pInfo->fname; *p != '.'; p++) {
		if (*p == '\0')
			continue;
	}
	if (*(++p) != 'J' && *p != 'j') return FALSE;
	if (*(++p) != 'P' && *p != 'p') return FALSE;
	if (*(++p) != 'G' && *p != 'g') return FALSE;
	if (*(++p) != '\0') return FALSE;

	return TRUE;
}

//=================================================================

// t@Cr
static U8 IsEqFn(const char* str1, const char* str2)
{
	for (; *str1 != '\0' && *str2 != '\0'; str1++, str2++)
	{
		// 召ʗL
		if (*str1 != *str2)
			return 0;
	}
	return (*str1 == *str2);
}
