/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for FatFs     (C)ChaN, 2007        */
/*-----------------------------------------------------------------------*/
/* This is a stub disk I/O module that acts as front end of the existing */
/* disk I/O modules and attach it to FatFs module with common interface. */
/*-----------------------------------------------------------------------*/

#include "diskio.h"
#include "board.h"
#include "sdc.h"

/*-----------------------------------------------------------------------*/
/* Inidialize a Drive                                                    */
/*-----------------------------------------------------------------------*/

DSTATUS disk_initialize (
	BYTE drv				/* Physical drive nmuber (0..) */
)
{
	switch (drv) {

	case DRV_PRIMARY :

		if (OpenSDC1() == RET_OK)
			return 0;
		break;

	case DRV_SECOND :

		if (!SDC2_CD) {
			if (OpenSDC2() == RET_OK)
				return 0;
		}
		break;
	}

	return STA_NOINIT;
}

/*-----------------------------------------------------------------------*/
/* Return Disk Status                                                    */
/*-----------------------------------------------------------------------*/

DSTATUS disk_status (
	BYTE drv		/* Physical drive nmuber (0..) */
)
{
	switch (drv) {

	case DRV_PRIMARY :
		
		if (SPI1STATbits.SPIEN)
			return 0;
		break;

	case DRV_SECOND :

		if (!SDC2_CD && SPI2STATbits.SPIEN)
			return 0;
		break;
	}

	return STA_NOINIT;
}

/*-----------------------------------------------------------------------*/
/* Read Sector(s)                                                        */
/*-----------------------------------------------------------------------*/

DRESULT disk_read (
	BYTE drv,		/* Physical drive nmuber (0..) */
	BYTE *buff,		/* Data buffer to store read data */
	DWORD sector,	/* Sector address (LBA) */
	BYTE count		/* Number of sectors to read (1..255) */
)
{
	switch (drv) {

	case DRV_PRIMARY :
		do {
			if (ReadSDC1(sector++, buff) != RET_OK)
				return RES_ERROR;
			buff += SDCBLK;
		}
		while (--count > 0);
		return RES_OK;

	case DRV_SECOND :
		do {
			if (ReadSDC2(sector++, buff) != RET_OK)
				return RES_ERROR;
			buff += SDCBLK;
		}
		while (--count > 0);
		return RES_OK;
	}

	return RES_PARERR;
}

/*-----------------------------------------------------------------------*/
/* Write Sector(s)                                                       */
/*-----------------------------------------------------------------------*/
/* The FatFs module will issue multiple sector transfer request
/  (count > 1) to the disk I/O layer. The disk function should process
/  the multiple sector transfer properly Do. not translate it into
/  multiple single sector transfers to the media, or the data read/write
/  performance may be drasticaly decreased. */

#if _READONLY == 0
DRESULT disk_write (
	BYTE drv,			/* Physical drive nmuber (0..) */
	const BYTE *buff,	/* Data to be written */
	DWORD sector,		/* Sector address (LBA) */
	BYTE count			/* Number of sectors to write (1..255) */
)
{
	switch (drv) {

	case DRV_PRIMARY :
		do {
			if (WriteSDC1(sector++, buff) != RET_OK)
				return RES_ERROR;
			buff += SDCBLK;
		}
		while (--count > 0);
		return RES_OK;

	case DRV_SECOND :
		do {
			if (WriteSDC2(sector++, buff) != RET_OK)
				return RES_ERROR;
			buff += SDCBLK;
		}
		while (--count > 0);
		return RES_OK;
	}

	return RES_PARERR;
}
#endif /* _READONLY */

/*-----------------------------------------------------------------------*/
/* Miscellaneous Functions                                               */
/*-----------------------------------------------------------------------*/

DRESULT disk_ioctl (
	BYTE drv,		/* Physical drive nmuber (0..) */
	BYTE ctrl,		/* Control code */
	void *buff		/* Buffer to send/receive control data */
)
{
	switch (drv) {

	case DRV_PRIMARY :
		if (ctrl == CTRL_SYNC)
			return RES_OK;
		break;

	case DRV_SECOND :
		if (ctrl == CTRL_SYNC)
			return RES_OK;
		break;
	}

	return RES_PARERR;
}

#if !_FS_READONLY
DWORD get_fattime (void)
{
	return 0;
}
#endif
