/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "fcpy.h"
#include "disp.h"

//=================================================================

static int NextFile(void);
static int NextSub(void);

//=================================================================

#define STATE_INIT		0
#define STATE_FIND		1
#define STATE_COPY		2

static FATFS s_FS2 __attribute__ ((space(dma)));
static FIL Src, Dst;
static int nState = STATE_INIT;

#define DIRDEPTH		4
static DIR s_Dirs[DIRDEPTH];
static int s_nDepth;
static FILINFO s_Info;
static char s_Start[16];
static char s_Copied[16];

//=================================================================

// t@CRs[
extern int CopyFiles(U8 cancel, FATFS* pFS1)
{
	// Xe[W
	if (nState == STATE_INIT)
	{
		s_Start[0] = '\0';
		s_Copied[0] = '\0';

		if (f_mount(DRV_SECOND, &s_FS2) == FR_OK)
		{
			if (f_chdrive(DRV_SECOND) == FR_OK)
			{
				s_nDepth = 0;
				if (f_opendir(&s_Dirs[0], "\\") == FR_OK)
				{
					if (f_chdir("\\") == FR_OK)
					{
						// t@CT
						nState++;
						return CPF_PROGRESS;
					}
				}
			}
			f_unmount(DRV_SECOND);
		}
		// G[ŏI
		return CPF_ERRSTOP;
	}
	
	// t@CTXe[W
	if (nState == STATE_FIND)
	{
		int nRet = CPF_COMPLETE;
		if (!cancel) {
			nRet = (f_chdrive(DRV_SECOND) == FR_OK)? NextFile() : CPF_ERRSTOP;
		}
		if (nRet != CPF_PROGRESS)
		{
			// LZ܂͎܂̓G[ŏI
			f_unmount(DRV_SECOND);
			nState = STATE_INIT;
			return nRet;
		}
		if (f_open(&Src, s_Info.fname, FA_READ) == FR_OK)
		{
			if (f_chdrive(DRV_PRIMARY) == FR_OK)
			{
				FILINFO Test;
				if (f_stat(s_Info.fname, &Test) != FR_OK || Test.fsize < 1)
				{
					FRESULT res = f_open(&Dst, s_Info.fname, FA_CREATE_ALWAYS | FA_WRITE);
					if (res == FR_OK)
					{
						if (f_sync(&Dst) == FR_OK)
						{
							// f[^Rs[
							nState = STATE_COPY;
							return CPF_PROGRESS;
						}
						f_close(&Dst);
					}
				}
				else
				{
					// ̗Lȃt@CL莟̃t@C
					f_close(&Src);
					return CPF_PROGRESS;
				}
			}
			f_close(&Src);
		}
		// G[ŏI
		f_unmount(DRV_SECOND);
		nState = STATE_INIT;
		return CPF_ERRSTOP;
	}

	// f[^Rs[Xe[W
	if (nState == STATE_COPY)
	{
		UINT cbr, cbw;
		if (f_read(&Src, g_DmaBuf, _MAX_SS, &cbr) == FR_OK)
		{
			if (f_write(&Dst, g_DmaBuf, cbr, &cbw) == FR_OK && cbr == cbw)
			{
				if (cbr < _MAX_SS)
				{
					// Rs[
					f_close(&Dst);
					f_close(&Src);
					if (f_chdrive(DRV_PRIMARY) == FR_OK)
					{
						if (f_utime(s_Info.fname, &s_Info) == FR_OK)
						{
							// ̃t@C
							nState = STATE_FIND;
							CopyFn(s_Copied, s_Info.fname);
							if (s_Start[0] == '\0')
								CopyFn(s_Start, s_Copied);
							return CPF_FILEEND;
						}
					}
					// G[ŏI
					f_unmount(DRV_SECOND);
					nState = STATE_INIT;
					return CPF_ERRSTOP;
				}
				// ̃ZN^Rs[
				return CPF_PROGRESS;
			}
		}

		// G[(fBXNt܂)̏ꍇ̓TCY0ɐ؂l߂Ă
		f_lseek(&Dst, 0);
		f_truncate(&Dst);

		// G[܂̓fBXNtŏI
		f_close(&Dst);
		f_close(&Src);
		f_unmount(DRV_SECOND);
		nState = STATE_INIT;
	}

	return CPF_ERRSTOP;
}

// ŏɃRs[t@C擾
extern const char* GetStart(void)
{
	return s_Start;
}

// ŌɃRs[t@C擾
extern const char* GetCopied(void)
{
	return s_Copied;
}

//=================================================================

// ̃t@C
static int NextFile(void)
{
	for(;;)
	{
		int nRet = NextSub();
		if (nRet != CPF_COMPLETE)
			return nRet;

		// S̏I
		if (s_nDepth == 0)
			break;

		// eֈړ
		--s_nDepth;
		if (f_chdir("..") != FR_OK)
			return CPF_ERRSTOP;
	}

	return CPF_COMPLETE;
}

// ̃t@C
static int NextSub(void)
{
	for(;;)
	{
		int nRet;

		if (f_readdir(&s_Dirs[s_nDepth], &s_Info) != FR_OK)
			return CPF_ERRSTOP;
		
		// ݂̃fBNgȉI
		if (*s_Info.fname == '\0')
			break;

		// ByуVXê͖̂
		if ((s_Info.fattrib & (AM_HID | AM_SYS)) != 0)
			continue;

		if (s_Info.fattrib & AM_DIR)
		{
			// [`FbN
			if (s_nDepth >= (DIRDEPTH - 1))
				continue;

			// LȃfBNg`FbN
			if (s_Info.fname[0] == '.')
			{
				if (s_Info.fname[1] == '\0')
					continue;
				if (s_Info.fname[1] == '.' && s_Info.fname[2] == '\0')
					continue;
			}

			// qfBNgֈړiċAj
			++s_nDepth;
			if (f_opendir(&s_Dirs[s_nDepth], s_Info.fname) != FR_OK)
				return CPF_ERRSTOP;

			if (f_chdir(s_Info.fname) != FR_OK)
				return CPF_ERRSTOP;

			nRet = NextSub();
			if (nRet != CPF_COMPLETE)
				return nRet;
		}
		else
		{
			// Lȃt@C`FbN
			if (!IsValidFile(&s_Info))
				continue;
				
			// t@C
			return CPF_PROGRESS;
		}
	}

	return CPF_COMPLETE;
}
