/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include <setjmp.h>

#define JPEG_INTERNAL_OPTIONS
#include "jinclude.h"
#include "jpeglib.h"

#undef _WIN32
#include "ff.h"

#include "board.h"
#include "lcd.h"
#include "jpeg.h"

//=================================================================

METHODDEF(void) ErrMsg(j_common_ptr p);
METHODDEF(void) ErrorExit(j_common_ptr p);
METHODDEF(void) InitSource(j_decompress_ptr pObj);
METHODDEF(boolean) FillInputBuffer(j_decompress_ptr pObj);
METHODDEF(void) SkipInputData(j_decompress_ptr pObj, long nBytes);
METHODDEF(void) TermSource(j_decompress_ptr pObj);

static U8 CheckSize(void);
static U8 DoProcess(void);

//=================================================================

typedef struct _source_mgr_t {
	struct jpeg_source_mgr jsm;
	const char* fname;
	FIL file;
	U8 fok;
} source_mgr_t;

static struct jpeg_decompress_struct s_Obj;
static struct jpeg_error_mgr s_Jerr;
static jmp_buf s_JmpEnv;
static source_mgr_t s_Src;

#define SCAN_LINE	1
static JSAMPROW s_Rows[SCAN_LINE];
static JSAMPLE s_Pixels[LCD_CX * RGB_PIXELSIZE * SCAN_LINE];

//=================================================================

// JPG
extern void InitJPG(void)
{
	// XLCz
	U8 i = 0;
	do s_Rows[i] = &s_Pixels[LCD_CX * RGB_PIXELSIZE * i];
	while (++i < SCAN_LINE);

	// \bhݒ
	s_Src.jsm.init_source = InitSource;;
	s_Src.jsm.fill_input_buffer = FillInputBuffer;
	s_Src.jsm.skip_input_data = SkipInputData;
	s_Src.jsm.resync_to_restart = jpeg_resync_to_restart;
	s_Src.jsm.term_source = TermSource;
}

// 摜\
extern U8 DispJPG(const char* fname)
{
	U8 nRet = RET_NG;

	// G[
	if (setjmp(s_JmpEnv) != 0)
	{
		jpeg_destroy_decompress(&s_Obj);
		return RET_NG;
	}

	// IuWFNg̏
	s_Obj.err = jpeg_std_error(&s_Jerr);
	s_Jerr.output_message = ErrMsg;
	s_Jerr.error_exit = ErrorExit;
	jpeg_create_decompress(&s_Obj);

	// ̓\[X̐ݒ
	s_Src.jsm.bytes_in_buffer = 0;
	s_Src.jsm.next_input_byte = NULL;
	s_Src.fname = fname;
	s_Obj.src = (struct jpeg_source_mgr*)&s_Src;

	// wb_[̃[h
	if (jpeg_read_header(&s_Obj, TRUE) == JPEG_HEADER_OK)
	{
		nRet = CheckSize();
		if (nRet == RET_OK)
		{
			// WJp[^̐ݒ
			s_Obj.out_color_space = JCS_RGB;

#ifdef DECOMP_FAST
			// 掿ݒii𗎂Ƃxグj
			s_Obj.two_pass_quantize = FALSE;
			s_Obj.dither_mode = JDITHER_ORDERED;
			if (!s_Obj.quantize_colors)
				s_Obj.desired_number_of_colors = 216;
			s_Obj.dct_method = JDCT_FASTEST;
			s_Obj.do_fancy_upsampling = FALSE;
#endif
			// kݒ
			if (s_Obj.image_width > LCD_CX || s_Obj.image_height > LCD_CY)
			{
				nRet = RET_NG;
				s_Obj.scale_num = 10;
				s_Obj.scale_denom = 9;
				do {
					jpeg_calc_output_dimensions(&s_Obj);
					if (s_Obj.output_width <= LCD_CX && s_Obj.output_height <= LCD_CY)
					{
						nRet = RET_OK;
						break;
					}
				}
				while (++s_Obj.scale_denom <= 300);
			}
			// ZbVJn
			if (nRet == RET_OK)
			{
				if (jpeg_start_decompress(&s_Obj))
				{
					// WJ\
					nRet = DoProcess();
				}
			}
		}
		// ZbVI
		jpeg_finish_decompress(&s_Obj);
	}

	// IuWFNgj
	jpeg_destroy_decompress(&s_Obj);

	return nRet;
}

//=================================================================

// 摜TCY
static U8 CheckSize(void)
{
	if (s_Obj.image_width <= 0)
		return RET_NG;
	if (s_Obj.image_width > 3840)
		return RET_NG;
	if (s_Obj.image_height <= 0)
		return RET_NG;
	if (s_Obj.image_height > 2400)
		return RET_NG;

	return RET_OK;
}

// WJ\
static U8 DoProcess(void)
{
	rect_t rct, rcl, rci, rcr, rcb;

	// 㕔}[Ẅ
	rct.x = rct.y = 0;
	rct.w = LCD_CX;
	rct.h = (LCD_CY - s_Obj.output_height) / 2;

	// }[Ẅ
	rcl.x = 0;
	rcl.y = rct.h;
	rcl.w = (LCD_CX - s_Obj.output_width) / 2;
	rcl.h = 1;

	// 摜̈
	rci.x = rcl.w;
	rci.y = rct.h;
	rci.w = s_Obj.output_width;
	rci.h = 1;

	// E}[Ẅ
	rcr.x = rci.x + s_Obj.output_width;
	rcr.y = rct.h;
	rcr.w = LCD_CX - rcr.x;
	rcr.h = 1;;

	// }[Ẅ
	rcb.x = 0;
	rcb.y = rci.y + s_Obj.output_height;
	rcb.w = LCD_CX;
	rcb.h = LCD_CY - rcb.y;

	// 㕔
	if (rct.h > 0)
		FillLCD(&rct, COL_BLACK);

	while (s_Obj.output_scanline < s_Obj.output_height)
	{
		int i = 0;

		JDIMENSION nLine = jpeg_read_scanlines(&s_Obj, s_Rows, SCAN_LINE);
		if (nLine == 0)
			return RET_NG;

		do {
			// 
			if (rcl.w > 0)
			{
				FillLCD(&rcl, COL_BLACK);
				rcl.y++;
			}

			// 摜
			BlitLCD(&rci, s_Rows[i++]);
			rci.y++;

			// E
			if (rcr.w > 0)
			{
				FillLCD(&rcr, COL_BLACK);
				rcr.y++;
			}
		}
		while (--nLine > 0);
	}

	// 
	if (rcb.h > 0)
		FillLCD(&rcb, COL_BLACK);

	return RET_OK;
}

//=================================================================

// bZ[Wo
METHODDEF(void) ErrMsg(j_common_ptr p)
{
	// ȂAprintf()֐gp̂h
	//char Buf[JMSG_LENGTH_MAX];
	//(*p->err->format_message)(p, Buf);
}

// G[I
METHODDEF(void) ErrorExit(j_common_ptr p)
{
	ErrMsg(p);
	longjmp(s_JmpEnv, p->err->msg_code);
	// exit()֐gp̂h
}

// ͏
METHODDEF(void) InitSource(j_decompress_ptr pObj)
{
	// t@CJ
	s_Src.fok = (f_open(&s_Src.file, s_Src.fname, FA_READ) == FR_OK);
}

// obt@O
METHODDEF(boolean) FillInputBuffer(j_decompress_ptr pObj)
{
	if (s_Src.fok)
	{
		// ቺhׂɃZN^Pʂœǂݍ
		UINT cb;
		if (f_read(&s_Src.file, g_DmaBuf, _MAX_SS, &cb) != FR_OK)
			return FALSE;

		s_Src.jsm.next_input_byte = g_DmaBuf;
		s_Src.jsm.bytes_in_buffer = cb;
		return TRUE;
	}

	return FALSE;
}

// ̓XLbv
METHODDEF(void) SkipInputData(j_decompress_ptr pObj, long nBytes)
{
	if (s_Src.fok && nBytes > 0)
	{
		// ቺhׂɃZN^ACgŃXLbv
		if ((size_t)nBytes > s_Src.jsm.bytes_in_buffer)
		{
			U32 size = (nBytes -= s_Src.jsm.bytes_in_buffer);
			U32 blkc = size / _MAX_SS;

			s_Src.jsm.next_input_byte = NULL;
			s_Src.jsm.bytes_in_buffer = 0;

			// ZN^XLbv
			if (blkc > 0)
			{
				if (f_lseek(&s_Src.file, s_Src.file.fptr + blkc * _MAX_SS) != FR_OK)
				{
					s_Src.fok = FALSE;
					return;
				}
				nBytes -= blkc * _MAX_SS;
			}

			// obt@O
			if (!FillInputBuffer(pObj))
			{
				s_Src.fok = FALSE;
				return;
			}
			if (s_Src.jsm.bytes_in_buffer < (size_t)nBytes)
			{
				s_Src.jsm.bytes_in_buffer = 0;
				return;
			}
		}

		s_Src.jsm.next_input_byte += nBytes;
		s_Src.jsm.bytes_in_buffer -= nBytes;
	}
}

// ͏I
METHODDEF(void) TermSource(j_decompress_ptr pObj)
{
	f_close(&s_Src.file);
}
