/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#ifndef _LCD_H_
#define _LCD_H_

#include "main.h"

typedef struct _rect_t {
	U16 x; U16 y; U16 w; U16 h;
} rect_t;

extern void InitLCD(void);
extern void FillLCD(const rect_t* rc, U32 c);
extern void BlitLCD(const rect_t* rc, const U8* bm);
extern void DrawLCD(const rect_t* rc, const char* fname);

#define COL_WHITE	0x3FFFFL
#define COL_BLACK	0x00000L
#define COL_RED		0x3F000L
#define COL_GREEN	0x00FC0L
#define COL_BLUE	0x0003FL
#define COL_CYAN	(COL_GREEN | COL_BLUE)
#define COL_MAGENTA	(COL_RED | COL_BLUE)
#define COL_YELLOW	(COL_RED | COL_GREEN)

#define LCD_CX		320
#define LCD_CY		240

#endif
