/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "LCD.h"

#define STATE_OFF		0
#define STATE_START		1
#define STATE_CLEAR		2
#define STATE_READY		3
#define STATE_STOP		4

#define MODE_FILL		0
#define MODE_BLIT		1
#define MODE_BITS		2

#define VT_CNT			480UL
#define HS_CNT			800UL
#define LINE_PITCH		1024UL

//=================================================================

static int s_nState;

static volatile int s_nMode asm("s_nMode");
static volatile BYTE* s_pDat asm("s_pDat");
static volatile DWORD s_nPos asm("s_nPos");
static volatile DWORD s_nRight asm("s_nRight");
static volatile DWORD s_nEnd asm("s_nEnd");
static volatile DWORD s_nAdd asm("s_nAdd");

//=================================================================

static void CommonProc(int nMode, const rect_t* rc, BYTE* pDat, WORD nDataL, WORD nDataH);

//=================================================================

// 
extern void InitLCD(void)
{
	s_nState = STATE_OFF;
}

// ^XN
extern void TaskLCD(void)
{
	switch (s_nState)
	{
	case STATE_START:
		PowerCtrlC(TRUE);
		FillLCD(NULL, COL_BLACK);
		s_nState++;
		break;

	case STATE_CLEAR:
		if (!IsBusyLCD())
		{
			BackLight(TRUE);
			s_nState++;
		}
		break;

	case STATE_READY:
		// Ȃ
		break;

	case STATE_STOP:
		BackLight(FALSE);
		while (IsBusyLCD());

		PowerCtrlC(FALSE);
		s_nState = STATE_OFF;
		break;
	
	default:
		//case STATE_OFF:
		// Ȃ
		break;
	}
}

// Lɂ
extern void EnableLCD(void)
{
	switch (s_nState)
	{
	case STATE_OFF:
		s_nState = STATE_START;
		break;
	case STATE_START:
	case STATE_CLEAR:
	case STATE_READY:
		break;
	case STATE_STOP:
		s_nState = STATE_CLEAR;
		break;
	}
}

// ɂ
extern void DisableLCD(void)
{
	switch (s_nState)
	{
	case STATE_OFF:
		break;
	case STATE_START:
		s_nState = STATE_OFF;
		break;
	case STATE_CLEAR:
	case STATE_READY:
		s_nState = STATE_STOP;
		break;
	case STATE_STOP:
		break;
	}
}

// LǂԂ
extern BOOL IsEnabledLCD(void)
{
	return (s_nState == STATE_READY);
}

// ǂԂ
extern BOOL IsDisabledLCD(void)
{
	return (s_nState == STATE_OFF);
}

//=================================================================

// ̈hԂ
extern void FillLCD(const rect_t* rc, COLOR c)
{
	CommonProc(MODE_FILL, rc, NULL, (WORD)c, (WORD)(c >> 16));
}

// rbg}bv]
extern void BlitLCD(const rect_t* rc, const BYTE* bm)
{
	CommonProc(MODE_BLIT, rc, (BYTE*)bm, 0, 0);
}

// rbg}bv擾
extern void GetBits(const rect_t* rc, BYTE* bm)
{
	CommonProc(MODE_BITS, rc, bm, 0, 0);

	// 擾܂ő҂
	while (IsBusyLCD());
}

//=================================================================

// ʏ
static void CommonProc(int nMode, const rect_t* rc, BYTE* pDat, WORD nDataL, WORD nDataH)
{
	// ȌI܂ő҂
	while (IsBusyLCD());

	// p[^Zbg
	s_nMode = nMode;
	s_pDat = pDat;
	if (rc == NULL)
	{
		// S
		s_nPos = 0;
		s_nRight = HS_CNT;
		s_nEnd = HS_CNT + (VT_CNT - 1) * LINE_PITCH;
		s_nAdd = LINE_PITCH - HS_CNT; 
	}
	else
	{
		// ̈
		s_nPos = rc->x + rc->y * LINE_PITCH;
		s_nRight = s_nPos + rc->w;
		s_nEnd = s_nRight + (rc->h - 1) * LINE_PITCH;
		s_nAdd = LINE_PITCH - rc->w;
	}

	// JnAhXZbg(L͓sxݒ)
	ADDR_H_CLR = ADDR_H_MASK;
	ADDR_H_SET = (s_nPos >> ADDR_H_SHIFT) & ADDR_H_MASK;

	DATA_L = nDataL;
	DATA_H = nDataH;

	// 荞݋
	HS_INT_EDGE = 0; // Ŋ荞
	HS_INT_IP = 7;	// ōDx(Vh[WX^ɂ荂)
	HS_INT_IF_CLR = HS_INT_IF_MASK;
	HS_INT_IE_SET = HS_INT_IE_MASK;
}

//=================================================================

// 1NbNpX
#define CLK_PLUS()	\
	asm("sw		$t8, 24936($a0)"); /* MUX_CLK_SET = MUX_CLK_MASK */ \
	asm("sw		$t8, 24932($a0)"); /* MUX_CLK_CLR = MUX_CLK_MASK */ \

// 4hbgtB
#define FILLx4 \
	/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */ \
	asm("sw		$t6, 24616($a0)");			\
	CLK_PLUS(); CLK_PLUS(); CLK_PLUS();		\
	/* s_nPos += 4; */						\
	asm("addu	$s1, $s1, $t3");			\
	/* ADDR_L = s_nPos; */					\
	asm("sw		$s1, 24800($a0)");			\
	/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */ \
	asm("sw		$t6, 24612($a0)");			\
	CLK_PLUS();

// sNZݒ聕1NbNpX
#define BLT_PLUS()	SET_PIX(); CLK_PLUS();

// 1sNZݒ
#define SET_PIX() \
	/* dwData = s_pDat[0] | (s_pDat[1] << 8); */ \
	asm("lbu	$v0, 0($s0)");					 \
	asm("lbu	$v1, 1($s0)");					 \
	asm("sll	$v1, $v1, 8");					 \
	asm("or		$v0, $v0, $v1");				 \
	/* DATA_L = dwData */						 \
	asm("sw		$v0, 24656($a0)");				 \
	/* dwData = s_pDat[2] */					 \
	asm("lbu	$v0, 2($s0)");					 \
	/* DATA_H = dwData */						 \
	asm("sw		$v0, 24848($a0)");				 \
	/* s_pDat += 3; */							 \
	asm("addu	$s0, $s0, $t2");				 \

// sNZ擾1NbNpX
#define GET_PLUS()	GET_PIX(); CLK_PLUS();

// sNZ擾1NbNpX
#define GET_PIX() \
	/* dwData = DATA_L */						 \
	asm("lw		$v0, 24656($a0)");				 \
	/* s_pDat[0] = dwData */					 \
	asm("sb		$v0, 0($s0)");					 \
	/* s_pDat[1] = dwData >> 8 */				 \
	asm("srl	$v0, $v0, 8");					 \
	asm("sb		$v0, 1($s0)");					 \
	/* dwData = DATA_H */						 \
	asm("lw		$v0, 24848($a0)");				 \
	/* s_pDat[2] = dwData */					 \
	asm("sb		$v0, 2($s0)");					 \
	/* s_pDat += 3; */							 \
	asm("addu	$s0, $s0, $t2");				 \

// 
void __ISR(_EXTERNAL_3_VECTOR, ipl7) _INT3Interrupt(void)
{
	// WX^
	asm("lui	$a0, 0xbf88");			// BaseAddress

	asm("addiu	$t0, $zero, 1");		// 1
	asm("addiu	$t1, $zero, 2");		// 2/SRAM_WE_MASK
	asm("addiu	$t2, $zero, 3");		// 3
	asm("addiu	$t3, $zero, 4");		// 4
	asm("addiu	$t4, $zero, 1024");		// SRAM_CE_TRIS_MASK
	asm("addiu	$t5, $zero, 4096");		// MUX_SEL_MASK
	asm("addiu	$t6, $zero, 32");		// SRAM_ADVLD_MASK/SRAM_ADVLD_TRIS_MSK
	asm("addiu	$t7, $zero, 28");		// ADDR_H_MASK
	asm("addiu	$t8, $zero, 8");		// MUX_CLK_MASK
	asm("ori	$t9, $zero, 0x8000");	// HS_INT_IF_MASK/HS_INT_IE_MASK

	asm("lw     $s0, s_pDat");			// s_pDat
	asm("lw     $s1, s_nPos");			// s_nPos
	asm("lw     $s2, s_nRight");		// s_nRight
	asm("lw     $s3, s_nEnd");			// s_nEnd
	asm("lw     $s4, s_nAdd");			// s_nAdd
	asm("xor	$s5, $zero, $zero");	// dwTime

	/* DWORD dwLimit = (VS_INT_IO)? 220 : 20000; */
	asm("lw		$v0, 24592($a0)");
	asm("ext	$v0, $v0, 15, 1");
	asm("beq	$v0, $zero, long_limit");
	asm("addiu	$s6, $zero, 220");		// uNF220TCN
	asm("beq	$zero, $zero, limit_end");
	asm("long_limit:");
	asm("addiu	$s6, $zero, 20000");	// uNF20000TCN
	asm("limit_end:");
	
	// JnAhXZbg(H͊ɃZbgς)
	/* ADDR_L = s_nPos; */
	asm("sw		$s1, 24800($a0)");
	/* ADDR_L_TRIS_CLR = ADDR_L_TRIS_MASK; */
	asm("ori	$v0, $zero, 0xfffc");
	asm("sw		$v0, 24772($a0)");
	/* ADDR_H_TRIS_CLR = ADDR_H_TRIS_MASK; */
	asm("addiu	$v0, $zero, 28");
	asm("sw		$v0, 24580($a0)");

	// 䃉Cݒ
	/* MUX_SEL_CLR = MUX_SEL_MASK; */
	asm("sw		$t5, 24932($a0)");
	/* SRAM_ADVLD_TRIS_CLR = SRAM_ADVLD_TRIS_MSK; */
	asm("sw		$t6, 24580($a0)");

	// ŏɃRRɂ܂ł65TCN
	/* if (s_nMode == MODE_FILL) */
	asm("lw     $v0, s_nMode");
	asm("bne	$v0, $zero, blit_proc");
	{
		// 䃉Cݒ
		/* SRAM_WE_CLR = SRAM_WE_MASK; */
		asm("sw		$t1, 24612($a0)");
		/* SRAM_CE_TRIS_CLR = SRAM_CE_TRIS_MASK; */
		asm("sw		$t4, 24580($a0)");
		
		// f[^Cݒ
		/* DATA_L_TRIS_CLR = DATA_L_TRIS_MASK; */
		asm("ori	$v0, $zero, 0xffff");
		asm("sw		$v0, 24644($a0)");
		/* DATA_H_TRIS_CLR = DATA_H_TRIS_MASK; */
		asm("addiu	$v0, $zero, 252");
		asm("sw		$v0, 24836($a0)");

		CLK_PLUS();

		asm("fill_loop:");
		/* do */
		{
			/* DWORD dwN = s_nRight - s_nPos; */
			asm("subu	$s7, $s2, $s1");	// dwN

			/* if (s_nPos & 0x3) */
			asm("andi	$v0, $s1, 0x3");
			asm("beq	$v0, $zero, fill_start");
			{
				/* DWORD tmp = 4 - (s_nPos & 0x3); */
				asm("andi	$v1, $s1, 0x3");
				asm("subu	$v0, $t3, $v1");
				
				/* if (dwN > tmp) */
				asm("sltu	$v1, $v0, $s7");
				asm("beq	$v1, $zero, fill_start");

					/* dwN = tmp; */
					asm("addu	$s7, $zero, $v0");
			}
			asm("fill_start:");

			/* if (dwN >= 32) */
			asm("sltiu	$v0, $s7, 32");
			asm("bne	$v0, $zero, fill_dwN4");
			{
				/* dwCost = 112 */
				asm("addiu	$a1, $zero, 112");

				FILLx4 FILLx4 FILLx4 FILLx4 FILLx4 FILLx4 FILLx4
				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				CLK_PLUS(); CLK_PLUS(); CLK_PLUS();
				/* s_nPos += 4; */
				asm("addu	$s1, $s1, $t3");
				asm("beq	$zero, $zero, fill_end");
			}
			/* else if (dwN >= 4) */
			asm("fill_dwN4:");
			asm("sltiu	$v0, $s7, 4");
			asm("bne	$v0, $zero, fill_dwN3");
			{
				/* dwCost = 39 */
				asm("addiu	$a1, $zero, 39");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				CLK_PLUS(); CLK_PLUS(); CLK_PLUS();
				/* s_nPos += 4; */
				asm("addu	$s1, $s1, $t3");
				asm("beq	$zero, $zero, fill_end");
			}
			/* else if (dwN == 3) */
			asm("fill_dwN3:");
			asm("bne	$s7, $t2, fill_dwN2");
			{
				/* dwCost = 41 */
				asm("addiu	$a1, $zero, 41");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				CLK_PLUS(); CLK_PLUS();
				/* s_nPos += 3; */
				asm("addu	$s1, $s1, $t2");
				asm("beq	$zero, $zero, fill_end");
			}
			/* else if (dwN == 2) */
			asm("fill_dwN2:");
			asm("bne	$s7, $t1, fill_dwN1");
			{
				/* dwCost = 41 */
				asm("addiu	$a1, $zero, 41");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				CLK_PLUS();
				/* s_nPos += 2; */
				asm("addu	$s1, $s1, $t1");
				asm("beq	$zero, $zero, fill_end");
			}
			/* else */
			asm("fill_dwN1:");
			{
				/* dwCost = 37 */
				asm("addiu	$a1, $zero, 37");

				/* s_nPos += 1; */
				asm("addu	$s1, $s1, $t0");
			}
			asm("fill_end:");

			/* if (s_nPos >= s_nRight) */
			asm("sltu	$v0, $s1, $s2");
			asm("bne	$v0, $zero, fill_load");
			{
				/* if (s_nPos >= s_nEnd) */
				asm("sltu	$v0, $s1, $s3");
				asm("bne	$v0, $zero, fill_line");
				{
					// 
					/* HS_INT_IE_CLR = HS_INT_IE_MASK; */
					asm("sw		$t9, 4196($a0)");

					/* ADDR_L = 0xFFFF; */
					asm("ori	$v0, 0xFFFF");
					asm("sw		$v0, 24800($a0)");
					/* ADDR_H_SET = ADDR_H_MASK; */
					asm("sw		$t7, 24616($a0)");
					/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */
					asm("sw		$t6, 24612($a0)");
					CLK_PLUS();

					asm("beq	$zero, $zero, proc_end");
				}
				asm("fill_line:");

				// C
				/* s_nPos += s_nAdd; */
				asm("addu	$s1, $s1, $s4");
				/* s_nRight += LINE_PITCH; */
				asm("addiu	$s2, $s2, 1024");

				/* ADDR_H_CLR = ADDR_H_MASK; */
				asm("sw		$t7, 24612($a0)");
				/* ADDR_H_SET = (s_nPos >> ADDR_H_SHIFT) & ADDR_H_MASK; */
				asm("srl	$v0, $s1, 0xe");
				asm("and	$v0, $v0, $t7");
				asm("sw		$v0, 24616($a0)");

				/* dwCost = 112 + 14 */
				asm("addiu	$a1, $zero, 126");
			}
			asm("fill_load:");

			/* ADDR_L = s_nPos; */
			asm("sw		$s1, 24800($a0)");
			/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */
			asm("sw		$t6, 24612($a0)");
			CLK_PLUS();

			/* dwTime += dwCost */
			asm("addu	$s5, $s5, $a1");
		}		
		/* while (dwTime < dwLimit); */
		asm("sltu	$v0, $s5, $s6");
		asm("bne	$v0, $zero, fill_loop");
		asm("beq	$zero, $zero, proc_end");
	}
	/* else if (s_nMode == MODE_BLIT) */
	asm("blit_proc:");
	asm("bne	$v0, $t0, bits_proc");
	{
		// 䃉Cݒ
		/* SRAM_WE_CLR = SRAM_WE_MASK; */
		asm("sw		$t1, 24612($a0)");
		/* SRAM_CE_TRIS_CLR = SRAM_CE_TRIS_MASK; */
		asm("sw		$t4, 24580($a0)");

		// f[^Cݒ
		/* DATA_L_TRIS_CLR = DATA_L_TRIS_MASK; */
		asm("ori	$v0, $zero, 0xffff");
		asm("sw		$v0, 24644($a0)");
		/* DATA_H_TRIS_CLR = DATA_H_TRIS_MASK; */
		asm("addiu	$v0, $zero, 252");
		asm("sw		$v0, 24836($a0)");

		CLK_PLUS();

		asm("blit_loop:");
		/* do */
		{
			/* DWORD dwN = s_nRight - s_nPos; */
			asm("subu	$s7, $s2, $s1");	// dwN

			/* if (s_nPos & 0x3) */
			asm("andi	$v0, $s1, 0x3");
			asm("beq	$v0, $zero, blit_start");
			{
				/* DWORD tmp = 4 - (s_nPos & 0x3); */
				asm("andi	$v1, $s1, 0x3");
				asm("subu	$v0, $t3, $v1");
				
				/* if (dwN > tmp) */
				asm("sltu	$v1, $v0, $s7");
				asm("beq	$v1, $zero, blit_start");

					/* dwN = tmp; */
					asm("addu	$s7, $zero, $v0");
			}
			asm("blit_start:");

			asm("sltiu	$v0, $s7, 4");
			asm("bne	$v0, $zero, blit_dwN3");
			{
				/* dwCost = 60 */
				asm("addiu	$a1, $zero, 60");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				BLT_PLUS(); BLT_PLUS(); BLT_PLUS();
				/* s_nPos += 4; */
				asm("addu	$s1, $s1, $t3");
				asm("beq	$zero, $zero, blit_end");
			}
			/* else if (dwN == 3) */
			asm("blit_dwN3:");
			asm("bne	$s7, $t2, blit_dwN2");
			{
				/* dwCost = 62 */
				asm("addiu	$a1, $zero, 62");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				BLT_PLUS(); BLT_PLUS();
				/* s_nPos += 3; */
				asm("addu	$s1, $s1, $t2");
				asm("beq	$zero, $zero, blit_end");
			}
			/* else if (dwN == 2) */
			asm("blit_dwN2:");
			asm("bne	$s7, $t1, blit_dwN1");
			{
				/* dwCost = 54 */
				asm("addiu	$a1, $zero, 54");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				BLT_PLUS();
				/* s_nPos += 2; */
				asm("addu	$s1, $s1, $t1");
				asm("beq	$zero, $zero, blit_end");
			}
			/* else */
			asm("blit_dwN1:");
			{
				/* dwCost = 42 */
				asm("addiu	$a1, $zero, 42");

				/* s_nPos += 1; */
				asm("addu	$s1, $s1, $t0");
			}
			asm("blit_end:");

			/* if (s_nPos >= s_nRight) */
			asm("sltu	$v0, $s1, $s2");
			asm("bne	$v0, $zero, blit_load");
			{
				/* if (s_nPos >= s_nEnd) */
				asm("sltu	$v0, $s1, $s3");
				asm("bne	$v0, $zero, blit_line");
				{
					// 
					/* HS_INT_IE_CLR = HS_INT_IE_MASK; */
					asm("sw		$t9, 4196($a0)");

					/* ADDR_L = 0xFFFF; */
					asm("ori	$v0, 0xFFFF");
					asm("sw		$v0, 24800($a0)");
					/* ADDR_H_SET = ADDR_H_MASK; */
					asm("sw		$t7, 24616($a0)");
					/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */
					asm("sw		$t6, 24612($a0)");
					BLT_PLUS();

					asm("beq	$zero, $zero, proc_end");
				}
				asm("blit_line:");

				// C
				/* s_nPos += s_nAdd; */
				asm("addu	$s1, $s1, $s4");
				/* s_nRight += LINE_PITCH; */
				asm("addiu	$s2, $s2, 1024");

				/* ADDR_H_CLR = ADDR_H_MASK; */
				asm("sw		$t7, 24612($a0)");
				/* ADDR_H_SET = (s_nPos >> ADDR_H_SHIFT) & ADDR_H_MASK; */
				asm("srl	$v0, $s1, 0xe");
				asm("and	$v0, $v0, $t7");
				asm("sw		$v0, 24616($a0)");

				/* dwCost = 62 + 14 */
				asm("addiu	$a1, $zero, 76");
			}
			asm("blit_load:");

			/* ADDR_L = s_nPos; */
			asm("sw		$s1, 24800($a0)");
			/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */
			asm("sw		$t6, 24612($a0)");
			BLT_PLUS();

			/* dwTime += dwCost */
			asm("addu	$s5, $s5, $a1");
		}		
		/* while (dwTime < dwLimit); */
		asm("sltu	$v0, $s5, $s6");
		asm("bne	$v0, $zero, blit_loop");
		asm("beq	$zero, $zero, proc_end");
	}
	/* else */
	asm("bits_proc:");
	{
		// 䃉Cݒ
		/* SRAM_CE_TRIS_CLR = SRAM_CE_TRIS_MASK; */
		asm("sw		$t4, 24580($a0)");
		CLK_PLUS();

		asm("bits_loop:");
		/* do */
		{
			/* DWORD dwN = s_nRight - s_nPos; */
			asm("subu	$s7, $s2, $s1");	// dwN

			/* if (s_nPos & 0x3) */
			asm("andi	$v0, $s1, 0x3");
			asm("beq	$v0, $zero, bits_start");
			{
				/* DWORD tmp = 4 - (s_nPos & 0x3); */
				asm("andi	$v1, $s1, 0x3");
				asm("subu	$v0, $t3, $v1");
				
				/* if (dwN > tmp) */
				asm("sltu	$v1, $v0, $s7");
				asm("beq	$v1, $zero, bits_start");

					/* dwN = tmp; */
					asm("addu	$s7, $zero, $v0");
			}
			asm("bits_start:");

			asm("sltiu	$v0, $s7, 4");
			asm("bne	$v0, $zero, bits_dwN3");
			{
				/* dwCost = 56 */
				asm("addiu	$a1, $zero, 56");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				GET_PLUS(); GET_PLUS(); GET_PLUS();
				/* s_nPos += 4; */
				asm("addu	$s1, $s1, $t3");
				asm("beq	$zero, $zero, bits_end");
			}
			/* else if (dwN == 3) */
			asm("bits_dwN3:");
			asm("bne	$s7, $t2, bits_dwN2");
			{
				/* dwCost = 59 */
				asm("addiu	$a1, $zero, 59");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				GET_PLUS(); GET_PLUS();
				/* s_nPos += 3; */
				asm("addu	$s1, $s1, $t2");
				asm("beq	$zero, $zero, bits_end");
			}
			/* else if (dwN == 2) */
			asm("bits_dwN2:");
			asm("bne	$s7, $t1, bits_dwN1");
			{
				/* dwCost = 52 */
				asm("addiu	$a1, $zero, 52");

				/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */
				asm("sw		$t6, 24616($a0)");
				GET_PLUS();
				/* s_nPos += 2; */
				asm("addu	$s1, $s1, $t1");
				asm("beq	$zero, $zero, bits_end");
			}
			/* else */
			asm("bits_dwN1:");
			{
				/* dwCost = 41 */
				asm("addiu	$a1, $zero, 41");

				/* s_nPos += 1; */
				asm("addu	$s1, $s1, $t0");
			}
			asm("bits_end:");

			/* if (s_nPos >= s_nRight) */
			asm("sltu	$v0, $s1, $s2");
			asm("bne	$v0, $zero, bits_load");
			{
				/* if (s_nPos >= s_nEnd) */
				asm("sltu	$v0, $s1, $s3");
				asm("bne	$v0, $zero, bits_line");
				{
					// 
					/* HS_INT_IE_CLR = HS_INT_IE_MASK; */
					asm("sw		$t9, 4196($a0)");
					GET_PLUS();
					asm("beq	$zero, $zero, proc_end");
				}
				asm("bits_line:");

				// C
				/* s_nPos += s_nAdd; */
				asm("addu	$s1, $s1, $s4");
				/* s_nRight += LINE_PITCH; */
				asm("addiu	$s2, $s2, 1024");

				/* ADDR_H_CLR = ADDR_H_MASK; */
				asm("sw		$t7, 24612($a0)");
				/* ADDR_H_SET = (s_nPos >> ADDR_H_SHIFT) & ADDR_H_MASK; */
				asm("srl	$v0, $s1, 0xe");
				asm("and	$v0, $v0, $t7");
				asm("sw		$v0, 24616($a0)");

				/* dwCost = 62 + 14 */
				asm("addiu	$a1, $zero, 76");
			}
			asm("bits_load:");

			/* ADDR_L = s_nPos; */
			asm("sw		$s1, 24800($a0)");
			/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */
			asm("sw		$t6, 24612($a0)");
			GET_PLUS();

			/* dwTime += dwCost */
			asm("addu	$s5, $s5, $a1");
		}		
		/* while (dwTime < dwLimit); */
		asm("sltu	$v0, $s5, $s6");
		asm("bne	$v0, $zero, bits_loop");
	}
	asm("proc_end:");

	// oXJ
	/* ADDR_L_TRIS_SET = ADDR_L_TRIS_MASK; */
	asm("ori	$v0, $zero, 0xfffc");
	asm("sw		$v0, 24776($a0)");
	/* ADDR_H_TRIS_SET = ADDR_H_TRIS_MASK; */
	asm("addiu	$v0, $zero, 28");
	asm("sw		$v0, 24584($a0)");
	/* ADDR_L_CLR = ADDR_L_A0A1_MASK; */
	asm("addiu	$v0, $zero, 3");
	asm("sw		$v0, 24804($a0)");
	/* DATA_L_TRIS_SET = DATA_L_TRIS_MASK; */
	asm("ori	$v0, $zero, 0xffff");
	asm("sw		$v0, 24648($a0)");
	/* DATA_H_TRIS_SET = DATA_H_TRIS_MASK; */
	asm("addiu	$v0, $zero, 252");
	asm("sw		$v0, 24840($a0)");

	// 䃉CJ
	/* SRAM_WE_SET = SRAM_WE_MASK; */
	asm("sw		$t1, 24616($a0)");
	/* SRAM_ADVLD_TRIS_SET = SRAM_ADVLD_TRIS_MSK; */
	asm("sw		$t6, 24584($a0)");
	/* SRAM_CE_TRIS_SET = SRAM_CE_TRIS_MASK; */
	asm("sw		$t4, 24584($a0)");
	/* MUX_SEL_SET = MUX_SEL_MASK; */
	asm("sw		$t5, 24936($a0)");

	// lۑ
	asm(".set at");
	asm("sw     $s0, s_pDat");		// s_pDat
	asm("sw     $s1, s_nPos");		// s_nPos
	asm("sw     $s2, s_nRight");	// s_nRight

	// 荞ݏI
	/* HS_INT_IF_CLR = HS_INT_IF_MASK; */
	asm("sw		$t9, 4148($a0)");
}
