/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/WFConsole.h"
#include "TCPIP Stack/WFEasyConfig.h"

#include "Main.h"
#include "SDC.h"
#include "STK.h"

#define STATE_OFF		0
#define STATE_ERROR		1
#define STATE_START		2
#define STATE_CONNECT	3
#define STATE_DHCPC		4
#define STATE_READY		5
#define STATE_STOP		6

//=================================================================

static void InitAppConfig(void);
static void LoadAppConfig(void);
static void WF_Connect(void);

//=================================================================

extern const char* NTP_SERVER;

APP_CONFIG AppConfig;
static char s_SNTPServer[32];
static int s_nState;
static int s_nConnect;

//=================================================================

// 
extern void InitSTK(void)
{
	InitAppConfig();
	StackInit();
	WFInitScan();

	s_nState = STATE_OFF;
	s_nConnect = STATE_OFF;
}

// ^XN
extern void TaskSTK(void)
{
	static DWORD dwLastIP = 0;
	static DWORD dwTimeout = 0;

	switch (s_nState)
	{
	case STATE_START:
		PowerCtrlB(TRUE);

	    // dON̓xɏKv
		MACInit();
		WF_Connect();
		WFConsoleInit();

		s_nState++;
		LOG("TaskSTK(): Connecting...\r\n");
		break;

	case STATE_CONNECT:
		StackTask();
		if (s_nConnect == STATE_READY)
		{
			if ((AppConfig.SecurityMode == WF_SECURITY_WPA_WITH_PASS_PHRASE) ||
				(AppConfig.SecurityMode == WF_SECURITY_WPA2_WITH_PASS_PHRASE) ||
				(AppConfig.SecurityMode == WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE))
			{
				// ς݈ÍL[͎擾Ă(vZɍő30b邽)
				UINT8 st, id;
				tWFCPElements prof;
				WF_CMGetConnectionState(&st, &id);
				WF_CPGetElements(id, &prof);
	                
				memcpy((char*)AppConfig.SecurityKey, (char*)prof.securityKey, 32);
				AppConfig.SecurityKeyLength = 32;                
				AppConfig.SecurityMode--;
			}
			LOG("TaskSTK(): Connected!\r\n");
			dwLastIP = 0;
			dwTimeout = TickGet() + TICKS_OF(0, 0, 5);
			s_nState++;
		}
		else if (s_nConnect == STATE_ERROR) {
			LOG("TaskSTK(): Connect error\r\n");
			s_nState = STATE_ERROR;
		}
		break;

	case STATE_DHCPC:
		if (AppConfig.Flags.bIsDHCPEnabled)
		{
			if (!DHCPIsBound(0))
			{
				StackTask();
				if (TickGet() >= dwTimeout)
				{
					// ^CAEg(5b)
					LOG("DHCPC time-out error\r\n");

					// MRF24WB0MȊO̎gpœdONp鎞̎lnCol[g
					// iWF_HibernateEnable()ł͌ASSERT̂ŎgȂj
					WF_HIBERNATE_IO = 1;
					PowerCtrlB(FALSE);
					s_nState = STATE_ERROR;
				}
				break;
			}
			else {
				LOG("DHCPC Succssfull\r\n");
			}
		}
		s_nState++;
		break;

	case STATE_READY:
		StackTask();
		StackApplications();

		WFConsoleProcess();
		WFConsoleProcessEpilogue();
		WFDisplayScanMgr();

		// IPAhXω
		if (dwLastIP != AppConfig.MyIPAddr.Val)
		{
			char buf[32];
			sprintf(buf, "New IP Address: %d.%d.%d.%d\r\n",
				AppConfig.MyIPAddr.v[0], AppConfig.MyIPAddr.v[1],
				AppConfig.MyIPAddr.v[2], AppConfig.MyIPAddr.v[3] );
			LOG(buf);
			dwLastIP = AppConfig.MyIPAddr.Val;
		}
		break;
	
	case STATE_STOP:
		// MRF24WB0MȊO̎gpœdONp鎞̎lnCol[g
		// iWF_HibernateEnable()ł͌ASSERT̂ŎgȂj
		WF_HIBERNATE_IO = 1;
		PowerCtrlB(FALSE);
		s_nState = STATE_OFF;
		break;

	default:
		// case STATE_OFF:
		// case STATE_ERROR:
		// ꉞR\[͎g悤ɂĂ
		// ADebug rhłłSTATE_OFF̎iwconfigASSERT
		// ܂AAPP.cŃp[Z[uĂԂUART͎gȂ
		// ǂ̂ƂȀԂŎg悤ɂɂ́Ap[Z[uȂ
		// 悤ɂKv遨ۖwǎgȂ̂Ńp[Z[uDŗǂ
		WFConsoleProcess();
		WFConsoleProcessEpilogue();
		break;
	}
}

// Lɂ
extern void EnableSTK(void)
{
	switch (s_nState)
	{
	case STATE_OFF:
	case STATE_ERROR:
		s_nState = STATE_START;
		break;
	case STATE_START:
	case STATE_CONNECT:
	case STATE_DHCPC:
	case STATE_READY:
		break;
	case STATE_STOP:
		s_nState = STATE_CONNECT;
		break;
	}
}

// ɂ
extern void DisableSTK(void)
{
	switch (s_nState)
	{
	case STATE_OFF:
		break;
	case STATE_ERROR:
		s_nState = STATE_OFF;
		break;
	case STATE_START:
		s_nState = STATE_OFF;
		break;
	case STATE_CONNECT:
	case STATE_DHCPC:
	case STATE_READY:
		s_nState = STATE_STOP;
		break;
	case STATE_STOP:
		break;
	}
}

// LǂԂ
extern BOOL IsEnabledSTK(void)
{
	return (s_nState == STATE_READY);
}

// ǂԂ
extern BOOL IsDisabledSTK(void)
{
	return (s_nState == STATE_OFF || s_nState == STATE_ERROR);
}

//=================================================================

// ݒ菉
static void InitAppConfig(void)
{
	// ftHglݒ
	memset((void*)&AppConfig, 0x00, sizeof(AppConfig));
	
	// Flags
	AppConfig.Flags.bIsDHCPEnabled = TRUE;
	AppConfig.Flags.bInConfigMode = TRUE;

	// MAC Address
	AppConfig.MyMACAddr.v[0] = MY_DEFAULT_MAC_BYTE1;
	AppConfig.MyMACAddr.v[1] = MY_DEFAULT_MAC_BYTE2;
	AppConfig.MyMACAddr.v[2] = MY_DEFAULT_MAC_BYTE3;
	AppConfig.MyMACAddr.v[3] = MY_DEFAULT_MAC_BYTE4;
	AppConfig.MyMACAddr.v[4] = MY_DEFAULT_MAC_BYTE5;
	AppConfig.MyMACAddr.v[5] = MY_DEFAULT_MAC_BYTE6;

	// IP Address
	AppConfig.MyIPAddr.Val = MY_DEFAULT_IP_ADDR_BYTE1 | MY_DEFAULT_IP_ADDR_BYTE2<<8ul
		| MY_DEFAULT_IP_ADDR_BYTE3<<16ul | MY_DEFAULT_IP_ADDR_BYTE4<<24ul;
	AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;

	// Net Mask
	AppConfig.MyMask.Val = MY_DEFAULT_MASK_BYTE1 | MY_DEFAULT_MASK_BYTE2<<8ul
		| MY_DEFAULT_MASK_BYTE3<<16ul | MY_DEFAULT_MASK_BYTE4<<24ul;
	AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;

	// Gateway Address
	AppConfig.MyGateway.Val = MY_DEFAULT_GATE_BYTE1 | MY_DEFAULT_GATE_BYTE2<<8ul
		| MY_DEFAULT_GATE_BYTE3<<16ul | MY_DEFAULT_GATE_BYTE4<<24ul;

	// DNS Address (Primary)
	AppConfig.PrimaryDNSServer.Val = MY_DEFAULT_PRIMARY_DNS_BYTE1 | MY_DEFAULT_PRIMARY_DNS_BYTE2<<8ul
		| MY_DEFAULT_PRIMARY_DNS_BYTE3<<16ul | MY_DEFAULT_PRIMARY_DNS_BYTE4<<24ul;

	// DNS Address (PrSecondary)
	AppConfig.SecondaryDNSServer.Val = MY_DEFAULT_SECONDARY_DNS_BYTE1 | MY_DEFAULT_SECONDARY_DNS_BYTE2<<8ul
		| MY_DEFAULT_SECONDARY_DNS_BYTE3<<16ul | MY_DEFAULT_SECONDARY_DNS_BYTE4<<24ul;

	// HostName
	ASSERT(strlen(MY_DEFAULT_HOST_NAME) < sizeof(AppConfig.NetBIOSName));
	memcpypgm2ram(AppConfig.NetBIOSName, (ROM void*)MY_DEFAULT_HOST_NAME, strlen(MY_DEFAULT_HOST_NAME));
	FormatNetBIOSName(AppConfig.NetBIOSName);

	// SSID
	AppConfig.SsidLength = strlen(MY_DEFAULT_SSID_NAME);
	ASSERT(AppConfig.SsidLength < sizeof(AppConfig.MySSID));
	memcpypgm2ram(AppConfig.MySSID, (ROM void*)MY_DEFAULT_SSID_NAME, AppConfig.SsidLength);

	// Netowrk type
	AppConfig.networkType = MY_DEFAULT_NETWORK_TYPE;

	// Security (Mode, Pass/Key, WEP Key index)
	AppConfig.SecurityMode = MY_DEFAULT_WIFI_SECURITY_MODE;
	switch(AppConfig.SecurityMode)
	{
	case WF_SECURITY_OPEN:
		AppConfig.SecurityKeyLength = 0;
		AppConfig.SecurityKey[0] = '\0';
		AppConfig.WepKeyIndex = 0;
		break;

	case WF_SECURITY_WEP_40:
		AppConfig.SecurityKeyLength = 5;
		memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = MY_DEFAULT_WEP_KEY_INDEX;
		break;

	case WF_SECURITY_WEP_104:
		AppConfig.SecurityKeyLength = 13;
		memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = MY_DEFAULT_WEP_KEY_INDEX;
		break;

	case WF_SECURITY_WPA_WITH_PASS_PHRASE:
	case WF_SECURITY_WPA2_WITH_PASS_PHRASE:
	case WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE:
		AppConfig.SecurityKeyLength = strlen(MY_DEFAULT_SECURITY_KEY);
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = 0;
		break;

    case WF_SECURITY_WPA_WITH_KEY:
    case WF_SECURITY_WPA2_WITH_KEY:
    case WF_SECURITY_WPA_AUTO_WITH_KEY:
		AppConfig.SecurityKeyLength = 32;
		memcpypgm2ram(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = 0;
		break;

	default:
		LOG("\r\n\r\nCaptain this should NOT happen.\r\n\r\n");
    }

	// ݒt@C[h
	LoadAppConfig();
}

// ݒ胍[h
static void LoadAppConfig(void)
{
	setting_t Setting;
	ASSERT(IsEnabledSDC());

	// ݒt@CI[v
	if (!OpenSettings(&Setting))
	{
	    LOG("LoadAppConfig() - OpenSettings error\r\n");
		return;
	}

	// MAC address
	if (ReadSettingAddr(&Setting, "MyMACAddr", 16)) {
		memcpy(AppConfig.MyMACAddr.v, Setting.Addr, sizeof(AppConfig.MyMACAddr));
	}
	// IP address
	if (ReadSettingAddr(&Setting, "MyIPAddr", 10)) {
		memcpy(AppConfig.MyIPAddr.v, Setting.Addr, sizeof(AppConfig.MyIPAddr));
		AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;
	}
	// Subnet mask
	if (ReadSettingAddr(&Setting, "MyMask", 10)) {
		memcpy(AppConfig.MyMask.v, Setting.Addr, sizeof(AppConfig.MyMask));
		AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;
	}
	// Default Gateway
	if (ReadSettingAddr(&Setting, "MyGateway", 10)) {
		memcpy(AppConfig.MyGateway.v, Setting.Addr, sizeof(AppConfig.MyGateway));
	}
	// Primary DNS Server
	if (ReadSettingAddr(&Setting, "PrimaryDNSServer", 10)) {
		memcpy(AppConfig.PrimaryDNSServer.v, Setting.Addr, sizeof(AppConfig.PrimaryDNSServer));
	}
	// Secondary DNS Server
	if (ReadSettingAddr(&Setting, "SecondaryDNSServer", 10)) {
		memcpy(AppConfig.SecondaryDNSServer.v, Setting.Addr, sizeof(AppConfig.SecondaryDNSServer));
	}
	// NetBIOS name
	if (ReadSettingStr(&Setting, "NetBIOSName"))
	{
		ASSERT(strlen(Setting.Str) < sizeof(AppConfig.NetBIOSName));
		strcpy(AppConfig.NetBIOSName, Setting.Str);
		FormatNetBIOSName(AppConfig.NetBIOSName);
	}
	// DHCP Enabled (0 or 1)
	if (ReadSettingNum(&Setting, "bIsDHCPEnabled")) {
		AppConfig.Flags.bIsDHCPEnabled = Setting.Num;
	}
	// Wireless SSID
	if (ReadSettingStr(&Setting, "MySSID"))
	{
		AppConfig.SsidLength = strlen(Setting.Str);
		ASSERT(AppConfig.SsidLength < sizeof(AppConfig.MySSID));
		strcpy(AppConfig.MySSID, Setting.Str);
	}
	// Netowrk type (WF_INFRASTRUCTURE:1 or WF_ADHOC:2)
	if (ReadSettingNum(&Setting, "NetowrkType")) {
		AppConfig.networkType = Setting.Num;
	}
	// Security mode (0 or 1 or 2 or 4 or 6 or 8)
	if (ReadSettingNum(&Setting, "SecurityMode")) {
		AppConfig.SecurityMode = Setting.Num;
	}
	// PassPhrase (WEP40: 5x4 or WEP104: 13x4 or WPA PASS_PHRASE)
	if (ReadSettingStr(&Setting, "PassPhrase"))
	{
		AppConfig.SecurityKeyLength = strlen(Setting.Str);
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		strcpy(AppConfig.SecurityKey, Setting.Str);
	}
	// WEP Key index (0 or 1 or 2 or 3)
	if (ReadSettingNum(&Setting, "WEPKeyIndex")) {
		AppConfig.WepKeyIndex = Setting.Num;
	}

	// SNTP Server
	if (ReadSettingStr(&Setting, "SNTPServer"))
	{
		ASSERT(strlen(Setting.Str) < sizeof(s_SNTPServer));
		strcpy(s_SNTPServer, Setting.Str);
		NTP_SERVER = s_SNTPServer;
	}

	// ݒt@CN[Y
	CloseSettings(&Setting);
}

// ڑ
static void WF_Connect(void)
{
    UINT8 pid;
    UINT8 list[] = MY_DEFAULT_CHANNEL_LIST;
    
    // ڑvt@C쐬
	WF_CPCreate(&pid);

	// p[^ݒ
	WF_CPSetSsid(pid, AppConfig.MySSID, AppConfig.SsidLength);
	WF_CPSetNetworkType(pid, AppConfig.networkType);
	if (AppConfig.networkType == WF_ADHOC) {
        WF_CPSetAdHocBehavior(pid, WF_ADHOC_CONNECT_THEN_START);
	}
	WF_CPSetSecurity(pid, AppConfig.SecurityMode, AppConfig.WepKeyIndex,
		AppConfig.SecurityKey, AppConfig.SecurityKeyLength);

	WF_CASetScanType(MY_DEFAULT_SCAN_TYPE);
	WF_CASetChannelList(list, sizeof(list));
	WF_CASetListRetryCount(MY_DEFAULT_LIST_RETRY_COUNT);
	WF_CASetEventNotificationAction(MY_DEFAULT_EVENT_NOTIFICATION_LIST);
    
	if (MY_DEFAULT_PS_POLL == WF_ENABLED) {
		WF_PsPollEnable(TRUE);
	}
    else {
		WF_PsPollDisable();
    }    
	WF_CASetBeaconTimeout(40);

	// ڑ
	s_nConnect = STATE_CONNECT;
	WF_CMConnect(pid);
}

//=================================================================

// WF_Config.c - WF_ProcessEvent()
void WF_ProcessEvent(UINT8 event, UINT16 eventInfo)
{
	char buf[8];
  
	WFSetFuncState(WF_PROCESS_EVENT_FUNC, WF_ENTERING_FUNCTION);
      
	switch (event)
	{
	case WF_EVENT_CONNECTION_SUCCESSFUL:
		LOG("Event: Connection Successful\r\n"); 
		s_nConnect = STATE_READY;
		break;
        
	case WF_EVENT_CONNECTION_FAILED:
		LOG("Event: Connection Failed  -- eventInfo = ");
		sprintf(buf, "%d\r\n", eventInfo);
		putsUART(buf);
		s_nConnect = STATE_ERROR;
		break; 
            
	case WF_EVENT_CONNECTION_TEMPORARILY_LOST:
		LOG("Event: Connection Temporarily Lost -- eventInfo = ");
		sprintf(buf, "%d\r\n", eventInfo);
		putsUART(buf);
		break;
            
	case WF_EVENT_CONNECTION_PERMANENTLY_LOST:            
		LOG("Event: Connection Permanently Lost -- eventInfo = ");
		sprintf(buf, "%d\r\n", eventInfo);
		putsUART(buf);
		s_nConnect = STATE_ERROR;
		break;

	case WF_EVENT_CONNECTION_REESTABLISHED:
		LOG("Event: Connection Reestablished\r\n");
		break;

	case WF_EVENT_KEY_CALCULATION_COMPLETE:
		LOG("Event: Key calculation has completed\r\n");
		break;
            
	case WF_EVENT_SCAN_RESULTS_READY:
		LOG("Event: Scan Results Ready,");
		sprintf(buf, "%d", eventInfo);
		putsUART(buf);
		LOG("results\r\n");

		WFScanEventHandler(eventInfo);
		break;
            
	case WF_EVENT_RX_PACKET_RECEIVED:
//		LOG("Event: Rx Packet Received - length = ");
//		sprintf(buf, "%d\r\n", eventInfo);
//		putsUART(buf);
		break;
            
	default:
		ASSERT(FALSE);
		break;
	}        
    
	WFSetFuncState(WF_PROCESS_EVENT_FUNC, WF_LEAVING_FUNCTION);
}    

// WF_Config.c - WF_AssertionFailed()
#ifdef WF_DEBUG
void WF_AssertionFailed(UINT8 moduleNumber, UINT16 lineNumber) 
{
	char buf[8];
    
	LOG("WF ASSERTION: Module Number = ");
	sprintf(buf, "%d  ", moduleNumber);
	putsUART(buf);

	LOG("Line Number = ");
	sprintf(buf, "%d", lineNumber);
	putsUART(buf);

	while(1);
}    
#endif //WF_DEBUG
