/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"

// Types
typedef struct _rect_t {
	U8 x; U8 y; U8 w; U8 h;
} rect_t;
typedef struct _text_t {
	U8 x; U8 y; U16 c;
	U8 size;
	const char rom *roms;
	const char* rams;
	U16 num;
	U8 flags;
} text_t;

// Functions
extern void InitLCD(void);
extern void LCD_Fill(const rect_t* rc, U16 c);
extern void LCD_Blit(const rect_t* rc, U8 id);
extern U8 LCD_Text(const text_t* info);
extern void LCD_OnUnmount(void);

// Variables
extern const rect_t g_Scr;

// Macros
#define LCD_WHITE		0xFFFF
#define LCD_BLACK		0x0000
#define LCD_RED			0xF800
#define LCD_GREEN		0x07E0
#define LCD_BLUE		0x001F
#define LCD_CYAN		(LCD_GREEN | LCD_BLUE)
#define LCD_MAGENTA		(LCD_RED | LCD_BLUE)
#define LCD_YELLOW		(LCD_RED | LCD_GREEN)

#define TXT_WHITE		7
#define TXT_BLACK		0
#define TXT_RED			4
#define TXT_GREEN		2
#define TXT_BLUE		1
#define TXT_CYAN		3
#define TXT_MAGENTA		5
#define TXT_YELLOW		6

#define TXT_HEX			0x01
#define TXT_2DIG		0x02
