/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include "mp3.h"
#include "VS1011e.h"
#include "romdat.h"
#include "ff.h"
#include "resource.h"

#define ENABLE_DISP

//=================================================================

typedef struct _params_t {
	rect_t R;
	U8 T;
	U16 C;
} params_t;
typedef struct _pinfo_t {
	DIR* pDir;
	U8 nPos;
	U8 nMax;
	U8 nL;
	const params_t Params;
} pinfo_t;

static UINT Transfer(const BYTE* buf, UINT cb);
static void SetVol(void);
static void SoftReset(void);
static void FastOut(U8 data);
static void Write(U8 addr, U16 data);
static U16 Read(U8 addr);

static U8 FirstOpen(void);
static U8 Seek(U8 flag, U8 skip);
static U8 SeekDir(U8 flag, const char* start);
static U8 IsValidDir(const FILINFO* pInfo);
static U8 SetDir(void);
static U8 SetPos(DIR* pDir, const char* fname);
static U8 SeekFile(U8 flag);
static U8 IsValidFile(const FILINFO* pInfo);
static U8 SetInfo(pinfo_t* pInfo, U8 flag);
static void Close(void);

static void LoadFn(U8* buf, U8 addr, U8 size);
static void SaveFn(U8 addr, U8 size, const U8* buf);
static void CopyFn(char* buf, const char* src);
static U8 IsEqFn(const char* str1, const char* str2);

static void UpdateStat(U8 flags);
static void DrawPos(pinfo_t* pInfo);
static U8 UpdateTime(void);

#define WaitDreq()	while(!MP3_DREQ);

//=================================================================

#define OST_CLOSE		0x00
#define OST_ERROR		0x01
#define OST_NOTFOUND	0x02
#define OST_OPEN		0x03

#define PST_STOP		0x00
#define PST_PLAY		0x01
#define PST_STOPPING	0x02
#define PSM_CHANGE		0x80
#define PSM_NEXT		0x01
#define PSM_SKIP		0x10

#define UPD_OST			0x01
#define UPD_PST			0x02

//=================================================================

#pragma udata overlay share=0x500
static FATFS _s_FS_;
static DIR s_Root;
static FILINFO s_DirInfo;
static DIR s_Dir;
static FILINFO s_FileInfo;
static FIL s_File;
static char s_sWork[EEP_FNAME_LEN];

#pragma udata
static U8 s_nOpen;
static U8 s_nState;
static U8 s_nVol;
static U8 s_nNameR;
static char s_Name[EEP_FNAME_LEN];
static U16 s_nNums;
static U8 s_nIcon;
static U16 s_nTime;
static U8 s_nMin;
static U8 s_nSec;
static U8 s_nPat;

#pragma idata
static pinfo_t s_DirPos = {
	0, 0, 0, 0, {
		{ MP3_DIR_X, MP3_DIR_Y, MP3_DIR_W, MP3_DIR_H },
		MP3_DIR_T, MP3_DIR_C }
};
static pinfo_t s_FilPos = {
	0, 0, 0, 0, {
		{ MP3_POS_X, MP3_POS_Y, MP3_POS_W, MP3_POS_H },
		MP3_POS_T, MP3_POS_C }
};

#ifdef ENABLE_VS1011E_TEST
#define SM_TESTS	0x0020
#else
#define SM_TESTS	0x0000
#endif

//=================================================================

// 
extern void InitMP3(void)
{
	s_DirPos.pDir = &s_Root;
	s_FilPos.pDir = &s_Dir;
}

// ON/OFF
extern void MP3_Enable(U8 flag)
{
	if (flag)
	{
		s_nVol = 0;

		DrawBase(MP3_TITLE, MP3_AREA);
		s_nNameR = 0;
		*s_Name = '\0';
		s_nNums = 0;
		s_nIcon = 0;
		s_nTime = 0xFFFF;
		s_nMin = 0;
		s_nSec = 0;
		s_nPat = 0;

		MP3_XRESET = 1;
		DelayMs(5); // Ô

		// SM_SDINEW,SM_LAYER12
		WaitDreq();
		Write(SCI_MODE, 0x0802 | SM_TESTS);

		// SCI_CLOCKF(12.288MHz->24.576MHz)
		WaitDreq();
		Write(SCI_CLOCKF, 12288 / 2 + 0x8000);

		// Analog power down
		WaitDreq();
		Write(SCI_VOL, 0xFFFF);

		// XgI
		s_nOpen = FirstOpen();
		s_nState = PST_STOP;
		UpdateStat(UPD_OST);
	}
	else
	{
		MP3_XRESET = 0;
		Close();
	}
}

// ʐݒ
extern void MP3_Volume(U8 vol)
{
	s_nVol = vol;
	if (s_nState == PST_PLAY)
		SetVol();
}

// ĐJn
extern void MP3_Play(void)
{
	if (s_nOpen == OST_OPEN && s_nState == PST_STOP)
	{
		SetVol();

		// Av~[g
		DelayMs(200);
		MUTE = 0;

		s_nState = PST_PLAY;
		UpdateStat(UPD_PST);
	}
}

// Đ~
extern void MP3_Stop(void)
{
	if (s_nState != PST_STOP)
	{
		s_nState = PST_STOPPING;
		while (s_nState != PST_STOP)
			MP3_Pump();
	}
}

// I
extern void MP3_Seek(U8 flag, U8 skip)
{
	if (s_nState == PST_STOP)
	{
		// ~̓Jgړ̂
		if (s_nOpen == OST_OPEN)
		{
			s_nOpen = Seek(flag, skip);
			UpdateStat(UPD_OST);
		}
	}
	else if (s_nState == PST_PLAY)
	{
		// ĐV[PXƓĎs
		s_nState = PSM_CHANGE;
		if (flag) s_nState |= PSM_NEXT;
		if (skip) s_nState |= PSM_SKIP;
	}
}

// Xe[ghu
extern U8 MP3_Pump(void)
{
	if (s_nState == PST_PLAY)
	{
		if (MP3_DREQ)
		{
			// f[^]
			UINT cb;
			if (f_forward(&s_File, Transfer, 2048, &cb) != FR_OK)
			{
				// ُ->~
				s_nState = PST_STOPPING;
			}
			else if (s_File.fptr >= s_File.fsize)
			{
				// I->̃t@C
				s_nState = PSM_CHANGE | PSM_NEXT;
			}
			UpdateTime();
		}
		return 0x00;
	}
	else if (s_nState == PST_STOPPING)
	{
		// Av~[g
		MUTE = 1;
		DelayMs(50);

		// Analog power down
		WaitDreq();
		Write(SCI_VOL, 0xFFFF);

		// Đ~
		SoftReset();

		f_lseek(&s_File, 0);
		s_nState = PST_STOP;

		UpdateStat(UPD_PST);
	}
	else if (s_nState & PSM_CHANGE)
	{
		// I
		SoftReset();

		s_nOpen = Seek((s_nState & PSM_NEXT) != 0, (s_nState & PSM_SKIP) != 0);
		s_nState = (s_nOpen == OST_OPEN)? PST_PLAY : PST_STOP;
		UpdateStat(UPD_OST);
	}

	return 0x03;
}

// Đǂ𒲂ׂ
extern U8 MP3_IsPlaying(void)
{
	return (s_nState != PST_STOP);
}

// geXg
#ifdef ENABLE_VS1011E_TEST
extern void MP3_Test(U8 flag)
{
	WaitDreq();

	DisableINT();
	MP3_SCLK = 0;
	MP3_XDCS = 0;

	if (flag)
	{
		// Jn
		FastOut(0x53);
		FastOut(0xEF);
		FastOut(0x6E);
		FastOut(0x68); // Fs=22.050kHz
		FastOut(0x00);
		FastOut(0x00);
		FastOut(0x00);
		FastOut(0x00);
	}
	else
	{
		FastOut(0x45);
		FastOut(0x78);
		FastOut(0x69);
		FastOut(0x74);
		FastOut(0x00);
		FastOut(0x00);
		FastOut(0x00);
		FastOut(0x00);
	}

	MP3_XDCS = 1;
	MP3_SCLK = 1;
	MP3_SI = 0;
	EnableINT();
}
#endif

//=================================================================

// ]R[obN
static UINT Transfer(const BYTE* buf, UINT btf)
{
	if (btf > 0)
	{
		UINT total = 0;
		do {
			UINT rem = btf - total;
			U8 cb = (rem >= 32)? 32 : rem;
			U8 j = cb;

			WaitDreq();

			DisableINT();
			MP3_SCLK = 0;
			MP3_XDCS = 0;

			do FastOut(*buf++);
			while (--j > 0);

			MP3_XDCS = 1;
			MP3_SCLK = 1;
			MP3_SI = 0;
			EnableINT();

			total += cb;
		}
		while (total < btf);
		return total;
	}

	return MP3_DREQ;
}

// {[ݒ
static void SetVol(void)
{
	if (s_nVol > 0)
	{
		#define MP3VOL 0x58
		U16 vol = MP3VOL - 
			(((U16)s_nVol * MP3VOL + MAX_VOLUME - 1) / MAX_VOLUME);

		WaitDreq();
		Write(SCI_VOL, MAKEWORD(vol, vol)); // L = R
	}
	else
	{
		// ~[gƓ
		WaitDreq();
		Write(SCI_VOL, 0xFEFE);
	}
}

// fR[_̃Zbg
static void SoftReset(void)
{
	// r؂h~
	U16 i = 64; // 64x32=2048 byte;
	do {
		U8 j = 32;
		WaitDreq();

		DisableINT();
		MP3_SCLK = 0;
		MP3_XDCS = 0;

		do FastOut(0); // 0 Padding
		while (--j > 0);

		MP3_XDCS = 1;
		MP3_SCLK = 1;
		EnableINT();
	}
	while (--i > 0);

	// S/W Reset
	WaitDreq();
	Write(SCI_MODE, 0x0806 | SM_TESTS);
	DelayMs(1); // need 2uS
}

// M
static void Write(U8 addr, U16 data)
{
	U16 bits, mask;

	DisableINT();
	MP3_SCLK = 0;
	MP3_XCS = 0;

	// Address (0x02,addr)
	bits = 0x0200 | addr;

	mask = 0x8000; // 8+8Bits
	do {
		MP3_SI = (bits & mask)? 1 : 0;
		MP3_SCLK = 1;
		MP3_SCLK = 0;
	}
	while (mask >>= 1);

	// Data
	mask = 0x8000; // 16Bits
	do {
		MP3_SI = (data & mask)? 1 : 0;
		MP3_SCLK = 1;
		MP3_SCLK = 0;
	}
	while (mask >>= 1);

	MP3_XCS = 1;
	MP3_SCLK = 1;
	MP3_SI = 0;
	EnableINT();
}

// M
static U16 Read(U8 addr)
{
	U16 bits, mask, data = 0;

	DisableINT();
	DIR_MP3_SO = 1;
	MP3_SCLK = 0;
	MP3_XCS = 0;

	// Address (0x03,addr)
	bits = 0x0300 | addr;

	mask = 0x8000; // 8+8Bits
	do {
		MP3_SI = (bits & mask)? 1 : 0;
		MP3_SCLK = 1;
		MP3_SCLK = 0;
	}
	while (mask >>= 1);

	// Data
	mask = 0x8000; // 16Bits
	do {
		MP3_SCLK = 1;
		data = (data << 1) | MP3_SO;
		MP3_SCLK = 0;
	}
	while (mask >>= 1);

	MP3_XCS = 1;
	MP3_SCLK = 1;
	MP3_SI = 0;
	DIR_MP3_SO = 0;
	EnableINT();

	return data;
}

// o
static void FastOut(U8 data)
{
	U8 mask = 0x80;
	do {
		MP3_SI = (data & mask)? 1 : 0;
		MP3_SCLK = 1;
		MP3_SCLK = 0;
	}
	while (mask >>= 1);
}

//=================================================================

// I[v
static U8 FirstOpen(void)
{
	char fname[EEP_FNAME_LEN];
	U8 nRes;

	// [gfBNgJ
	if (f_chdir("/") != FR_OK)
		return OST_ERROR;
	if (f_opendir(&s_Root, "/") != FR_OK)
		return OST_ERROR;

	// XgfBNgJ
	LoadFn(fname, (U8)LAST_DIR, sizeof(fname));
	if (*fname != '\0')
	{
		for(;;)
		{
			if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
				return OST_ERROR;
			if (*s_DirInfo.fname == '\0')
				break;
			if (IsEqFn(s_DirInfo.fname, fname))
			{
				if (!IsValidDir(&s_DirInfo))
					*s_DirInfo.fname = '\0';
				break;
			}
		}
		if (*s_DirInfo.fname != '\0')
		{
			if (!SetDir())
				return OST_ERROR;
			
			// Xgt@CJ
			LoadFn(fname, (U8)LAST_FILE, sizeof(fname));
			if (*fname != '\0')
			{
				for(;;)
				{
					if (f_readdir(&s_Dir, &s_FileInfo) != FR_OK)
						return OST_ERROR;
					if (*s_FileInfo.fname == '\0')
						break;
					if (IsEqFn(s_FileInfo.fname, fname))
					{
						if (!IsValidFile(&s_FileInfo))
							*s_FileInfo.fname = '\0';
						break;
					}
				}
				if (*s_FileInfo.fname != '\0')
				{
					// t@C
					if (!SetInfo(&s_DirPos, 1))
						return OST_ERROR;
					if (!SetInfo(&s_FilPos, 1))
						return OST_ERROR;

					if (f_open(&s_File, fname, FA_READ) == FR_OK)
						return OST_OPEN;
				}

				// Xg͗LłȂȂ
				SaveFn((U8)LAST_DIR, sizeof(LAST_DIR), "");
				SaveFn((U8)LAST_FILE, sizeof(LAST_FILE), "");
			}
		}
	}

	// 擪V[NėLȃGgT
	if (f_readdir(&s_Root, 0) != FR_OK)
		return OST_ERROR;
	do {
		nRes = SeekDir(1, 0);
		if (nRes != OST_OPEN)
			return nRes;

		nRes = SeekFile(1);
		if (nRes == OST_ERROR)
			return OST_ERROR;
	}
	while (nRes != OST_OPEN);

	// Gg
	if (!SetInfo(&s_DirPos, 1))
		return OST_ERROR;
	if (!SetInfo(&s_FilPos, 1))
		return OST_ERROR;

	return nRes;
}

// V[N
static U8 Seek(U8 flag, U8 skip)
{
	char fname[EEP_FNAME_LEN];
	U8 nRes1, nRes2;

	// t@CV[N
	if (!skip)
	{
		if (!flag)
		{
			// ĐJn10bȏo߂ꍇ͓oƂ
			if (Read(SCI_DECODE_TIME) >= 10)
			{
				f_lseek(&s_File, 0);
				return OST_OPEN;
			}
		}
		nRes1 = SeekFile(flag);
		if (nRes1 != OST_NOTFOUND)
		{
			// ȂN[YԂɂĂ
			if (nRes1 != OST_OPEN && s_nOpen == OST_OPEN)
			{
				f_close(&s_File);
				s_nOpen = OST_CLOSE;
			}
			if (nRes1 == OST_OPEN)
			{
				// ʒu̎擾
				if (!SetInfo(&s_FilPos, 0))
					return OST_ERROR;
			}
			return nRes1;
		}
	}
	// N[YĂ
	if (s_nOpen == OST_OPEN)
	{
		f_close(&s_File);
		s_nOpen = OST_CLOSE;
	}

	// fBNgV[N
	CopyFn(fname, s_DirInfo.fname);
	CopyFn(s_sWork, fname);
	do {
		// ̃fBNg
		nRes1 = SeekDir(flag, fname);
		if (nRes1 == OST_ERROR)
			return OST_ERROR;

		// ̃t@C
		nRes2 = SeekFile((skip)? 1 : flag);
		if (nRes2 == OST_ERROR)
			return OST_ERROR;
	}
	while (nRes1 != OST_NOTFOUND && nRes2 != OST_OPEN);

	// \ʃG[̌o
	// ꏄČ݂ɖ߂͂Ȃ̂Œʏ킠蓾Ȃ
	if (nRes2 != OST_OPEN)
		return OST_ERROR;

	// ʒu̎擾
	if (!SetInfo(&s_DirPos, 1))
		return OST_ERROR;
	if (!SetInfo(&s_FilPos, 1))
		return OST_ERROR;

	return OST_OPEN;
}

// fBNgEhV[N
static U8 SeekDir(U8 flag, const char* fname)
{
	if (flag)
	{
		// tH[h
		for(;;)
		{
			if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
				return OST_ERROR;
			if (*s_DirInfo.fname == '\0')
			{
				if (f_readdir(&s_Root, 0) != FR_OK)
					return OST_ERROR;
				if (fname == 0)
					return OST_NOTFOUND;
				for(;;)
				{
					if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
						return OST_ERROR;
					if (*s_DirInfo.fname == '\0')
						return OST_ERROR; // ʏ킠蓾Ȃ
					if (IsValidDir(&s_DirInfo))
						break;
				}
				if (IsEqFn(s_DirInfo.fname, fname)) {
					return (SetDir())? OST_NOTFOUND : OST_ERROR;
				}
				break;
			}
			if (IsValidDir(&s_DirInfo)) {
				break;
			}
		}
		if (!SetDir()) {
			return OST_ERROR;
		}
	}
	else
	{
		// o[X
		FILINFO dinfo;
		dinfo.fattrib = 0;
		for(;;)
		{
			if (f_readdir(&s_Root, 0) != FR_OK)
				return OST_ERROR;
			for(;;)
			{
				if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
					return OST_ERROR;
				if (*s_DirInfo.fname == '\0')
				{
					if (*s_sWork != '\0')
						return OST_ERROR; // ʏ킠蓾Ȃ
					break;
				}
				if (IsValidDir(&s_DirInfo))
				{
					if (*s_sWork != '\0')
					{
						if (IsEqFn(s_DirInfo.fname, s_sWork))
							break;
					}
					dinfo = s_DirInfo;
				}
			}
			if (dinfo.fattrib != 0)
			{
				s_DirInfo = dinfo;
				if (!SetPos(&s_Root, s_DirInfo.fname))
					return OST_ERROR;

				if (*s_sWork == '\0')
				{
					if (IsEqFn(s_DirInfo.fname, fname))
						return (SetDir())? OST_NOTFOUND : OST_ERROR;
				}
				if (!SetDir()) {
					return OST_ERROR;
				}

				CopyFn(s_sWork, s_DirInfo.fname);
				break;
			}
			else
			{
				dinfo = s_DirInfo; // Έꏄ
				*s_sWork = '\0';
			}
		}
	}

	return OST_OPEN;
}

// LȃfBNgǂ𒲂ׂ
static U8 IsValidDir(const FILINFO* pInfo)
{
	if ((pInfo->fattrib & (AM_HID | AM_SYS | AM_VOL | AM_DIR)) != AM_DIR)
		return 0;
	if (pInfo->fname[0] == '.')
		return 0;

	return 1;
}

// fBNgZbg
static U8 SetDir(void)
{
	if (f_chdir("/") != FR_OK)
		return 0;
	if (f_opendir(&s_Dir, s_DirInfo.fname) != FR_OK)
		return 0;
	if (f_chdir(s_DirInfo.fname) != FR_OK)
		return 0;

	return 1;
}

// fBNgʒuݒ肷
static U8 SetPos(DIR* pDir, const char* fname)
{
	if (f_readdir(pDir, 0) == FR_OK)
	{
		FILINFO Info;
		for(;;)
		{
			if (f_readdir(pDir, &Info) != FR_OK)
				break;
			if (*Info.fname == '\0')
				break;
			if (IsEqFn(Info.fname, fname))
				return 1;
		}
	}
	return 0;
}

// t@CV[N
static U8 SeekFile(U8 flag)
{
	FILINFO finfo;
	char fname[EEP_FNAME_LEN];

	// o[XV[Nׂ̈̏
	if (!flag)
	{
		finfo.fsize = 0;

		if (s_nOpen == OST_OPEN)
			CopyFn(fname, s_FileInfo.fname);
		else
			fname[0] = '\0';

		if (f_readdir(&s_Dir, 0) != FR_OK)
			return OST_ERROR;
	}

	// N[YĂ
	if (s_nOpen == OST_OPEN)
	{
		f_close(&s_File);
		s_nOpen = OST_CLOSE;
	}
	for(;;)
	{
		if (f_readdir(&s_Dir, &s_FileInfo) != FR_OK)
			return OST_ERROR;
		
		if (*s_FileInfo.fname == '\0')
		{
			if (flag)
				return OST_NOTFOUND;
			break;
		}
		if (IsValidFile(&s_FileInfo))
		{
			if (fname[0] != '\0')
			{
				if (IsEqFn(s_FileInfo.fname, fname))
					break;
			}
			if (f_open(&s_File, s_FileInfo.fname, FA_READ) == FR_OK)
			{
				if (flag)
					return OST_OPEN;

				finfo = s_FileInfo;
			}
			// I[vłȂt@C̓G[T
		}
	}

	// RR̓o[XV[N̂ݒʂ
	if (finfo.fsize != 0)
	{
		s_FileInfo = finfo;
		if (!SetPos(&s_Dir, s_FileInfo.fname))
			return OST_ERROR;

		if (f_open(&s_File, s_FileInfo.fname, FA_READ) == FR_OK)
			return OST_OPEN;

		// I[vł͂Ȃ̂ɏoȂꍇ
		return OST_ERROR;
	}

	return OST_NOTFOUND;
}

// Lȃt@Cǂ𒲂ׂ
static U8 IsValidFile(const FILINFO* pInfo)
{
	if ((pInfo->fattrib & (AM_HID | AM_SYS | AM_VOL | AM_DIR)) != 0)
		return 0;
	if (pInfo->fsize < 8)
		return 0;

	return 1;
}

// ʒu擾ݒ肷
static U8 SetInfo(pinfo_t* pInfo, U8 flag)
{
	FILINFO info;
	U8 fRoot = (pInfo->pDir == &s_Root);
	const char* pCur = (fRoot)? s_DirInfo.fname : s_FileInfo.fname;
	U8 nPos = 0;

	if (f_readdir(pInfo->pDir, 0) != FR_OK)
		return 0;

	for(;;)
	{
		if (f_readdir(pInfo->pDir, &info) != FR_OK)
			return 0;
		if (*info.fname == '\0')
			break;

		if (fRoot) {
			if (!IsValidDir(&info))
				continue;
		}
		else {
			if (!IsValidFile(&info))
				continue;
		}
		if (IsEqFn(info.fname, pCur))
		{
			pInfo->nPos = nPos;
			if (!flag)
				break;
		}
		nPos++;
	}

	if (flag)
	{
		pInfo->nMax = nPos;
		return SetPos(pInfo->pDir, pCur);
	}

	return 1;
}

// t@CN[Y
static void Close(void)
{
	if (s_nOpen == OST_OPEN)
	{
		f_close(&s_File);

		// Xgۑ
		SaveFn((U8)LAST_DIR, EEP_FNAME_LEN, s_DirInfo.fname);
		SaveFn((U8)LAST_FILE, EEP_FNAME_LEN, s_FileInfo.fname);
	}
	s_nOpen = OST_CLOSE;
}

//=================================================================

// t@C[h
static void LoadFn(U8* buf, U8 addr, U8 max)
{
	U8 *end = buf + max;
	do *buf = Read_b_eep(addr++);
	while (*buf != 0 && ++buf < end);
}

// t@CZ[u
static void SaveFn(U8 addr, U8 max, const U8* buf)
{
	U8 *end = buf + max - 1;
	while (*buf != 0 && buf < end)
	{
		Write_b_eep(addr++, *buf++);
		Busy_eep();
	}
	Write_b_eep(addr, 0);
	Busy_eep();
}

// t@CRs[
static void CopyFn(char* buf, const char* src)
{
	while (*src) {
		*buf++ = *src++;
	}
	*buf = '\0';
}

// t@Cr
static U8 IsEqFn(const char* str1, const char* str2)
{
	for (; *str1 != '\0' && *str2 != '\0'; str1++, str2++)
	{
		// 召ʗL
		if (*str1 != *str2)
			return 0;
	}
	return (*str1 == *str2);
}

//=================================================================

// \XV
static void UpdateStat(U8 flags)
{
#ifdef ENABLE_DISP

	static rect_t NameR = {
		MP3_NAME_X, MP3_NAME_Y, 0, MP3_NAME_S
	};
	static text_t NameI = {
		MP3_NAME_X, MP3_NAME_Y, 0, MP3_NAME_S, 0, 0, 0, 0
	};

	if (flags & UPD_OST)
	{
		U16 nNums = 0;

		// ^Cg̈
		NameI.rams = 0;
		NameI.roms = 0;

		if (s_nOpen == OST_OPEN)
		{
			NameI.c = MP3_NAME_C1;
			NameI.rams = s_DirInfo.fname;
		}
		else if (s_nOpen == OST_NOTFOUND) {
			NameI.c = MP3_NAME_C2;
			NameI.roms = "Not Found.";
		}
		else {
			NameI.c = MP3_NAME_C3;
			NameI.roms = "Error.";
		}

		if (NameI.rams == 0 || !IsEqFn(s_Name, NameI.rams))
		{
			if (s_nNameR > MP3_NAME_X)
			{
				NameR.w = s_nNameR - MP3_NAME_X;
				LCD_Fill(&NameR, COL_SCREEN);
			}
			s_nNameR = LCD_Text(&NameI);
			if (NameI.rams != 0)
				CopyFn(s_Name, NameI.rams);
			else
				*s_Name = '\0';
		}

		// ̈
		if (s_nOpen == OST_OPEN)
			nNums = MAKEWORD(s_DirPos.nPos, s_DirPos.nMax);
		if (s_nNums != nNums)
		{
			if (s_nNums != 0)
			{
				const static rect_t NumsR = {
					MP3_NUMS_X, MP3_NUMS_Y, MP3_NUMS_W, MP3_NUMS_S
				};
				LCD_Fill(&NumsR, COL_SCREEN);
			}
			if (nNums != 0)
			{
				static text_t NumsI = {
					0, MP3_NUMS_Y, MP3_NUMS_C, MP3_NUMS_S,
					0, 0, 0, TXT_2DIG
				};
				NumsI.x = MP3_NUMS_X;
				NumsI.num = s_DirPos.nPos + 1;
				NumsI.x = LCD_Text(&NumsI);
				NumsI.roms = "/";
				NumsI.x = LCD_Text(&NumsI);
				NumsI.roms = 0;
				NumsI.num = s_DirPos.nMax;
				LCD_Text(&NumsI);
			}
			s_nNums = nNums;
		}

		// Q[Ẅ(SD͎gpȂ̂ŏɎs)
		DrawPos(&s_DirPos);
		DrawPos(&s_FilPos);
	}

	if (flags & (UPD_OST | UPD_PST))
	{
		// ACR̈
		U8 nIcon = 0;
		if (s_nOpen == OST_OPEN)
			nIcon = (s_nState == PST_PLAY)? PLAY_IMG : STOP_IMG;
		if (s_nIcon != nIcon)
		{
			static const rect_t IconR = {
				PLAY_IX, PLAY_IY, PLAY_IW, PLAY_IH
			};
			if (nIcon != 0) {
				LCD_Blit(&IconR, nIcon);
			}
			else {
				LCD_Fill(&IconR, COL_SCREEN);
			}
			s_nIcon = nIcon;
		}

		// ԗ̈
		if (s_nTime != 0 || s_nOpen != OST_OPEN)
		{
			if (s_nOpen == OST_OPEN)
			{
				static text_t TimeI = {
					0, MP3_TIME_Y, MP3_TIME_C, MP3_TIME_S,
					0, 0, 0, TXT_2DIG
				};
				TimeI.x = MP3_TIME_X1;
				LCD_Text(&TimeI);
				TimeI.x = MP3_TIME_X2;
				LCD_Text(&TimeI);
				s_nTime = 0;
			}
			else
			{
				static rect_t TiimeR = {
					0, MP3_TIME_Y, MP3_TIME_W, MP3_TIME_S
				};
				TiimeR.x = MP3_TIME_X1;
				LCD_Fill(&TiimeR, COL_SCREEN);
				TiimeR.x = MP3_TIME_X2;
				LCD_Fill(&TiimeR, COL_SCREEN);
				s_nTime = 0xFFFF;
			}
			s_nMin = s_nSec = s_nPat = 0;
		}
	}

#endif
}

// Q[W`
static void DrawPos(pinfo_t* pInfo)
{
	rect_t rc = pInfo->Params.R;

	if (pInfo->nL > 0)
	{
		rc.x = pInfo->nL;
		LCD_Fill(&rc, COL_SCREEN);
	}

	rc.x = pInfo->Params.R.x;
	if (pInfo->nMax > 1)
	{
		U8 max = pInfo->nMax - 1;
		rc.x += ((U16)pInfo->nPos * pInfo->Params.T + max - 1) / max;
	}

	LCD_Fill(&rc, pInfo->Params.C);
	pInfo->nL = rc.x;
}

// \XV
static U8 UpdateTime(void)
{
#ifdef ENABLE_DISP

	static text_t TimeI = {
		0, MP3_TIME_Y, MP3_TIME_C, MP3_TIME_S,
		0, 0, 0, 0
	};

	U8 nMin, nSec;
	s_nTime = Read(SCI_DECODE_TIME);
	nMin = s_nTime / 60;
	nSec = s_nTime % 60;

	// 1ÂXVȂƓr؂
	if (s_nMin != nMin)
	{
		if (s_nPat == 0)
		{
			TimeI.x = MP3_TIME_X1;
			TimeI.num = nMin / 10;
			s_nPat = LCD_Text(&TimeI);
		}
		else
		{
			TimeI.x = s_nPat;
			TimeI.num = nMin % 10;
			LCD_Text(&TimeI);
			s_nPat = 0;
			s_nMin = nMin;
		}
		return 0x00;
	}
	else if (s_nSec != nSec)
	{
		if (s_nPat == 0)
		{
			TimeI.x = MP3_TIME_X2;
			TimeI.num = nSec / 10;
			s_nPat = LCD_Text(&TimeI);
		}
		else
		{
			TimeI.x = s_nPat;
			TimeI.num = nSec % 10;
			LCD_Text(&TimeI);
			s_nPat = 0;
			s_nSec = nSec;
		}
		return 0x00;
	}

#endif
	return 0x02;
}
