/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "Device/LCD/lcd.h"
#include "Device/MP3/mp3.h"
#include "Device/FMR/fmr.h"
#include "Device/MSD/system/usb/usb.h"
#include "ff.h"
#include "resource.h"

//=================================================================

static void EnableMSD(U8 flag);
static void MSDTask(void);
static void MenuBack(void);

//=================================================================

#pragma udata overlay share=0x500
static FATFS s_FS;

//=================================================================

#define MST_POFF	0
#define MST_EXIT	1
#define MST_CURR	2

//=================================================================

// j[[h
extern U8 Menu(void)
{
	U8 nState = MST_CURR;

	// Jn
	SetKeyRate(800);
	MenuBack();

	// [v
	do {
		U8 nKey = GetKey();
		ClearWDT();
		switch (nKey & ~PUSHING)
		{
		case SW_NONE:
			break;

		//case SW_VDOWN:
		//	KeyBeep();
		//	break;
		//case SW_UP:
		//	KeyBeep();
		//	break;

		case SW_PLAY:
			if (!PIE2bits.USBIE)
			{
				KeyBeep();
				EnableMSD(1);
			}
			break;
		case SW_STOP:
			if (PIE2bits.USBIE)
			{
				KeyBeep();
				EnableMSD(0);
			}
			break;

		//case SW_PREV:
		//	KeyBeep();
		//	break;
		//case SW_NEXT:
		//	KeyBeep();
		//	break;

		case SW_MENU:
			KeyBeep();
			nState = MST_EXIT;
			break;
		case SW_POWER:
			nState = MST_POFF;
			break;
		}

		// MSD Task
		if (PIE2bits.USBIE) {
			MSDTask();
		}

		if (!CheckBAT(1, LEDO) || !CheckOFF())
			nState = MST_EXIT;
	}
	while (nState >= MST_CURR);

	// I
	if (PIE2bits.USBIE) {
		EnableMSD(0);
	}

	return nState;
}

//=================================================================

// MSD ON/OFF
static void EnableMSD(U8 flag)
{
	if (flag)
	{
		// t@CVXe؂藣
		// (LĂ邽)
		LCD_OnUnmount();
		f_mount(0, 0);

		// USB-ISRLɂ̂݁A̓|[O
		PIE2bits.USBIE = 1;
	}
	else
	{
		// MSDAChɂȂ܂ő҂
		U8 i = 0;
		do {
			MSDTask();
			if (!mMSDRxIsBusy() || mMSDTxIsBusy()) {
				i = 0;
			}
		}
		while (++i <= 128);
		PIE2bits.USBIE = 0;
		
		// ؒf
		USBSoftDetach();
		MSDInitEP();

		// t@CVXeėL
		f_mount(0, &s_FS);
		f_chdrive(0);
	}
}

// MSD Polling task
static void MSDTask(void)
{
	SetLEDR(!mMSDRxIsBusy());
	SetLEDG(mMSDTxIsBusy());
	SetLEDB(mMSDTxIsBusy());

	USBCheckBusStatus();
	ProcessIO();

	SetLEDR(!mMSDRxIsBusy());
	SetLEDG(mMSDTxIsBusy());
	SetLEDB(mMSDTxIsBusy());
}

//=================================================================

// x[X`
static void MenuBack(void)
{
	static const rect_t VArea = {
		VAREA_X, VAREA_Y, VAREA_W, VAREA_H };

	DrawBase(MENU_TITLE, MENU_AREA);
	LCD_Fill(&VArea, COL_SCREEN);
}
