/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include "LCD/lcd.h"

// Colors
#define MAKE_COL(r, g, b)	((((U16)(r) & 0xF8) << 8) | (((U16)(g) & 0xFC) << 3) | (((U16)(b) & 0xF8) >> 3))

// Common
#define IMG_SPLASH		0
#define IMG_SCREEN		1
#define COL_SCREEN		MAKE_COL(  0,   0,  40)
#define TITLE_X			2
#define TITLE_Y			2
#define TITLE_W			83
#define TITLE_H			25
#define CAREA_X			4
#define CAREA_Y			31
#define CAREA_W			122
#define CAREA_H			84
#define VAREA_X			4
#define VAREA_Y			118
#define VAREA_W			122
#define VAREA_H			9
#define VOL_IMG			10

// Main
#define APF_IMG			4
#define APF_IX			96
#define APF_IY			2
#define APF_IW			11
#define APF_IH			9
#define APF_S			10
#define APF_X			109
#define APF_Y			2
#define APF_C			TXT_CYAN
#define APF_W			((APF_X + APF_S * 2) - APF_IX)
#define APF_H			APF_IH

#define BAT_X			91
#define BAT_Y			14
#define BAT_W			2
#define BAT_H			11
#define BAT_SP			1
#define BAT_C0			MAKE_COL(255,   0,   0)
#define BAT_C1			MAKE_COL(245, 196,  24)
#define BAT_BK			MAKE_COL(  0,   0,   0)

#define VOL_X			31
#define VOL_Y			118
#define VOL_W			5
#define VOL_H			9
#define VOL_SP			1
#define VOL_C			MAKE_COL(153, 217, 238)

//MP3
#define MP3_TITLE		5
#define MP3_AREA		2

#define MP3_NAME_S		12
#define MP3_NAME_X		11
#define MP3_NAME_Y		38
#define MP3_NAME_C1		TXT_YELLOW
#define MP3_NAME_C2		TXT_GREEN
#define MP3_NAME_C3		TXT_RED

#define MP3_NUMS_S		11
#define MP3_NUMS_X		14
#define MP3_NUMS_Y		52
#define MP3_NUMS_W		(MP3_NUMS_S * 2)
#define MP3_NUMS_C		TXT_WHITE

#define PLAY_IMG		7
#define STOP_IMG		8
#define PLAY_IX			14
#define PLAY_IY			66
#define PLAY_IW			17
#define PLAY_IH			19

#define MP3_TIME_S		22
#define MP3_TIME_X1		37
#define MP3_TIME_X2		84
#define MP3_TIME_Y		64
#define MP3_TIME_W		40
#define MP3_TIME_C		TXT_WHITE

#define MP3_DIR_X		32
#define MP3_DIR_Y		95
#define MP3_DIR_W		4	
#define MP3_DIR_H		7
#define MP3_DIR_T		(93 - MP3_DIR_W)
#define MP3_DIR_C		MAKE_COL(255, 20, 255)

#define MP3_POS_X		32
#define MP3_POS_Y		107
#define MP3_POS_W		4	
#define MP3_POS_H		7
#define MP3_POS_T		(93 - MP3_POS_W)
#define MP3_POS_C		MAKE_COL(255, 255, 20)

// FMR
#define FMR_TITLE		6
#define FMR_AREA		3

#define FMR_NAME_S		12
#define FMR_NAME_X		11
#define FMR_NAME_Y		38
#define FMR_NAME_C1		TXT_GREEN
#define FMR_NAME_C2		TXT_CYAN

#define FMR_FREQ_S		26
#define FMR_FREQ_X1		16
#define FMR_FREQ_X2		68
#define FMR_FREQ_Y		59
#define FMR_FREQ_C		TXT_WHITE

#define FMR_POS_X		32
#define FMR_POS_Y		107
#define FMR_POS_W		4	
#define FMR_POS_H		7
#define FMR_POS_T		(93 - FMR_POS_W)
#define FMR_POS_C		MAKE_COL(255, 20, 255)

// Menu
#define MENU_TITLE		9
#define MENU_AREA		11
