/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "Volume.h"
#include "AMRadio.h"

//=================================================================

#define ST_NONE			0
#define ST_WAIT			1
#define ST_PLAY			2
#define ST_SEEK			3

#define MODE_MANU		0
#define MODE_PSET		1
#define MODE_FADJ		2
#define MAX_PSET		16

//#define MAKE_TABLE

//=================================================================

static void Start(void);
static void Stop(void);
static void ChanUpDn(BOOL fUp);
static void FreqUpDn(BOOL fUp);
static void TuneAdj(BOOL fUp);
static void Seek(BOOL fUp);
static void SetFreq(WORD freq);
static int GetFreq(int nUnit);
static void RevFreq(void);
static WORD GetLevel(void);
static void LoadPsets(void);
static void Update(void);
static const char* FindName(void);

static void InitSPI(void);
static void SetDAC(short nA, short nB);
static BYTE SendSPI(BYTE data);
#ifdef MAKE_TABLE
static void MakeTableA(void);
static void MakeTableB(void);
#endif

//=================================================================

// DAC{le[u
static struct dacval_t {
	short nA;
	short nB;
	short nAdj;
} s_DacTbl[(1602 - 531) / 9 + 1] = {
	{ 1085, 1593 }, { 1124, 1613 }, { 1162, 1633 }, { 1200, 1653 }, { 1236, 1672 },
	{ 1272, 1692 }, { 1308, 1712 }, { 1342, 1731 }, { 1377, 1750 }, { 1410, 1769 },
	{ 1444, 1787 }, { 1477, 1806 }, { 1510, 1825 }, { 1542, 1843 }, { 1574, 1862 },
	{ 1610, 1880 }, { 1637, 1898 }, { 1665, 1915 }, { 1692, 1933 }, { 1719, 1951 },
	{ 1745, 1968 }, { 1771, 1986 }, { 1797, 2003 }, { 1823, 2020 }, { 1848, 2037 },
	{ 1873, 2054 }, { 1898, 2071 }, { 1922, 2088 }, { 1946, 2105 }, { 1969, 2122 },
	{ 1992, 2138 }, { 2015, 2155 }, { 2037, 2171 }, { 2060, 2187 }, { 2082, 2203 },
	{ 2104, 2220 }, { 2125, 2236 }, { 2147, 2252 }, { 2168, 2268 }, { 2189, 2283 },
	{ 2210, 2299 }, { 2231, 2314 }, { 2251, 2328 }, { 2272, 2343 }, { 2292, 2358 },
	{ 2312, 2373 }, { 2332, 2388 }, { 2352, 2403 }, { 2372, 2418 }, { 2392, 2432 },
	{ 2411, 2448 }, { 2431, 2463 }, { 2450, 2477 }, { 2470, 2492 }, { 2489, 2507 },
	{ 2508, 2521 }, { 2527, 2535 }, { 2547, 2549 }, { 2566, 2563 }, { 2585, 2578 },
	{ 2605, 2592 }, { 2624, 2607 }, { 2643, 2621 }, { 2663, 2635 }, { 2683, 2649 },
	{ 2703, 2663 }, { 2723, 2677 }, { 2743, 2691 }, { 2763, 2705 }, { 2783, 2719 },
	{ 2803, 2734 }, { 2823, 2748 }, { 2850, 2762 }, { 2870, 2776 }, { 2890, 2790 },
	{ 2910, 2804 }, { 2930, 2817 }, { 2950, 2831 }, { 2970, 2845 }, { 2990, 2858 },
	{ 3009, 2871 }, { 3029, 2884 }, { 3049, 2898 }, { 3068, 2911 }, { 3088, 2924 },
	{ 3108, 2938 }, { 3127, 2952 }, { 3146, 2966 }, { 3165, 2980 }, { 3185, 2994 },
	{ 3204, 3008 }, { 3224, 3022 }, { 3243, 3036 }, { 3263, 3050 }, { 3282, 3064 },
	{ 3302, 3078 }, { 3321, 3092 }, { 3341, 3107 }, { 3360, 3121 }, { 3380, 3135 },
	{ 3399, 3150 }, { 3419, 3164 }, { 3438, 3178 }, { 3457, 3192 }, { 3476, 3207 },
	{ 3495, 3221 }, { 3514, 3236 }, { 3533, 3250 }, { 3552, 3265 }, { 3571, 3280 },
	{ 3590, 3295 }, { 3609, 3311 }, { 3628, 3326 }, { 3647, 3341 }, { 3666, 3357 },
	{ 3685, 3373 }, { 3704, 3389 }, { 3723, 3405 }, { 3742, 3421 }, { 3761, 3437 },
};

//=================================================================

static struct preset {
	char name[13];
	WORD freq;
} s_Psets[MAX_PSET];
static int s_nPset = 0;

static int s_nState = ST_NONE;
static int s_nMode;
static int s_nChan;
static WORD s_wFreq;
static DWORD s_dwTick;

static struct dacval_t* s_pDac;
static int s_nCount;
static short s_nDacA;
static short s_nDacB;
static DWORD s_dwAdj = 0;

//=================================================================

// 
extern void InitAMR(void)
{
	// |[g(SPI͋LȂ̂œsx)
	POW_RADIO_IO = 0;
	POW_RADIO_TRIS = OUTPUT;
	DAC_CS_IO = 1;
	DAC_CS_TRIS = OUTPUT;
	DAC_LDAC_IO = 1;
	DAC_LDAC_TRIS = OUTPUT;
	AM_AGC_TRIS = INPUT;
	AM_AGC_PCFG = ANALOG;

	// ^C}[
	T1CON = 0x0002;	// ONbN񓯊
	PR1 = 0xFFFF;
	IPC1bits.T1IP = 3;
	IEC0bits.T1IE = 1;
}

// Jn
extern void StartAMR(void)
{
	ASSERT(s_nState == ST_NONE);

	// ݒ蕜
	s_nMode = g_Data.nLastAmMode;
	s_nChan = g_Data.nLastAmChan;
	s_wFreq = g_Data.nLastAmFreq;
	if (s_wFreq == 0) {
		s_wFreq = 531;
	}
	
	ASSERT(sizeof(s_DacTbl) == sizeof(g_Data.DacTbl));
	if (g_Data.DacTbl[0] != 0) {
		memcpy(s_DacTbl, g_Data.DacTbl, sizeof(s_DacTbl));
	}
	s_pDac = NULL;

	// xJn
	s_dwTick = TickGet() + TICKS_OFMS(500);
	s_nState = ST_WAIT;
	Update();
}

// ~
extern void StopAMR(void)
{
	ASSERT(s_nState != ST_NONE);

	// ~
	if (s_nState >= ST_PLAY)
	{
		SetDefClock();
		SetMute(TRUE);
		Stop();
	}
	// ݒۑ
	g_Data.nLastAmMode = (BYTE)s_nMode;
	g_Data.nLastAmChan = (BYTE)s_nChan;
	g_Data.nLastAmFreq = s_wFreq;
	memcpy(g_Data.DacTbl, s_DacTbl, sizeof(s_DacTbl));

	// ~
	s_dwAdj = 0;
	s_nState = ST_NONE;
}

// ^XN
extern void TaskAMR(void)
{
	switch (s_nState)
	{
	case ST_WAIT:
		ASSERT(GetSystemClock() == DEFAULT_CLK);
		if (TickGet() >= s_dwTick)
		{
			// xJn
			if (s_nPset == 0)
			{
				// vZbg[h
				LoadPsets();
				Update();
			}
			// MJn
			SetClock(CLK_8MHz);
			Start();
			SetMute(FALSE);

			// NbN_E
			SetClock(CLK_32KHz);

			s_dwTick = 0;
			s_nState = ST_PLAY;
		}
		break;

	case ST_PLAY:
		if (s_nMode == MODE_MANU)
		{
			// }jA[h
			int nSW = GetPressedSW(SW_PREV | SW_NEXT);
			if (nSW == SW_NONE)
			{
				nSW = GetHoldingSW(SW_PREV | SW_NEXT);
				if (nSW != SW_NONE)
				{
					// F}jA[hֈڍsăV[N
					s_nState = ST_SEEK;
					Update();
					Seek(nSW == SW_NEXT);
					s_nState = ST_PLAY;
					Update();
					ResetInput();
				}
				else if (GetPressedSW(SW_FUNC))
				{
					if (IsDisplay())
					{
						// [hؑ
						s_nMode = MODE_PSET;
						Update();
					}
					else {
						DisplayCtrl(DISPLAY_AUTO);
					}
				}
				else if (GetHoldingSW(SW_FUNC))
				{
					// It^C}[
					SetOffTimer(TRUE);
					ResetInput();
				}
				else {
					// ␳
					RevFreq();
				}
			}
			else
			{
				if (IsDisplay())
				{
					// FgUp/Down
					FreqUpDn(nSW == SW_NEXT);
					Update();
				}
				else {
					DisplayCtrl(DISPLAY_AUTO);
				}
			}
		}
		else if (s_nMode == MODE_PSET)
		{
			// vZbg[h
			int nSW = GetPressedSW(SW_PREV | SW_NEXT);
			if (nSW == SW_NONE)
			{
				nSW = GetHoldingSW(SW_PREV | SW_NEXT);
				if (nSW != SW_NONE)
				{
					// F}jA[hֈڍsăV[N
					s_nMode = MODE_MANU;
					s_nState = ST_SEEK;
					Update();
					Seek(nSW == SW_NEXT);
					s_nState = ST_PLAY;
					Update();
					ResetInput();
				}
				else if (GetPressedSW(SW_FUNC))
				{
					if (IsDisplay())
					{
						// [hؑ
						s_nMode = MODE_FADJ;
						Update();
					}
					else {
						DisplayCtrl(DISPLAY_AUTO);
					}
				}
				else if (GetHoldingSW(SW_FUNC))
				{
					// It^C}[
					SetOffTimer(TRUE);
					ResetInput();
				}
				else {
					// ␳
					RevFreq();
				}
			}
			else
			{
				if (IsDisplay())
				{
					// F`lUp/Down
					ChanUpDn(nSW == SW_NEXT);
					Update();
				}
				else {
					DisplayCtrl(DISPLAY_AUTO);
				}
			}
		}
		else
		{
			// [h
			int nSW = GetPressedSW(SW_PREV | SW_NEXT);
			if (nSW == SW_NONE)
			{
				nSW = GetHoldingSW(SW_PREV | SW_NEXT);
				if (nSW != SW_NONE)
				{
					// FlUp/Down
					TuneAdj(nSW == SW_NEXT);
					Update();
				}
				else if (GetPressedSW(SW_FUNC))
				{
					if (IsDisplay())
					{
						// [hؑ
						s_nMode = MODE_MANU;
						Update();
					}
					else {
						DisplayCtrl(DISPLAY_AUTO);
					}
				}
				else if (GetHoldingSW(SW_FUNC))
				{
					// It^C}[
					SetOffTimer(TRUE);
					ResetInput();
				}
				else
				{
					// ␳͍s킸x\
					if (TickGet() >= s_dwTick)
					{
						Update();
						s_dwTick = TickGet() + TICKS_OFMS(250);
					}
				}
			}
			else
			{
				if (IsDisplay())
				{
					// FlUp/Down
					TuneAdj(nSW == SW_NEXT);
					Update();
				}
				else {
					DisplayCtrl(DISPLAY_AUTO);
				}
			}
		}
		break;

	default:
		ASSERT(s_nState == ST_NONE);
	}
}

// NbNύX
extern void OnClockAMR(DWORD dwOld, DWORD dwNew)
{
	// L^ĂTicklC
	if (s_dwAdj != 0)
	{
		DWORD dwTick = TickGet() + 1;
		s_dwAdj = (s_dwAdj > dwTick)?
			(dwTick + ((s_dwAdj - dwTick) * dwNew) / dwOld) : dwTick;
	}
}

//=================================================================

// Jn
static void Start(void)
{
	ASSERT(POW_RADIO_IO == 0);

	POW_RADIO_IO = 1;

	InitSPI();

	SetDAC(s_DacTbl[0].nA, s_DacTbl[0].nB);
	DelayMS(50);

	#ifdef MAKE_TABLE
	MakeTableA();
	MakeTableB();
	#endif

	// I
	SetFreq(s_wFreq);
}

// ~
static void Stop(void)
{
	ASSERT(POW_RADIO_IO == 1);
	POW_RADIO_IO = 0;
	DAC_SPICON.ON = 0;
}

// I(`l)
static void ChanUpDn(BOOL fUp)
{
	if (s_nPset > 0)
	{
		ASSERT(0 <= s_nChan && s_nChan < s_nPset);

		// ̃vZbgԍ
		if (s_wFreq != s_Psets[s_nChan].freq)
		{
			// ݂̎gɋ߂`l
			if (fUp)
			{
				for (s_nChan = 0; s_nChan < s_nPset; s_nChan++)
				{
					if (s_Psets[s_nChan].freq > s_wFreq)
						break;
				}
			}
			else
			{
				for (s_nChan = s_nPset - 1; s_nChan >= 0; s_nChan--)
				{
					if (s_Psets[s_nChan].freq < s_wFreq)
						break;
				}
			}
		}
		else {
			s_nChan += ((fUp)? 1 : -1);
		}

		// ɖ߂
		if (s_nChan < 0) {
			s_nChan = s_nPset - 1;
		}
		else if (s_nChan >= s_nPset) {
			s_nChan = 0;
		}

		// I
		SetFreq(s_Psets[s_nChan].freq);
	}
}

// I(g)
static void FreqUpDn(BOOL fUp)
{
	ASSERT(531 <= s_wFreq && s_wFreq <= 1602);

	if (fUp)
	{
		if (s_wFreq < 1602) {
			SetFreq(s_wFreq += 9);
		}
		else {
			SetFreq(s_wFreq = 531);
		}
	}
	else
	{
		if (s_wFreq > 531) {
			SetFreq(s_wFreq -= 9);
		}
		else {
			SetFreq(s_wFreq = 1602);
		}
	}
}

// V[N
static void Seek(BOOL fUp)
{
	short nStep = (fUp)? 9 : -9;

	WORD wSave = s_wFreq;
	WORD wFreq = s_wFreq + nStep;
	for (;; wFreq += nStep)
	{
		// g
		if (wFreq > 1602) {
			wFreq = 531;
		}
		else if (wFreq < 531) {
			wFreq = 1602;
		}
		// gݒ肵ăx
		SetFreq(wFreq);
		DelayMS(100);
		if (GetLevel() >= 55) {
			break;
		}
		if (wFreq == wSave) {
			break;
		}
		ClearWDT();
	}
}

// gݒ肷
static void SetFreq(WORD freq)
{
	ASSERT(531 <= freq && freq <= 1602);
	s_wFreq = freq;

	PushClock(CLK_8MHz);

	// {lݒ肷
	s_pDac = &s_DacTbl[(freq - 531) / 9];
	SetDAC(s_pDac->nA + s_pDac->nAdj, s_pDac->nB);

	// ǔ␳
	int nOSC = (freq + 455) * 10;
	for (;;)
	{
		DelayMS(50);
		int nAdj = (nOSC - GetFreq(10)) / 7; // 700Hz per step Z
		if (nAdj != 0)
		{
			SetDAC(0xFFFF, s_nDacB + nAdj);
			ClearWDT();
			continue;
		}
		break;
	}
	if (s_nDacB != s_pDac->nB)
	{
		// ␳(OSC̕␳l𓯒ɂKp)
		SetDAC(s_nDacA + (s_nDacB - s_pDac->nB), 0xFFFF);

		// ␳̒lۑ
		s_pDac->nB = s_nDacB;
		s_pDac->nA = s_nDacA - s_pDac->nAdj;
	}

	// ␳ԍXV
	s_dwAdj = TickGet() + TICK_SECOND;

	PopClock();
}

// 
static void TuneAdj(BOOL fUp)
{
	PushClock(CLK_8MHz);

	if (fUp)
	{
		if (s_pDac->nAdj < 20)
		{
			s_pDac->nAdj++;
			SetDAC(s_nDacA + 1, 0xFFFF);
		}
	}
	else
	{
		if (s_pDac->nAdj > -20)
		{
			s_pDac->nAdj--;
			SetDAC(s_nDacA - 1, 0xFFFF);
		}
	}
	DelayMS(100);

	PopClock();
}

// g擾
static int GetFreq(int nUnit)
{
	ASSERT(IEC0bits.T1IE && PR1 == 0xFFFF);
	ASSERT(T1CONbits.ON == 0);

	s_nCount = 0;
	TMR1 = 0;
	IFS0CLR = _IFS0_T1IF_MASK;

	INTCtrl(FALSE);

	T1CONSET = _T1CON_ON_MASK;
	DelayMS(nUnit);
	T1CONCLR = _T1CON_ON_MASK;

	INTCtrl(TRUE);

	return s_nCount + TMR1;
}

// ␳
static void RevFreq(void)
{
	// 1bɕ␳
	if (TickGet() >= s_dwAdj)
	{
		PushClock(CLK_8MHz);

		// ݂̎g擾}350Hzȓɕ␳
		int nOSC = (s_wFreq + 455) * 10;
		int nDiff = nOSC - GetFreq(10);
		if (nDiff > 350)
		{
			SetDAC(s_nDacA + 1, s_nDacB + 1);
			//LOG("+ Adjust");
		}
		else if (nDiff < -350)
		{
			SetDAC(s_nDacA - 1, s_nDacB - 1);
			//LOG("- Adjust");
		}
		else {
			//LOG(" Locked ");
		}

		// ␳ԍXV
		s_dwAdj = TickGet() + TICK_SECOND;

		PopClock();
	}
}

// x擾
static WORD GetLevel(void)
{
	WORD wVal;

	AD1CHSbits.CH0SA = AM_AGC_AN;
	AD1CON1bits.ON = 1;
	DelayUS(250);

	// ͓ǂݎ̂Ă
	AD1CON1bits.DONE = 0;
	while(!AD1CON1bits.DONE);

	// 4񕽋
	AD1CON1bits.DONE = 0;
	while(!AD1CON1bits.DONE);
	wVal = ADC1BUF0;
	AD1CON1bits.DONE = 0;
	while(!AD1CON1bits.DONE);
	wVal += ADC1BUF0;
	AD1CON1bits.DONE = 0;
	while(!AD1CON1bits.DONE);
	wVal += ADC1BUF0;
	AD1CON1bits.DONE = 0;
	while(!AD1CON1bits.DONE);
	wVal += ADC1BUF0;

	AD1CON1bits.ON = 0;
	return (1020 - wVal / 4);
}

//=================================================================

// vZbg[h
static void LoadPsets(void)
{
	setting_t Setting;

	// ݒt@CI[v
	if (!OpenSettings(&Setting))
	{
	    LOG("Settings error");
		return;
	}

	// ݒǂݏo
	for (s_nPset = 0; s_nPset < MAX_PSET; s_nPset++)
	{
		char keyF[10];
		sprintf(keyF, "AM%02d-Freq", s_nPset + 1);
		if (ReadSettingNum(&Setting, keyF))
		{
			char keyN[10];
			sprintf(keyN, "AM%02d-Name", s_nPset + 1);
			if (ReadSettingStr(&Setting, keyN))
			{
				ASSERT(strlen(Setting.Str) < sizeof(s_Psets[s_nPset].name));
				strcpy(s_Psets[s_nPset].name, Setting.Str);
				s_Psets[s_nPset].freq = (WORD)Setting.Num;
				continue;
			}
		}
		break;
	}
}

// \XV
static void Update(void)
{
	PushClock(CLK_8MHz);

	if (s_nState != ST_SEEK)
	{
		char buf[32];
		sprintf(buf, "AM: %4dKHz", s_wFreq);
		DisplayText(0, 0, buf);

		if (s_nMode == MODE_MANU)
		{
			/* AM: 0000KHz[   ] */
			/* --- NNNNNNNNNNNN */
			sprintf(buf, "--- %s             ", FindName());
			buf[16] = '\0';
			DisplayText(0, 1, buf);
		}
		else if (s_nMode == MODE_PSET)
		{
			/* AM: 0000KHz[   ] */
			/* P00 NNNNNNNNNNNN */
			if (s_wFreq == s_Psets[s_nChan].freq)
			{	
				sprintf(buf, "P%02d %s             ", s_nChan + 1, s_Psets[s_nChan].name);
				buf[16] = '\0';
				DisplayText(0, 1, buf);
			}
			else
			{
				sprintf(buf, "P-- %s             ", FindName());
				buf[16] = '\0';
				DisplayText(0, 1, buf);
			}
		}
		else
		{
			ASSERT(s_nMode == MODE_FADJ);

			/* AM: 0000KHz[   ] */
			/* ADJ:+NN  LV:NNN  */
			if (s_pDac != NULL)
			{
				if (s_pDac->nAdj > 0)
					sprintf(buf, "ADJ:+%02d  LV:%3u ", s_pDac->nAdj, (UINT)GetLevel());
				else if (s_pDac->nAdj < 0)
					sprintf(buf, "ADJ:-%02d  LV:%3u ", s_pDac->nAdj * -1, (UINT)GetLevel());
				else
					sprintf(buf, "ADJ: 00  LV:%3u ", (UINT)GetLevel());

				DisplayText(0, 1, buf);
			}
			else {
				DisplayText(0, 1, "                ");
			}
		}
	}
	else
	{
		/* AM: ----KHz[   ] */
		/*  Seeking...      */
		DisplayText(0, 0, "AM: ----KHz");
		DisplayText(0, 1, " Seeking...     ");
	}

	PopClock();

	DisplayCtrl(DISPLAY_AUTO);
}

// ݂̕ǖ
static const char* FindName(void)
{
	int i;
	for (i = 0; i < s_nPset; i++)
	{
		if (s_Psets[i].freq == s_wFreq)
			return s_Psets[i].name;
	}
	return "------------";
}

//=================================================================

// SPI
static void InitSPI(void)
{
	ASSERT(!DAC_SPICON.ON);

	// SPI Mode0 - 4MHz
	DAC_SPICON.FRMEN = 0;
	DAC_SPICON.SIDL = 0;
	DAC_SPICON.DISSDO = 0;
	DAC_SPICON.MODE32 = 0;
	DAC_SPICON.MODE16 = 0;
	DAC_SPICON.SMP = 0;
	DAC_SPICON.CKE = 1;
	DAC_SPICON.SSEN = 0;
	DAC_SPICON.CKP = 0;
	DAC_SPICON.MSTEN = 1;
	DAC_SPIBRG = CALCBRG(4000000UL);
	DAC_SPISTAT.SPIROV = 0;
	DAC_SPICON.ON = 1;

	DWORD nTemp = DAC_SPIBUF;
}

// DAClݒ
static void SetDAC(short nA, short nB)
{
	ASSERT(GetPeripheralClock() == CLK_8MHz);

	// 
	if (nA != (short)0xFFFF)
	{
		ASSERT(0 < nA && nA < 4096);
		s_nDacA = nA;

		DAC_CS_IO = 0;
		nA |= 0x3000; // Write to DACa BUF=Unbufferd GA=1x SHDN=1
		SendSPI(HIBYTE(nA));
		SendSPI(LOBYTE(nA));
		DAC_CS_IO = 1;
	}

	// ǔ
	if (nB != (short)0xFFFF)
	{
		ASSERT(0 < nB && nB < 4096);
		s_nDacB = nB;

		DAC_CS_IO = 0;
		nB |= 0xB000; // Write to DACb BUF=Unbufferd GA=1x SHDN=1
		SendSPI(HIBYTE(nB));
		SendSPI(LOBYTE(nB));
		DAC_CS_IO = 1;
	}

	DAC_LDAC_IO = 0;
	DAC_LDAC_IO = 1;
}

// SPIM
static BYTE SendSPI(BYTE data)
{
	DAC_SPIBUF = data;
	while(!DAC_SPISTAT.SPIRBF);
	return (BYTE)DAC_SPIBUF;
}

#ifdef MAKE_TABLE
// ݂̃e[ult@Cɏo͂
static void MakeTableA(void)
{
	FIL file;
	VERIFY(f_open(&file, "\\TABLE.TXT", FA_CREATE_ALWAYS | FA_WRITE) == FR_OK);
	int i;
	for (i = 0; i <= (1602 - 531) / 9; i++) {
		VERIFY(f_printf(&file, "%03u. A:%4u B:%4u Adj:%u\n",
			i, s_DacTbl[i].nA, s_DacTbl[i].nB, s_DacTbl[i].nAdj) != -1);
	}
	VERIFY(f_close(&file) == FR_OK);
}

// ǔɑ΂DACl(B)t@Cɏo͂
static void MakeTableB(void)
{
	DisplayText(0, 1, "MakeTableB Setup");
	DisplayCtrl(DISPLAY_AUTO);
	s_nDacB = 1500; // Jnl

	// e[u쐬
	int i;
	for (i = 0; i <= (1575 - 531) / 9; i++)
	{
		DWORD dwFreq = (531 + i * 9 + 455) * 100;
		for (;;)
		{
			SetDAC(0xFFFF, ++s_nDacB);
			DelayMS(50);
			if (GetFreq(100) >= dwFreq)
			{
				s_DacTbl[i].nB = s_nDacB;
				break;
			}
		}

		char buf[32];
		sprintf(buf, "Freq:%uHz    ", (UINT)dwFreq);
		buf[16] = '\0';
		DisplayText(0, 1, buf);
		DisplayCtrl(DISPLAY_AUTO);
	}

	// t@C֏o
	FIL file;
	VERIFY(f_open(&file, "\\DAC_B.TXT", FA_CREATE_ALWAYS | FA_WRITE) == FR_OK);
	for (i = 0; i <= (1575 - 531) / 9; i++) {
		VERIFY(f_printf(&file, "%03u. %4uKHz(%4uKHz) %u\n",
			i, 531 + i * 9 + 455, 531 + i * 9, s_DacTbl[i].nB) != -1);
	}
	VERIFY(f_close(&file) == FR_OK);

	// I
	DisplayText(0, 1, "                ");
}
#endif

//=================================================================

// TMR1
void __ISR(_TIMER_1_VECTOR, ipl4) _T1Interrupt(void)
{
	s_nCount += 0x00010000;
	IFS0CLR = _IFS0_T1IF_MASK;
}
