/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Decoder.h"

//=================================================================

// VS1053b SCI WX^
#define SCI_MODE		0x0	// [hERg[
#define SCI_STATUS		0x1	// VS1053b̃Xe[^X
#define SCI_BASS		0x2	// ̒ቹ/Rg[
#define SCI_CLOCKF		0x3	// NbNg{}`vC
#define SCI_DECODE_TIME	0x4	// bPʂł̍Đ
#define SCI_AUDATA		0x5	// eI[fBIEf[^
#define SCI_WRAM		0x6	// RAM[h/Cg
#define SCI_WRAMADDR	0x7	// RAM[h/Cg̃x[XEAhX
#define SCI_HDAT0		0x8	// Xg[Ewb_Ef[^0
#define SCI_HDAT1		0x9	// Xg[Ewb_Ef[^1
#define SCI_AIADDR		0xA	// AvP[V̊JnAhX
#define SCI_VOL			0xB	// {[ERg[
#define SCI_AICTRL0		0xC	// AvP[VERg[EWX^0
#define SCI_AICTRL1		0xD	// AvP[VERg[EWX^1
#define SCI_AICTRL2		0xE	// AvP[VERg[EWX^2
#define SCI_AICTRL3		0xF	// AvP[VERg[EWX^3

// [hݒl
#define MODE_VALUE		0x0822 // SM_SDINEW, SM_TESTS, SM_LAYER12

static void InitSPI(void);
static void WriteReg(BYTE addr, WORD data);
static WORD ReadReg(BYTE addr);
static BYTE SendSPI(BYTE data);
#define WaitDREQ()		while(!DEC_DREQ_IO);

//=================================================================

// 
extern void InitDecoder(void)
{
	// |[g(SPI͋LȂ̂œsx)
	DEC_XRESET_IO = 0;
	DEC_XRESET_TRIS = OUTPUT;
	DEC_XCS_IO = 1;
	DEC_XCS_TRIS = OUTPUT;
	DEC_XDCS_IO = 1;
	DEC_XDCS_TRIS = OUTPUT;
	DEC_DREQ_TRIS = INPUT;
}

// Ԑݒ
extern void DEC_Enable(BOOL fEnable)
{
	if (fEnable)
	{
		InitSPI();
		
		ASSERT(!DEC_XRESET_IO);
		DEC_XRESET_IO = 1;

		// SM_SDINEW, SM_TESTS, SM_LAYER12
		WaitDREQ();
		WriteReg(SCI_MODE, MODE_VALUE);
		ASSERT(ReadReg(SCI_MODE) == MODE_VALUE);

		// SC_MULT: SC_MULT=3.5~, SC_ADD=1.0~, SC_FREQ:0(12.288MHz)
		WaitDREQ();
		WriteReg(SCI_CLOCKF, 0x8800);
	}
	else
	{
		DEC_XCS_IO = 1;
		DEC_XDCS_IO = 1;
		DEC_XRESET_IO = 0;

		DEC_SPICON.ON = 0;
	}
}

// {[ݒ
extern void DEC_SetVolume(BYTE nVol)
{
	WaitDREQ();
	WriteReg(SCI_VOL, MAKEWORD(nVol, nVol));
}

// f[^M(32Byte)
extern void DEC_SendData(BYTE* pData, DWORD dwSize)
{
	ASSERT(dwSize > 0 && dwSize < 32);
	ASSERT(DEC_DREQ_IO);

	DEC_XDCS_IO = 0;
	for (; dwSize > 0; dwSize--) {
		SendSPI(*pData++);
	}
	DEC_XDCS_IO = 1;
}

// f[^M(32ByteP)
extern DWORD DEC_SendData32(BYTE* pData, DWORD dwSize)
{
	ASSERT(dwSize > 0 && (dwSize % 32) == 0);
	ASSERT(DEC_DREQ_IO);

	DEC_XDCS_IO = 0;
	DWORD dwRemain = dwSize;
	do {
		SendSPI(pData[ 0]); SendSPI(pData[ 1]); SendSPI(pData[ 2]); SendSPI(pData[ 3]);
		SendSPI(pData[ 4]); SendSPI(pData[ 5]); SendSPI(pData[ 6]); SendSPI(pData[ 7]);
		SendSPI(pData[ 8]); SendSPI(pData[ 9]); SendSPI(pData[10]); SendSPI(pData[11]);
		SendSPI(pData[12]); SendSPI(pData[13]); SendSPI(pData[14]); SendSPI(pData[15]);
		SendSPI(pData[16]); SendSPI(pData[17]); SendSPI(pData[18]); SendSPI(pData[19]);
		SendSPI(pData[20]); SendSPI(pData[21]); SendSPI(pData[22]); SendSPI(pData[23]);
		SendSPI(pData[24]); SendSPI(pData[25]); SendSPI(pData[26]); SendSPI(pData[27]);
		SendSPI(pData[28]); SendSPI(pData[29]); SendSPI(pData[30]); SendSPI(pData[31]);
		dwRemain -= 32;
		pData += 32;
	}
	while (DEC_DREQ_IO && dwRemain > 0);
	DEC_XDCS_IO = 1;

	return (dwSize - dwRemain);
}

// endFillBytȇo
extern void DEC_SendFills(int nCount)
{
	#ifdef __DEBUG
	WaitDREQ();
	WriteReg(SCI_WRAMADDR, 0x1E02); // structure version
	WaitDREQ();
	ASSERT(ReadReg(SCI_WRAM) == 0x0003); // VS1053b
	#endif

	// endFillByte擾
	WaitDREQ();
	WriteReg(SCI_WRAMADDR, 0x1E06); // byte value to send after file sen
	WaitDREQ();
	BYTE eb = ReadReg(SCI_WRAM);
	
	// o(32ByteP)
	for (; nCount >= 32; nCount -= 32)
	{
		WaitDREQ();
		DEC_XDCS_IO = 0;
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		SendSPI(eb); SendSPI(eb); SendSPI(eb); SendSPI(eb);
		DEC_XDCS_IO = 1;
	}

	// o(1ByteP)
	WaitDREQ();
	DEC_XDCS_IO = 0;
	for (; nCount > 0; --nCount) {
		SendSPI(eb);
	}
	DEC_XDCS_IO = 1;
}

// rbg[g擾
extern WORD DEC_GetBitrate(void)
{
	// VS1053b rbg[g
	const WORD BitRates[16][6] = {
		{   0,   0,   0,   0,   0,   0 },
		{  32,  32,	 32,   8,  32,   8 },
		{  64,  48,  48,  16,  40,  16 },
		{  96,  56,  56,  24,  48,  24 },
		{ 128,  64,  64,  32,  56,  32 },
		{ 160,  80,  80,  40,  64,  40 },
		{ 192,  96,  96,  48,  80,  48 },
		{ 224, 112, 112,  56,  96,  56 },
		{ 256, 128, 128,  64, 112,  64 },
		{ 288, 144, 160,  80, 128,  80 },
		{ 320, 160, 192,  96, 160,  96 },
		{ 352, 176, 224, 112, 192, 112 },
		{ 384, 192, 256, 128, 224, 128 },
		{ 416, 224, 320, 144, 256, 144 },
		{ 448, 256, 384, 160, 320, 160 },
		{   0,   0,   0,   0,   0,   0 }
	};
	
	// rbg[g擾
	WORD wTemp = ReadReg(SCI_HDAT0);
	if (wTemp == 0) {
		return 0;
	}
	BYTE nBitrate = (wTemp & 0xF000) >> 12;

	// ID,C擾
	wTemp = ReadReg(SCI_HDAT1);
	if (wTemp == 0) {
		return 0;
	}
	BYTE nID = ((BYTE)wTemp & 0x18) >> 3;
	BYTE nLayer = ((BYTE)wTemp & 0x06) >> 1;

	ASSERT(1 <= nBitrate && nBitrate <= 14);
	ASSERT(0 <= nID && nID <= 3);
	ASSERT(1 <= nLayer && nLayer <= 3);

	return BitRates[nBitrate][(3 - nLayer) * 2 + ((nID == 3)? 0 : 1)];
}

// fR[h^C擾
extern WORD DEC_GetDecodeTime(void)
{
	WaitDREQ();
	return ReadReg(SCI_DECODE_TIME);
}

// fR[h^Cݒ
extern void DEC_SetDecodeTime(WORD nSec)
{
	WaitDREQ();
	WriteReg(SCI_DECODE_TIME, nSec);
	WaitDREQ();
	WriteReg(SCI_DECODE_TIME, nSec);
}

// LZ
extern void DEC_SetCancel(void)
{
	WaitDREQ();
	WriteReg(SCI_MODE, MODE_VALUE | 0x0008); // +SM_CANCEL
}

// LZꂽǂ
extern BOOL DEC_IsCanceled(void)
{
	WaitDREQ();
	return ((ReadReg(SCI_MODE) & 0x0008) == 0);
}

// \tgZbg
extern void DEC_SoftReset(void)
{
	WaitDREQ();
	WriteReg(SCI_MODE, MODE_VALUE | 0x0004); // +SM_RESET
}

// fR[h~
extern void DEC_StopDecode(void)
{
	// Ȃ̏I̒~
	// yf[^𑗂Ȃ~ĂȂ̂ŁAfƂĂ͐菇Ƃ͎኱قȂ
	DEC_SendFills(2052);
	DEC_SetCancel();
	int nCount = 0;
	do
	{
		DEC_SendFills(32);
		nCount += 32;
		if (nCount >= 2048)
		{
			DEC_SoftReset();
			break;
		}
	} while (!DEC_IsCanceled());

	// (fR[hׂf[^)
	ASSERT(ReadReg(SCI_HDAT0) == 0);
	ASSERT(ReadReg(SCI_HDAT1) == 0);

	// X|bvmCŶh~
	DelayMS(100);
}
		
// geXg
extern void DEC_Test(BOOL fStart)
{
	WaitDREQ();
	DEC_XDCS_IO = 0;
	if (fStart)
	{
		SendSPI(0x53);
		SendSPI(0xEF);
		SendSPI(0x6E);
		SendSPI(0xC8); // 689Hz
		SendSPI(0x00);
		SendSPI(0x00);
		SendSPI(0x00);
		SendSPI(0x00);
	}
	else
	{
		SendSPI(0x45);
		SendSPI(0x78);
		SendSPI(0x69);
		SendSPI(0x74);
		SendSPI(0x00);
		SendSPI(0x00);
		SendSPI(0x00);
		SendSPI(0x00);
	}
	DEC_XDCS_IO = 1;
}

//=================================================================

// SPI
static void InitSPI(void)
{
	ASSERT(!DEC_SPICON.ON);

	// SPI Mode0 - 2MHz
	DEC_SPICON.FRMEN = 0;
	DEC_SPICON.SIDL = 0;
	DEC_SPICON.DISSDO = 0;
	DEC_SPICON.MODE32 = 0;
	DEC_SPICON.MODE16 = 0;
	DEC_SPICON.SMP = 0;
	DEC_SPICON.CKE = 1;
	DEC_SPICON.SSEN = 0;
	DEC_SPICON.CKP = 0;
	DEC_SPICON.MSTEN = 1;
	DEC_SPIBRG = CALCBRG(2000000UL);
	DEC_SPISTAT.SPIROV = 0;
	DEC_SPICON.ON = 1;

	DWORD nTemp = DEC_SPIBUF;
}

// SCICg
static void WriteReg(BYTE addr, WORD data)
{
	ASSERT(DEC_XCS_IO);

	DEC_XCS_IO = 0;

	SendSPI(0x02);
	SendSPI(addr);
	SendSPI(HIBYTE(data));
	SendSPI(LOBYTE(data));

	DEC_XCS_IO = 1;
}

// SCI[h
static WORD ReadReg(BYTE addr)
{
	ASSERT(DEC_XCS_IO);

	DEC_XCS_IO = 0;

	SendSPI(0x03);
	SendSPI(addr);
	WORD data = MAKEWORD(SendSPI(0), SendSPI(0));

	DEC_XCS_IO = 1;

	return data;
}

// SPIM
static BYTE SendSPI(BYTE data)
{
	DEC_SPIBUF = data;
	while(!DEC_SPISTAT.SPIRBF);
	return (BYTE)DEC_SPIBUF;
}
