/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/
#ifndef _WF_CONFIG_H_
#define _WF_CONFIG_H_

/*----------------------------------------------------------------------------*/
/* This block of defines allows for code and data reduction by removing       */
/* WiFi driver code and or data that is not needed by the application.        */
/* Comment out those function blocks that are not needed.                     */
/*----------------------------------------------------------------------------*/
//#define WF_USE_SCAN_FUNCTIONS
#define WF_USE_TX_POWER_CONTROL_FUNCTIONS
#define WF_USE_POWER_SAVE_FUNCTIONS
//#define WF_USE_MULTICAST_FUNCTIONS
#define WF_USE_INDIVIDUAL_SET_GETS
#define WF_USE_GROUP_SET_GETS
//#define WF_USE_DATA_TX_RX_FUNCTIONS
//#define USE_GRATUITOUS_ARP


/*= WF_ASSERT MACRO ==================================================================*/
/* Customize how the WiFi driver assert macro (WF_ASSERT) should operate.             */
/*  To DISABLE the WF_ASSERT macro: Comment out '#define WF_DEBUG'                    */
/*  To ENABLE the WF_ASSERT macro:  Unomment out '#define WF_DEBUG'                   */
/*====================================================================================*/
#ifdef __DEBUG
#define WF_DEBUG
#endif


/*= WF_CONSOLE =======================================================================*/
/* Customize whether the WiFi Driver supports a serial console application            */
/*  To DISABLE the serial console application: Comment out '#define WF_CONSOLE'       */
/*  To ENABLE the serial console application: Uncomment out '#define WF_CONSOLE'      */
/*====================================================================================*/
//#define WF_CONSOLE              /* needed for console demo */
//#define WF_CONSOLE_IFCFGUTIL    /* needed for console demo */


//#define USE_MRF24W_HOST_BUFFER
//#define STACK_USE_EZ_CONFIG
//#define EZ_CONFIG_SCAN
//#define EZ_CONFIG_STALL
//#define EZ_CONFIG_STORE


/*--------------------------------------------*/
/* Default settings for Connection Management */
/*--------------------------------------------*/
#define MY_DEFAULT_SSID_NAME                ""
#define MY_DEFAULT_NETWORK_TYPE             WF_INFRASTRUCTURE
#define MY_DEFAULT_SCAN_TYPE                WF_ACTIVE_SCAN
#define MY_DEFAULT_CHANNEL_LIST             { 5, 7, 9, 11 }
#define MY_DEFAULT_WIFI_SECURITY_MODE       WF_SECURITY_OPEN
#define MY_DEFAULT_SECURITY_KEY				""
#define MY_DEFAULT_WEP_KEY_INDEX			0

#define MY_DEFAULT_LIST_RETRY_COUNT         (3)
#define MY_DEFAULT_EVENT_NOTIFICATION_LIST  WF_NOTIFY_ALL_EVENTS
#define MY_DEFAULT_PS_POLL                  WF_DISABLED


#endif //_WF_CONFIG_H_
