/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Amp.h"
#include "peripheral\i2c.h"

#define MAX_STEP	25
#define DEV_ADDR	(0x54 >> 1)

//=================================================================

static void SetModulation(BOOL fBDMode);
static WORD ToData(int nVol, BOOL fSpeaker);
static void WriteB(BYTE addr, BYTE data);
static void WriteW(BYTE addr, WORD data);
static void WriteD(BYTE addr, DWORD data);
static BYTE ReadB(BYTE addr);
static WORD ReadW(BYTE addr);
static DWORD ReadD(BYTE addr);
static void Write(BYTE addr, BYTE data[], int nLen);
static void Read(BYTE addr, BYTE data[], int nLen); 

//=================================================================

static BOOL s_fMute = TRUE;
static BOOL s_fSpeaker = TRUE;
static BYTE s_nVol = 0xFF;

//=================================================================

// 
extern void InitAmp(void)
{
	// |[g
	AMP_RST_IO = 0;
	AMP_RST_TRIS = OUTPUT;
	AMP_PDN_IO = 0;
	AMP_PDN_TRIS = OUTPUT;

	// I2C
	I2CConfigure(AMP_I2C, I2C_ENABLE_HIGH_SPEED);
}

// Ԑݒ
extern void AmpEnable(BOOL fEnable)
{
	if (fEnable)
	{
		ASSERT(!AMP_RST_IO && !AMP_PDN_IO);

		I2CSetFrequency(AMP_I2C, GetPeripheralClock(), 400000);
		I2CEnable(AMP_I2C, TRUE);

		DelayMS(10);

		AMP_PDN_IO = 1;
		DelayUS(100);
		AMP_RST_IO = 1;
		DelayMS(12);

		// MeXg˂ăftHglmF
		ASSERT(ReadB(0x00) == 0x6C);
		ASSERT(ReadB(0x01) == 0xC1);
		ASSERT(ReadB(0x02) == 0x00);
		ASSERT(ReadB(0x03) == 0xA0);
		ASSERT(ReadB(0x04) == 0x05);
		ASSERT(ReadB(0x05) == 0x40);
		ASSERT(ReadB(0x06) == 0x00);
		ASSERT(ReadW(0x07) == 0x03FF);
		ASSERT(ReadD(0x25) == 0x01021345);

		// Oscillator trim registerFfactory trim łȂƂȂ삵Ȃ
		WriteB(0x1B, 0x80);

		// BD mode ŉ^p
		//SetModulation(TRUE);

		// System Control Register 2FNormal operation (Speaker Mode)
		WriteB(0x05, 0x00);

		// G[NA
		WriteB(0x02, 0x00);

		VERIFY(SetVolume(0));
	}
	else
	{
		ASSERT(AMP_RST_IO && AMP_PDN_IO);

		//System Control Register 2FEnter all-channel shutdown (hard mute)
		WriteB(0x05, ReadB(0x05) | 0x40);

		AMP_RST_IO = 0;
		AMP_PDN_IO = 0;

		s_fMute = TRUE;
		s_fSpeaker = TRUE;
		s_nVol = 0xFF;

		DelayMS(10);

		I2CEnable(AMP_I2C, FALSE);
	}
}

// Xs[J[[h
extern void SetSpeaker(BOOL fOn)
{
	ASSERT(AMP_RST_IO && AMP_PDN_IO);

	if (s_fSpeaker != fOn)
	{
		// System Control Register 2FNormal operation
		WriteB(0x05, (fOn)? 0x00 : 0x13);
		s_fSpeaker = fOn;
	}
}

// Xs[J[Ԃ̎擾
extern BOOL IsSpeaker(void)
{
	return s_fSpeaker;
}

// ~[g
extern void SetMute(BOOL fMute)
{
	ASSERT(AMP_RST_IO && AMP_PDN_IO);

	if (s_fMute != fMute)
	{
		// Master volume
		WriteW(0x07, (fMute)? 0x03FF : 0x0C0);
		s_fMute = fMute;
	}
}

// ~[gԂ̎擾
extern BOOL IsMute(void)
{
	return s_fMute;
}

// {[lݒ
extern BOOL SetVolume(int nVol)
{
	ASSERT(AMP_RST_IO && AMP_PDN_IO);

	if (s_nVol != nVol)
	{
		if (0 <= nVol && nVol <= MAX_STEP)
		{
			s_nVol = nVol;
			WriteW(0x08, ToData(s_nVol, TRUE)); // Channel-1 volume
			WriteW(0x09, ToData(s_nVol, TRUE)); // Channel-2 volume
			WriteW(0x0C, ToData(s_nVol, FALSE)); // Headphone volume
			return TRUE;
		}
	}
	return FALSE;
}

// {[l擾
extern int GetVolume(void)
{
	return s_nVol;
}

//=================================================================

// Modulation(AD/BD)ݒ
static void SetModulation(BOOL fBDMode)
{
	if (fBDMode)
	{
		// Channel Interchannel Delay Register
		ASSERT(ReadB(0x11) == 0xAC);
		ASSERT(ReadB(0x12) == 0x54);
		ASSERT(ReadB(0x13) == 0xAC);
		ASSERT(ReadB(0x14) == 0x54);
		WriteB(0x11, 0xB8);
		WriteB(0x12, 0x60);
		WriteB(0x13, 0xA0);
		WriteB(0x14, 0x48);

		// Input Multiplexer Register
		ASSERT(ReadD(0x20) == 0x00017772);
		WriteD(0x20, 0x00897772);
	}
	else
	{
		// Channel Interchannel Delay Register
		ASSERT(ReadB(0x11) == 0xB8);
		ASSERT(ReadB(0x12) == 0x60);
		ASSERT(ReadB(0x13) == 0xA0);
		ASSERT(ReadB(0x14) == 0x48);
		WriteB(0x11, 0xAC);
		WriteB(0x12, 0x54);
		WriteB(0x13, 0xAC);
		WriteB(0x14, 0x54);

		// Input Multiplexer Register
		ASSERT(ReadD(0x20) == 0x00897772);
		WriteD(0x20, 0x00017772);
	}
}

// {[WX^l֕ϊ
static WORD ToData(int nVol, BOOL fSpeaker)
{
	if (fSpeaker)
	{
		#define MIN_VALU_SP		0xC0  //  -0.000dB
		#define MAX_VALU_SP		0x2A0 // -60.000dB
		#define ADJ_VALU_SP		(MAX_VALU_SP - MIN_VALU_SP)

		return (WORD)(ADJ_VALU_SP - ((ADJ_VALU_SP * nVol) / MAX_STEP) + MIN_VALU_SP);
	}
	else
	{
		#define MIN_VALU_HP		0x0E8 //  -5.000dB
		#define MAX_VALU_HP		0x2F0 // -70.000dB
		#define ADJ_VALU_HP		(MAX_VALU_HP - MIN_VALU_HP)

		return (WORD)(ADJ_VALU_HP - ((ADJ_VALU_HP * nVol) / MAX_STEP) + MIN_VALU_HP);
	}
}

// WX^Cg(8Bit)
static void WriteB(BYTE addr, BYTE data)
{
	BYTE temp[1];
	temp[0] = data;
	Write(addr, temp, 1);
}

// WX^Cg(16Bit)
static void WriteW(BYTE addr, WORD data)
{
	BYTE temp[2];
	temp[0] = HIBYTE(data);
	temp[1] = LOBYTE(data);
	Write(addr, temp, 2);
	ASSERT(ReadW(addr) == data);
}

// WX^Cg(32Bit)
static void WriteD(BYTE addr, DWORD data)
{
	BYTE temp[4];
	temp[0] = HIBYTE(HIWORD(data));
	temp[1] = LOBYTE(HIWORD(data));
	temp[2] = HIBYTE(LOWORD(data));
	temp[3] = LOBYTE(LOWORD(data));
	Write(addr, temp, 4);
	ASSERT(ReadD(addr) == data);
}

// WX^[h(8Bit)
static BYTE ReadB(BYTE addr)
{
	BYTE data[1];
	Read(addr, data, 1);
	return data[0];
}

// WX^[h(16Bit)
static WORD ReadW(BYTE addr)
{
	BYTE data[2];
	Read(addr, data, 2);
	return MAKEWORD(data[0], data[1]);
}

// WX^[h(32Bit)
static DWORD ReadD(BYTE addr)
{
	BYTE data[4];
	Read(addr, data, 4);
	return MAKEDWORD(MAKEWORD(data[0], data[1]), MAKEWORD(data[2], data[3]));
}

// WX^Cg
static void Write(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(I2CTransmitterIsReady(AMP_I2C));
		VERIFY(I2CSendByte(AMP_I2C, data[i]) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(AMP_I2C));
		ASSERT(I2CByteWasAcknowledged(AMP_I2C));
	}
	while (++i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}

// WX^[h
static void Read(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// Repeat condition
	VERIFY(I2CRepeatStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & R flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_READ);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(!I2CReceivedDataIsAvailable(AMP_I2C));
		VERIFY(I2CReceiverEnable(AMP_I2C, TRUE) == I2C_SUCCESS);
		while (!I2CReceivedDataIsAvailable(AMP_I2C));
		data[i] = I2CGetByte(AMP_I2C);

		// ACK and NAK (TAS5717̎dlŌNAK𑗐M)
		I2CAcknowledgeByte(AMP_I2C, (nLen != ++i));
		while (!I2CAcknowledgeHasCompleted(AMP_I2C));
	}
	while (i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}
