/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "TCPIP Stack/TCPIP.h"
#include "ff.h"

//=================================================================

static struct flist {
	FILINFO info;
	DIR dir;
	BOOL detail;
} s_List;

static int s_nOpen = 0;
static FIL s_File;

//=================================================================

// [U[F
extern BOOL FtpVerify(char* pUser, char* Pass)
{
	// SĎ󂯓
	VERIFY(f_chdir("\\") == FR_OK);
	return TRUE;
}

// JgfBNgύX
extern BOOL FtpChDir(char* pDir)
{
	return (f_chdir(pDir) == FR_OK);
}

// \^Cvݒ
extern BOOL FtpSetType(char* pType)
{
	// SĎ󂯓
	return TRUE;
}

// I[v
extern FTPH FtpOpen(char* pFile, int nType)
{
	if (s_nOpen != 0)
	{
		ASSERT(FALSE);
		return NULL;
	}
	
	BYTE nFlags;
	switch (nType)
	{
	case FTP_FREAD:
		nFlags = FA_READ;
		break;
	case FTP_FCREATE:
		nFlags = FA_WRITE | FA_CREATE_ALWAYS;
		break;
	case FTP_FAPPEND:
		nFlags = FA_WRITE | FA_OPEN_ALWAYS;
		break;
	default:
		ASSERT(FALSE);
		return NULL;
	}
	
	if (f_open(&s_File, pFile, nFlags) != FR_OK) {
		return NULL;
	}
	if (nType == FTP_FAPPEND)
	{
		if (f_lseek(&s_File, s_File.fsize) != FR_OK)
		{
			VERIFY(f_close(&s_File) == FR_OK);
			return NULL;
		}
	}
	s_nOpen++;
	return &s_File;
}

// N[Y
extern void FtpClose(FTPH hFile)
{
	ASSERT(hFile == &s_File);
	if (s_nOpen != 1)
	{
		ASSERT(FALSE);
		return;
	}
	s_nOpen--;
	VERIFY(f_close(&s_File) == FR_OK);
}

// [h
extern BOOL FtpRead(FTPH hFile, BYTE* pBuf, UINT nSize, UINT* pSize)
{
	ASSERT(hFile == &s_File);
	ASSERT(nSize > 0);
	return (f_read(&s_File, pBuf, nSize, pSize) == FR_OK);
}

// Cg
extern BOOL FtpWrite(FTPH hFile, BYTE* pBuf, UINT nSize)
{
	ASSERT(hFile == &s_File);
	ASSERT(nSize > 0);

	UINT nWrite;
	if (f_write(&s_File, pBuf, nSize, &nWrite) != FR_OK)
		return FALSE;

	return (nSize == nWrite);
}

// t@C(J)
extern FTPH FtpOpenList(char* pPath, BOOL fDetail)
{
	if (pPath[0] != '/' || pPath[1] != '\0')
	{
		if (f_stat(pPath, &s_List.info) != FR_OK)
			return NULL;
	}
	else
	{
		memset(&s_List.info, 0, sizeof(s_List.info));
		s_List.info.fattrib = AM_DIR;
	}

	if (s_List.info.fattrib & AM_DIR)
	{
		if (f_opendir(&s_List.dir, pPath) != FR_OK)
			return NULL;
	}
	else
	{
		if (!fDetail)
			return NULL;
	}

	s_List.detail = fDetail;
	return &s_List;
}

// t@C(ꍀڎ擾)
extern int FtpGetNext(FTPH hList, char* pBuf, UINT* pSize)
{
	ASSERT(hList == &s_List);

	if (s_List.info.fattrib & AM_DIR)
	{
		FILINFO info;
		if (f_readdir(&s_List.dir, &info) != FR_OK)
			return -1;
		if (*info.fname == '\0')
			return 0;

		if (s_List.detail)
		{
			*pSize += sprintf(pBuf, "%crwxrwxrwx 0 owner %u Jan 1 00:00 %s\r\n",
				(info.fattrib & AM_DIR)? 'd' : '-', (UINT)info.fsize, info.fname);
		}
		else {
			*pSize += sprintf(pBuf, "%s\r\n", info.fname);
		}
		return 1;
	}
	else
	{
		*pSize += sprintf(pBuf, "-rwxrwxrwx 0 owner %u Jan 1 00:00 %s\r\n",
			(UINT)s_List.info.fsize, s_List.info.fname);
		return 0;
	}
}

// l[
extern BOOL FtpRename(char* pOld, char* pNew)
{
	return (f_rename(pOld, pNew) == FR_OK);
}

// 폜
extern BOOL FtpDelete(char* pPath)
{
	return (f_unlink(pPath) == FR_OK);
}

// 쐬
extern BOOL FtpMkDir(char* pDir)
{
	return (f_mkdir(pDir) == FR_OK);
}

// JgfBNg̎擾
extern char* FtpGetCur(char* pPath)
{
	if (f_getcwd(pPath, MAX_PATH) == FR_OK) {
		return pPath + 2;
	}
	return NULL;
}
