/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"

//=================================================================

#define USE_LCD09052
//#define USE_WEH001602A

#ifdef USE_LCD09052
#define CLSDISP_DELAY	2
#endif
#ifdef USE_WEH001602A
#define CLSDISP_DELAY	8
#endif

#define TEMPON_TIME		TICKS_OF(15)
//#define DISABLE_AUTOFF // for Test

//=================================================================

static void Initialize(void);
static void Write4(BYTE rs, BYTE data);
static void Write8(BYTE rs, BYTE data);

//=================================================================

static int s_nType = DISPLAY_OFF;
static DWORD s_dwAuto = 0;
static DWORD s_dwTemp = 0;

//=================================================================

// 
extern void InitDisplay(void)
{
	// |[g
	LCD_E_IO = 0;
	LCD_E_TRIS = OUTPUT;
	LCD_RS_IO = 0;
	LCD_RS_TRIS = OUTPUT;
	LCD_DAT_IOCLR = LCD_DAT_MASK;
	LCD_DAT_TRISCLR = LCD_DAT_MASK;
	
	BKLIGHT_IO = 0; // USE_WEH001602A͖gp
	BKLIGHT_TRIS = OUTPUT;

	// LCD
	Initialize();
}

// ^XN
extern void TaskDisplay(void)
{
	if (s_dwAuto != 0 || s_dwTemp != 0)
	{
		DWORD dwTick = TickGet();

		// DISPLAY_AUTO
		if (s_dwAuto != 0)
		{
			ASSERT(s_nType == DISPLAY_AUTO);
			if (dwTick >= s_dwAuto) {
				DisplayCtrl(DISPLAY_OFF);
			}
		}
		else {
			ASSERT(s_nType != DISPLAY_AUTO);
		}

		// DISPLAY_TEMPON
		if (s_dwTemp != 0)
		{
			if (dwTick >= s_dwTemp)
			{
				if (s_nType == DISPLAY_OFF)
				{
					BKLIGHT_IO = 0;
					Write8(0, 0b00001000); // Display Off
				}
				s_dwTemp = 0;
			}
		}
	}
}

// NbNύX
extern void OnClockDisp(DWORD dwOld, DWORD dwNew)
{
	// L^ĂTicklC
	if (s_dwAuto != 0)
	{
		DWORD dwTick = TickGet() + 1;
		s_dwAuto = (s_dwAuto > dwTick)?
			(dwTick + ((s_dwAuto - dwTick) * (long long)dwNew) / dwOld) : dwTick;
	}
	if (s_dwTemp != 0)
	{
		DWORD dwTick = TickGet() + 1;
		s_dwTemp = (s_dwTemp > dwTick)?
			(dwTick + ((s_dwTemp - dwTick) * (long long)dwNew) / dwOld) : dwTick;
	}
}

// \NA
extern void ClearDisplay(void)
{
	Write8(0, 0b00000001); // Display Clear
	DelayMS(CLSDISP_DELAY);
}

// \
extern void DisplayText(int x, int y, const char* pText)
{
	BYTE data = 0x80; // SetDDRAM address
	data |= y << 6; // Line1/2 start address
	data += x;

	Write8(0, data);
	for (; *pText != '\0'; pText++) {
		Write8(1, *pText);
	}
}

// obNCg
extern void DisplayCtrl(int nType)
{
#ifdef DISABLE_AUTOFF
	if (nType == DISPLAY_AUTO) {
		nType = DISPLAY_ON;
	}
#endif
	switch (nType)
	{
	case DISPLAY_OFF:
		if (s_nType != DISPLAY_OFF)
		{
			if (s_dwTemp == 0)
			{
				BKLIGHT_IO = 0;
				Write8(0, 0b00001000); // Display Off
			}
			s_dwAuto = 0;
			s_nType = DISPLAY_OFF;
		}
		break;

	case DISPLAY_ON:
		if (s_nType != DISPLAY_ON)
		{
			Write8(0, 0b00001100);
			BKLIGHT_IO = 1; // Display On
			s_dwAuto = 0;
			s_nType = DISPLAY_ON;
		}
		break;

	case DISPLAY_AUTO:
		if (s_nType == DISPLAY_OFF)
		{
			Write8(0, 0b00001100);
			BKLIGHT_IO = 1; // Display On
		}
		s_dwAuto = TickGet() + TEMPON_TIME;
		s_nType = DISPLAY_AUTO;
		break;

	case DISPLAY_TEMPON:
		Write8(0, 0b00001100);
		BKLIGHT_IO = 1; // Display On
		s_dwTemp = TickGet() + TEMPON_TIME;
		break;

	case DISPLAY_RESET:
		BKLIGHT_IO = 0;
		Write8(0, 0b00001000); // Display Off
		s_dwAuto = 0;
		s_dwTemp = 0;
		s_nType = DISPLAY_OFF;
		break;
	}
}

// \Ԃ擾
extern BOOL IsDisplay(void)
{
	return BKLIGHT_IO;
}

//=================================================================

// LCD(4bit mode)
static void Initialize(void)
{
#ifdef USE_LCD09052
	Write4(0, 0b0011);
	DelayMS(5);

	Write4(0, 0b0011);
	DelayUS(100);

	Write4(0, 0b0011);

	Write4(0, 0b0010);
	Write8(0, 0b00101000); // Function Set
	Write8(0, 0b00001000); // Display Off
	Write8(0, 0b00000001); // Display Clear
	DelayMS(2);
	Write8(0, 0b00000110); // Entry Mode Set
#endif
#ifdef USE_WEH001602A
	int i;
	for (i = 0; i < 16; i++) {
		Write4(0, 0);
	}
	Write4(0, 0b0010);
	Write8(0, 0b00101000); // Function Set(WESTERN EUROPEAN CHARACTER FONT TABLE II)
	Write8(0, 0b00001000); // Display Off
	Write8(0, 0b00000001); // Display Clear
	DelayMS(8);
	Write8(0, 0b00000110); // Entry Mode Set
#endif
}

// LCD֏(4Bit)
static void Write4(BYTE rs, BYTE data)
{
	BYTE temp = LCD_DAT_IO & ~LCD_DAT_MASK;

	LCD_RS_IO = rs;

	LCD_E_IO = 1;
	LCD_DAT_IO = temp | (data & LCD_DAT_MASK);
	DelayUS(50);

	LCD_E_IO = 0;
	DelayUS(50);
}

// LCD֏(4Bit x2)
static void Write8(BYTE rs, BYTE data)
{
	BYTE temp = LCD_DAT_IO & ~LCD_DAT_MASK;

	LCD_RS_IO = rs;

	LCD_E_IO = 1;
	LCD_DAT_IO = temp | ((data >> 4) & LCD_DAT_MASK);
	DelayUS(50);

	LCD_E_IO = 0;
	DelayUS(50);

	LCD_E_IO = 1;
	LCD_DAT_IO = temp | ((data >> 0) & LCD_DAT_MASK);
	DelayUS(50);

	LCD_E_IO = 0;
	DelayUS(50);
}
