/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "SDC.h"
#include "ff.h"

//=================================================================

#define MAX_SPICLOCK	20000000UL // 20MHz

static FATFS s_FS;

//=================================================================

// 
extern void InitSDC(void)
{
	f_mount(DRV_SDC, &s_FS);
}

// NbNύX
extern void OnClockSDC(void)
{
	if (SDC_SPICON.ON)
	{
		SDC_SPICON.ON = 0;
		SDC_SPIBRG = CALCBRG(MAX_SPICLOCK);
		SDC_SPICON.ON = 1;
	}
}

//=================================================================

// SDC Commands
#define GO_IDLE_STATE		0x40
#define SEND_OP_COND		0x41
#define SEND_IF_COND		0x48
#define SEND_CSD			0x49
#define SET_BLOCKLEN		0x50
#define READ_SINGLE_BLOCK	0x51
#define WRITE_SINGLE_BLOCK	0x58
#define APP_OP_COND			0x69
#define APP_CMD				0x77
#define READ_OCR			0x7A

#define FLOATING_BUS		0xFF
#define DATA_START_TOKEN	0xFE
#define DATA_ACCEPTED		0x05

#define MODE_NORMAL			9
#define MODE_HC				0

#define Clocking8()			SendSPI(0xFF)
#define NOCRC				0xFF

//=================================================================

static void InitSPI(void);
static BOOL CheckSDC(void);
static BOOL BusyCheck(void);
static BYTE SendCMD(BYTE cmd, DWORD param, BYTE crc, BYTE f1, BYTE f2);
static BYTE RecvSPI(void);
static BYTE SendSPI(BYTE data);

//=================================================================

static int s_nMode;
static int s_nBusy;

//=================================================================

// J
extern BOOL OpenSDC(void)
{
	int nCount;
	BYTE nR1;

	s_nMode = -1;
	s_nBusy = FALSE;

	// |[g
	SDC_CS_IO = 1;
	SDC_CS_TRIS = OUTPUT;

	// C^[tF[X
	InitSPI();
	DelayMS(1);

	nCount = 10;
	do Clocking8();
	while (--nCount > 0);

	// J[hZbg
	SDC_CS_IO = 0;
	DelayMS(1);
	nR1 = SendCMD(GO_IDLE_STATE, 0, 0x95, TRUE, TRUE);
	if (nR1 != 0x01)
	{
		SDC_SPICON.ON = 0;
	    LOG("SDC open error");
		return FALSE;
	}

	// J[h
	nR1 = SendCMD(SEND_IF_COND, 0x1AA, 0x87, FALSE, FALSE);
	if (nR1 <= 0x01)
	{
		// SDC Ver2 or SDHC
		DWORD nR7 =
			((DWORD)RecvSPI() << 24) |
			((DWORD)RecvSPI() << 16) |
			((DWORD)RecvSPI() <<  8) |
			((DWORD)RecvSPI() <<  0);

		Clocking8();
		SDC_CS_IO = 1;

		s_nMode = MODE_HC;

		if (nR7 == 0x1AA)
		{
			nCount = 500;
			do {
				DelayMS(1);
				SendCMD(APP_CMD, 0, NOCRC, TRUE, FALSE);
				nR1 = SendCMD(APP_OP_COND, 0x40000000, NOCRC, TRUE, TRUE);
			}
			while(nR1 != 0x00 && --nCount > 0);
		}
		else {
			nCount = 0;
		}
	}
	else
	{
		// MMC or SDC Ver1
		Clocking8();
		SDC_CS_IO = 1;

		s_nMode = MODE_NORMAL;

		nCount = 500;
		do {
			DelayMS(1);
			nR1 = SendCMD(SEND_OP_COND, 0, 0xF9, TRUE, TRUE);
		}
		while(nR1 != 0x00 && --nCount > 0);
	}

	// J[hݒmF
	if (nCount == 0 || !CheckSDC())
	{
		SDC_SPICON.ON = 0;
	    LOG("SDC open error");
		return FALSE;
	}

	return TRUE;
}

// ZN^[h
extern BOOL ReadSDC(DWORD addr, BYTE* buf)
{
	int nCount;
	BYTE nR1;

	// rW[`FbN
	if (!BusyCheck())
		return FALSE;

	// R}hs
	if (SendCMD(READ_SINGLE_BLOCK, addr << s_nMode, NOCRC, TRUE, FALSE) != 0x00)
	{
		SDC_CS_IO = 1;
		if (SendCMD(READ_SINGLE_BLOCK, addr << s_nMode, NOCRC, TRUE, FALSE) != 0x00)
		{
			SDC_CS_IO = 1;
			return FALSE;
		}
	}

	// g[NmF
	nCount = 4000;
	do nR1 = RecvSPI();
	while (nR1 == FLOATING_BUS && --nCount > 0);

	if (nR1 == DATA_START_TOKEN)
	{
#if 0
		/* WX^ */
		asm("lui	$t0, 0xbf80");		// Base address
		asm("lw		$t1, 52($s8)");		// buf
		asm("addiu	$t2, $zero, 255");	// 0xFF
		asm("addiu	$t3, $zero, 1");	// 1

		/* BYTE* e = buf + SECTOR_SIZE; */
		asm("addiu	$t4, $t1, 512");
		/* do */
		asm("read_loop:");
		{
			/* SDC_SPIBUF = 0xFF; */
			asm("sw		$t2, 23584($t0)");
			/* 	while(!SDC_SPISTAT.SPIRBF); */
			asm("wait_loop:");
			asm("lw		$v0, 23568($t0)");
			asm("ext	$v0, $v0, 0, 1");
			asm("beq	$v0, $zero, wait_loop");
			/* *buf = (BYTE)SDC_SPIBUF; */
			asm("lw		$v0, 23584($t0)");
			asm("sb		$v0, 0($t1)");
		}
		/* while (++buf < e); */
		asm("addu	$t1, $t1, $t3");
		asm("sltu	$v0, $t1, $t4");
		asm("bne	$v0, $zero, read_loop");
#else
		BYTE* e = buf + SECTOR_SIZE;
		do {
			SDC_SPIBUF = 0xFF;
			while(!SDC_SPISTAT.SPIRBF);
			*buf = (BYTE)SDC_SPIBUF;
		}
		while (++buf < e);
#endif
		// CRC ǂ
		RecvSPI();
		RecvSPI();
	}

	Clocking8();
	SDC_CS_IO = 1;

	return (nR1 == DATA_START_TOKEN);
}

// ZN^Cg
extern BOOL WriteSDC(DWORD addr, const BYTE* buf)
{
	BYTE nDO;
	const BYTE* e;

	// rW[`FbN
	if (!BusyCheck())
		return FALSE;

	// R}hs
	if (SendCMD(WRITE_SINGLE_BLOCK, addr << s_nMode, NOCRC, TRUE, FALSE) != 0x00)
	{
		SDC_CS_IO = 1;
		return FALSE;
	}

	// g[No
	SendSPI(DATA_START_TOKEN);

	// f[^o
	e = buf + SECTOR_SIZE;
	do {
		unsigned nTemp;
		SDC_SPIBUF = *buf;
		while(!SDC_SPISTAT.SPIRBF);
		nTemp = SDC_SPIBUF;
	}
	while (++buf < e);

	// CRC 󑗏o
	SendSPI(NOCRC);
	SendSPI(NOCRC);

	// X|XmF
	nDO = RecvSPI() & 0x0F;
	if (nDO == DATA_ACCEPTED)
		s_nBusy = TRUE;
        
	Clocking8();
	SDC_CS_IO = 1;

	return (nDO == DATA_ACCEPTED);
}

// 
extern void CloseSDC(void)
{
	// rW[`FbNiȂꍇ͋Ij
	BusyCheck();

	SDC_CS_IO = 1;
	SDC_SPICON.ON = 0;
}

// ݂̏Ԃ擾
extern BOOL IsOpenSDC(void)
{
	return SDC_SPICON.ON;
}

//=================================================================

// SPI
static void InitSPI(void)
{
	ASSERT(!SDC_SPICON.ON);
	ASSERT(GetPeripheralClock() >= 400000 * 2);

	// SPI Mode0 - 400kHz
	SDC_SPICON.FRMEN = 0;
	SDC_SPICON.SIDL = 0;
	SDC_SPICON.DISSDO = 0;
	SDC_SPICON.MODE32 = 0;
	SDC_SPICON.MODE16 = 0;
	SDC_SPICON.SMP = 0;
	SDC_SPICON.CKE = 1;
	SDC_SPICON.SSEN = 0;
	SDC_SPICON.CKP = 0;
	SDC_SPICON.MSTEN = 1;
	SDC_SPIBRG = CALCBRG(400000UL);
	SDC_SPISTAT.SPIROV = 0;
	SDC_SPICON.ON = 1;

	DWORD nTemp = SDC_SPIBUF;
}

// J[hݒ
static BOOL CheckSDC(void)
{
	// ]xto
	SDC_SPICON.ON = 0;
	SDC_SPIBRG = CALCBRG(MAX_SPICLOCK);
	SDC_SPICON.ON = 1;
	
	// AhbVOmF
	if (s_nMode == MODE_HC)
	{
		s_nMode = MODE_NORMAL;
		if (SendCMD(READ_OCR, 0, NOCRC, FALSE, FALSE) == 0x00)
		{
			DWORD nR7 =
				((DWORD)RecvSPI() << 24) |
				((DWORD)RecvSPI() << 16) |
				((DWORD)RecvSPI() <<  8) |
				((DWORD)RecvSPI() <<  0);

			if ((nR7 & 0xC0000000) == 0xC0000000)
				s_nMode = MODE_HC;
		}
		Clocking8();
		SDC_CS_IO = 1;
	}

	// ubNTCYݒ
	if (s_nMode == MODE_NORMAL)
	{
		if (SendCMD(SET_BLOCKLEN, SECTOR_SIZE, NOCRC, TRUE, TRUE) != 0x00)
			return FALSE;
	}

	return TRUE;
}

// rW[`FbN
static BOOL BusyCheck(void)
{
	if (s_nBusy)
	{
		DWORD nCount;
		BYTE nDO;

		SDC_CS_IO = 0;

		nCount = 0xFFFFF;
		do nDO = RecvSPI();
		while (nDO == 0x00 && --nCount > 0);

		Clocking8();
		SDC_CS_IO = 1;

		if (nCount == 0)
			return FALSE;

		s_nBusy = FALSE;
	}

	return TRUE;
}

// R}hM
static BYTE SendCMD(BYTE cmd, DWORD param, BYTE crc, BYTE f1, BYTE f2)
{
	int nCount;
	BYTE nR1;
	    
	SDC_CS_IO = 0;

	// R}hubNM
	SendSPI(cmd);
	SendSPI((BYTE)(param >> 24));
	SendSPI((BYTE)(param >> 16));
	SendSPI((BYTE)(param >> 8));
	SendSPI((BYTE)(param >> 0));
	SendSPI(crc);

	// R1X|XM
	nCount = 8;
	do nR1 = RecvSPI();
	while ((nR1 & 0x80) != 0 && --nCount > 0);
    
	// 㑱
	if (f1) Clocking8();
	if (f2) SDC_CS_IO = 1;

	return (nCount > 0)? nR1 : FLOATING_BUS;
}

// SPIM
static BYTE RecvSPI(void)
{
	SDC_SPIBUF = 0xFF;
	while(!SDC_SPISTAT.SPIRBF);
	return (BYTE)SDC_SPIBUF;
}

// SPIM
static BYTE SendSPI(BYTE data)
{
	SDC_SPIBUF = data;
	while(!SDC_SPISTAT.SPIRBF);
	return (BYTE)SDC_SPIBUF;
}
