/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/
#ifndef _HONEY_SYSTEM_H_
#define _HONEY_SYSTEM_H_

#include "Compiler.h"

// Clock
extern DWORD g_dwSysClock;
#define SYS_CLOCK			g_dwSysClock
#define GetSystemClock()		(SYS_CLOCK)
#define GetInstructionClock()	(GetSystemClock()/1)	// for PIC32
#define GetPeripheralClock()	(GetSystemClock()/1)	// for PIC32

// MRF24WB0M
#define _WF_CS_TRIS			TRISBbits.TRISB15
#define _WF_CS_IO			LATBbits.LATB15
#define _WF_RESET_TRIS		TRISBbits.TRISB8
#define _WF_RESET_IO		LATBbits.LATB8
#define _WF_HIBERNATE_TRIS	TRISBbits.TRISB13
#define _WF_HIBERNATE_IO	LATBbits.LATB13
#define _WF_INT_TRIS		TRISDbits.TRISD8
#define _WF_INT_IO			PORTDbits.RD8	// INT1
#define _WF_INT_EDGE		INTCONbits.INT1EP
#define _WF_INT_IE			IEC0bits.INT1IE
#define _WF_INT_IF			IFS0bits.INT1IF
#define _WF_INT_IE_CLEAR	IEC0CLR
#define _WF_INT_IF_CLEAR	IFS0CLR
#define _WF_INT_IE_SET		IEC0SET
#define _WF_INT_IF_SET		IFS0SET
#define _WF_INT_BIT			_IEC0_INT1IE_MASK
#define _WF_INT_IPCSET		IPC1SET
#define _WF_INT_IPCCLR		IPC1CLR
#define _WF_INT_IPC_MASK	(_IPC1_INT1IP_MASK | _IPC1_INT1IS_MASK)
#define _WF_INT_IPC_VALUE	0x0C000000
#define _WF_SSPBUF			SPI4BUF
#define _WF_SPISTAT			SPI4STAT
#define _WF_SPISTATbits		SPI4STATbits
#define _WF_SPICON1			SPI4CON
#define _WF_SPICON1bits		SPI4CONbits
#define _WF_SPI_IE_CLEAR	IEC1CLR
#define _WF_SPI_IF_CLEAR	IFS1CLR
#define _WF_SPI_INT_BITS	(_IEC1_SPI4EIE_MASK | _IEC1_SPI4RXIE_MASK | _IEC1_SPI4TXIE_MASK)
#define _WF_SPI_BRG			SPI4BRG
#define _WF_MAX_SPI_FREQ	25000000UL // 25MHz

// SDCard
#define SDC_CS_TRIS			TRISBbits.TRISB5
#define SDC_CS_IO			LATBbits.LATB5
#define SDC_SPICON			SPI2CONbits
#define SDC_SPISTAT			SPI2STATbits
#define SDC_SPIBUF			SPI2BUF
#define SDC_SPIBRG			SPI2BRG

// LCD-09052
#define LCD_RS_TRIS			TRISFbits.TRISF1
#define LCD_RS_IO			LATFbits.LATF1
#define LCD_E_TRIS			TRISFbits.TRISF0
#define LCD_E_IO			LATFbits.LATF0
#define LCD_DAT_TRISCLR		TRISECLR
#define LCD_DAT_IOCLR		LATECLR
#define LCD_DAT_IO			LATE
#define LCD_DAT_MASK		0x000F
#define BKLIGHT_TRIS		TRISEbits.TRISE4
#define BKLIGHT_IO			LATEbits.LATE4

// VS1053b
#define DEC_XCS_TRIS		TRISDbits.TRISD4
#define DEC_XCS_IO			LATDbits.LATD4
#define DEC_XDCS_TRIS		TRISDbits.TRISD5
#define DEC_XDCS_IO			LATDbits.LATD5
#define DEC_XRESET_TRIS		TRISDbits.TRISD7
#define DEC_XRESET_IO		LATDbits.LATD7
#define DEC_DREQ_TRIS		TRISDbits.TRISD6
#define DEC_DREQ_IO			PORTDbits.RD6
#define DEC_SPICON			SPI3CONbits
#define DEC_SPISTAT			SPI3STATbits
#define DEC_SPIBUF			SPI3BUF
#define DEC_SPIBRG			SPI3BRG

// TAS5717
#define AMP_RST_TRIS		TRISDbits.TRISD11
#define AMP_RST_IO			LATDbits.LATD11
#define AMP_PDN_TRIS		TRISDbits.TRISD0
#define AMP_PDN_IO			LATDbits.LATD0
#define AMP_I2C				I2C1

// Other ports
#define POWER_TRIS			TRISBbits.TRISB9
#define POWER_IO			LATBbits.LATB9
#define LED_TRIS			TRISEbits.TRISE5
#define LED_IO				LATEbits.LATE5
#define CHARGE_TRIS			TRISBbits.TRISB11
#define CHARGE_IO			LATBbits.LATB11
#define BZ_TRIS				TRISFbits.TRISF3
#define BZ_IO				LATFbits.LATF3
#define BZ_INV				LATFINV
#define BZ_MASK				_LATF_LATF3_MASK
#define POWERSW_TRIS		TRISBbits.TRISB3
#define POWERSW_IO			PORTBbits.RB3
#define POWERSW_CNMASK		_CNEN_CNEN5_MASK
#define ADAPTER_TRIS		TRISBbits.TRISB10
#define ADAPTER_IO			PORTBbits.RB10
#define PHJ_TRIS			TRISCbits.TRISC13
#define PHJ_IO				PORTCbits.RC13
#define PHJ_CNMASK			_CNEN_CNEN1_MASK
#define SW_TRISSET			TRISBSET
#define SW_IO				PORTB
#define SW_IOMASK			(_PORTB_RB0_MASK | _PORTB_RB1_MASK | _PORTB_RB2_MASK)
#define SW_CNMASK			(_CNEN_CNEN2_MASK | _CNEN_CNEN3_MASK | _CNEN_CNEN4_MASK)
#define BATV_TRIS			TRISBbits.TRISB12
#define BATV_PCFG			AD1PCFGbits.PCFG12
#define BATV_AN				12


#endif //_HONEY_SYSTEM_H_
