/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "EEPRom.h"
#include "peripheral\i2c.h"

//=================================================================

#define EEP_PAGE_SIZE	64	// 24FC256(32KB)

//=================================================================

// 
extern BOOL WriteEEP(UINT addr, const BYTE* data, int nLen)
{
	ASSERT(nLen > 0);
	if ((addr + nLen) > EEPROM_SIZE) {
		return FALSE;
	}

	I2C_7_BIT_ADDRESS hdr;
	int a = EEP_PAGE_SIZE - (addr % EEP_PAGE_SIZE);
	int i = 0;

	do {
		int j = 0;

		ASSERT(I2CBusIsIdle(EEP_I2C));
		do {
			// Start conditon
			VERIFY(I2CStart(EEP_I2C) == I2C_SUCCESS);
			while ((I2CGetStatus(EEP_I2C) & I2C_START) == 0);

			// 7bit address & W flag
			I2C_FORMAT_7_BIT_ADDRESS(hdr, EEP_DEV_ADDR, I2C_WRITE);
			ASSERT(I2CTransmitterIsReady(EEP_I2C));
			VERIFY(I2CSendByte(EEP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
			while (!I2CTransmissionHasCompleted(EEP_I2C));
		}
		while (!I2CByteWasAcknowledged(EEP_I2C));

		// address(H)
		ASSERT(I2CTransmitterIsReady(EEP_I2C));
		VERIFY(I2CSendByte(EEP_I2C, HIBYTE(addr)) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(EEP_I2C));
		ASSERT(I2CByteWasAcknowledged(EEP_I2C));

		// address(L)
		ASSERT(I2CTransmitterIsReady(EEP_I2C));
		VERIFY(I2CSendByte(EEP_I2C, LOBYTE(addr)) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(EEP_I2C));
		ASSERT(I2CByteWasAcknowledged(EEP_I2C));

		do {
			// data
			ASSERT(I2CTransmitterIsReady(EEP_I2C));
			VERIFY(I2CSendByte(EEP_I2C, data[i]) == I2C_SUCCESS);
			while (!I2CTransmissionHasCompleted(EEP_I2C));
			ASSERT(I2CByteWasAcknowledged(EEP_I2C));
		}
		while (++i < nLen && ++j < a);

		// Stop condition
		I2CStop(EEP_I2C);
		while ((I2CGetStatus(EEP_I2C) & I2C_STOP) == 0);

		// y[W
		addr += a;
		a = EEP_PAGE_SIZE;
	}
	while (i < nLen);

	return TRUE;
}

// ǂݍ
extern BOOL ReadEEP(UINT addr, BYTE* data, int nLen)
{
	ASSERT(nLen > 0);
	if ((addr + nLen) > EEPROM_SIZE) {
		return FALSE;
	}
	
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	ASSERT(I2CBusIsIdle(EEP_I2C));
	do {
		// Start conditon
		VERIFY(I2CStart(EEP_I2C) == I2C_SUCCESS);
		while ((I2CGetStatus(EEP_I2C) & I2C_START) == 0);

		// 7bit address & W flag
		I2C_FORMAT_7_BIT_ADDRESS(hdr, EEP_DEV_ADDR, I2C_WRITE);
		ASSERT(I2CTransmitterIsReady(EEP_I2C));
		VERIFY(I2CSendByte(EEP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(EEP_I2C));
	}
	while (!I2CByteWasAcknowledged(EEP_I2C));

	// address(H)
	ASSERT(I2CTransmitterIsReady(EEP_I2C));
	VERIFY(I2CSendByte(EEP_I2C, HIBYTE(addr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(EEP_I2C));
	ASSERT(I2CByteWasAcknowledged(EEP_I2C));

	// address(L)
	ASSERT(I2CTransmitterIsReady(EEP_I2C));
	VERIFY(I2CSendByte(EEP_I2C, LOBYTE(addr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(EEP_I2C));
	ASSERT(I2CByteWasAcknowledged(EEP_I2C));

	// Start conditon
	VERIFY(I2CStart(EEP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(EEP_I2C) & I2C_START) == 0);

	// 7bit address & R flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, EEP_DEV_ADDR, I2C_READ);
	ASSERT(I2CTransmitterIsReady(EEP_I2C));
	VERIFY(I2CSendByte(EEP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(EEP_I2C));
	ASSERT(I2CByteWasAcknowledged(EEP_I2C));

	do {
		// data
		ASSERT(!I2CReceivedDataIsAvailable(EEP_I2C));
		VERIFY(I2CReceiverEnable(EEP_I2C, TRUE) == I2C_SUCCESS);
		while (!I2CReceivedDataIsAvailable(EEP_I2C));
		data[i] = I2CGetByte(EEP_I2C);

		// ACK or NAK
		I2CAcknowledgeByte(EEP_I2C, (nLen != ++i));
		while (!I2CAcknowledgeHasCompleted(EEP_I2C));
	}
	while (i < nLen);

	// Stop condition
	I2CStop(EEP_I2C);
	while ((I2CGetStatus(EEP_I2C) & I2C_STOP) == 0);

	return TRUE;
}
