/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Amp.h"
#include "peripheral\i2c.h"

#define MAX_STEP	40
#define DEV_ADDR	(0x36 >> 1)

//=================================================================

static BYTE ToData(int nVol, BOOL fSpeaker);
static void WriteB(BYTE addr, BYTE data);
static void WriteW(BYTE addr, WORD data);
static void WriteD(BYTE addr, DWORD data);
static BYTE ReadB(BYTE addr);
static WORD ReadW(BYTE addr);
static DWORD ReadD(BYTE addr);
static void Write(BYTE addr, BYTE data[], int nLen);
static void Read(BYTE addr, BYTE data[], int nLen); 

//=================================================================

static BOOL s_fEnable = FALSE;
static BOOL s_fSpeaker = TRUE;
static BOOL s_fMute = TRUE;
static BYTE s_nVol = 0;

//=================================================================

// 
extern void InitAmp(void)
{
	// |[g
	AMP_RST_IO = 0;
	AMP_RST_TRIS = OUTPUT;
}

// Ԑݒ
extern void AmpEnable(BOOL fEnable)
{
	if (fEnable != s_fEnable)
	{
		s_fEnable = fEnable;

		if (fEnable)
		{
			ASSERT(!AMP_RST_IO);

			// V[PXɃNbNG[ɂȂĂ͂ȂȂƂ
			// ̂ŁA̎_ŃNbNĂȂ΂ȂȂ
			DelayUS(100);

			AMP_RST_IO = 1;
			DelayMS(14);

			// MeXg˂ăftHglmF
			ASSERT(ReadB(0x00) == 0x6C);
			//ASSERT(ReadB(0x01) == 0x28); // f[^V[glƂ͈قȂ
			ASSERT(ReadB(0x02) == 0x00);
			ASSERT(ReadB(0x03) == 0xA0);
			ASSERT(ReadB(0x04) == 0x05);
			ASSERT(ReadB(0x05) == 0x40);
			ASSERT(ReadB(0x06) == 0x00);
			ASSERT(ReadB(0x07) == 0xFF);
			ASSERT(ReadD(0x20) == 0x0089777A);
			ASSERT(ReadD(0x25) == 0x01021345);

			// Oscillator trim register
			WriteB(0x1B, 0x00);
			DelayMS(50);

			// System Control Register 2FNormal operation
			WriteB(0x05, (s_fSpeaker)? 0x00 : 0x02);

			// ~[g,{[
			WriteB(0x07, (s_fMute)? 0xFF : 0x30);
			WriteB(0x08, ToData(s_nVol, TRUE)); // Channel-1 volume
			WriteB(0x09, ToData(s_nVol, TRUE)); // Channel-2 volume
			WriteB(0x0C, ToData(s_nVol, FALSE)); // Headphone volume

			// G[NA
			WriteB(0x02, 0x00);
		}
		else
		{
			ASSERT(AMP_RST_IO);

			//System Control Register 2FEnter all-channel shutdown (hard mute)
			WriteB(0x05, 0x00);
			DelayMS(10);

			AMP_RST_IO = 0;
		}
	}
}

// Xs[J[[h
extern void SetSpeakerMode(BOOL fOn)
{
	if (s_fSpeaker != fOn)
	{
		// System Control Register 2FNormal operation
		if (s_fEnable) {
			WriteB(0x05, (fOn)? 0x00 : 0x02);
		}
		s_fSpeaker = fOn;
	}
}

// Xs[J[Ԃ̎擾
extern BOOL IsSpeaker(void)
{
	return s_fSpeaker;
}

// ~[g
extern void SetMute(BOOL fMute)
{
	if (s_fMute != fMute)
	{
		// Master volume
		if (s_fEnable) {
			WriteB(0x07, (fMute)? 0xFF : 0x30);
		}
		s_fMute = fMute;
	}
}

// ~[gԂ̎擾
extern BOOL IsMute(void)
{
	return s_fMute;
}

// {[lݒ
extern BOOL SetVolume(int nVol)
{
	if (s_nVol != nVol)
	{
		if (0 <= nVol && nVol <= MAX_STEP)
		{
			s_nVol = nVol;
			if (s_fEnable)
			{
				WriteB(0x08, ToData(s_nVol, TRUE)); // Channel-1 volume
				WriteB(0x09, ToData(s_nVol, TRUE)); // Channel-2 volume
				WriteB(0x0C, ToData(s_nVol, FALSE)); // Headphone volume
			}
			return TRUE;
		}
	}
	return FALSE;
}

// {[l擾
extern int GetVolume(void)
{
	return s_nVol;
}

// Tv[g擾
extern BYTE GetSampleRate(void)
{
	return (ReadB(0x00) >> 5);
}

//=================================================================

// {[WX^l֕ϊ
static BYTE ToData(int nVol, BOOL fSpeaker)
{
	if (fSpeaker)
	{
		#define MIN_VALU_SP		0x3C //  -6.000dB
		#define MAX_VALU_SP		0xD0 // -80.000dB
		#define ADJ_VALU_SP		(MAX_VALU_SP - MIN_VALU_SP)

		return (BYTE)(ADJ_VALU_SP - ((ADJ_VALU_SP * nVol) / MAX_STEP) + MIN_VALU_SP);
	}
	else
	{
		#define MIN_VALU_HP		0x30 //  -0.000dB
		#define MAX_VALU_HP		0xD0 // -80.000dB
		#define ADJ_VALU_HP		(MAX_VALU_HP - MIN_VALU_HP)

		return (BYTE)(ADJ_VALU_HP - ((ADJ_VALU_HP * nVol) / MAX_STEP) + MIN_VALU_HP);
	}
}

// WX^Cg(8Bit)
static void WriteB(BYTE addr, BYTE data)
{
	BYTE temp[1];
	temp[0] = data;
	Write(addr, temp, 1);
}

// WX^Cg(16Bit)
static void WriteW(BYTE addr, WORD data)
{
	BYTE temp[2];
	temp[0] = HIBYTE(data);
	temp[1] = LOBYTE(data);
	Write(addr, temp, 2);
	ASSERT(ReadW(addr) == data);
}

// WX^Cg(32Bit)
static void WriteD(BYTE addr, DWORD data)
{
	BYTE temp[4];
	temp[0] = HIBYTE(HIWORD(data));
	temp[1] = LOBYTE(HIWORD(data));
	temp[2] = HIBYTE(LOWORD(data));
	temp[3] = LOBYTE(LOWORD(data));
	Write(addr, temp, 4);
	ASSERT(ReadD(addr) == data);
}

// WX^[h(8Bit)
static BYTE ReadB(BYTE addr)
{
	BYTE data[1];
	Read(addr, data, 1);
	return data[0];
}

// WX^[h(16Bit)
static WORD ReadW(BYTE addr)
{
	BYTE data[2];
	Read(addr, data, 2);
	return MAKEWORD(data[0], data[1]);
}

// WX^[h(32Bit)
static DWORD ReadD(BYTE addr)
{
	BYTE data[4];
	Read(addr, data, 4);
	return MAKEDWORD(MAKEWORD(data[0], data[1]), MAKEWORD(data[2], data[3]));
}

// WX^Cg
static void Write(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(I2CTransmitterIsReady(AMP_I2C));
		VERIFY(I2CSendByte(AMP_I2C, data[i]) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(AMP_I2C));
		ASSERT(I2CByteWasAcknowledged(AMP_I2C));
	}
	while (++i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}

// WX^[h
static void Read(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// Repeat condition
	VERIFY(I2CRepeatStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & R flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_READ);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(!I2CReceivedDataIsAvailable(AMP_I2C));
		VERIFY(I2CReceiverEnable(AMP_I2C, TRUE) == I2C_SUCCESS);
		while (!I2CReceivedDataIsAvailable(AMP_I2C));
		data[i] = I2CGetByte(AMP_I2C);

		// ACK or NAK
		I2CAcknowledgeByte(AMP_I2C, (nLen != ++i));
		while (!I2CAcknowledgeHasCompleted(AMP_I2C));
	}
	while (i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}
