/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Selector.h"

//=================================================================

static int s_nSrc = SRC_DECODER;

//=================================================================

// 
extern void InitSelector(void)
{
	// |[g
	DIR_RST_IO = 0;
	DIR_RST_TRIS = OUTPUT;
	DIR_ERR_TRIS = INPUT;

	I2S_SEL_IO = 1;
	I2S_SEL_TRIS = OUTPUT;

	SPDIF_SEL0_IO = 0;
	SPDIF_SEL0_TRIS = OUTPUT;
	SPDIF_SEL1_IO = 0;
	SPDIF_SEL1_TRIS = OUTPUT;
}

// ̓\[XI
extern void SlectSource(int nSrc)
{
	if (s_nSrc != nSrc)
	{
		switch (nSrc)
		{
		case SRC_DECODER:
			I2S_SEL_IO = 1;
			DIR_RST_IO = 0;
			SPDIF_SEL0_IO = 0;
			SPDIF_SEL1_IO = 0;
			break;

		case SRC_DIGITAL1:
			SPDIF_SEL0_IO = 1;
			SPDIF_SEL1_IO = 1;
			DIR_RST_IO = 1;
			I2S_SEL_IO = 0;
			break;

		case SRC_DIGITAL2:
			SPDIF_SEL0_IO = 0;
			SPDIF_SEL1_IO = 1;
			DIR_RST_IO = 1;
			I2S_SEL_IO = 0;
			break;

		case SRC_USBAUDIO:
			SPDIF_SEL0_IO = 1;
			SPDIF_SEL1_IO = 0;
			DIR_RST_IO = 1;
			I2S_SEL_IO = 0;
			break;

		default:
			ASSERT(FALSE);
			return;
		}
		s_nSrc = nSrc;
		DelayMS(1);
	}
}

// ݂̓̓\[X擾
extern int GetSource(void)
{
	return s_nSrc;
}

// G[Ԏ擾
extern BOOL IsDIRError(void)
{
	ASSERT(DIR_RST_IO);
	return DIR_ERR_IO;
}
