/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include <pic.h>
#include "GenericTypeDefs.h"

//=================================================================

#define LED			LATA2
#define SSR			LATC3
#define IRIN		RC2
#define GetRE()		((PORTC >> 4) & 0x03)

#define IR_HI		(!IRIN)
#define IR_LO		(IRIN)

#define DEV_ADDR	0x77

#define KEY_NONE	0x00
#define KEY_POWER	0x01
#define KEY_BTN1	0x02
#define KEY_BTN2	0x03
#define KEY_VUP		0x04
#define KEY_VDN		0x05
#define KEY_PREV	0x06
#define KEY_NEXT	0x07
#define REP_FLAG	0x80

#define CMD_NONE	0x00
#define CMD_POFF	0x01

#define VOLINT_MIN	25
#define VOLINT_MAX	100

#define REMOCON		0x3B86 // JX^R[h
#define REPEAT		3

#define MARGIN	0.25
#define READER1_S	((9.00 - MARGIN) * 4)
#define READER1_L	((9.00 + MARGIN) * 4)
#define READER2_S	((4.50 - MARGIN) * 4)
#define READER2_L	((4.50 + MARGIN) * 4)
#define REPEAT_S	((2.25 - MARGIN) * 4)
#define REPEAT_L	((2.25 + MARGIN) * 4)
#define DATBIT_S	((0.50 - MARGIN) * 4)
#define DATBIT_L	((0.50 + MARGIN) * 4)
#define LODAT_S		((1.00 - MARGIN) * 4)
#define LODAT_L		((1.25 + MARGIN) * 4)
#define HIDAT_S		((2.25 - MARGIN) * 4)
#define HIDAT_L		((2.25 + MARGIN) * 4)

//=================================================================

static BYTE s_nRecv = CMD_NONE;
static BYTE s_nSend = KEY_NONE;
static BYTE s_nRem = KEY_NONE;
static WORD s_wTick1 = 0;
static WORD s_wTick2 = 0;
static WORD s_wLast1 = 0;
static WORD s_wLast2 = 0;
static WORD s_wLast3 = 0;
static WORD s_wPoffm;
static BYTE s_nOldRE;
static BYTE s_nNewRE;
static BYTE s_nRECnt;

//=================================================================

static void InitSystem(void);
static void Run(void);
static void DetectRE(void);
static void DetectIR(void);
static BYTE ToKey(BYTE code);
static WORD GetElapsed1(WORD wBase);
static WORD GetElapsed2(WORD wBase);

//=================================================================

// CGg
void main(void)
{
	InitSystem();
	Run();
}

//	VXe
static void InitSystem(void)
{
	// |[g
	PORTA = 0x00;
	LATA = 0x00;
	ANSELA = 0x00;
	WPUA = 0b11111011;
	TRISA = 0b11111011;

	PORTC = 0x00;
	LATC = 0x00;
	ANSELC = 0x00;
	WPUC = 0b11110111;
	TRISC = 0b11110111;

	nWPUEN = 0;

	// Timer0 (TickJE^p)
	OPTION_REGbits.PS = 0b010; // 1:8 (0.25ms)
	PSA = 0;
	TMR0CS = 0;
	TMR0 = 0;
	TMR0IE = 1;
	
	// Timer2 (RE`^Op)
	T2CON = 0b00000011; // Prescaler is 64 (125KHz)
	PR2 = 0xFF; // 2ms
	
	// I2C
	SSP1ADD = DEV_ADDR << 1;
	SSP1MSK = 0b11111110;
	SSP1STAT= 0b00000000;
	GCEN = 0;
	SEN = 1;
	SSP1CON1 = 0b00110110;
	SSP1IF = 0;
	SSP1IE = 1;

	// ݋
	PEIE = 1;
	GIE = 1;
}

// s[v
static void Run(void)
{
#ifndef __DEBUG
	SWDTEN = 1;
#endif
	
	s_nOldRE = GetRE();
	s_nNewRE = s_nOldRE;
	s_nRECnt = 128;

	LED = 1;
	for (;;)
	{
		DetectRE();
		DetectIR();

		// PowerOFF
		if (s_nRecv == CMD_POFF)
		{
			SSR = 0;

			// Sɓd܂ő҂
			WORD wDelay = s_wTick2;
			while(GetElapsed2(wDelay) < 1000);

			s_nSend = KEY_NONE;
			s_nRecv = CMD_NONE;
			s_nRem = KEY_NONE;
			s_wLast3 = 0;
		}

		CLRWDT();
	}
}

// REo
static void DetectRE(void)
{
	// pXωo
	BYTE nCur = GetRE();
	if (nCur != s_nNewRE)
	{
		s_nNewRE = nCur;
		TMR2ON = 0;
		TMR2 = 0;
		TMR2IF = 0;
		TMR2IE = 1;
		TMR2ON = 1;
		s_wLast1 = s_wTick2;
	}
	else if (GetElapsed2(s_wLast1) >= VOLINT_MAX) {
		s_nRECnt = 128;
	}

	// 莞{[_EœdOFF
	if (s_wLast3 != 0)
	{
		if (GetElapsed2(s_wLast3) >= 100) {
			s_wLast3 = 0;
		}
		else if (GetElapsed2(s_wPoffm) >= 500)
		{
			s_nSend = KEY_POWER;
			s_wLast3 = 0;
		}
	}
}

// IRo
static void DetectIR(void)
{
	static BYTE s_nState = 0;
	static WORD s_wStart;
	static WORD s_wCst;
	static BYTE s_bDat;
	static BYTE s_nDat;
	static BYTE s_nBit;
	static WORD s_wClr = 0;
	static int s_nRep;

	// IRo
	switch (s_nState)
	{
	case 0:
		// [_[R[hJno
		if (IR_HI)
		{
			s_wStart = s_wTick1;
			s_nState++;
		}
		break;

	case 1:
		// [_[R[hIo1
		if (IR_LO)
		{
			if (GetElapsed1(s_wStart) >= READER1_S)
			{
				s_wStart = s_wTick1;
				s_nState++;
			}
		}
		else
		{
			if (GetElapsed1(s_wStart) > READER1_L) {
				s_nState = 0;
			}
		}
		break;

	case 2:
		// [_[R[hIo2
		if (IR_HI)
		{
			WORD w = GetElapsed1(s_wStart);
			if ((REPEAT_S <= w) && (w <= REPEAT_L))
			{
				// s[gR[ho!
				if (s_nRem != KEY_NONE)
				{
					if (s_nRep >= REPEAT) {
						s_nSend = REP_FLAG | s_nRem;
					}
					else {
						s_nRep++;
					}
					s_wClr = s_wTick2;
				}
			}
			else if (GetElapsed1(s_wStart) >= READER2_S)
			{
				// [_[R[ho!
				s_wCst = s_bDat = s_nDat = s_nBit = 0;
				s_wStart = s_wTick1;
				s_nState++;
				break;
			}
			s_nState = 0;
		}
		else
		{
			if (GetElapsed1(s_wStart) > READER2_L) {
				s_nState = 0;
			}
		}
		break;

	case 3:
		// rbgo1
		if (IR_LO)
		{
			if (GetElapsed1(s_wStart) >= DATBIT_S) {
				s_nState++;
			}
		}
		else
		{
			if (GetElapsed1(s_wStart) > DATBIT_L) {
				s_nState = 0;
			}
		}
		break;

	case 4:
		// rbgo2
		if (IR_HI)
		{
			BYTE b;
			WORD w = GetElapsed1(s_wStart);
			if ((LODAT_S <= w) && (w <= LODAT_L))
			{
				// '0'o!
				b = 0x00;
			}
			else if (GetElapsed1(s_wStart) >= HIDAT_S)
			{
				// '1'o!
				b = 0x80;
			}
			else
			{
				s_nState = 0;
				break;
			}
			if (s_nBit < 16)
			{
				// JX^R[h
				s_wCst >>= 1;
				s_wCst |= (WORD)b << 8;
			}
			else if (s_nBit < 24)
			{
				// f[^R[h
				s_bDat >>= 1;
				s_bDat |= b;
			}
			else if (s_nBit < 32)
			{
				// f[^R[h(])
				s_nDat >>= 1;
				s_nDat |= b;
			}
			if (++s_nBit == 32)
			{
				// I
				if (s_wCst == REMOCON)
				{
					if (s_bDat == (BYTE)~s_nDat)
					{
						s_nRem = ToKey(s_bDat);
						s_wClr = s_wTick2;
						if (!SSR)
						{
							if (s_nRem == KEY_POWER)
							{
								SSR = 1; // PowerON
								s_wLast3 = 0;
							}
							s_nRem = KEY_NONE;
						}
						else if (s_nRem != KEY_NONE) {
							s_nSend = s_nRem;
						}
					}
					else {
						s_nRem = KEY_NONE;
					}
					s_nRep = 0;
				}
				s_nState = 0;
			}
			else
			{
				s_wStart = s_wTick1;
				s_nState--;
			}
		}
		else
		{
			if (GetElapsed1(s_wStart) > HIDAT_L) {
				s_nState = 0;
			}
		}
		break;
	}

	// ԌoߌێĂ郊RR[hNA
	if (s_nRem != KEY_NONE && GetElapsed2(s_wClr) >= 500) {
		s_nRem = KEY_NONE;
	}
}

// RR[hL[R[h֕ϊ
static BYTE ToKey(BYTE code)
{
	switch (code)
	{
	case 0x01: return KEY_POWER;
	case 0x02: return KEY_PREV;
	case 0x03: return KEY_NEXT;
	case 0x05: return KEY_VUP;
	case 0x04: return KEY_VDN;
	}
	return KEY_NONE;
}

// oߎԂ擾(0.25msP)
static WORD GetElapsed1(WORD wBase)
{
	WORD wTick = s_wTick1;
	if (wTick >= wBase) {
		return (wTick - wBase);
	}
	else {
		return ((65535 - (wBase - wTick)) + 1);
	}
}

// oߎԂ擾(1msP)
static WORD GetElapsed2(WORD wBase)
{
	WORD wTick = s_wTick2;
	if (wTick >= wBase) {
		return (wTick - wBase);
	}
	else {
		return ((65535 - (wBase - wTick)) + 1);
	}
}

// 
void interrupt Interrupt(void)
{
	if (TMR0IF)
	{
		// TickJE^
		s_wTick1++; // 0.25msP
		if ((s_wTick1 & 3) == 0) {
			if (++s_wTick2 == 0) { // 1msP
				s_wTick2 = 1; // 0ɂȂȂ悤ɂ
			}
		}
		TMR0IF = 0;
	}
	else if (SSP1IF)
	{
		// I2CʐM
		BYTE temp;

		// D/A,R/W,BFrbg𒲍
		switch (SSP1STAT & 0b00100101)
		{
		case 0b00000101:
			// AhX(D/A=0) }X^[֑M(R/W=1) f[^(BF=1)
			temp = SSP1BUF; // ǂ
			SSP1BUF = s_nSend;
			s_nSend = KEY_NONE;
			CKP = 1;
			break;

		case 0b00100001:
			// f[^(D/A=1) }X^[M(R/W=0) f[^(BF=1)
			s_nRecv = SSP1BUF;
			CKP = 1;
			break;

		default:
			temp = SSP1BUF;
			CKP = 1;
			break;
		}

		SSP1IF = 0;
	}
	else if (TMR2IF)
	{
		// [^[GR[_
		if (s_nOldRE != s_nNewRE)
		{
			if (((s_nOldRE << 1) + s_nNewRE) & 0x02) // H
			{
				// v(VUP)
				if (++s_nRECnt >= (128 + 4))
				{
					if (SSR)
					{
						if (GetElapsed2(s_wLast2) >= VOLINT_MIN)
						{
							s_nSend = KEY_VUP;
							s_wLast2 = s_wTick2;
							s_nRECnt = 128;
						}
					}
					else
					{
						SSR = 1; // PowerON
						s_nRECnt = 128;
					}

					s_wLast3 = 0;
				}
			}
			else
			{
				// v(VDN)
				if (--s_nRECnt <= (128 - 4))
				{
					if (SSR)
					{
						if (GetElapsed2(s_wLast2) >= VOLINT_MIN)
						{
							s_nSend = KEY_VDN;
							s_wLast2 = s_wTick2;
							s_nRECnt = 128;
						}

						if (s_wLast3 == 0) {
							s_wPoffm = s_wTick2;							
						}
						s_wLast3 = s_wTick2;
					}
				}
			}
			s_nOldRE = s_nNewRE;
		}
		TMR2ON = 0;
		TMR2IE = 0;
		TMR2IF = 0;
	}
}
