/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Amp.h"
#include "peripheral\i2c.h"

#define MAX_STEP	40
#define DEV_ADDR	(0xDA >> 1)

//=================================================================

static BYTE ToData(int nVol);
static void WriteB(BYTE addr, BYTE data);
static void WriteW(BYTE addr, WORD data);
static void WriteD(BYTE addr, DWORD data);
static BYTE ReadB(BYTE addr);
static WORD ReadW(BYTE addr);
static DWORD ReadD(BYTE addr);
static void Write(BYTE addr, BYTE data[], int nLen);
static void Read(BYTE addr, BYTE data[], int nLen); 

//=================================================================

static BOOL s_fEnable = FALSE;
static BOOL s_fMute = TRUE;
static BYTE s_nVol = 0;

//=================================================================

// 
extern void InitAmp(void)
{
	// |[g
	AMP_SPKSD_IO = 0;
	AMP_SPKSD_TRIS = OUTPUT;
}

// Ԑݒ
extern void AmpEnable(BOOL fEnable)
{
	if (fEnable != s_fEnable)
	{
		s_fEnable = fEnable;

		if (fEnable)
		{
			ASSERT(!AMP_SPKSD_IO);

			// MeXg˂ăftHglmF
			//ASSERT(ReadB(0x00) == 0x00);
			//ASSERT(ReadB(0x01) == 0xFD);
			//ASSERT(ReadB(0x02) == 0x14);
			//ASSERT(ReadB(0x03) == 0x80);
			//ASSERT(ReadB(0x04) == 0xCF);
			//ASSERT(ReadB(0x05) == 0xCF);
			//ASSERT(ReadB(0x06) == 0x51);
			//ASSERT(ReadB(0x07) == 0x00);
			//ASSERT(ReadB(0x10) == 0xFF);
			//ASSERT(ReadB(0x11) == 0xFC);

			// ~[g
			WriteB(0x03, 0x83);
			s_fMute = TRUE;

			// ftHglŏ
			WriteB(0x01, 0xFD);
			WriteB(0x06, 0x51);
			WriteB(0x07, 0x00);
			WriteB(0x10, 0xFF);
			WriteB(0x11, 0xFC);

			// Digital Boost yуTv[gݒ(VS1063ał96KHzo͂悤ɂĂ)
			// Serial Audio Port will accept double speed sample rates (that is 64kHz, 88.2kHz, 96kHz)
			//WriteB(0x02, 0x0C); // +0 dB is added to the signal in the digital path
			WriteB(0x02, 0x1C); // +6 dB is added to the signal in the digital path
			//WriteB(0x02, 0x2C); // +12dB is added to the signal in the digital path

			// {[
			BYTE nVal = ToData(0);
			WriteB(0x04, nVal); // Left Channel Volume
			WriteB(0x05, nVal); // Right Channel Volume
			s_nVol = 0;

			// G[NA
			WriteB(0x08, 0x00);

			AMP_SPKSD_IO = 1;
		}
		else
		{
			ASSERT(AMP_SPKSD_IO);

			WriteD(0x03, 0x83);

			AMP_SPKSD_IO = 0;
		}
	}
}

// ~[g
extern void SetMute(BOOL fMute)
{
	if (s_fMute != fMute)
	{
		if (s_fEnable) {
			WriteB(0x03, (fMute)? 0x83 : 0x80);
		}

		s_fMute = fMute;
	}
}

// ~[gԂ̎擾
extern BOOL IsMute(void)
{
	return s_fMute;
}

// {[lݒ
extern BOOL SetVolume(int nVol)
{
	if (s_nVol != nVol)
	{
		if (0 <= nVol && nVol <= MAX_STEP)
		{
			s_nVol = nVol;
			if (s_fEnable)
			{
				BYTE nVal = ToData(s_nVol);
				WriteB(0x04, nVal); // Left Channel Volume
				WriteB(0x05, nVal); // Right Channel Volume
			}
			return TRUE;
		}
	}
	return FALSE;
}

// {[l擾
extern int GetVolume(void)
{
	return s_nVol;
}

// G[Xe[^X擾
extern BYTE GetErrorState(void)
{
	BYTE nStat = ReadB(0x08);
	if (nStat != 0) {
		WriteB(0x08, 0);
	}
	return nStat;
}

//=================================================================

// {[WX^l֕ϊ
static BYTE ToData(int nVol)
{
	#define MAX_VALU_SP		0xCF //   -0.000dB
	#define MIN_VALU_SP		0x39 //  -75.000dB
	//#define MIN_VALU_SP	0x07 // -100.000dB
	#define ADJ_VALU_SP		(MAX_VALU_SP - MIN_VALU_SP)

	return (BYTE)(((ADJ_VALU_SP * nVol) / MAX_STEP) + MIN_VALU_SP);
}

// WX^Cg(8Bit)
static void WriteB(BYTE addr, BYTE data)
{
	BYTE temp[1];
	temp[0] = data;
	Write(addr, temp, 1);
	//ASSERT(ReadB(addr) == data);
}

// WX^Cg(16Bit)
static void WriteW(BYTE addr, WORD data)
{
	BYTE temp[2];
	temp[0] = HIBYTE(data);
	temp[1] = LOBYTE(data);
	Write(addr, temp, 2);
	ASSERT(ReadW(addr) == data);
}

// WX^Cg(32Bit)
static void WriteD(BYTE addr, DWORD data)
{
	BYTE temp[4];
	temp[0] = HIBYTE(HIWORD(data));
	temp[1] = LOBYTE(HIWORD(data));
	temp[2] = HIBYTE(LOWORD(data));
	temp[3] = LOBYTE(LOWORD(data));
	Write(addr, temp, 4);
	ASSERT(ReadD(addr) == data);
}

// WX^[h(8Bit)
static BYTE ReadB(BYTE addr)
{
	BYTE data[1];
	Read(addr, data, 1);
	return data[0];
}

// WX^[h(16Bit)
static WORD ReadW(BYTE addr)
{
	BYTE data[2];
	Read(addr, data, 2);
	return MAKEWORD(data[0], data[1]);
}

// WX^[h(32Bit)
static DWORD ReadD(BYTE addr)
{
	BYTE data[4];
	Read(addr, data, 4);
	return MAKEDWORD(MAKEWORD(data[0], data[1]), MAKEWORD(data[2], data[3]));
}

// WX^Cg
static void Write(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(I2CTransmitterIsReady(AMP_I2C));
		VERIFY(I2CSendByte(AMP_I2C, data[i]) == I2C_SUCCESS);
		while (!I2CTransmissionHasCompleted(AMP_I2C));
		ASSERT(I2CByteWasAcknowledged(AMP_I2C));
	}
	while (++i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}

// WX^[h
static void Read(BYTE addr, BYTE data[], int nLen)
{
	I2C_7_BIT_ADDRESS hdr;
	int i = 0;

	// Start conditon
	ASSERT(I2CBusIsIdle(AMP_I2C));
	VERIFY(I2CStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// subaddress
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, addr) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	// Repeat condition
	VERIFY(I2CRepeatStart(AMP_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(AMP_I2C) & I2C_START) == 0);

	// 7bit address & R flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, DEV_ADDR, I2C_READ);
	ASSERT(I2CTransmitterIsReady(AMP_I2C));
	VERIFY(I2CSendByte(AMP_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(AMP_I2C));
	ASSERT(I2CByteWasAcknowledged(AMP_I2C));

	do {
		// data
		ASSERT(!I2CReceivedDataIsAvailable(AMP_I2C));
		VERIFY(I2CReceiverEnable(AMP_I2C, TRUE) == I2C_SUCCESS);
		while (!I2CReceivedDataIsAvailable(AMP_I2C));
		data[i] = I2CGetByte(AMP_I2C);

		// ACK or NAK
		I2CAcknowledgeByte(AMP_I2C, (nLen != ++i));
		while (!I2CAcknowledgeHasCompleted(AMP_I2C));
	}
	while (i < nLen);

	// Stop condition
	I2CStop(AMP_I2C);
	while ((I2CGetStatus(AMP_I2C) & I2C_STOP) == 0);
}
