/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "Compiler.h"
#include "GenericTypeDefs.h"
#include "HoneySystem.h"

// Macros
#define OUTPUT			0
#define INPUT			1

#define MAKEBYTE(h, l)	(((0x0F & (h)) << 4) | (0x0F & (l)))
#define LOBYTE(x)		((x) & 0xFF)
#define HIBYTE(x)		(((x) >> 8) & 0xFF)
#define MAKEWORD(h, l)	(((WORD)(h) << 8) | (WORD)l)
#define LOWORD(x)		((x) & 0xFFFF)
#define HIWORD(x)		(((x) >> 16) & 0xFFFF)
#define MAKEDWORD(h, l)	(((DWORD)(h) << 16) | (DWORD)l)

#include "TCPIP Stack/Tick.h"
#define TICKS_OF(s)		(TICK_SECOND * (s))
#define TICKS_OFMS(ms)	((TICK_SECOND * (ms)) / 1000)

#define CLK_80MHz		80000000UL
#define CLK_40MHz		40000000UL
#define CLK_20MHz		20000000UL
#define CLK_10MHz		10000000UL
#define CLK_8MHz		8000000UL
#define CLK_5MHz		5000000UL
#define CLK_2MHz		2500000UL
#define CLK_1MHz		1250000UL
#define CLK_32KHz		32768UL

#define OFFSET_DATA		0
#define MAX_DATA		1024
#define OFFSET_FILE		MAX_DATA
#define MAX_FILE		(EEPROM_SIZE - OFFSET_FILE)
#define FILE0_VALID		0x01234567UL
#define FILE1_VALID		0x12345678UL
#define DRV_USB			0

#define CMD_NONE		0
#define CMD_POFF		1
#define CMD_PMODE		2
#define CMD_NMODE		3
#define CMD_VUP			4
#define CMD_VDN			5
#define CMD_PREV		6
#define CMD_NEXT		7
#define CMD_ENTER		8

// Functions
extern int GetCommand(void);
extern BOOL GetRepeat(void);
extern void SetClock(DWORD dwClock);
extern void Beep(int nFreq, int nTime, BOOL fWait);
extern void DelayMS(DWORD dwMs);
extern void DelayUS(DWORD dwUs);
extern DWORD CalcSpiBRG(DWORD dwHz);

// Setting library
typedef struct _sfile_t {
	DWORD dwMarking;
	WORD wDataSize;
} sfile_t;

typedef struct _setting_t {
	WORD size;
	WORD fp;
	char buf[128];
	const char* Str;
	int Num;
	BYTE Addr[6];
} setting_t;

extern BOOL InitSettings(setting_t* pObj);
extern BOOL ReadSettingStr(setting_t* pObj, const char* pKey);
extern BOOL ReadSettingNum(setting_t* pObj, const char* pKey);
extern BOOL ReadSettingAddr(setting_t* pObj, const char* pKey, BYTE nRadix);
extern void LoadData(void);
extern void SaveData(void);

// Application data
#define FNAME_LEN		13
typedef struct _datas_t {
	DWORD dwMarking;
	BYTE nLastMode;
	BYTE nLastVolume;
	BYTE nLastNrChan;
	char LastDir[FNAME_LEN];
	char LastFile[FNAME_LEN];
	char Passphrase[64];
	BYTE SecurityKey[64];
} datas_t;
extern datas_t g_Data;

// Global buffer
#define BUFFER_SIZE		(104 * 1024UL)
extern BYTE g_Buffer[BUFFER_SIZE];

// Debug
extern void OutputLog(const char* pLog);

#define DISP_LOG
#ifdef DISP_LOG
#define	LOG(x)	OutputLog(x)
#else
#define	LOG(x)
#endif

#ifdef __DEBUG
extern void _Assert(BOOL cond, const char* msg, int line);
#define ASSERT(x)	_Assert(x, __FUNCTION__, __LINE__)
#define VERIFY(x)	ASSERT(x)
#else
#define ASSERT(x)
#define VERIFY(x)	(void)(x)
#endif


#endif //_MAIN_H_
