/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "SubMpu.h"
#include "peripheral\i2c.h"

//=================================================================

// R}hM
extern BYTE RecvSubMpu(void)
{
	I2C_7_BIT_ADDRESS hdr;
	BYTE data;

	// Start conditon
	ASSERT(I2CBusIsIdle(SUBMPU_I2C));
	VERIFY(I2CStart(SUBMPU_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(SUBMPU_I2C) & I2C_START) == 0);

	// 7bit address & R flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, SUBMPU_DEV_ADDR, I2C_READ);
	ASSERT(I2CTransmitterIsReady(SUBMPU_I2C));
	VERIFY(I2CSendByte(SUBMPU_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(SUBMPU_I2C));
	ASSERT(I2CByteWasAcknowledged(SUBMPU_I2C));

	// data
	ASSERT(!I2CReceivedDataIsAvailable(SUBMPU_I2C));
	VERIFY(I2CReceiverEnable(SUBMPU_I2C, TRUE) == I2C_SUCCESS);
	while (!I2CReceivedDataIsAvailable(SUBMPU_I2C));
	data = I2CGetByte(SUBMPU_I2C);

	// NACK
	I2CAcknowledgeByte(SUBMPU_I2C, FALSE);
	while (!I2CAcknowledgeHasCompleted(SUBMPU_I2C));

	// Stop condition
	I2CStop(SUBMPU_I2C);
	while ((I2CGetStatus(SUBMPU_I2C) & I2C_STOP) == 0);

	return data;
}

// R}hM
extern void SendSubMpu(BYTE cmd)
{
	I2C_7_BIT_ADDRESS hdr;

	// Start conditon
	ASSERT(I2CBusIsIdle(SUBMPU_I2C));
	VERIFY(I2CStart(SUBMPU_I2C) == I2C_SUCCESS);
	while ((I2CGetStatus(SUBMPU_I2C) & I2C_START) == 0);

	// 7bit address & W flag
	I2C_FORMAT_7_BIT_ADDRESS(hdr, SUBMPU_DEV_ADDR, I2C_WRITE);
	ASSERT(I2CTransmitterIsReady(SUBMPU_I2C));
	VERIFY(I2CSendByte(SUBMPU_I2C, I2C_GET_7_BIT_ADDRESS_BYTE(hdr)) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(SUBMPU_I2C));
	ASSERT(I2CByteWasAcknowledged(SUBMPU_I2C));

	// data
	ASSERT(I2CTransmitterIsReady(SUBMPU_I2C));
	VERIFY(I2CSendByte(SUBMPU_I2C, cmd) == I2C_SUCCESS);
	while (!I2CTransmissionHasCompleted(SUBMPU_I2C));
	ASSERT(I2CByteWasAcknowledged(SUBMPU_I2C));

	// Stop condition
	I2CStop(SUBMPU_I2C);
	while ((I2CGetStatus(SUBMPU_I2C) & I2C_STOP) == 0);
}
