/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/
#ifndef _HONEY_SYSTEM_H_
#define _HONEY_SYSTEM_H_

#include "Compiler.h"

// Clock
extern DWORD g_dwSysClock;
#define SYS_CLOCK				g_dwSysClock
#define GetSystemClock()		(SYS_CLOCK)
#define GetInstructionClock()	(GetSystemClock()/1)	// for PIC32
#define GetPeripheralClock()	(GetSystemClock()/1)	// for PIC32

// MRF24WG0MB
#define MRF24WG
#define _WF_CS_TRIS			TRISBbits.TRISB8
#define _WF_CS_IO			LATBbits.LATB8
#define _WF_RESET_TRIS		TRISBbits.TRISB10
#define _WF_RESET_IO		LATBbits.LATB10
#define _WF_HIBERNATE_TRIS	TRISBbits.TRISB9
#define _WF_HIBERNATE_IO	LATBbits.LATB9
#define _WF_INT_TRIS		TRISDbits.TRISD8
#define _WF_INT_IO			PORTDbits.RD8	// INT1
#define _WF_INT_EDGE		INTCONbits.INT1EP
#define _WF_INT_IE			IEC0bits.INT1IE
#define _WF_INT_IF			IFS0bits.INT1IF
#define _WF_INT_IE_CLEAR	IEC0CLR
#define _WF_INT_IF_CLEAR	IFS0CLR
#define _WF_INT_IE_SET		IEC0SET
#define _WF_INT_IF_SET		IFS0SET
#define _WF_INT_BIT			_IEC0_INT1IE_MASK
#define _WF_INT_IPCSET		IPC1SET
#define _WF_INT_IPCCLR		IPC1CLR
#define _WF_INT_IPC_MASK	(_IPC1_INT1IP_MASK | _IPC1_INT1IS_MASK)
#define _WF_INT_IPC_VALUE	0x0C000000
#define _WF_SSPBUF			SPI4BUF
#define _WF_SPISTAT			SPI4STAT
#define _WF_SPISTATbits		SPI4STATbits
#define _WF_SPICON1			SPI4CON
#define _WF_SPICON1bits		SPI4CONbits
#define _WF_SPI_IE_CLEAR	IEC1CLR
#define _WF_SPI_IF_CLEAR	IFS1CLR
#define _WF_SPI_INT_BITS	(_IEC1_SPI4EIE_MASK | _IEC1_SPI4RXIE_MASK | _IEC1_SPI4TXIE_MASK)
#define _WF_SPI_BRG			SPI4BRG
#define _WF_MAX_SPI_FREQ	20000000UL // 20MHz

// 24FC256
#define EEP_I2C				I2C1
#define EEP_DEV_ADDR		0x50

// SUB MPU(PIC16F1823)
#define SUBMPU_I2C			I2C4
#define SUBMPU_DEV_ADDR		0x77

// WEH001602AWPP5N00000
#define LCD_RS_TRIS			TRISFbits.TRISF1
#define LCD_RS_IO			LATFbits.LATF1
#define LCD_E_TRIS			TRISFbits.TRISF0
#define LCD_E_IO			LATFbits.LATF0
#define LCD_DAT_TRISCLR		TRISECLR
#define LCD_DAT_IOCLR		LATECLR
#define LCD_DAT_IO			LATE
#define LCD_DAT_MASK		0x00FF

// VS1063a
#define DEC_XCS_TRIS		TRISDbits.TRISD4
#define DEC_XCS_IO			LATDbits.LATD4
#define DEC_XDCS_TRIS		TRISDbits.TRISD5
#define DEC_XDCS_IO			LATDbits.LATD5
#define DEC_XRESET_TRIS		TRISDbits.TRISD7
#define DEC_XRESET_IO		LATDbits.LATD7
#define DEC_DREQ_TRIS		TRISDbits.TRISD6
#define DEC_DREQ_IO			PORTDbits.RD6
#define DEC_SPICON			SPI3CONbits
#define DEC_SPISTAT			SPI3STATbits
#define DEC_SPIBUF			SPI3BUF
#define DEC_SPIBRG			SPI3BRG

// TAS560L
#define AMP_SPKSD_TRIS		TRISDbits.TRISD11
#define AMP_SPKSD_IO		LATDbits.LATD11
#define AMP_I2C				I2C1

// Other ports
#define LED_TRIS			TRISBbits.TRISB4
#define LED_IO				LATBbits.LATB4

#define BZ_TRIS				TRISGbits.TRISG9
#define BZ_IO				LATGbits.LATG9
#define BZ_INV				LATGINV
#define BZ_MASK				_LATG_LATG9_MASK


#endif //_HONEY_SYSTEM_H_
