/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "TCPIP Stack/FTP.h"
#include "TCPIP Stack/TCPIP.h"

//=================================================================

// FTPR}h(RFC959, RFC1123, RFC1639, RFC2228, RFC2389, RFC2428, RFC2640, RFC3659)
typedef enum _FTPCMD
{
	FCMD_USER,	FCMD_PASS,	FCMD_ACCT,	FCMD_CWD,
	FCMD_CDUP,	FCMD_SMNT,	FCMD_QUIT,	FCMD_REIN,
	FCMD_PORT,	FCMD_PASV,	FCMD_TYPE,	FCMD_STRU,
	FCMD_MODE,	FCMD_RETR,	FCMD_STOR,	FCMD_STOU,
	FCMD_APPE,	FCMD_ALLO,	FCMD_REST,	FCMD_RNFR,
	FCMD_RNTO,	FCMD_ABOR,	FCMD_DELE,	FCMD_RMD,
	FCMD_MKD,	FCMD_PWD,	FCMD_LIST,	FCMD_NLST,
	FCMD_SITE,	FCMD_SYST,	FCMD_STAT,	FCMD_HELP,
	FCMD_NOOP,	FCMD_XMKD,	FCMD_XRMD,	FCMD_XPWD,
	FCMD_XCUP,	FCMD_XCWD,	FCMD_LPRT,	FCMD_LPSV,
	FCMD_ADAT,	FCMD_AUTH,	FCMD_CCC,	FCMD_CONF,
	FCMD_ENC,	FCMD_MIC,	FCMD_PBSZ,	FCMD_FEAT,
	FCMD_OPTS,	FCMD_EPRT,	FCMD_EPSV,	FCMD_LANG,
	FCMD_MDTM,	FCMD_MLSD,	FCMD_MLST,	FCMD_SIZE,
	NONE_CMD
} FTPCMD;

static const char* s_CmdStrs[] =
{
	"USER",		"PASS",		"ACCT",		"CWD",
	"CDUP",		"SMNT",		"QUIT",		"REIN",
	"PORT",		"PASV",		"TYPE",		"STRU",
	"MODE",		"RETR",		"STOR",		"STOU",
	"APPE",		"ALLO",		"REST",		"RNFR",
	"RNTO",		"ABOR",		"DELE",		"RMD",
	"MKD",		"PWD",		"LIST",		"NLST",
	"SITE",		"SYST",		"STAT",		"HELP",
	"NOOP",		"XMKD",		"XRMD",		"XPWD",
	"XCUP",		"XCWD",		"LPRT",		"LPSV",
	"ADAT",		"AUTH",		"CCC",		"CONF",
	"ENC",		"MIC",		"PBSZ",		"FEAT",
	"OPTS",		"EPRT",		"EPSV",		"LANG",
	"MDTM",		"MLSD",		"MLST",		"SIZE"
};

// FTPX|X(RFC959)
typedef enum _FTPRES
{
	RES_200,	RES_500,	RES_501,	RES_202,
	RES_502,	RES_503,	RES_504,	RES_110,
	RES_211,	RES_212,	RES_213,	RES_214,
	RES_215,	RES_120,	RES_220,	RES_221,
	RES_421,	RES_125,	RES_225,	RES_425,
	RES_226,	RES_426,	RES_227,	RES_230,
	RES_530,	RES_331,	RES_332,	RES_532,
	RES_150,	RES_250,	RES_257,	RES_350,
	RES_450,	RES_550,	RES_451,	RES_551,
	RES_452,	RES_552,	RES_553,	NONE_RES
} FTPRES;

static const char* s_ResStrs[] =
{
	"200 Command okay.\r\n",
	"500 Syntax error, command unrecognized.\r\n",
	"501 Syntax error in parameters or arguments.\r\n",
	"202 Command not implemented, superfluous at this site.\r\n",
	"502 Command not implemented.\r\n",
	"503 Bad sequence of commands.\r\n",
	"504 Command not implemented for that parameter.\r\n",
	"110 Restart marker reply.\r\n",
	"211 System status, or system help reply.\r\n",
	"212 Directory status.\r\n",
	"213 File status.\r\n",
	"214 Help message.\r\n",
	"215 NAME system type.\r\n",
	"120 Service ready in nnn minutes.\r\n",
	"220 Service ready for new user.\r\n",
	"221 Service closing control connection.\r\n",
	"421 Service not available, closing control connection.\r\n",
	"125 Data connection already open; transfer starting.\r\n",
	"225 Data connection open; no transfer in progress.\r\n",
	"425 Can't open data connection.\r\n",
	"226 Closing data connection.\r\n",
	"426 Connection closed; transfer aborted.\r\n",
	"227 Entering Passive Mode (h1,h2,h3,h4,p1,p2).\r\n",
	"230 User logged in, proceed.\r\n",
	"530 Not logged in.\r\n",
	"331 User name okay, need password.\r\n",
	"332 Need account for login.\r\n",
	"532 Need account for storing files.\r\n",
	"150 File status okay; about to open data connection.\r\n",
	"250 Requested file action okay, completed.\r\n",
	"257 \"%s\" %s\r\n",
	"350 Requested file action pending further information.\r\n",
	"450 Requested file action not taken.\r\n",
	"550 Requested action not taken.\r\n",
	"451 Requested action aborted. Local error in processing.\r\n",
	"551 Requested action aborted. Page type unknown.\r\n",
	"452 Requested action not taken.\r\n",
	"552 Requested file action aborted.\r\n",
	"553 Requested action not taken.\r\n"
};

#define PORT_COMMAND		21
#define	PORT_DATA			20
#define TIMEOUT_CMD			TICKS_OF(180)
#define TIMEOUT_CNT			TICKS_OF(5)

#define ST_START			0
#define ST_SENDRES			1
#define ST_WAITCMD			2
#define ST_EXECCMD			3

#define DS_IDLE				0
#define DS_SENDRES			1
#define DS_CONNECT			2
#define DS_CONWAIT			3
#define DS_DISCONNECT		4
#define DS_LIST_START		5
#define DS_LIST_GET			6
#define DS_LIST_SEND		7
#define DS_RETR_START		8
#define DS_RETR_GET			9
#define DS_RETR_SEND		10
#define DS_STOR_START		11
#define DS_STOR_RECV		12
#define DS_STOR_PUT			13
#define DS_ABORT			14
#define DS_ABORT_END		15

#define PR_START			0
#define PR_STEP1			1
#define PR_WAIT1			2
#define PR_STEP2			3
#define PR_WAIT2			4

#define USER_NONE			0
#define USER_OK				1
#define USER_LOGIN			2

//=================================================================

static void TransTask(void);
static void Init(void);
static FTPCMD ParseCmd(void);

static void NotCommand(void);
static void NotImplement(void);
static void CmdUser(void);
static void CmdPass(void);
static void CmdCwd(void);
static void CmdCdup(void);
static void CmdQuit(void);
static void CmdPort(void);
static void CmdType(void);
static void CmdStru(void);
static void CmdMode(void);
static void CmdRetr(void);
static void CmdStor(void);
static void CmdAppe(void);
static void CmdAllo(void);
static void CmdRnfr(void);
static void CmdRnto(void);
static void CmdAbor(void);
static void CmdDele(void);
static void CmdRmd(void);
static void CmdMkd(void);
static void CmdPwd(void);
static void CmdList(void);
static void CmdNoop(void);

static void (*s_Proc[])(void) =
{
 /* FCMD_USER */	CmdUser,
 /* FCMD_PASS */	CmdPass,
 /* FCMD_ACCT */	NotImplement,
 /* FCMD_CWD  */	CmdCwd,
 /* FCMD_CDUP */	CmdCdup,
 /* FCMD_SMNT */	NotImplement,
 /* FCMD_QUIT */	CmdQuit,
 /* FCMD_REIN */	NotImplement,
 /* FCMD_PORT */	CmdPort,
 /* FCMD_PASV */	NotImplement,
 /* FCMD_TYPE */	CmdType,
 /* FCMD_STRU */	CmdStru,
 /* FCMD_MODE */	CmdMode,
 /* FCMD_RETR */	CmdRetr,
 /* FCMD_STOR */	CmdStor,
 /* FCMD_STOU */	NotImplement,
 /* FCMD_APPE */	CmdAppe,
 /* FCMD_ALLO */	CmdAllo,
 /* FCMD_REST */	NotImplement,
 /* FCMD_RNFR */	CmdRnfr,
 /* FCMD_RNTO */	CmdRnto,
 /* FCMD_ABOR */	CmdAbor,
 /* FCMD_DELE */	CmdDele,
 /* FCMD_RMD  */	CmdRmd,
 /* FCMD_MKD  */	CmdMkd,
 /* FCMD_PWD  */	CmdPwd,
 /* FCMD_LIST */	CmdList,
 /* FCMD_NLST */	CmdList,
 /* FCMD_SITE */	NotImplement,
 /* FCMD_SYST */	NotImplement,
 /* FCMD_STAT */	NotImplement,
 /* FCMD_HELP */	NotImplement,
 /* FCMD_NOOP */	CmdNoop,
 /* FCMD_XMKD */	CmdMkd,
 /* FCMD_XRMD */	CmdRmd,
 /* FCMD_XPWD */	CmdPwd,
 /* FCMD_XCUP */	CmdCdup,
 /* FCMD_XCWD */	CmdCwd,
 /* FCMD_LPRT */	NotImplement,
 /* FCMD_LPSV */	NotImplement,
 /* FCMD_ADAT */	NotImplement,
 /* FCMD_AUTH */	NotImplement,
 /* FCMD_CCC  */	NotImplement,
 /* FCMD_CONF */	NotImplement,
 /* FCMD_ENC  */	NotImplement,
 /* FCMD_MIC  */	NotImplement,
 /* FCMD_PBSZ */	NotImplement,
 /* FCMD_FEAT */	NotImplement,
 /* FCMD_OPTS */	NotImplement,
 /* FCMD_EPRT */	NotImplement,
 /* FCMD_EPSV */	NotImplement,
 /* FCMD_LANG */	NotImplement,
 /* FCMD_MDTM */	NotImplement,
 /* FCMD_MLSD */	NotImplement,
 /* FCMD_MLST */	NotImplement,
 /* FCMD_SIZE */	NotImplement,
 /* NONE_CMD */	NotCommand
};

//=================================================================

static int s_nState;
static int s_nTrans;
static DWORD s_dwTick;
static DWORD s_dwTrns;
static char s_Buf[32 + MAX_PATH];
static TCP_SOCKET s_hSock;
static TCP_SOCKET s_hTrns;
static FTPCMD s_nCmd;
static FTPRES s_nRes;
static char s_Res[32 + MAX_PATH];
static char* s_Args[8];
static int s_nProc;
static BYTE s_Buffer[512]; // SECTOR_SIZE

static int s_nUser;
static char s_User[32];
static char s_File[32];
static IP_ADDR s_Addr;
static WORD_VAL s_Port;
static FTPH s_hList;
static FTPH s_hFile;

//=================================================================

// 
void FTPInit(void)
{
	Init();
	s_hSock = TCPOpen(0, TCP_OPEN_SERVER, PORT_COMMAND, TCP_PURPOSE_FTP_COMMAND);
	s_hTrns = INVALID_SOCKET;
}

// ^XN
BOOL FTPServer(void)
{
	ASSERT(s_hSock != INVALID_SOCKET);

	WORD wPos;
	const char* pRes;

	// ڑ
	if (TCPWasReset(s_hSock) || !TCPIsConnected(s_hSock))
	{
		// ؒfԂɖ߂
		if (s_nState != ST_START)
		{
			if (s_hTrns != INVALID_SOCKET)
			{
				TCPDisconnect(s_hTrns);
				TCPDisconnect(s_hTrns);
				s_hTrns = INVALID_SOCKET;
			}
			Init();
		}
		return TRUE;
	}

	// R}h^XN
	switch (s_nState)
	{
	case ST_START: // ڑm
		ASSERT(s_hTrns == INVALID_SOCKET);
		s_nRes = RES_220;
		s_nState = ST_SENDRES;
		// No break;

	case ST_SENDRES: // X|XM
		ASSERT(s_nCmd == NONE_CMD);
		ASSERT(s_nRes < NONE_RES || s_Res[0] != '\0');
		pRes = (s_Res[0] == '\0')? s_ResStrs[s_nRes] : s_Res;
		if(TCPIsPutReady(s_hSock) < strlen(pRes)) {
			break;
		}
		TCPPutROMString(s_hSock, pRes);
		TCPFlush(s_hSock);
		s_nRes = NONE_RES;
		s_Res[0] = '\0';

		s_dwTick = TickGet() + TICKS_OF(TIMEOUT_CMD);
		s_nState = ST_WAITCMD;
		break;

	case ST_WAITCMD: // R}h҂
		ASSERT(s_nCmd == NONE_CMD);
		ASSERT(s_nRes == NONE_RES);

		wPos = TCPFind(s_hSock, 0x0A, 0, FALSE);
		if(wPos == 0xFFFF)
		{
			if (s_nTrans == DS_IDLE)
			{
				if(TickGet() >= s_dwTick)
				{
					// QUITR}hƓs
					s_nCmd = FCMD_QUIT;
					s_nState = ST_EXECCMD;
				}
			}
			else {
				s_dwTick = TickGet() + TICKS_OF(TIMEOUT_CMD);
			}
			break;
		}
		ASSERT((wPos + 1) <= sizeof(s_Buf));
		TCPGetArray(s_hSock, (BYTE*)s_Buf, wPos + 1);
		s_Buf[wPos] = '\0';

		s_nCmd = ParseCmd();
		s_nState = ST_EXECCMD;
		// No break

	case ST_EXECCMD: // R}hs
		ASSERT(s_nRes == NONE_RES);
		ASSERT(s_nCmd <= NONE_CMD);
		s_Proc[s_nCmd]();
		break;

	default:
		ASSERT(FALSE);
	}

	// ]^XN
	TransTask();

	return TRUE;
}

// ]^XN
static void TransTask(void)
{
	static FTPRES s_nDrs = NONE_RES;
	static int s_nRnx;
	static int s_nCnx;
	static UINT s_nSize;
	static UINT s_nSend;
	WORD wSize;
	int nRet;

	switch (s_nTrans)
	{
	case DS_IDLE:
		break;

	case DS_LIST_START: // FCMD_LIST
		s_nSize = 0;
		s_nDrs = RES_150;
		s_nRnx = DS_CONNECT;
		s_nCnx = DS_LIST_GET;
		s_nTrans = DS_SENDRES;
		break;

	case DS_RETR_START: // FCMD_RETR
		s_nSize = 0;
		s_nDrs = RES_150;
		s_nRnx = DS_CONNECT;
		s_nCnx = DS_RETR_GET;
		s_nTrans = DS_SENDRES;
		break;

	case DS_STOR_START: // FCMD_STOR
		s_nSize = 0;
		s_nDrs = RES_150;
		s_nRnx = DS_CONNECT;
		s_nCnx = DS_STOR_RECV;
		s_nTrans = DS_SENDRES;
		break;

	case DS_ABORT: // FCMD_ABOR
		s_hList = NULL;
		if (s_hFile != NULL) {
			FtpClose(s_hFile);
			s_hFile = NULL;
		}
		s_nDrs = RES_426;
		s_nRnx = DS_ABORT_END;
		s_nCnx = DS_SENDRES;
		s_nTrans = DS_DISCONNECT;
		break;

	case DS_SENDRES: // X|XM
		ASSERT(s_nDrs < NONE_RES);
		if(TCPIsPutReady(s_hSock) < strlen(s_ResStrs[s_nDrs])) {
			break;
		}
		TCPPutROMString(s_hSock, s_ResStrs[s_nDrs]);
		TCPFlush(s_hSock);
		s_nDrs = NONE_RES;
		s_nTrans = s_nRnx;
		break;

	case DS_CONNECT: // f[^ڑ
		ASSERT(s_hTrns == INVALID_SOCKET);
		s_hTrns = TCPOpen(s_Addr.Val, TCP_OPEN_IP_ADDRESS, s_Port.Val, TCP_PURPOSE_FTP_DATA);
		if (s_hTrns == INVALID_SOCKET) {
			break;
		}
		s_dwTrns = TickGet() + TICKS_OF(TIMEOUT_CNT);
		s_nTrans = DS_CONWAIT;
		break;

	case DS_CONWAIT: // f[^ڑ҂
		if (!TCPIsConnected(s_hTrns))
		{
			if (TickGet() >= s_dwTrns)
			{
				s_hList = NULL;
				s_nDrs = RES_425;
				s_nRnx = DS_IDLE;
				s_nCnx = DS_SENDRES;
				s_nTrans = DS_DISCONNECT;
			}
			break;
		}
		s_dwTrns = TickGet() + TIMEOUT_CNT;
		s_nTrans = s_nCnx;
		break;

	case DS_DISCONNECT: // f[^ؒf
		if (s_hTrns != INVALID_SOCKET)
		{
			TCPDisconnect(s_hTrns);
			TCPDisconnect(s_hTrns);
			s_hTrns = INVALID_SOCKET;
		}
		s_nTrans = s_nCnx;
		break;

	case DS_LIST_GET: // Xg擾
		ASSERT(s_hList != NULL);
		do  {
			nRet = FtpGetNext(s_hList, (char*)s_Buffer + s_nSize, &s_nSize);
			if (nRet != 1) {
				break;
			}
		} while (s_nSize < (sizeof(s_Buffer) - 64));
		if ((nRet == 0 && s_nSize == 0) || (nRet == -1))
		{
			s_hList = NULL;
			s_nDrs = (nRet == 0)? RES_226 : RES_451;
			s_nRnx = DS_IDLE;
			s_nCnx = DS_SENDRES;
			s_nTrans = DS_DISCONNECT;
			break;
		}
		s_nSend = 0;
		s_nTrans = DS_LIST_SEND;
		break;

	case DS_LIST_SEND: // XgM
		ASSERT(s_nSize > 0);
		if (!TCPIsConnected(s_hTrns))
		{
			s_hList = NULL;
			s_nDrs = RES_426;
			s_nRnx = DS_IDLE;
			s_nCnx = DS_SENDRES;
			s_nTrans = DS_DISCONNECT;
			break;
		}
		wSize = TCPIsPutReady(s_hTrns);
		if(wSize < 64) {
			break;
		}
		if (s_nSize < wSize) {
			wSize = s_nSize;
		}

		TCPPutArray(s_hTrns, s_Buffer + s_nSend, wSize);
		TCPFlush(s_hTrns);
		s_nSend += wSize;
		s_nSize -= wSize;

		if (s_nSize == 0) {
			s_nTrans = DS_LIST_GET;
		}
		break;

	case DS_RETR_GET: // t@C[h
		ASSERT(s_hFile != NULL);
		nRet = FtpRead(s_hFile, s_Buffer, sizeof(s_Buffer), &s_nSize);
		if ((nRet && s_nSize == 0) || !nRet)
		{
			FtpClose(s_hFile);
			s_hFile = NULL;
			s_nDrs = (nRet)? RES_226 : RES_451;
			s_nRnx = DS_IDLE;
			s_nCnx = DS_SENDRES;
			s_nTrans = DS_DISCONNECT;
			break;
		}
		s_nSend = 0;
		s_nTrans = DS_RETR_SEND;
		break;

	case DS_RETR_SEND: // t@CM
		ASSERT(s_nSize > 0);
		if (!TCPIsConnected(s_hTrns))
		{
			FtpClose(s_hFile);
			s_hFile = NULL;
			s_nDrs = RES_426;
			s_nRnx = DS_IDLE;
			s_nCnx = DS_SENDRES;
			s_nTrans = DS_DISCONNECT;
			break;
		}
		wSize = TCPIsPutReady(s_hTrns);
		if(wSize > 0)
		{
			if (s_nSize < wSize) {
				wSize = s_nSize;
			}
			TCPPutArray(s_hTrns, s_Buffer + s_nSend, wSize);
			TCPFlush(s_hTrns);
			s_nSend += wSize;
			s_nSize -= wSize;

			if (s_nSize == 0) {
				s_nTrans = DS_RETR_GET;
			}
		}
		break;

	case DS_STOR_RECV: // t@CM
		wSize = TCPIsGetReady(s_hTrns);
		if (wSize == 0)
		{
			if (TCPIsConnected(s_hTrns))
			{
				if (TickGet() >= s_dwTrns)
				{
					FtpClose(s_hFile);
					s_hFile = NULL;
					s_nDrs = RES_552;
					s_nRnx = DS_IDLE;
					s_nCnx = DS_SENDRES;
					s_nTrans = DS_DISCONNECT;
				}
				break;
			}
			if (s_nSize == 0)
			{
				FtpClose(s_hFile);
				s_hFile = NULL;
				s_nDrs = RES_226;
				s_nRnx = DS_IDLE;
				s_nCnx = DS_SENDRES;
				s_nTrans = DS_DISCONNECT;
				break;
			}
		}
		else
		{
			s_dwTrns = TickGet() + TIMEOUT_CNT;
			if (wSize > (sizeof(s_Buffer) - s_nSize)) {
				wSize = sizeof(s_Buffer) - s_nSize;
			}
			TCPGetArray(s_hTrns, s_Buffer + s_nSize, wSize);
			s_nSize += wSize;
			if (s_nSize < sizeof(s_Buffer)) {
				break;
			}
		}
		s_nTrans = DS_STOR_PUT;
		break;

	case DS_STOR_PUT: // t@CCg
		ASSERT(s_hFile != NULL);
		ASSERT(s_nSize > 0);
		if (!FtpWrite(s_hFile, s_Buffer, s_nSize))
		{
			FtpClose(s_hFile);
			s_hFile = NULL;
			s_nDrs = RES_552;
			s_nRnx = DS_IDLE;
			s_nCnx = DS_SENDRES;
			s_nTrans = DS_DISCONNECT;
		}
		s_nSize = 0;
		s_nTrans = DS_STOR_RECV;
		break;

	case DS_ABORT_END: // f
		s_nDrs = RES_226;
		s_nRnx = DS_IDLE;
		s_nTrans = DS_SENDRES;
		break;

	default:
		ASSERT(FALSE);
	}
}

// (\PbgȊO)
static void Init(void)
{
	s_nState = ST_START;
	s_nTrans = DS_IDLE;
	s_nCmd = NONE_CMD;
	s_nRes = NONE_RES;
	s_Res[0] = '\0';
	s_nProc = PR_START;
	s_nUser = USER_NONE;
	s_File[0] = '\0';
	s_Addr.Val = 0x7F000001;
	s_Port.Val = PORT_DATA;
	s_hList = NULL;
	if (s_hFile != NULL)
	{
		FtpClose(s_hFile);
		s_hFile = NULL;
	}
}

//=================================================================

// R}hp[X
static FTPCMD ParseCmd(void)
{
	// R}h
	FTPCMD cmd = FCMD_USER;
	do {
		if (memcmp(s_CmdStrs[cmd], s_Buf, 3) == 0) {
			break;
		}
	} while (++cmd < NONE_CMD);

	// 
	memset(s_Args, 0, sizeof(s_Args));
	if (cmd != NONE_CMD)
	{
		char* p = s_Buf;
		int i = 0;
		do {
			s_Args[i++] = p;
			do {
				ASSERT(*p != '\n');
				if (*p == ' ' || *p == ',')
				{
					*p = '\0';
					p++;
					break;
				}
				else if (*p == '\r')
				{
					*p = '\0';
					break;
				}
				p++;
			}
			while (*p != '\0');
			while (*p == ' ') p++;
		}
		while (*p != '\0');
	}

	return cmd;
}

// Fs
static void NotCommand(void)
{
	s_nCmd = NONE_CMD;
	s_nRes = RES_500;
	s_nState = ST_SENDRES;
}

// 
static void NotImplement(void)
{
	s_nCmd = NONE_CMD;
	s_nRes = RES_502;
	s_nState = ST_SENDRES;
}

// FCMD_USER
static void CmdUser(void)
{
	if (s_Args[1] != NULL)
	{
		strcpy((char*)s_User, (char*)s_Args[1]);
		s_nUser = USER_OK;
		s_nRes = RES_331;
	}
	else {
		s_nRes = RES_501;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_PASS
static void CmdPass(void)
{
	if (s_nUser >= USER_OK)
	{
		if (FtpVerify(s_User, s_Args[1]))
		{
			s_nRes = RES_230;
			s_nUser = USER_LOGIN;
		}
		else {
			s_nRes = RES_530;
			s_nUser = USER_NONE;
		}
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_CWD
static void CmdCwd(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (FtpChDir(s_Args[1]))
				s_nRes = RES_250;
			else
				s_nRes = RES_550;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_CDUP
static void CmdCdup(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (FtpChDir(".."))
			s_nRes = RES_250;
		else
			s_nRes = RES_550;
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_PORT
static void CmdPort(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL && s_Args[2] != NULL && s_Args[3] != NULL &&
			s_Args[4] != NULL && s_Args[5] != NULL && s_Args[6] != NULL)
		{
			s_Addr.v[0] = (BYTE)atoi(s_Args[1]);
			s_Addr.v[1] = (BYTE)atoi(s_Args[2]);
			s_Addr.v[2] = (BYTE)atoi(s_Args[3]);
			s_Addr.v[3] = (BYTE)atoi(s_Args[4]);
			s_Port.v[1] = (BYTE)atoi(s_Args[5]);
			s_Port.v[0] = (BYTE)atoi(s_Args[6]);
			s_nRes = RES_200;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_TYPE
static void CmdType(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (FtpSetType(s_Args[1]))
				s_nRes = RES_200;
			else
				s_nRes = RES_504;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_STRU
static void CmdStru(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (*s_Args[1] == 'F')
				s_nRes = RES_200;
			else
				s_nRes = RES_504;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_MODE
static void CmdMode(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (*s_Args[1] == 'S')
				s_nRes = RES_200;
			else
				s_nRes = RES_504;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_RETR
static void CmdRetr(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_nTrans == DS_IDLE)
		{
			if (s_Args[1] != NULL)
			{
				ASSERT(s_hFile == NULL);
				s_hFile = FtpOpen(s_Args[1], FTP_FREAD);
				if (s_hFile != NULL)
				{
					s_nTrans = DS_RETR_START;
					s_nCmd = NONE_CMD;
					s_nState = ST_WAITCMD;
					return;
				}
				else {
					s_nRes = RES_450;
				}
			}
			else {
				s_nRes = RES_501;
			}
		}
		else {
			s_nRes = RES_550;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_STOR
static void CmdStor(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_nTrans == DS_IDLE)
		{
			if (s_Args[1] != NULL)
			{
				ASSERT(s_hFile == NULL);
				s_hFile = FtpOpen(s_Args[1], FTP_FCREATE);
				if (s_hFile != NULL)
				{
					s_nTrans = DS_STOR_START;
					s_nCmd = NONE_CMD;
					s_nState = ST_WAITCMD;
					return;
				}
				else {
					s_nRes = RES_450;
				}
			}
			else {
				s_nRes = RES_501;
			}
		}
		else {
			s_nRes = RES_553;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_APPE
static void CmdAppe(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_nTrans == DS_IDLE)
		{
			if (s_Args[1] != NULL)
			{
				ASSERT(s_hFile == NULL);
				s_hFile = FtpOpen(s_Args[1], FTP_FAPPEND);
				if (s_hFile != NULL)
				{
					s_nTrans = DS_STOR_START;
					s_nCmd = NONE_CMD;
					s_nState = ST_WAITCMD;
					return;
				}
				else {
					s_nRes = RES_450;
				}
			}
			else {
				s_nRes = RES_501;
			}
		}
		else {
			s_nRes = RES_553;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_ALLO
static void CmdAllo(void)
{
	if (s_nUser == USER_LOGIN)
		s_nRes = RES_202;
	else
		s_nRes = RES_530;

	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_RNFR
static void CmdRnfr(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			strcpy((char*)s_File, (char*)s_Args[1]);
			s_nRes = RES_350;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_RNTO
static void CmdRnto(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_File[0] != '\0')
		{
			if (s_Args[1] != NULL)
			{
				if (FtpRename(s_File, s_Args[1]))
					s_nRes = RES_250;
				else
					s_nRes = RES_553;

				s_File[0] = '\0';
			}
			else {
				s_nRes = RES_501;
			}
		}
		else {
			s_nRes = RES_503;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_ABOR
static void CmdAbor(void)
{
	if (s_nTrans != DS_IDLE)
	{
		s_nTrans = DS_ABORT;
		s_nCmd = NONE_CMD;
		s_nState = ST_WAITCMD;
	}
	else
	{
		s_nRes = RES_226;
		s_nCmd = NONE_CMD;
		s_nState = ST_SENDRES;
	}
}

// FCMD_DELE
static void CmdDele(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (FtpDelete(s_Args[1]))
				s_nRes = RES_250;
			else
				s_nRes = RES_450;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_RMD
static void CmdRmd(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (FtpDelete(s_Args[1]))
				s_nRes = RES_250;
			else
				s_nRes = RES_550;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_MKD
static void CmdMkd(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_Args[1] != NULL)
		{
			if (FtpMkDir(s_Args[1]))
				sprintf(s_Res, s_ResStrs[RES_257], s_Args[1], "created.");
			else
				s_nRes = RES_550;
		}
		else {
			s_nRes = RES_501;
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_PWD
static void CmdPwd(void)
{
	char buf[MAX_PATH];
	char* cur = FtpGetCur(buf);
	if (cur != NULL) {
		sprintf(s_Res, s_ResStrs[RES_257], cur, "is current.");
	}
	else {
		s_nRes = RES_550;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_LIST
static void CmdList(void)
{
	if (s_nUser == USER_LOGIN)
	{
		if (s_nTrans == DS_IDLE)
		{
			ASSERT(s_hList == NULL);

			if (s_Args[1] == NULL)
				s_Args[1] = FtpGetCur(s_Args[0] + 5); // "LIST"̎

			if (s_Args[1] != NULL)
				s_hList = FtpOpenList(s_Args[1], s_nCmd == FCMD_LIST);

			if (s_hList != NULL)
			{
				s_nTrans = DS_LIST_START;
				s_nCmd = NONE_CMD;
				s_nState = ST_WAITCMD;
				return;
			}
			else {
				s_nRes = RES_450;
			}
		}
		else {
			s_nRes = RES_550; // None RFC959
		}
	}
	else {
		s_nRes = RES_530;
	}
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_NOOP
static void CmdNoop(void)
{
	s_nRes = RES_200;
	s_nCmd = NONE_CMD;
	s_nState = ST_SENDRES;
}

// FCMD_QUIT
static void CmdQuit(void)
{
	switch (s_nProc)
	{
	case PR_START:
		if (s_hTrns != INVALID_SOCKET)
		{
			TCPDisconnect(s_hTrns);
			TCPDisconnect(s_hTrns);
			s_hTrns = INVALID_SOCKET;
			s_nProc = PR_STEP1;
			break;
		}
		s_nProc = PR_STEP1;
		// No break;

	case PR_STEP1:
		if(TCPIsPutReady(s_hSock) < strlen(s_ResStrs[RES_221])) {
			break;
		}
		TCPPutROMString(s_hSock, s_ResStrs[RES_221]);
		TCPFlush(s_hSock);
		s_nProc = PR_STEP2;
		break;

	case PR_STEP2:
		if (TCPIsPutReady(s_hSock))
		{
			if (TCPIsConnected(s_hSock))
				TCPDisconnect(s_hSock);
		}
		// ڑŏԂɖ߂
		break;

	default:
		ASSERT(FALSE);
	}
}
