/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "TCPIP Stack/Tick.h"

//=================================================================

static DWORD s_dwTick16 = 0;

//=================================================================

// 
extern void TickInit(void)
{
	T1CON = 0;
	T1CONbits.TCKPS = 0b11; // 1:256 prescaler
	PR1 = 0xFFFF;
	IPC1bits.T1IP = 7; // ōDx
	IEC0bits.T1IE = 1;
	T1CONbits.ON = 1;
}

// Tickl
extern DWORD TickGet(void)
{
	while (TMR1 == 0xFFFF);
	return ((s_dwTick16 << 16) | TMR1);
}

// Tickl(1/256)
extern DWORD TickGetDiv256(void)
{
	while (TMR1 == 0xFFFF);
	return ((s_dwTick16 << 8) | (TMR1 >> 8));
}

//=================================================================

// TMR1
void __ISR(_TIMER_1_VECTOR, IPL7SRS) _T1Interrupt(void)
{
	ASSERT(TMR1 < 0x1000); // 荞݋֎~Ԃƈ
	s_dwTick16++;
	IFS0CLR = _IFS0_T1IF_MASK;
}
