/*
 * HK_Multi.c
 *
 * Created: 2012/09/28 1:01:29
 *  Author: strv
 *
 * HobbyKing̃}`Rv^[{[hV3œNAbhRv^[pvO
 * {[hƃ[^zů֌W͈ȉ̂ƂB
 *  O
 * M1 M3	M1:CW M3:CCW
 *  \/
 *  /\
 * M2 M4	M2:CCW M4:CW
 *  
 *
 * oPWM400Hz߂̂őΉĂESCɂȂƁB
 * T[{ȂƔ߂ƂɂȂ肩˖̂łȂȂ̂߁B
 *
 * oPWM͖̐߂̎s^C~OɈˑĂ̂ŁA
 * ȏ㊄荞݂𑝂₳ȂقWb^𑝂₳Ȃ̂ŋg
 * 
 * œKOsO3ׂ
 * 
 * XV
 * 2012/10/03	EJ
 * 2012/10/04	EWCSl̎擾ŎgȉYC
 *				EXeBbN삪q߂̂ŁAŜɊZ悤ɂ
 *				@ɔA|eV̕␳WύX₷悤ɂ
 *				@ɔAe␳WύX@̂ւ͋@̂ɍ킹ēKX
 *				ENLED_ł悤ɂ
 *
 */ 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>
#include <stdint.h>

#include "HK_MultiUtil.h"
#include "AD.h"
#include "I2C.h"

//I̐ώZʂ̍ől
#define ISUMLIMIT (100)
//IQC̕
#define IGAIN_DIV (1<<4)

//WC̒SlƂ邽߂ɕς
#define CENTER_SUM_ORDER (16)

//WCADlvZɎg₷lɕ␳l@ƃQCオ̂Ɠ
#define SCALE_GYRO (1<<1)		//q
#define SCALE_GYRO_DIV (1<<1)	//
//M@̐MvZɎg₷lɕ␳l@ꏬƑɑ΂Ă񂵂
#define SCALE_RX (1<<4)
//|eV̒lQCɂ␳W 傫ƃQCȂ
#define SCALE_GAIN (1<<3)		
//ŏIIȒl鎞̕␳W@傫ƁAS̓Iɓ݂Ȃ
#define SCALE_OUT (1<<2)		

//WČ̕␳ 1-1
#define GYRO_DIR_R (1)
#define GYRO_DIR_P (1)
#define GYRO_DIR_Y (-1)

//fobOȂwaitזȂ̂ł΂@0łȂ@1ł
#define DO_DEBUG 0

int main(void)
{
	volatile int16_t rxRoll,rxPitch,rxYaw,rxThr;	//M@̏
	volatile int16_t out1=0,out2=0,out3=0,out4=0;	//o͒l
	int16_t roll,pitch,yaw;							//e̐ó@ԂႯŏԂɌvZ΂
	int16_t pGain=0,iGain=0,yawPGain=0;				//QC
	int16_t iSumP,iSumR,iSumY;						//eI
	int16_t rollCenter,pitchCenter,yawCenter;		//eWC̒Sl
	uint8_t i=0,mode=0,mode_count = 0;				//GpiA[hA[hJԂJE^
	
	//KXCjVCY
	cli();
	initBoardIo();
	initRxInt();
	initSoftPwm();
	initAd();
	sei();	
	
	LED_OFF();
	
	//WCƂ肳邽߂ɖʑ҂
#if DO_DEBUG == 0
	for(i=0;i<5;i++){
		wait(250);
		LED_ON();
		wait(250);
		LED_OFF();
	}	
#endif
	
    while(1)
    {
		//M@̐M擾
	    getRx(&rxRoll,&rxPitch,&rxYaw,&rxThr);
		
		//XbgŒ(t)?
		if(rxThr < RX_THR_THR){
			//_[ς@@[hڂƂĂ?
			if(rxYaw < -RX_YAW_THR && mode >= 10){
				mode_count++;
				//ȏԂ΂炭
				if(mode_count > 200){
					//LEDOFFɂāAҋ@[hɈڍs
					LED_OFF();
					mode_count = 0;
					mode = 0;					
				}
			}else if(rxYaw > RX_YAW_THR && mode == 0){ //_[Eς@@[hҋ@?
				mode_count++;
				//ȏԂ΂炭
				if(mode_count > 200){
					//LEDONɂāAڂƂ
					LED_ON();
					mode_count = 0;
					mode = 10;
				}
			}				
		}
		
		switch(mode){
			//ҋ@
			case 0:
			out1 = 0;
			out2 = 0;
			out3 = 0;
			out4 = 0;
			break;
			
			//WC̒Sl擾̏
			case 10:			
			rollCenter = 0;
			pitchCenter = 0;
			yawCenter = 0;
			i=0;
			
			mode++;
			break;
			
			//WC̒Sl擾
			case 11:
			rollCenter += getAd(ADC2D);
			pitchCenter += getAd(ADC1D);
			yawCenter += getAd(ADC0D);
			i++;
			
			//񐔎擾c
			if(i >= CENTER_SUM_ORDER)mode++;
			break;
			
			//WC̒SlvZ
			case 12:			
			rollCenter /= CENTER_SUM_ORDER;
			pitchCenter /= CENTER_SUM_ORDER;
			yawCenter /= CENTER_SUM_ORDER;
			
			//ꉞϕ̗ݐςNA
			iSumR = 0;
			iSumP = 0;
			iSumY = 0;
			
			//|eVlƂĂăQCɂ
			pGain = getAd(PIN_POT_ROL)/SCALE_GAIN;
			iGain = getAd(PIN_POT_PIT)/SCALE_GAIN;
			yawPGain = getAd(PIN_POT_YAW)/SCALE_GAIN;
				
			//䃋[vɈڍs
			mode++;
			break;
			
			//C̐䃋[v
			case 13:
			
			//ẽWC擾āASl
			roll = getAd(ADC2D) - rollCenter;
			pitch = getAd(ADC1D) - pitchCenter;
			yaw = getAd(ADC0D) - yawCenter;
			
			//XbgŒt߂琧䂵Ȃ
			if(rxThr < RX_THR_THR){
				out1 = 0;
				out2 = 0;
				out3 = 0;
				out4 = 0;
				break;
			}
			
			//ȉPIvZ
			out1 = rxThr;
			out2 = rxThr;
			out3 = rxThr;
			out4 = rxThr;
			
			//[
			roll = rxRoll / SCALE_RX - (roll * GYRO_DIR_R) * SCALE_GYRO_DIV / SCALE_GYRO;
			iSumR += roll;
			if(iSumR > ISUMLIMIT)iSumR=ISUMLIMIT;
			if(iSumR < -ISUMLIMIT)iSumR=-ISUMLIMIT;
			roll *= pGain;
			roll += iSumR * iGain / IGAIN_DIV;
			roll /= SCALE_OUT;
			
			out1 += roll;
			out2 += roll;
			out3 -= roll;
			out4 -= roll;
			
			//sb`
			pitch = rxPitch / SCALE_RX - (pitch * GYRO_DIR_P) * SCALE_GYRO_DIV / SCALE_GYRO;
			iSumP += pitch;
			if(iSumP > ISUMLIMIT)iSumP=ISUMLIMIT;
			if(iSumP < -ISUMLIMIT)iSumP=-ISUMLIMIT;
			pitch *= pGain;
			pitch += iSumP * iGain / IGAIN_DIV;
			pitch /= SCALE_OUT;
			
			out1 += pitch;
			out2 -= pitch;
			out3 += pitch;
			out4 -= pitch;
			
			//[
			//[QCႤ
			yaw = rxYaw / SCALE_RX - (yaw * GYRO_DIR_Y) * SCALE_GYRO_DIV / SCALE_GYRO;
			iSumY += yaw;
			if(iSumY > ISUMLIMIT)iSumY=ISUMLIMIT;
			if(iSumY < -ISUMLIMIT)iSumY=-ISUMLIMIT;
			yaw *= yawPGain;
			yaw += iSumY * iGain / IGAIN_DIV;
			yaw /= SCALE_OUT;
			
			out1 -= yaw;
			out2 += yaw;
			out3 += yaw;
			out4 -= yaw;
			
			break;
		}
		//PWMo͂āc
		startPwm();
		//o͔g`XP[Oāc
		scalePwm(&out1,&out2,&out3,&out4);
		//o͂
		endPwm(out1,out2,out3,out4);
		
#if DO_DEBUG == 0
		//OŷPWMZȂ߂Ȃ悤ɒ
		//OdȂ炢Ȃ
		wait(1);
#endif
    }
}

