#include <stdint.h>
#include "STOyyb.h"
#include "system_timer.h"
#include "led.h"
#include "switch.h"

#define LED_INTERVAL (500)

int main(void) {
	uint32_t now=0, last_now=0;

	NVIC_SetVectorTable(NVIC_VectTab_FLASH, VECT_TAB_OFFSET);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO,ENABLE);
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);

	st_init();
	switch_init();
	led_init();

	led_on(LED1);
	led_off(LED2);
	while (1) {
		now = st_now();
		if(switch_state() == 1){
			if (now - last_now >= LED_INTERVAL/2) {
				led_toggle(LED1 | LED2);
				last_now += LED_INTERVAL/2;
			}
		}else{
			if (now - last_now >= LED_INTERVAL) {
				led_toggle(LED1 | LED2);
				last_now += LED_INTERVAL;
			}

		}
	}
}
