/**
 ******************************************************************************
 * @file	switch.c
 * @author	Seiga
 * @brief	I{[hXCb`pCu
 * @see		SW_POLARITY_REVERSE
 ******************************************************************************
 */
#include "platform_config.h"
#include "switch.h"

/**
 * @brief CjVCY֐
 * @param Ȃ
 * @return Ȃ
 *
 * K֐sOɖ{֐ŃCjVCY邱ƁB
 */
void switch_init(void) {
	RCC_APB2PeriphClockCmd(SW_RCC, ENABLE);

	GPIO_InitTypeDef GPIO_InitStructure;

	GPIO_InitStructure.GPIO_Pin = SW_PIN;
#if defined(SW_POLARITY_REVERSE)
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
#else
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;
#endif
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(SW_PORT, &GPIO_InitStructure);
}

/**
 * @brief XCb`Ԏ擾֐
 * @param Ȃ
 * @return ݂̃XCb`
 *
 * ݂̃XCb`Ԃ擾BXCb`Ă1AĂ0B
 */
uint16_t switch_state(void) {
#if defined(SW_POLARITY_REVERSE)
	return (~GPIO_ReadInputDataBit(SW_PORT,SW_PIN) & 0x01);
#else
	return (GPIO_ReadInputDataBit(SW_PORT, SW_PIN) & 0x01);
#endif
}
