/*
 * SystemTimer.c
 *
 *  Created on: 2013/08/23
 *      Author: strv
 */
#include "system_timer.h"
#include "stm32f10x.h"
#include "platform_config.h"

volatile SYSTIMER_UINT_TYPE msec = 0;
volatile SYSTIMER_UINT_TYPE sw_start_time = 0;
volatile SYSTIMER_UINT_TYPE tick = 0;

void st_init(void) {
	/* Setup SysTick Timer for 1 msec interrupts  */
	//SystemCoreClock is defined insystem_stm32f10x.c
	//by default SystemCoreClock is 72,000,000. SystemCoreClock/1000 is  72,000
	//System clock frequency is 72MHz. After counting 72,000 at 72MHz, 1ms passes.
	if (SysTick_Config(SystemCoreClock / SYSTIMER_TICK_INTERVAL_HZ)) {
		/* Capture error */
	}
}

SYSTIMER_UINT_TYPE st_now(void) {
	return msec;
}

void st_wait(SYSTIMER_UINT_TYPE ms) {
	SYSTIMER_UINT_TYPE now = msec;
	while (msec - now < ms)
		;
}

void st_sw_start(void) {
	sw_start_time = msec;
}

SYSTIMER_UINT_TYPE st_sw_lap(void) {
	return msec - sw_start_time;
}

void st_set(SYSTIMER_UINT_TYPE val) {
	tick = val * SYSTIMER_TICK_INTERVAL_HZ / 1000;
	msec = val;
}

void st_count_up(void) {
	tick++;
	if (tick * 1000 / SYSTIMER_TICK_INTERVAL_HZ != msec) {
		msec++;
	}
}
