// ==UserScript==
// @name searchResultHilite2
// @author temp_h
// @namespace http://www.pandora.nu/tempo-depot/js/
// @version 2.0.4
// @license public domain
// @description : highlight words that read from search query or referrer.
//     And also does inputed words. 
//     If the page has some query, this script is automatically executed.
//     Not in this case, 'ctrl + /' is the key to execute.
// @published 2005-11-15
// @modified 2005-11-17
// @modified 2006-07-28 勝手にEUC-JPにも対応
// @include *
// ==/UserScript==


// ここに http://nurucom-archives.hp.infoseek.co.jp/digital/ecl.js の内容を貼り付けて使用


// =========================================
// =========================================
// 簡単な設定項目
// CONFIGURATION
// 好きなようにして下さい
// Set value as you like.
// -----------------------------------------
(function(){ var c = {}; var key = {};

// 検索結果ページでもハイライトするか true か false
// highlight in search result page. true or false
c.enableResultPage = true;

// コントロールボックスの位置
// 0:非表示 | 1:左上 | 2:右上 | 3:右下 | 4:左下
// control div-box positin. 
// 0:do not show | 1:top-left | 2:top-right | 3:bottom-right | 4:bottom-left
c.controlBoxPosition = 3;

// ハイライトボックスのスタイル 'frost_glass' か 'simple'
// highlight box style 'frost_glass' or 'simple'
//c.divStyle = 'frost_glass';
c.divStyle = 'simple';

// ハイライトの色 'soft' か 'google' パステルカラーかgoogle風
// highlight colors 'soft' or 'google'
c.highlightColors = 'soft';

// 通常ページでの起動ショートカット
// デフォルトでは ctrl + / です
// Shortcut key to start in normal page
// default : ctrl + /
// ショートカットの有効無効 true:有効 | false:無効
// enable or not shortcut key  true:enable | false:disable
key.enable = true;

// モディファイアキィ
// modifier key 'alt' | 'ctrl' | 'shift'
key.modifierKey = 'ctrl';

// キィコード
// key code (default:47 ('/'))
key.keyCode = 47;

// =========================================
// =========================================

// advance configuration
// search site URL and query string(reg exp)
c.searchSitesQuery = {
	'google.com/search' : 'q=([^&]+)',
	'google.co.jp/search' : 'q=([^&]+)',
	'search.yahoo' : 'p=([^&]+)',  //Only ASCII String
	'alltheweb.com/search' : '(?:q|query)=([^&]+)',
	'ask.jp/web.asp' : 'q=([^&]+)',
// --->
	'ceek.jp/search.cgi' : 'q=([^&]+)',
	'infoseek.co.jp' : 'qt=([^&]+)',
	'sagool.jp/s' : 'q=([^&]+)',
	'wikipedia.org/w/wiki.phtml' : 'search=([^&]+)',
	'google.co.jp/groups' : 'q=([^&]+)',
	'google.com/groups' : 'q=([^&]+)',
	'google.co.jp/news' : 'q=([^&]+)',
	'google.com/news' : 'q=([^&]+)',
	'google.co.jp/images' : 'q=([^&]+)',
	'google.com/images' : 'q=([^&]+)',
	'google.co.jp/blogsearch' : 'q=([^&]+)',
	'google.com/blogsearch' : 'q=([^&]+)',
// <---
	'search.opera.com' : 'search=([^&]+)'
};
c.Colors = {};
c.Colors.soft = [
	 '#fff1a3', '#c1fbff', '#dfffc1', '#ffc4c1', '#ffc1f7', '#97ffb8',
	 '#a4c7eb', '#d2c582', '#82b6d2', '#d282a2', '#9cd282', '#ffc094'
];
c.Colors.google = [
	 '#ffff66', '#a0ffff', '#99ff99', '#ff9999', '#ff66ff',
	 '#880000', '#00aa00', '#886800', '#004699', '#990099'
];


document.addEventListener('load', 
	function(){
		// search result or linked page
		var hilite = new serchResultHighlight(c);
		if (hilite.has_query){
			hilite.getKeywords();
			hilite.highlight();
			if (c.controlBoxPosition != 0){
				hilite.createDiv();
			}
		}
		// listen shortcut key
		if(key.enable){
			var keyCap = new pageHighlightKeyCapture(key);
			document.addEventListener('keypress', function(e){
				if(keyCap.checkKey(e)){
					if (hilite.Div && hilite.Div.show){
						hilite.closeDiv();
					}else{
						if (hilite.Div){
							hilite.refreshDiv();
						}else{
							if(hilite.has_query && hilite.getKeywords()){
								hilite.highlight();
							}
							hilite.createDiv();
						}
						hilite.focusInput();
					}
				}
			}, false);
		}
	}, 
	false
);


function serchResultHighlight(cf){
	// get config
	this.config = cf;
	var b = this.config.enableResultPage;
	var s = this.config.searchSitesQuery;
	// execute or not
	for (var key in s ){
		if (
			(b && (document.location.href.indexOf(key) >= 0)) || 
			(
				(document.location.href.indexOf(key) == -1) && 
				(document.referrer.indexOf(key) >= 0)
			)
		){
			if (document.location.href.indexOf(key) >= 0) {
				this.stripDuplicateBold();
			}
			this.site = key;
			this.has_query = true;
			return;
		}
	}
	this.has_query = false;
}

serchResultHighlight.prototype = {
	getKeywords : function(){
		return this.makeRegExp(this.getQueryString());
	},
	reFindwords : function(str){
		if (
			typeof(str) == 'string' && 
			str != ''
		){
			this.closeDiv();
			this.makeRegExp(str);
			this.refreshDiv();
		}
	},
	getQueryString : function(){
		var qRE = new RegExp(this.config.searchSitesQuery[this.site]);
		if(qRE.test(document.location.href) || qRE.test(document.referrer)){
			var org = RegExp.$1.replace(/\+/g,' ');
			var dec;
			if('EUCJP' == GetEscapeCodeType(org)) dec = EscapeUTF8(UnescapeEUCJP(org));
			else dec = org;
			return decodeURIComponent(dec);
		}
	},
	makeRegExp : function(str){
		/* make regular expression and set color */
		var colors = (
			this.config.Colors[this.config.highlightColors] || 
			this.config.Colors['google']
		);
		if(! str) return false;
		str = '|' + str + '|';
		str = str
			.replace(/([\x00-\x20\x28-\x29\x7B-\xBF\u3000]|\+)+/g, '|')
			.replace(/\|"([^"\|]*)\|((?:[^"\|]*\|)*)([^"\|]*)"\|/g, 
				function($0, $1, $2, $3){
					return '|'+$1+' '+$2.replace(/\|/g, ' ')+$3+'|'
				}
			)
			.replace(/\\/g, '\\\\')
			.replace(/([\^\-.*+?$])/g, '\\$1')
			.replace(/^\|(.*)\|$/g, '$1');
		if(!str.length > 1) return false;
		str = str.toLowerCase();
		var words = str.split('|');
		var keywords = {};
		for (var i=0;i < words.length; i++){
			keywords[i] = {};
			keywords[i]['word'] = words[i];
			keywords[i]['color'] = colors[i % colors.length];
			keywords[i]['count'] = 0;
			keywords[i]['current'] = 1;
		}
		var reStr = '(('+ words.join(')|(')+'))';
		reStr = reStr
			.replace(/\(\)/g, '')
			.replace(/\|+/g, '|')
			.replace(/\(\|/g, '(')
			.replace(/\|\)/g, ')');
		keywords['regex'] = new RegExp(reStr,'im');
		this.keywords = keywords;
		return true;
	},
	stripDuplicateBold : function(){
		/* marge separated text <b>key</b><b>word</b> -> <b>keyword</b> */
		var nodes = document.getElementsByTagName('B');
		var c =  nodes.length;
		for (var i = c-1; i > 0; i--){
			if (nodes[i] == nodes[i-1].nextSibling){
				nodes[i-1].innerText += nodes[i].innerText;
				nodes[i].parentNode.removeChild(nodes[i]);
			}else if(
				(nodes[i].previousSibling) && 
				(nodes[i].previousSibling.nodeType == 3) && 
				(nodes[i].previousSibling.nodeValue.match(/^\s+$/m)) &&
				(nodes[i].previousSibling.previousSibling == nodes[i-1])
			){
				nodes[i-1].innerText += 
					nodes[i].previousSibling.nodeValue + 
					nodes[i].innerText;
				nodes[i-1].parentNode.removeChild(nodes[i].previousSibling);
				nodes[i-1].parentNode.removeChild(nodes[i]);
			}
		}
	},
	highlight : function(){
		/* execute each window */
		if(! this.keywords) return;
		if(top.frames.length > document.getElementsByTagName('iframe').length){
			for (var i = 0; i < top.frames.length; i++){
				this.addStyle(top.frames[i].document.body);
				this.showHighlights(top.frames[i].document.body);
			}
		}else{
			this.addStyle(window.document);
			this.showHighlights(window.document.body);
		}
	},
	showHighlights : function(n){
		/* trace node tree recurcive function */
		if(n.nodeType == 3){
			this.markText(n);
		}else if(
			n.nodeType == 1 && 
			n.childNodes && 
			n.tagName.toUpperCase() != 'SCRIPT' && 
			n.tagName.toUpperCase != 'STYLE'
		){
			var crNode = n.firstChild;
			while (crNode){
				if (
					crNode.nodeType == 3 || 
					crNode.nodeType == 1
				){
					this.showHighlights(crNode);
				}
				if (crNode.nextSibling){
					crNode = crNode.nextSibling;
					continue;
				}
				break;
			}
		}
		return;
	},
	markText : function(n){
		var k = this.keywords;
		var matchText, matchPattern, beforText, afterText, arr;
		var text = n.nodeValue;
		var fr = document.createDocumentFragment();
		var reF = false;
		while (k['regex'].test(text)){
			arr = k['regex'].exec(text);
			matchText = arr[1];
			beforText = text.substring(0, arr.index);
			afterText = text.substring(
				arr.index + matchText.length, text.length
			);
			if (beforText){
				fr.appendChild(document.createTextNode(beforText));
			}
			fr.appendChild(this.highlightNode(matchText));
			reF = true;
			text = afterText;
		}
		if (reF){
			if (afterText){
				fr.appendChild(document.createTextNode(afterText));
			}
			n.parentNode.replaceChild(fr, n);
		}
	},
	highlightNode : function(str){
		/* make highlight node 
		<span style='...' id='...'>str</span> */
		var k = this.keywords;
		var kIndex = this.getMatchWordIndex(str);
		k[kIndex].count ++;
		var spNode = document.createElement('SPAN');
		spNode.class = 'userjs_srhl_hiliteSpan';
		spNode.id='userjs_srhl_' + kIndex + ';' + k[kIndex].count;
		spNode.style.backgroundColor = k[kIndex].color;
		spNode.style.fontWeight = 'bold';
		spNode.style.color = '#000000';
		spNode.style.fontFamily = 'inherit';
		spNode.appendChild(document.createTextNode(str));
		return spNode;
	},
	getMatchWordIndex : function(w){
		var k = this.keywords;
		for (var i in k){
			if (typeof(k[i].word) != 'string') continue;
			if( k[i].word == w.toLowerCase()){
				return i;
			} else {
				var escaped = w.toLowerCase().replace(/\\/g, '\\\\');
				escaped =  escaped.replace(/([\^\-.*+?$])/g, '\\$1');
				if (k[i].word == escaped ){
					return i;
				}
			}
		}
		return false;
	},
	searchWords : function(){
		var k = this.keywords;
		var words = [];
		for (var i in k){
			if (typeof(k[i].word) != 'string') continue;
			words.push(k[i].word);
		}
		return words.join(' ');
	},
	clearHighlightes : function(){
		/* disable highlight */
		removeSpan = function(d){
			var nodes = d.getElementsByTagName('SPAN');
			var c = nodes.length;
			for (var i = c-1; i >=0; i--){
				var n = nodes[i];
				if(n.class == 'userjs_srhl_hiliteSpan'){
					// remove span
					var nn = document.createTextNode(n.innerText);
					n.parentNode.replaceChild(nn, n);
					// concatenate text node fragment
					if(
						nn.nextSibling &&
						nn.nextSibling.nodeType == 3
					){
						nn.nodeValue += nn.nextSibling.nodeValue;
						nn.parentNode.removeChild(nn.nextSibling);
					}
					if(
						nn.previousSibling && 
						nn.previousSibling.nodeType == 3
					){
						nn.previousSibling.nodeValue += nn.nodeValue;
						nn.previousSibling.parentNode.removeChild(nn);
					}
				}
			}
		}
		if(top.frames.length > document.getElementsByTagName('iframe').length){
			for (var i = 0; i < top.frames.length; i++){
				removeSpan(top.frames[i].document.body);
			}
		}else{
			removeSpan(window.document.body);
		}
	},
	createDiv : function(){
		/* make information div */
		this.Div = new makeDragableDivBox();
		var ctrb = this.Div;
		
		ctrb.setPosition(this.config.controlBoxPosition);
		ctrb.dElem.id = 'userjs_srhl_ctrlBox';
		ctrb.setTitle('Highlight Control Box');
		// overrife function when the close button is pushed
		ctrb.closeB.removeEventListener('mouseup', ctrb.closeDiv, false);
		var obj = this;
		ctrb.closeB.addEventListener('mouseup', function(){
			obj.closeDiv();
		}, false);
		
		var cnt = ctrb.contentDiv;
		cnt.appendChild(this.makeInputBox());
		cnt.appendChild(this.makeJumpList());

		this.addStyle(window.document);

		// show control box
		ctrb.show_togle();
	},
	refreshDiv : function(){
		// show control box
		this.Div.show_togle();
		this.highlight();
		var old = document.getElementById('userjs_jumplist');
		old.parentNode.replaceChild(this.makeJumpList(), old);
	},
	makeInputBox : function(){
		/* search input box */
		var k = this.keywords;
		var textL = document.createElement('INPUT');
		textL.type = 'text';
		textL.name = 'userjs_words_input';
		textL.id = 'userjs_words_input';
		textL.value = this.searchWords()
			.replace(/\\(.[^\\]*)/g, '$1')
			.replace(/\\\\/g, '\\');
		var obj = this;
		textL.addEventListener('keypress', function(e){
			if (e.keyCode == 13) {
				obj.reFindwords(this.value);
			}
		}, false);
		return textL;
	},
	makeJumpList : function(){
		/* make anchor list which jump to next highlighted word */
		var k = this.keywords;
		var ulEl = document.createElement('UL');
		ulEl.id = 'userjs_jumplist';
		for(i in k){
			if (typeof(k[i].word) != 'string') continue;
			var liEl = document.createElement('LI');
			var aEl = document.createElement('SPAN');
			if(k[i].count){
				aEl.hashAnchor = '#userjs_srhl_' + i + ';1';
				aEl.innerText = k[i].word
					.replace(/\\(.[^\\]*)/g, '$1')
					.replace(/\\\\/g, '\\') + ' : 0 / ' + k[i].count;
			}else{
				aEl.hashAnchor = '';
				aEl.innerText = k[i].word + ' Not Found';
			}
			var obj = this; //for using in event listener adapt to scope change
			aEl.addEventListener('mouseup', function(){
				obj.gotoAnch(this);
			}, false);
			liEl.appendChild(aEl);
			ulEl.appendChild(liEl);
		}
		return ulEl;
	},
	focusInput : function(){
		document.getElementById('userjs_words_input').focus();
	},
	closeDiv : function(){
		/* close div box*/
		this.Div.closeDiv();
		this.clearHighlightes();
	},
	gotoAnch : function(a){
		/* goto highlighted ancher */
		if (a.hashAnchor == '')return;
		var k = this.keywords;
		document.location.href = document.URL.replace(/#.*?$/, '')
		 + a.hashAnchor;
		var arr = a.hashAnchor.match(/^#?userjs_srhl_(\d*);(\d+)$/);
		var kIndex  = arr[1];
		a.innerText = k[kIndex].word
			.replace(/\\(.[^\\]*)/g, '$1')
			.replace(/\\\\/g, '\\');
		a.innerText += ' : ' + k[kIndex].current + ' / ' + k[kIndex].count;
		k[kIndex].current = (
			k[kIndex].current < k[kIndex].count
		) ? k[kIndex].current + 1 : 1;
		a.hashAnchor = '#userjs_srhl_' + kIndex + ';' + k[kIndex].current;
	},
	addStyle : function(d){
		if (document.added_css_by_userjs) return;
		var cssAr = (this.config.style[this.config.divStyle] ||
			 this.config.style['simple']
		);
		var cText = '';
		for (i in cssAr){
			cText += i + '{';
			for (j in cssAr[i]){
				cText += j + ':' + cssAr[i][j] + ';';
			}
			cText += '}';
		}
		var stl = document.createElement('STYLE');
		stl.type = 'text/css';
		stl.innerText = cText;
		var hs = document.getElementsByTagName('HEAD');
		
		h = hs ? hs[0] : document;
		h.appendChild(stl);
		document.added_css_by_userjs = true;
	}
}


function makeDragableDivBox(){
	/* Float Div Box contains titlebar, close button and content aria. */

	// make valiables to be accessable from grobal scope
	document.DragableDivBox = this;
	//for using in event listener to adapt to scope change
	var obj = this;
	
	this.show = false;

	this.dElem = document.createElement('DIV');
	var div = this.dElem;
	this.setStyle();

	this.titleBar = document.createElement('DIV');
	var tb = this.titleBar;
	tb.className = 'titlebar';
	tb.addEventListener('mousedown', obj.startDrag, false);

	this.closeB = document.createElement('DIV');
	var x = this.closeB;
	x.className = 'close';
	x.appendChild(document.createTextNode('close'));
	x.addEventListener('mouseup', obj.closeDiv, false);

	this.titleS = document.createElement('SPAN');
	var ts = this.titleS;
	ts.className = 'titlename';
	ts.appendChild(document.createTextNode('title'));

	this.contentDiv = document.createElement('DIV');
	this.contentDiv.className = 'content';
	
	tb.appendChild(x);
	tb.appendChild(ts);
	div.appendChild(tb);
	div.appendChild(this.contentDiv);
}
makeDragableDivBox.prototype = {
	show_togle : function(){
		this.show = this.show ? false : true;
		if(this.show){
			document.body.appendChild(this.dElem);
		}else{
			document.body.removeChild(this.dElem);
		}
	},
	setStyle : function(){
		var div = this.dElem;
		div.style.position = 'fixed';
		div.style.zIndex = 9000;
	},
	setPosition: function(p){
		var div = this.dElem;
		if ((this.posX >= 0) && (this.posY >= 0)){
			div.style.left = this.deltaX + 'px';
			div.style.top = this.deltaY + 'px';
			div.style.bottom = 'inherit';
			div.style.right = 'inherit';
		} else {
			var mgn = '13px';
			switch (p){
				case 1 : div.style.left = mgn; div.style.top = mgn; break;
				case 2 : div.style.right = mgn; div.style.top = mgn; break;
				case 3 : div.style.right = mgn; div.style.bottom = mgn; break;
				case 4 : div.style.left = mgn; div.style.bottom = mgn; break;
				default : div.style.right = mgn; div.style.top = mgn; break; 
			}
		}
	},
	setTitle : function(str){
		str = (typeof(str) == 'string') ? str : str.toString();
		var t = document.createTextNode(str);
		this.titleS.replaceChild(t, this.titleS.firstChild);
	},
	/* following functions are called as event handler */
	/* note object scope. 'e' is event. 'obj' is this object */
	startDrag : function(e){
		var obj = document.DragableDivBox;
		var dragEle = obj.dElem;
		var x = dragEle.offsetLeft;
		var y = dragEle.offsetTop;
		obj.deltaX = e.clientX - x;
		obj.deltaY = e.clientY - y;
		document.addEventListener('mousemove',obj.moveMouse, false);
		document.addEventListener('mouseup', obj.stopDrag, false);
	},
	moveMouse : function(e){
		var obj = document.DragableDivBox;
		var dragEle = obj.dElem;
		dragEle.style.left = (e.clientX - obj.deltaX) + 'px';
		dragEle.style.top = (e.clientY - obj.deltaY) + 'px';
		dragEle.style.bottom = 'inherit';
		dragEle.style.right = 'inherit';
	},
	stopDrag : function(e){
		var obj = document.DragableDivBox; 
		document.removeEventListener('mouseup', obj.stopDrag, false);
		document.removeEventListener('mousemove', obj.moveMouse, false);
		document.getElementById('userjs_words_input').focus(); // dirty :-(
	},
	closeDiv : function(e){
		var obj = document.DragableDivBox;
		this.posX = obj.dElem.offsetLeft;
		this.posY = obj.dElem.offsetTop;
		this.show_togle();
		window.scrollBy(0, 1); // force refresh
		window.scrollBy(0,-1);
		
	}
}


function pageHighlightKeyCapture(c){
	this.keyConfig = c;
	var ck = parseInt(this.keyConfig.keyCode);
	this.keyConfig.keyCode = ((ck>32) && (ck<127)) ? ck : 47;
	var mdk = this.keyConfig.modifierKey.toLowerCase();
	this.keyConfig.modifierKey = (
		(mdk == 'alt') || (mdk == 'shift')
	) ? mdk : 'ctrl';
	this.altF = false;
	this.shftF = false;
	this.ctrlF = false;
}
pageHighlightKeyCapture.prototype.checkKey = function(e){
	var k = e.keyCode;
	this.altF = (e.altKey) ? true : false;
	this.ctrlF = (e.ctrlKey) ? true : false;
	this.shiftF = (e.shiftKey) ? true : false;
	if (this[this.keyConfig.modifierKey + 'F']) {
		if (k == this.keyConfig.keyCode) return true;
	}
	return false;
}

c.image = {
'top' : 'data:image/png;base64,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',
'mid' : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAN4AAAABCAYAAACxDxBNAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9ULDgscMNXT4w4AAAAddEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIFRoZSBHSU1Q72QlbgAAAKBJREFUeNrt0jEOgkAQheF5swsxEDUWXMx4Bq9i6SFsre1tvICt1YZQUhEX3J0ZCzyF4Uv+6rUPZlYTUXW6X85j/uybendtqm3wcExqXrP4nFKRU/Y55UJVmIxARAbHygwBoGA2EOZlsfgDmM9sDJADa1GWm9W6OpTEr+ftcWzbNnZdJ8MwcIzRT9PkzcyJiJlZVtWoqu9fI4Cp73sJIegXPMRcA1pghMwAAAAASUVORK5CYII=',
'bottom' : 'data:image/png;base64,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'
};

// css -- if you wish to change style, modify below.
c.style = {};
c.style.frost_glass = {
	'div#userjs_srhl_ctrlBox' : {
//		'border' : '1px solid #ffaaaa', //for positioning debug
		'margin' : '0',
		'padding' : '0',
		'font-family' : 'sans-serif',
		'font-size' : '14px',
		'text-align' : 'justify',
		'color' : '#404070',
		'background-color' : 'transparent',
		'width' : '222px'
	},
	'#userjs_srhl_ctrlBox div.titlebar' : {
//		'border' : '1px solid #ffaaaa', //for positioning debug
		'cursor' : 'move',
		'margin' : '0px',
		'font-family' : 'sans-serif',
		'font-size' : '12px',
		'color' : '#404070',
		'background-color' : 'transparent',
		'background-image' : 'url('+c.image.top+')',
		'background-repeat' : 'no-repeat',
		'background-position' : 'left top',
		'width' : '222px',
		'height' : '61px',
		'z-index' : '9900'
	},
	'#userjs_srhl_ctrlBox div.close' : {
//		'border' : '1px solid #ffaaaa', //for positioning debug
		'cursor' : 'pointer',
		'content' : '\"\\20\"',
		'margin' : '0px',
		'padding' : '0px',
		'position' : 'relative',
		'float' : 'right',
		'width' : '25px',
		'height' : '25px',
		'right' : '30px',
		'top' : '8px',
		'z-index' : '10000'
	},
	'#userjs_srhl_ctrlBox span.titlename' : {
//		'border' : '1px solid #ffaaaa', //for positioning debug
		'display' : 'block',
		'margin-top' : '0px',
		'margin-left' : '16px',
		'margin-right' : '55px',
		'padding-top' : '12px' // 9.0tp1 bug?
	},
	'#userjs_srhl_ctrlBox div.content' : {
		'margin' : '0px',
		'padding' : '5px 28px 5px 12px',
		'clear' : 'both',
		'font-family' : 'sans-serif',
		'font-size' : '14px',
		'color' : '#404070',
		'background-color' : 'transparent',
		'background-image' : 'url('+c.image.mid+')',
		'background-repeat' : 'repeat-y',
		'background-position' : 'left top'
	},
	'div#userjs_srhl_ctrlBox::after' : {
		'content' : '\"\\20\"',
		'display' : 'block',
		'margin' : '0',
		'padding' : '0',
		'clear' : 'both',
		'background-image' : 'url('+c.image.bottom+')',
		'background-repeat' : 'no-repeat',
		'background-position' : 'left top',
		'height' : '42px'
	},
	'#userjs_words_input' : {
		'width' : '178px',
		'border-width' : '1px',
		'border-style' : 'solid',
		'border-color' : '#e1eee7 #7cba9a #7cba9a #e1eee7',
		'color' : '#307f56',
		'background-color' : '#c1d4ca'
	},
	'ul#userjs_jumplist' : {
		'margin' : '0.3em',
		'padding' : '0'
	},
	'#userjs_jumplist li' : {
		'list-style' : 'none outside',
		'cursor' : 'pointer',
		'margin' : '0',
		'padding' : '0.2em'
	}
};
c.style.simple = {
	'div#userjs_srhl_ctrlBox' : {
		'border' : '1px solid #b1d6c3',
		'margin' : '0',
		'padding' : '0',
		'font-family' : 'sans-serif',
		'font-size' : '14px',
		'text-align' : 'justify',
		'color' : '#404070',
		'background-color' : '#ffffff',
		'width' : '200px'
	},
	'#userjs_srhl_ctrlBox div.titlebar' : {
		'cursor' : 'move',
		'margin' : '0',
		'padding' : '2px',
		'font-family' : 'sans-serif',
		'font-size' : '12px',
		'color' : '#404070',
		'background-color' : '#abdec2',
		'height' : '18px'
	},
	'#userjs_srhl_ctrlBox div.close' : {
		'border' : '1px solid #6bae8b',
		'cursor' : 'pointer',
		'content' : '\"X\"',
		'margin' : '0px',
		'padding' : '0px',
		'float' : 'right',
		'width' : '14px',
		'height' : '14px',
		'text-align' : 'center',
		'font-size' : '12px',
		'line-height' : '14px'
	},
	'#userjs_srhl_ctrlBox div.content' : {
		'margin' : '0px',
		'padding' : '5px 12px 5px 12px',
		'clear' : 'both',
		'font-family' : 'sans-serif',
		'font-size' : '14px',
		'color' : '#404070',
		'background-color' : '#ffffff'
	},
	'#userjs_words_input' : {
		'width' : '174px',
		'border-width' : '1px',
		'border-style' : 'solid',
		'border-color' : '#e1eee7 #7cba9a #7cba9a #e1eee7',
		'color' : '#307f56',
		'background-color' : '#c1d4ca'
	},
	'ul#userjs_jumplist' : {
		'margin-left' : '0',
		'padding-left' : '0'
	},
	'#userjs_jumplist li' : {
		'list-style' : 'none outside',
		'cursor' : 'pointer',
		'margin' : '0',
		'padding' : '0 0.5em'
	}
};
})();