#ifndef __DEF_H__
#define __DEF_H__

#include "type.h"

// カラーナンバー
#define COLORN		16
#define COL_000000	0
#define COL_FF0000	1
#define COL_00FF00	2
#define COL_FFFF00	3
#define COL_0000FF	4
#define COL_FF00FF	5
#define COL_00FFFF	6
#define COL_FFFFFF	7
#define COL_C6C6C6	8
#define COL_840000	9
#define COL_008400	10
#define COL_848400	11
#define COL_000084	12
#define COL_840084	13
#define COL_008484	14
#define COL_848484	15

// アドレス
#define ADR_IDT			0x0026f800
#define LIMIT_IDT		0x000007ff
#define ADR_GDT			0x00270000
#define LIMIT_GDT		0x0000ffff
#define ADR_BOTPAK		0x00280000
#define LIMIT_BOTPAK	0x0007ffff
#define AR_DATA32_RW	0x4092
#define AR_CODE32_ER	0x409a
#define AR_INTGATE32	0x008e

// ポート番号
#define PIC0_ICW1		0x0020
#define PIC0_OCW2		0x0020
#define PIC0_IMR		0x0021
#define PIC0_ICW2		0x0021
#define PIC0_ICW3		0x0021
#define PIC0_ICW4		0x0021
#define PIC1_ICW1		0x00a0
#define PIC1_OCW2		0x00a0
#define PIC1_IMR		0x00a1
#define PIC1_ICW2		0x00a1
#define PIC1_ICW3		0x00a1
#define PIC1_ICW4		0x00a1

// ブート情報
typedef struct __BOOTINFO__ {
	char cyls, leds, vmode, reserve;
	short scrnx, scrny;
	char *vram;
} __attribute__((__packed__)) BOOTINFO;

// セグメントデスクリプタ
typedef struct __SEGMENT_DESCRIPTOR__ {
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
} __attribute__((__packed__)) SEGMENT_DESCRIPTOR;

// ゲートデスクリプタ
typedef struct __GATE_DESCRIPTOR__ {
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
} __attribute__((__packed__)) GATE_DESCRIPTOR;

// 半角英数字(ASCII)
extern char hankaku[4096];
// ブート情報
extern BOOTINFO *binfo;

#endif // __DEF_H__
