#include "def.h"
#include "prot.h"

void init_pic() {
	io_out8(PIC0_IMR, 0xff);	// すべての割り込みを受け付けない
	io_out8(PIC1_IMR, 0xff);	// すべての割り込みを受け付けない

	io_out8(PIC0_ICW1, 0x11);	// エッジトリガモード
	io_out8(PIC0_ICW2, 0x20);	// IRQ0-7はINT20-27で受ける	
	io_out8(PIC0_ICW3, 1 << 2);	// PIC1はIRQ2にて接続
	io_out8(PIC0_ICW4, 0x01);	// ノンバッファモード

	io_out8(PIC1_ICW1, 0x11);	// エッジトリガモード
	io_out8(PIC1_ICW2, 0x28);	// IRQ8-15はINT28-2fで受ける
	io_out8(PIC1_ICW3, 2);		// PIC1はIRQ2にて接続
	io_out8(PIC1_ICW4, 0x01);	// ノンバッファモード

	io_out8(PIC0_IMR, 0xfb);	// PIC1以外はすべて割り込み禁止
	io_out8(PIC1_IMR, 0xff);	// すべての割り込みを受け付けない
}

// interrupt from PS/2 keyboard
void hInt21(int *esp) {
//	io_out8(0x0060, 0x61);

	boxfill(COL_000000, 0, 0, 32 * 8 - 1, 15);
	vprint("INT 21 (IRQ-1) : PS/2 keyboard", 0, 0, COL_FFFFFF);
	return;
}

// interrupt from PS/2 mouse
void hInt2c(int *esp) {
	boxfill(COL_000000, 0, 0, 32 * 8 - 1, 15);
	vprint("INT 2C (IRQ-12) : PS/2 mouse", 0, 0, COL_FFFFFF);
	while(1) { io_hlt(); }
}
