#ifndef __PROT_H__
#define __PROT_H__

#include "types.h"

// boot.c
// Main関数からOSを実行
void Main();

// graphic.c
// グラフィック関連の関数群
void draw_mouse(int, int);
void init_palete();
void boxfill(byte, int, int, int, int);
void init_screen(const int, const int);
void vprint(byte *, int, int, char);
void init_mouse_cursor(char *, char);
void putblock(int, int, int, int, const char *, int);
//void set_palete(int, int, unsigned char *);
//void putfont(int, int, char, char *);

// dsctbl.c
// GDT,IDT等のデスクリプタテーブル関連
void init_gdtidt();
//void set_segmdesc(SEGMENT_DESCRIPTOR *, dword int, int, int);
//void set_gatedesc(GATE_DESCRIPTOR *, int, int, int);

// int.c
// 割り込み関連の関数群
void init_pic();

// lib.c
// 標準ライブラリ的関数群
int lsprintf(char *str, const char *format, ...);
void strcls(char *);
//void int2hex(char *, int, int);
//void int2dec(char *, int);

// fifo.c
// QUEUEバッファ利用関数群
void queue_init(QUEUE *, int, byte *);
int queue_put(QUEUE *, byte);
int queue_get(QUEUE *);
int queue_status(QUEUE *);

// memory.c
// メモリ管理関数群
dword memtest(dword, dword);
void mem_init(MEMORY_MANAGE *);
dword mem_total(MEMORY_MANAGE *);
dword mem_alloc(MEMORY_MANAGE *, dword);
int mem_free(MEMORY_MANAGE *, dword, dword);

// keyboard.c
// キーボード関連関数群
void hInt21(int *);
void wait_KBC_sendready();
void init_keyboard();

// mouse.c
// マウス関連関数群
void hInt2c(int *);
void enable_mouse(MOUSE_DEC *);
int mouse_decode(MOUSE_DEC *, byte);

// func.s 
// GASで記述された関数
dword memtest_sub(dword, dword);

// mnemonic.s
// GASで記述されたニーモニック関連関数
extern inline void	io_hlt();
extern inline void	io_cli();
extern inline void	io_sti();
extern inline void	io_stihlt();
extern inline int	io_in8();
extern inline int	io_in16();
extern inline int	io_in32();
extern inline void	io_out8();
extern inline void	io_out16();
extern inline void	io_out32();
extern inline int	io_load_eflags();
extern inline void	io_store_eflags(int eflags);
extern inline int	io_load_cr0();
extern inline void	store_cr0(int cr0);

// int.s
// GASで記述された割り込み関連関数群
void inthandler21();
void inthandler2c();

#endif // __PROT_H__
