#include "def.h"
#include "prot.h"

SHEET_CTL *sheetctl_init(MEMORY_MANAGE* man, byte *vram,  int xsize, int ysize) {
	SHEET_CTL *ctl;
	int i;
	ctl = (SHEET_CTL*)mem_alloc_4k(man, sizeof(SHEET_CTL));
	if(ctl == 0) return 0;

	ctl->vram = vram;
	ctl->xsize = xsize;
	ctl->ysize = ysize;
	ctl->top = -1;	// シートは1枚もない
	for(i = 0; i < MAX_SHEETS; i++) {
		ctl->sheets0[i].flags = 0;	// 未使用マーク
	}

	return ctl;
}

SHEET *sheet_alloc(SHEET_CTL *ctl) {
	SHEET *sheet;
	int i;
	for(i = 0; i < MAX_SHEETS; i++) {
		if(ctl->sheets0[i].flags == 0) {
			sheet = &ctl->sheets0[i];
			sheet->flags = SHEET_USE;
			sheet->height = -1;	// 非表示中
			return sheet;
		}
	}
	return 0;	// すべてのシートが使用中だった
}

void sheet_setbuf(SHEET *sheet, byte *buf, int xsize, int ysize, int col_inv) {
	sheet->buf		= buf;
	sheet->bxsize	= xsize;
	sheet->bysize	= ysize;
	sheet->col_inv	= col_inv;
}

void sheet_updown(SHEET_CTL *ctl, SHEET *sheet, int height) {
	int h, old = sheet->height;	// 設定前の高さを記憶する

	// 指定が低すぎや高すぎだったら修正する
	if(height > ctl->top + 1)	height = ctl->top + 1;
	if(height < -1)				height = -1;
	sheet->height = height;	// 高さを設定

	// 以下は主にsheets[]の並べ替え
	if(old > height) {	// 以前よりも低くなる
		if(height >= 0) {
			// 間のものを引き上げる
			for(h = old; h > height; h--) {
				ctl->sheets[h] = ctl->sheets[h-1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sheet;
		} else {	// 非表示化
			if(ctl->top > old) {
				// 上になっているものをおろす
				for(h = old; h < ctl->top; h++) {
					ctl->sheets[h] = ctl->sheets[h+1];
					ctl->sheets[h]->height = h;
				}
			}
			ctl->top--;	// 表示中の下敷きが1つ減るので一番上の高さが減る
		}
		sheet_refresh_sub(ctl, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize);
	} else if(old < height) {	// 以前よりも高くなる
		if(old >= 0) {
			// 間のものを押し下げる
			for(h = old; h < height; h++) {
				ctl->sheets[h] = ctl->sheets[h-1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sheet;
		} else {	// 表示状態へ
			// 上になるものを持ち上げる
			for(h = ctl->top; h >= height; h--) {
				ctl->sheets[h+1] = ctl->sheets[h];
				ctl->sheets[h+1]->height = h + 1;
			}
			ctl->sheets[height] = sheet;
			ctl->top++;	// 表示中の下敷きが1つ増えるので一番上の高さが増える
		}
		sheet_refresh_sub(ctl, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize);
	}
	return;
}

void sheet_refresh_sub(SHEET_CTL *ctl, int vx0, int vy0, int vx1, int vy1) {
	int h, bx, by, vx, vy, bx0, by0, bx1, by1;
	byte *buf, c, *vram = ctl->vram;
	SHEET *sheet;

	for(h = 0; h <= ctl->top; h++) {
		sheet = ctl->sheets[h];
		buf = sheet->buf;

		bx0 = vx0 - sheet->vx0;
		by0 = vy0 - sheet->vy0;
		bx1 = vx1 - sheet->vx0;
		by1 = vy1 - sheet->vy0;

		if(bx0 < 0) bx0 = 0;
		if(by0 < 0) by0 = 0;
		if(bx1 > sheet->bxsize) bx1 = sheet->bxsize;
		if(by1 > sheet->bysize) by1 = sheet->bysize;

		for(by = 0; by < sheet->bysize; by++) {
			vy = sheet->vy0 + by;
			for(bx = 0; bx < sheet->bxsize; bx++) {
				vx = sheet->vx0 + bx;
				c = buf[by * sheet->bxsize + bx];
				if(c != sheet->col_inv) vram[vy * ctl->xsize + vx] = c;
			}
		}
	}
}

void sheet_refresh(SHEET_CTL *ctl, SHEET *sheet, int bx0, int by0, int bx1, int by1) {
	if(sheet->height >= 0) {
		sheet_refresh_sub(ctl, sheet->vx0 + bx0, sheet->vy0 + by0, sheet->vx0 + bx1, sheet->vy0 + by1);
	}
}

void sheet_slide(SHEET_CTL *ctl, SHEET *sheet, int vx0, int vy0) {
	int old_vx0 = sheet->vx0, old_vy0 = sheet->vy0;
	sheet->vx0 = vx0;
	sheet->vy0 = vy0;
	if(sheet->height >= 0) { // 表示中なら
		sheet_refresh_sub(ctl, old_vx0, old_vy0, old_vx0 + sheet->bxsize, old_vy0 + sheet->bysize);
		sheet_refresh_sub(ctl, vx0, vy0, vx0 + sheet->bxsize, vy0 + sheet->bysize);
	}
}

void sheet_free(SHEET_CTL *ctl, SHEET *sheet) {
	if(sheet->height >= 0) {	// 表示中なら
		sheet_updown(ctl, sheet, -1);	// 非表示にする
	}
	sheet->flags = 0;	// 未使用マーク
}
