#include "def.h"
#include "prot.h"

#define ADR_BOOTINFO		0x0ff0

#define WIN_XS				160
#define WIN_YS				52

// ブート情報アドレス
BOOTINFO *binfo = (BOOTINFO *)ADR_BOOTINFO;
// 割り込み用バッファ
QUEUE qInt;

void make_window(byte *, int, int, char *);
void putfont_sheet(SHEET *, int, int, int, int, char *, int);

void Main() {
	char s[30];
	int int_buf[128];
	int i;
	int mx = (binfo->scrnx-16)/2, my = (binfo->scrny-28-16)/2;
	int count = 0;
	MOUSE_DEC mdec;
	dword memtotal;
	MEMORY_MANAGE *memman = (MEMORY_MANAGE *)ADR_MEMMAN;
	SHEET_CTL *sheetctl;
	SHEET *sheet_back, *sheet_mouse, *sheet_win;
	byte *buf_back, *buf_mouse, *buf_win;
	TIMER *timer1, *timer2, *timer3;

	init_gdtidt();	// GDT/IDTの初期化
	init_pic();		// PICの初期化
	io_sti();		// 割り込み許可

	// 割り込み用QUEUEの初期化
	queue_init(&qInt, 128, int_buf);

	init_pit();		// PITの初期化

	io_out8(PIC0_IMR, 0xf8);	// PITとPIC1とキーボードを許可(0xf9)
	io_out8(PIC1_IMR, 0xef);	// マウスを許可

	// タイマ設定
	timer1 = timer_alloc();
	timer_init(timer1, &qInt, 10);
	timer_settime(timer1, 1000);
	timer2 = timer_alloc();
	timer_init(timer2, &qInt, 3);
	timer_settime(timer2, 300);
	timer3 = timer_alloc();
	timer_init(timer3, &qInt, 1);
	timer_settime(timer3, 50);

	init_keyboard(&qInt);
	enable_mouse(&qInt, &mdec);
	// メモリ管理
	memtotal = memtest(0x00400000, 0xbfffffff);
	mem_init(memman);
	mem_free(memman, 0x00001000, 0x0009e000);
	mem_free(memman, 0x00400000, memtotal- 0x00400000);

	init_palete();	// パレットの初期化

	// 下敷き管理
	sheetctl = sheetctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	if(!sheetctl) return;
	sheet_back	= sheet_alloc(sheetctl);
	sheet_mouse	= sheet_alloc(sheetctl);
	sheet_win	= sheet_alloc(sheetctl);
	buf_back	= (byte*)mem_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	buf_win		= (byte*)mem_alloc_4k(memman, WIN_XS * WIN_YS);
	sheet_setbuf(sheet_back, buf_back, binfo->scrnx, binfo->scrny, -1);
	sheet_setbuf(sheet_mouse, buf_mouse, 16, 16, 99);
	sheet_setbuf(sheet_win, buf_win, WIN_XS, WIN_YS, -1);

	init_screen(buf_back, binfo->scrnx, binfo->scrny);
	init_mouse_cursor(buf_mouse, 99);

	make_window(buf_win, WIN_XS, WIN_YS, "counter");

	sheet_slide(sheet_back, 0, 0);
	sheet_slide(sheet_mouse, mx, my);
	sheet_slide(sheet_win, 80, 72);	
	sheet_updown(sheet_back, 0);
	sheet_updown(sheet_win, 1);
	sheet_updown(sheet_mouse, 2);

	lsprintf(s, "memory %dMB   free : %dKB", memtotal / (1024*1024),
				mem_total(memman) / 1024);
	putfont_sheet(sheet_back, 0, 32, COL_FFFFFF, COL_008484, s, 40);

	while(1) {
		//count++;

		lsprintf(s, "%d", timerctl.count);
		putfont_sheet(sheet_win, 40, 28, COL_000000, COL_C6C6C6, s, 10);

		io_cli();
		// 割り込みバッファからデータを受け取っていない
		if(queue_status(&qInt) == 0) {
			io_sti();
		} else {
			i = queue_get(&qInt);
			io_sti();
			// キーボードからデータを受信
			if(INT_KEYBOARD <= i && i <= INT_KEYBOARD + 255) {
				lsprintf(s, "%X", i - INT_KEYBOARD);
				putfont_sheet(sheet_back, 0, 16, COL_FFFFFF, COL_008484, s, 2);
			// マウスかデータを受信
			} else if(INT_MOUSE <= i && i <= INT_MOUSE + 255) {
				// マウスデータが3バイト揃う
				if(mouse_decode(&mdec, i - INT_MOUSE)) {
					// データの表示
					lsprintf(s, "[lcr] x=%d y=%d", mdec.x, mdec.y);
					if((mdec.button & 0x01) != 0) s[1] = 'L';
					if((mdec.button & 0x02) != 0) s[3] = 'R';
					if((mdec.button & 0x03) != 0) s[2] = 'C';
					putfont_sheet(sheet_back, 32, 16, COL_FFFFFF, COL_008484, s, 30);

					// マウスの移動
					mx += mdec.x; my += mdec.y;
					if(mx < 0) mx = 0;
					if(my < 0) my = 0;
					if(mx > binfo->scrnx - 1) mx = binfo->scrnx - 1;
					if(my > binfo->scrny - 1) my = binfo->scrny - 1;
					sheet_slide(sheet_mouse, mx, my);
				}
			} else if(i == 10) {
				putfont_sheet(sheet_back, 0, 64, COL_FFFFFF, COL_008484, "10[sec]", 7);
			} else if(i == 3) {
				putfont_sheet(sheet_back, 0, 80, COL_FFFFFF, COL_008484, "3[sec]", 6);
				count = 0;	// 測定開始
			} else if(i == 1) {
				timer_init(timer3, &qInt, 0);
				boxfill(buf_back, binfo->scrnx, COL_FFFFFF, 8, 96, 15, 111);
				timer_settime(timer3, 50);
				sheet_refresh(sheet_back, 8, 96, 16, 112);
			} else if(i == 0) {
				timer_init(timer3, &qInt, 1);
				boxfill(buf_back, binfo->scrnx, COL_008484, 8, 96, 15, 111);
				timer_settime(timer3, 50);
				sheet_refresh(sheet_back, 8, 96, 16, 112);
			}
		}
	}
}

void make_window(byte * buf, int xsize, int ysize, char *title) {
	static char closebtn[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQQQ@@QQQQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	int x, y;
	char c;
	boxfill(buf, xsize, COL_C6C6C6, 0,		0,		xsize-1,0		);
	boxfill(buf, xsize, COL_FFFFFF, 1,		1,		xsize-2,1		);
	boxfill(buf, xsize, COL_C6C6C6, 0,		0,		0,		ysize-1	);
	boxfill(buf, xsize, COL_FFFFFF, 1,		1,		1,		ysize-2	);
	boxfill(buf, xsize, COL_848484, xsize-2,1,		xsize-2,ysize-2	);
	boxfill(buf, xsize, COL_000000, xsize-1,0,		xsize-1,ysize-1	);
	boxfill(buf, xsize, COL_C6C6C6, 2,		2,		xsize-3,ysize-3	);
	boxfill(buf, xsize, COL_000084, 3,		3,		xsize-4,20		);
	boxfill(buf, xsize, COL_848484, 1,		ysize-2,xsize-1,ysize-2	);
	boxfill(buf, xsize, COL_000000, 0,		ysize-1,xsize-1,ysize-1	);

	vprint(buf, title, xsize, 24, 4, COL_FFFFFF);

	for(y = 0; y < 14; y++)
	for(x = 0; x < 16; x++) {
		c = closebtn[y][x];
		switch(c) {
			case '@':
				c = COL_000000; break;
			case '$':
				c = COL_848484; break;
			case 'Q':
				c = COL_C6C6C6; break;
			default:
				c = COL_FFFFFF;
		}
		buf[(5+y)*xsize + (xsize-21+x)] = c;
	}
}

void putfont_sheet(SHEET * sheet, int x, int y, int c, int b, char *s, int l) {
	boxfill(sheet->buf, sheet->bxsize, b, x, y, x + l * 8 -1, y + 15);
	vprint(sheet->buf, s, sheet->bxsize, x, y, c);
	sheet_refresh(sheet, x, y, x + l * 8, y + 16);
}
